/*  XPOST program written by Michael Burton
    Copyright 1996 Michael Burton
    All rights reserved
    Do not redistribute without written consent


Heavily modified and Betelized 
by Chris Freeze (Betelgues) <phy10006@mtsu.edu>

*/
/* This program assumes that all ftpmail nodes are under HOLD Status */


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


/* Change this to your AdeptXBBS Mailer's outbound dir */
outbounddir = 'd:\adept\mailer\outbound_mail\'
FTPMailRootDrive =  'E:'
XPostDrive = 'D:'


currentdir = Directory()

'@echo off'                /* turn off the screen echos */

getnode:				/* get node information routine */
NodeFile = LineIn(xpost.lst)		/* read node and Dir from xpost.lst */
if Length(NodeFile) <= 1 then signal EndMail	/* end of file then end program */
Dir = LineIn(xpost.lst)			/* leave the file open to retain pointer */
if Length(Dir) <= 1 then signal endmail	/* end of file? then end program */
say 'Processing 'NodeFile

RC = Stream(outbounddir || '*' || NodeFile || '*','c','query exists')
    If RC \= "" Then
       Do
	   Call DoEchoMail
	   RC = Stream(outbounddir || 't.' || NodeFile || '*','c','query exists')
	   if RC \= "" Then Call DoNetMail
	   RC = Stream(outbounddir || 'h.' || NodeFile || '*','c','query exists')
	   if RC \= "" Then Call DoTicFiles

       End
Signal GetNode



DoEchoMail:
FTPMailRootDrive
cd '\'Dir				/* change to the nodes dir */
/* ECHOMAIL */
copy outbounddir || 'a.' || NodeFile    /* copy file */
NewExtension = ''
Call GetExtension
NewName = ''
Call HEXName NodeFile

NumericalExtension = 0
InvalidName = 1


Do While InvalidName
	RC = Stream(NewName || '.' || NewExtension || NumericalExtension,'c','query exists')
	    If RC \= "" Then
	       Do
	           Say 'File Already Exist Renaming again'
		   InvalidName = 1
		   NumericalExtension = NumericalExtension + 1
		   if NumericalExtension = 10 Then NewExtension = SubStr(NewExtension,1,1)
	       End
	     Else
		InvalidName = 0
End
rename 'a.'NodeFile NewName || '.' || NewExtension || NumericalExtension
del outbounddir || 'a.' || NodeFile /* del original */
return



/* NetMail */
DoNetmail:
copy outbounddir || 't.' || NodeFile
NewName = ''
InvalidName = 1


Do While InvalidName
	Call RandomName
	RC = Stream(NewName || '.PKT','c','query exists')
	    If RC \= "" Then
	       Do
	           Say 'File Already Exist Renaming again'
		   InvalidName = 1
	       End
	     Else
		InvalidName = 0
End
ren 't.'NodeFile Newname || '.PKT'
del outbounddir || 't.' || NodeFile /* delete original */
return


DoTicFiles:				/* copy files/tics to nodes dir routine */
GetFile = LineIn(outbounddir || 'h.' || NodeFile)
if Length(GetFile) <= 1 then /* Empty poll file */
  do
    call LineOut(outbounddir || 'h.' || NodeFile) /* closes file */
    del outbounddir || 'h.' || NodeFile
    return	/* process next node if done */
   end
say 'Copying 'GetFile			/* display the status */

FirstChar = SubStr(GetFile,1,1)  /* Grab the first Character of filename inside */


DeleteAble = 0  /* Reset Del status */
If (FirstChar = '^') Then /* Determine if it needs to be deleted */
  Do
	GetFile = SubStr(GetFile,2,Length(GetFile))  /* ReAdjust the file to copy */
	DeleteAble = 1 /* Mark it DeleteAble */
  End

copy GetFile				/* copy the file */

If DeleteAble = 1 Then '@Del 'GetFile  /* if Deleteable then delete */

GetFile = ''  /* clear GetFile */

signal DoTicFiles				/* return and process next file */


/*
^ delete
*/


endmail:
XPostDrive				/* cleanup and exit routine */
cd CurrentDir   /* Return to directory we started from */
call LineOut(xpost.lst)			/* now close the node data file... */
exit


RandomName:
do j = 1 to 8
	i = random(15)
	if i == 10 then i = a
	if i == 11 then i = b
	if i == 12 then i = c
	if i == 13 then i = d
	if i == 14 then i = e
	if i == 15 then i = f
	NewName = NewName||i
	end
Return NewName



HEXName:
Arg Zone'.'Net'.'Node'.'Point'.'Domain

HEXNet = d2x(Net)
HEXNode = d2x(Node)

If length(HEXNet) < 4 Then HEXNet = Right(HEXNet,4,0)
If length(HEXNode) < 4 Then HEXNode = Right(HEXNode,4,0)

NewName = HEXNet || HEXNode

Return NewName





GetExtension:

/* build monthdays array */
monthdays.1 = 31
monthdays.2 = 28
monthdays.3 = 31
monthdays.4 = 30
monthdays.5 = 31
monthdays.6 = 30
monthdays.7 = 31
monthdays.8 = 31
monthdays.9 = 30
monthdays.10 = 31
monthdays.11 = 30
monthdays.12 = 31

date1 = Date('S')

date1 = check_date(date1)

result_datergf = weekday(date1)

say result_datergf


NewExtension = substr(result_datergf,1,2)

Lowers='abcdefghijklmnopqrstuvwxyz'
Uppers='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

NewExtension = Translate(NewExtension,Uppers,Lowers)


return NewExtension



WEEKDAY: PROCEDURE EXPOSE monthdays.
    total_days = date2days(ARG(1))
    dayindex = (total_days + 2) // 7 + 1  /* normalize on Mondays = 1, ..., Sunday = 7 */

    IF ARG(2) = 'I' THEN result_function = dayindex
    ELSE IF ARG(2) = 'ALL' THEN result_function = total_days dayindex
    ELSE result_function = WORD("Monday Tuesday Wednesday Thursday Friday Saturday Sunday", dayindex)

    RETURN result_function


DATE2DAYS: PROCEDURE  EXPOSE monthdays.
    PARSE ARG year month day

    days_1    = year * 365
    leap_days = year % 4

    IF year > 0 THEN
    DO
       leap_days = leap_days + 1        /* account for leap year in 0000 */

       IF year > 1582 THEN days_1 = days_1 - 10 /* account for 1582, which had 10 days less */

       IF year > 1600 THEN         /* account for Gregorian calender */
       DO
           diff = year - 1600
           leap_days = leap_days - (diff % 100 - diff % 400)
           leap_year = (((diff // 4) = 0) & \((diff // 100) = 0)) | ((diff // 400)=0) /* leap year in hand ? */
       END
       ELSE leap_year = ((year // 4) = 0)       /* leap year in hand ? */

       leap_days = leap_days - leap_year
    END

    days_2 = SUBSTR(date2julian(ARG(1)), 5, 3)

    RETURN (days_1 + leap_days + days_2)
/* end of DATE2DAYS */

DATE2JULIAN: PROCEDURE EXPOSE monthdays.
    PARSE ARG year month day

    /* is year a leap year ? */
    IF year > 1582 THEN                 /* Gregorian calender */
       leap_year = (((year // 4) = 0) & \((year // 100) = 0)) | ((year // 400)=0)
    ELSE leap_year = (year // 4) = 0    /* Julian calender    */

    monthdays.2 = 28 + leap_year
    IF year = 1582 THEN monthdays.10 = 21       /* 1582: October just had 21 days */

    result_function = 0
    DO i = 1 TO month - 1
       result_function = result_function + monthdays.i
    END

    IF year = 1582 & month = 10 & day > 4 THEN day = day - 10       /* Gregorian: 10 days too many */
    result_function = result_function + day

    RETURN year||RIGHT(result_function,3,'0')
/* end of DATE2JULIAN */


CHECK_DATE: PROCEDURE EXPOSE monthdays. flag

    PARSE ARG 1 year 5 month 7 day 9

    IF \DATATYPE(year,'N') THEN
    DO
       errmsg = ARG(1)": year is not numeric"
       SIGNAL error
    END

    IF year < 0 THEN
    DO
       errmsg = ARG(1)": year must be 0000 or greater"
       SIGNAL error
    END

    /* is year a leap year ? */
    IF year > 1582 THEN                 /* Gregorian calender */
       leap_year = (((year // 4) = 0) & \((year // 100) = 0)) | ((year // 400)=0)
    ELSE leap_year = ((year // 4) = 0)  /* Julian calender    */

    monthdays.2 = 28 + leap_year
    IF year = 1582 THEN monthdays.10 = 21       /* 1582: October had 10 days less */

    SELECT
       WHEN \DATATYPE(month,'N') THEN
            DO
               errmsg = ARG(1)||": month is not numeric"
               SIGNAL error
            END
       WHEN (month < 1) | (month > 12) THEN
            DO
               errmsg = ARG(1)||": month out of range"
               SIGNAL error
            END
       OTHERWISE
            month = month % 1   /* get rid of leading nulls */
    END

    SELECT
       WHEN \DATATYPE(day,'N') THEN
            DO
               errmsg = ARG(1)": day is not numeric"
               SIGNAL error
            END
       WHEN (day < 1) THEN
            DO
               errmsg = ARG(1)": day out of range"
               SIGNAL error
            END
       WHEN year = 1582 & month = 10 THEN    /* Gregorian: 1582, October 1-4, 15-31 */
            DO
               IF (day > 4 & day < 15) | day > 31 THEN
               DO
                  IF day > 31 THEN
                     errmsg = ARG(1)": too many days for given month"
                  ELSE
                     errmsg = ARG(1)": day out of range (1582/10/05-1582/10/14 do not exist)"
                  SIGNAL error
               END
            END
       WHEN day > monthdays.month THEN
            DO
               errmsg = ARG(1)": too many days for given month"
               SIGNAL error
            END
       OTHERWISE
            day = day % 1 /* get rid of leading nulls */
    END

    RETURN year month day
/* end of CHECK_DATE */

