#ifndef __MAGIDOOR_H__
#define __MAGIDOOR_H__

#include <stdint.h>

#define MAGIDOOR_VERSION_MAJOR 1
#define MAGIDOOR_VERSION_MINOR 3

#define TRUE  1
#define FALSE 0

typedef struct MDDoorControl {
    char user_alias[32];
    char user_firstname[32];
    char user_lastname[32];
    int user_timeleft;
    char sysop_name[32];
    int node;
    char user_location[32];
    int user_seclevel;
    int socket;
} MDDoorControl_t;

extern MDDoorControl_t mdcontrol;


extern char md_getche(uint32_t sec, uint32_t usec);
extern void md_init(const char* dropfile, int socket);
extern void md_exit(int exitcode);
extern void md_putchar(char c);
extern void md_printf(const char* fmt, ...);
extern char md_getc();
extern int md_getstring(char* ptr, int maxlen, char minchar, char maxchar);
extern void md_sendfile(const char* filename, int pause);
extern void md_clr_scr();
extern void md_set_cursor(int y, int x);
extern char md_get_answer(const char* options);
#endif
