{

 SCATTER
 -------

 This external utility uses Specials to distribute items around the world in
 random places.

 "Specials" store one number for every map position in the world.
 SCATTER searches each map position for Special spots with a value > 0.

 For each of these Special spots found, SCATTER randomly decides whether an
 item should be placed there. The higher the Special type (1-5), the greater
 the chance of this.

 The next time SCATTER is run, the special spots are once again checked, but
 this time all the Special spots with items placed on the same spot, have
 their items *removed* before scattering more items.

 Distribute and modify freely,
 beau@corplink.com.au

 PS. It's documented, but if you have any questions just ask

}

{$I-}

Program Scatter;

Uses DOS;         { Used for FEXPAND, FSPLIT and FSEARCH }

{$I SWORLD.REC}   { From STRUCTS2.ZIP, Sage's Pascal Record structures,   }
{$I SMAP.REC}     { which are available at my web site among other places }

Var WorldPath : String;    { Path to the world you want to scatter items to }

    totalspecials,         { Total Special spots in world }
    totalitems,            { Total Items currently placed on Special spots }
    untouched,             { Items on Special spots which were left untouched }
    removed,               { Items on Special Spots which were removed }
    added : longint;       { Items on Special Spots added to the world }

    MapInf      : Maprec;        { One Map record }
    Templateinf : Templaterec;   { The World and Template information }


{----------------------------------------------------------[ Get Item ]-----
 Returns the number of the item to place, or 0 to place no item.
 ---------------------------------------------------------------------------}
Function GetItem(s : byte) : Byte;

Var Result : Longint;

Begin

 GetItem := 0;            { By default, place no item }

 { NOTE: TO REMOVE ALL ITEMS ON SPECIAL SPOTS,
   REMOVE THIS CLOSE COMMENT MARKER ---> }

 If s = 0 then{} Exit;    { If a special spot of type 0 is passed, exit,
                            but that should never happen because it's checked
                            before here }

 {

   Now generate a random number. The higher the special type,
   the higher the chances of an item being placed.

   Here are the exact odds for this calculation:

   Special Type         Odds
   ---------------------------------------------
        1               1:390
        2               1:360
        3               1:310
        4               1:240
        5               1:150

 }

 Result := 400 - (10 * (s * s));

 If Random(Result) = 1 then{}
 Begin
    GetItem := 1; { 1 = place item number 1 }
    If (s = 5) and (random(3) = 1) then GetItem := 3;
 End;

End;


{-----------------------------------------------------[ Read Template ]-----
 This is required to get the Map Window co-ordinates of the template screen.
 ---------------------------------------------------------------------------}
Procedure Read_SWORLD;

Var tf : file; { File var of SWORLD.DAT }

Begin
 Assign(tf, Worldpath + 'SWORLD.DAT');
 Reset(tf, 1);
 BlockRead(tf, TemplateInf, sizeof(Templateinf));
 Close(tf);
End;


{-------------------------------------------------------[ Process Map ]-----
 Processes the next map screen in the SMAP.DAT file, adding, removing or
 leaving items.
 ---------------------------------------------------------------------------}
Procedure ProcessMap(var mapf : file); { Receives file var of SMAP.DAT }

var startpos,       { The starting file position of the map screen }
    li : longint;   { Multiple use longinteger variable }
    ti,             { An item number }
    x, y : byte;    { Used as counters for the X and Y co-ordinates }

Begin

 startpos := filepos(mapf);    { Save file position of the first map screen }
 BlockRead(mapf, Mapinf, sizeof(Mapinf));        { Read the map screen info }
 If Ioresult > 0 then;                                  { Ignore I/O errors }

 { Because you can't have more than 1600 hotspots in a map screen,
   we can check if there is an error in the file here }
 If mapinf.maphotspots > 1600 then
 Begin
   close(mapf);
   exit;
 End;


 { Traverse every map position in the map screen }
 For x := TemplateInf.MapWindow_x1 to TemplateInf.MapWindow_x2 do
 For y := TemplateInf.MapWindow_y1 to TemplateInf.MapWindow_y2 do

   { Only process if this map position is Special }
   If (Mapinf.Mapposinf[x, y].Special > 0) then
   Begin

     { Get the item number to place here, (0 means no item) }
     ti := GetItem(MapInf.MapPosInf[x, y].Special);

     { If the item to place is already there, there is no need to process
       this map position }
     if (ti = Mapinf.Mapposinf[x, y].Item) then
     Begin

       { Update some counting variables }
       if ti > 0 then
       Begin
         inc(untouched);
         inc(totalitems);
       End;

       { Abort processing this map position and go onto the next one }
       Continue;

     End;

     {------------------------------------------------------}
     { We're adding or removing an item from a special spot }
     {------------------------------------------------------}

     { Update some counting variables }
     if ti = 0 then inc(removed)
               else Begin
                      inc(added);
                      Inc(totalitems);
                    End;

     { Now we need to write the new item number to the Mapposition.Item byte
       for this map position.

     { Calculate how far this map position is into the file }
     li := Sizeof(mapposrec)
           * (
              ((x - 1) * 20)
             + (y - 1)
             );

     Seek(mapf, startpos              { Seek to the start of the map screen }
              + sizeof(Mapinf.MapName)
              + sizeof(Mapinf.RandomFLE)         { Past all the other }
              + sizeof(Mapinf.Chance)            { Mapinf variables.. }
              + sizeof(Mapinf.MapHotspots)
              + li  { Past all the other map positions.. }
              + 2); { Mapposition.Item is the 3rd byte in the Mapposition
                      record }

     { Write the new item to the file }
     BlockWrite(mapf, ti, 1);

     { Display it to the screen (removed - BB) }
     {Writeln(mapinf.mapname,', (', x, ',',y,') ', ti);{}

   End;

 { Seek past this entire map screen and it's hotspots,
   ready to process the next one. }
 Seek(mapf, startpos
          + sizeof(mapinf)
          + (sizeof(hotspot) * mapinf.maphotspots));

End;


{-----------------------------------------------------[ Process World ]-----
 Processes every map screen in the SMAP.DAT file.
 ---------------------------------------------------------------------------}
Procedure Process_SMAP;

Var Mapf : File; { The SMAP.DAT file to be processed }

Begin

 { Open the SMAP.DAT file }
 Assign(mapf, Worldpath + 'SMAP.DAT');
 Reset(mapf, 1);

 { Process each map screen within the SMAP.DAT file }
 While not eof(mapf) do
 Begin
   ProcessMap(mapf);  { Call the Processing procedure }
   Write('.');        { Write one dot to the screen for each map processed }
 End;

 Close(mapf);

End;


{--------------------------------------------------------[ Extract Dir ]-----
 Small procedure which just extracts the Directory from a Path String. Used
 for getting the path which SCATTER is being run (that's where the world is
 that will be processed).
 ---------------------------------------------------------------------------}
Function ExtractDir( Path: DirStr ): String;  { Receives a pathname }

Var dir : DirStr;
    name: NameStr;
    ext : ExtStr;

Begin

 If Pos('\', path) > 0 then
 Begin
   FSplit( path, dir, name, ext );
   ExtractDir := dir;
 End
 Else ExtractDir := '';

End;


{-------------------------------------------------------[ Check Exist ]-----
 Another small procedure. Terminates the program if a file doesn't exist.
 ---------------------------------------------------------------------------}
Procedure CheckExist(Path : DirStr);  { Receives the pathname to check }
Begin

 If (FSearch(Path, '') = '') then { If the file doesn't exist, }
 Begin
   Writeln('Could not find ', Path, ', aborting..'); { say so, }
   Halt(1);                                          { and terminate. }
 End;

End;


{------------------------------------------------------------------- Main --}
Begin

 Writeln;

 { Initialise the Random number generator }
 Randomize;

 { Initialise the counting variables }
 removed       := 0;
 added         := 0;
 totalitems    := 0;

 { Get the path where SCATTER is being run.
   That's where the world is that will be processed. }
 WorldPath := ExtractDir(FExpand(Paramstr(0)));
 If Paramcount > 0 then WorldPath := ParamStr(1);

 { Check that a world exists there }
 CheckExist(WorldPath + 'SWORLD.DAT');
 CheckExist(WorldPath + 'SMAP.DAT');

 { Everything seems okay, time to start processing }
 Writeln('Scattering items around the world..');
 Writeln;

 { Call the Read_SWORLD and Process_SMAP procedures }
 Write('Reading ', WorldPath + 'SWORLD.DAT ..');  Read_SWORLD;  Writeln(' (ok!)');
 Write('Processing ', WorldPath + 'SMAP.DAT ..'); Process_SMAP; Writeln(' (ok!)');

 { Display the final results }
 Writeln;
 Writeln('Removed   : ', removed);
 Writeln('Added     : ', added);
 Writeln('Untouched : ', untouched);
 Writeln('Total now : ', totalitems);

 Writeln;
 Writeln('Exiting..');

End.
