#if WIN32
#   define _MSC_VER 1
#	define _CRT_SECURE_NO_WARNINGS
#   include <Windows.h>
#else
#
#endif

#include <OpenDoor.h>
#include <time.h>
#include <stdlib.h>
#include <ctype.h>
enum peg_colors {
	green,
	blue,
	red,
	purple,
	yellow,
	brown
};

void shuffle(int *array, size_t n)
{
	if (n > 1)
	{
		size_t i;
		for (i = 0; i < n - 1; i++)
		{
			size_t j = i + rand() / (RAND_MAX / (n - i) + 1);
			int t = array[j];
			array[j] = array[i];
			array[i] = t;
		}
}
}

#if _MSC_VER
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
#else
int main(int argc, char **argv)
{
#endif

	int done = 0;
	int secret[6];
	int i, j;
	int turn = 0;
	int guess[4];
	char ch;
	int white_pegs;
	int black_pegs;

#if _MSC_VER
	od_parse_cmd_line(lpszCmdLine);
#else
	od_parse_cmd_line(argc, argv);
#endif
	od_init();
	srand(time(NULL));

	while (!done) {
		od_clr_scr();
		od_send_file("mastermind.ans");

		for (i = 0; i < 6; i++) {
			secret[i] = i;
		}
		shuffle(secret, 6);

		while (1) {
			// clear board
			for (turn = 0; turn < 12; turn++) {
				for (i = 0; i < 4; i++) {
					od_set_cursor(turn + 5, i * 2 + 9);
					od_printf("`bright black`\xfe");
				}
				for (i = 0; i < 4; i++) {
					od_set_cursor(turn + 5, i * 2 + 20);
					od_printf("  ");
				}
			}
			for (turn = 0; turn < 12; turn++) {
				for (i = 0; i < 4; i++) {
					od_set_cursor(turn + 5, i * 2 + 9);
					ch = od_get_answer("AaBbCcDdEeFfQq");
					switch (tolower(ch)) {
					case 'a':
						od_printf("`bright green`\xfe`white`");
						guess[i] = green;
						break;
					case 'b':
						od_printf("`bright cyan`\xfe`white`");
						guess[i] = blue;
						break;
					case 'c':
						od_printf("`bright red`\xfe`white`");
						guess[i] = red;
						break;
					case 'd':
						od_printf("`bright magenta`\xfe`white`");
						guess[i] = purple;
						break;
					case 'e':
						od_printf("`bright yellow`\xfe`white`");
						guess[i] = yellow;
						break;
					case 'f':
						od_printf("`yellow`\xfe`white`");
						guess[i] = brown;
						break;
					case 'q':
						od_exit(0, FALSE);
					}

				}
				// calculate clue pegs.
				black_pegs = 0;
				white_pegs = 0;
				for (i = 0; i < 4; i++) {
					for (j = 0; j < 4; j++) {
						if (guess[i] == secret[j]) {
							black_pegs++;
							break;
						}
					}
				}

				for (i = 0; i < 4; i++) {
					if (guess[i] == secret[i]) {
						white_pegs++;
						black_pegs--;
					}
				}
				if (white_pegs == 4) {
					// you win
					break;
				}
				// display pegs
				for (i = 0; i < 4; i++) {
					od_set_cursor(turn + 5, i * 2 + 20);
					if (white_pegs > 0) {
						od_printf("`bright white`\xfe");
						white_pegs--;
					}
					else if (black_pegs > 0) {
						od_printf("`bright black`\xfe");
						black_pegs--;
					}
				}
			}
			if (white_pegs == 4) {
				od_set_cursor(turn + 5, 20);
				od_printf("`bright green`YOU WON!");
			}
			for (i = 0; i < 4; i++) {
				od_set_cursor(19, i * 3 + 6);
				switch (secret[i]) {
				case green:
					od_printf("`bright green`\xdb\xdb");
					break;
				case blue:
					od_printf("`bright cyan`\xdb\xdb");
					break;
				case red:
					od_printf("`bright red`\xdb\xdb");
					break;
				case purple:
					od_printf("`bright magenta`\xdb\xdb");
					break;
				case yellow:
					od_printf("`bright yellow`\xdb\xdb");
					break;
				case brown:
					od_printf("`yellow`\xdb\xdb");
					break;
				}
			}
			od_get_key(TRUE);
		}
	}

	od_exit(0, FALSE);
}
