{$M 19456,0,655360}

PROGRAM EclecticAvenue ;

USES DOS, APMisc, CRT, ApPort, ApUART, ApCom, ApTimer, EADef,
     JPDoor32, EASup, Play, EAUtils ;

CONST
   Version             = '2.02FW' ;


VAR
   IRQVector                  : BYTE ;
   Holding                    : CHAR ;
   Register                   : LONGINT ;
   BaudRate                   : LONGINT ;
   EndProgram                 : BOOLEAN ;
   GameStarted                : BOOLEAN ;
   GoLocal                    : BOOLEAN ;
   DoCopy                     : BOOLEAN ;
   CopyPath                   : STRING ;
   PlayerNumber               : BYTE ;
   ComPortNameSetting         : ComNameType ;
   ch                         : char ;
   tbool                      : boolean ;


PROCEDURE UpdatePlayer ;
BEGIN
   fn := 'EA.DAT' ;
   ASSIGN(UserFile,fn) ;
   RESET(UserFile) ;
   WHILE NOT EOF(UserFile) DO BEGIN
      READUser ;
      IF User.Alias = Alias THEN BEGIN
         WRITELN(' Updating player ',Alias) ;
         GetDate(yr,mn,dt,dy) ;
         User.LastOn := Julian(yr,mn,dt) ;
         User.GamesStarted := GamesStarted ;
         User.LastStarted := LastStarted ;
         SEEK(UserFile,FilePos(UserFile)-1) ;
         WRITEUser ;
         SEEK(UserFile,FileSize(UserFile)) ;
      END ;
   END ;
   CLOSE(UserFile) ;
END ;


PROCEDURE CloseGame(IsOn:BOOLEAN) ;
BEGIN
   WRITELN(' Closing game files') ;
   IF InAGame THEN BEGIN
      GameInfo.InUse := FALSE ;
      WriteThisGame ;
   END ;
   IF GameStarted THEN BEGIN
      UpdatePlayer ;
   END ;
   IF IsOn THEN BEGIN
      MakeTournFile ;
   END ;
   RemoveUser(Info.CommDrive,UserName) ;
   IF IsOn THEN BEGIN
      StatusLineOn := FALSE ;
      SetColor(0,7,0) ;
      ClearScreen ;
   END ;
END ;


PROCEDURE KillPort(Wait:BOOLEAN) ;
BEGIN
   IF NOT UseAsync THEN EXIT ;
   IF Wait THEN WHILE OutBuffUsed(P) > 0 DO {wait} ;
   DeactivatePort(P,TRUE) ;
END ;


Procedure Terminate(n:byte) ;
begin
  if rip then begin
     crlf ;
     sendout('!|1K|*|#|#|#') ;
  end ;
  case n of
    0 : begin
          CloseGame(TRUE) ;
          LastComments ;
          KillPort(TRUE) ;
        end ;
    1 : begin
          Writeln(' Carrier lost') ;
          CloseGame(FALSE) ;
          KillPort(FALSE) ;
        end ;
    2 : begin
          Writeln(' Time limit exceeded') ;
          CloseGame(TRUE) ;
          LastComments ;
          KillPort(FALSE) ;
        end ;
    3 : begin
          Writeln(' User inactive') ;
          CloseGame(FALSE) ;
          LastComments ;
          KillPort(FALSE) ;
        end ;
    4 : begin
           If Not DoorSys then
             Writeln(' Dorinfo'+Node+'.Def file not found')
           else Writeln(' Door.Sys file not found') ;
        end ;
    5 : begin
           Writeln('DOOR.SYS or DORINFOx.DEF file not found') ;
        end ;
    6 : begin
           Writeln(' Directory read/change error') ;
        end ;
    7 : begin
          Writeln(' CTS timeout error') ;
          CloseGame(FALSE) ;
          KillPort(FALSE) ;
        End ;
    8,
    10: begin  {null exit - like no ansi enabled, no config file specified}
           RemoveUser(Info.CommDrive,UserName) ;
           StatusLineOn := FALSE ;
           clearscreen ;
           LastComments ;
           KillPort(TRUE) ;
        end ;
    15: begin
        end ;
    else CloseGame(FALSE) ;  { probable runtime error. check .log}
  end ;  { case }
end ;

{$I EAExit}

{$F+}
PROCEDURE ALT_E ;
BEGIN
   CRLF ;
   CRLF ;
   Display(0,9,0,'The SysOp has requested your presence back on the BBS!') ;
   CRLF ;
   HALT(0) ;
END ;
{F-}


PROCEDURE GETPARMS ;
BEGIN
   GoLocal := FALSE ;
   DoCopy := FALSE ;
   CopyPath := '' ;
   IF Paramcount = 0 THEN BEGIN
      WRITELN(#7,'NO CONFIGURATION FILENAME SPECIFIED!') ;
      DELAY(2000) ;
      HALT(10) ;
   END ;
   ConfigFileName := ParamStr(1) ;
   IF Paramcount > 1 THEN BEGIN
      IF (ParamStr(2) = '/M') OR (ParamStr(2) = '/m') THEN BEGIN
         DoMaintenance(1) ;
         HALT(15) ; {do nothing at all exit}
      END ELSE IF (ParamStr(2) = '/R') OR (ParamStr(2) = '/r') THEN BEGIN
         Restart ;
         HALT(15) ; {do nothing at all exit}
      END ELSE IF (ParamStr(2) = '/C') OR (ParamStr(2) = '/c') THEN BEGIN
         DoMaintenance(2) ;
         HALT(15) ;
      END ELSE IF (ParamStr(2) = '/I') OR (ParamStr(2) = '/i') THEN BEGIN
         ImportTrivia ;
         HALT(15) ;
      END ELSE IF (ParamStr(2) = '/L') OR (ParamStr(2) = '/l') THEN BEGIN
         GoLocal := TRUE ;
      END ELSE IF (ParamStr(2) = '/D') OR (ParamStr(2) = '/d') THEN BEGIN
         DoCopy := TRUE ;
         CopyPath := ChangeCase(ParamStr(3)) ;
      END ;
   END ;
END ;


PROCEDURE GetConfig ;
BEGIN
   GetParms ;
   fn := ConfigFileName ;
   ASSIGN(ConfigFile,fn) ;
   {$I-} RESET(ConfigFile) ; {$I+} ;
   IF IORESULT <> 0 THEN BEGIN
      WRITELN(#7,'NO CONFIGURATION FILENAME FOUND!') ;
      DELAY(2000) ;
      HALT(10) ;
   END ;
   READ(ConfigFile,Info) ;
   CLOSE(ConfigFile) ;
END ;


FUNCTION GetUserVals : INTEGER ;
VAR
   j         : BYTE ;
   UserVal1,
   UserVal2  : INTEGER ;
BEGIN
   UserVal1 := 0 ; UserVal2 := 0 ;
   FOR j := 1 TO LENGTH(Info.OpName) DO BEGIN
      UserVal1 := UserVal1 + ORD(Info.OpName[j]) ;
   END ;
   FOR j := 1 TO LENGTH(Info.SysName) DO BEGIN
      UserVal2 := UserVal2 + ORD(Info.SysName[j]) ;
   END ;
   GetUserVals := UserVal1 + UserVal2 ;
   EXIT ;
END ;


 PROCEDURE GetUserInfo ;
 VAR
    PlayerFound    : BOOLEAN ;
    b,a            : CHAR ;
    Tstr           : STRING[45] ;
    jj             : BYTE ;
    Found          : BOOLEAN ;
    counter        : INTEGER ;
 BEGIN
    counter:=0 ;
    IF Info.MultiLine THEN BEGIN
       IF Activity(Info.CommDrive,3) THEN BEGIN
          CRLF ;
          DISPLAY(0,10,0,'Another node is logging on.') ;
          CRLF ;
          sdisplay(0,14,1,'Please stand by...') ;
          REPEAT
             DELAY(5000) ;
             sDisplay(0,14,0,'.') ;
             INC(counter) ;
             chkconnect ;
             if counter > 6 then clearactivity(Info.CommDrive,3) ;
          UNTIL NOT Activity(Info.CommDrive,3) ;
          CRLF ; CRLF ;
          Display(0,10,0,'Continuing') ;
       END ;
    END ;
    SetActivity(Info.CommDrive,UserName,3) ;
    b := #0 ; Tstr := '' ;

    filemode := 66 ;

    fn := 'EA.DAT' ;
    ASSIGN(UserFile,fn) ;
    {$I-} RESET(UserFile) ; {$I+}
    IF IORESULT <> 0 THEN REWRITE(UserFile) ;

    PlayerFound := FALSE ;
    WHILE NOT EOF(UserFile) DO BEGIN
       READUser;
       IF User.Name = UserName THEN BEGIN
          PlayerFound := TRUE ;
          Alias := User.Alias ;
          GetDate(yr,mn,dt,dy) ;
          IF (Julian(yr,mn,dt) - User.LastStarted) >= Info.GameRetention THEN BEGIN
             GamesStarted := 0 ;
             User.GamesStarted := 0 ;
             LastStarted := Julian(yr,mn,dt) ;
             User.LastStarted := LastStarted ;
             SEEK(UserFile,FilePos(UserFile)-1) ;
             WRITEUser ;
          END ELSE BEGIN
             GamesStarted := User.GamesStarted ;
             LastStarted := User.LastStarted ;
          END ;
          SEEK(UserFile,FileSize(UserFile)) ;
       END ;
    END ;
    CLOSE(UserFile) ;

    SetActivity(Info.CommDrive,UserName,1) ;

    IF NOT PlayerFound THEN BEGIN               { new player  }
       GetDate(yr,mn,dt,dy) ;
       User.LastOn := Julian(yr,mn,dt) ;
       user.gameswon := 0 ;
       FirstTimer := TRUE ;
       CRLF ;
       filemode := 66 ;
       GameScreen('ANSFILES\WelCome.ans') ;
       repeat
          holding := getchar ;
       until holding = #13 ;

       IF Info.UseHandles THEN BEGIN
          REPEAT
             filemode := 66 ;
             ClearScreen ;
             GameScreen('ANSFILES\Alias.ans') ;
             CRLF ;
             sDisplay(0,14,0,'Alias: ') ;
             Tstr := GetInput('',1,35) ;
             IF Tstr = '' THEN Alias := UserName ELSE Alias := LTrim(RTrim(Tstr)) ;

             Found := FALSE ;

             Filemode := 66 ;
             fn := 'EA.DAT' ;
             ASSIGN(UserFile,fn) ;
             RESET(UserFile) ;
             WHILE NOT EOF(UserFile) DO BEGIN
                READUser ;
                IF (User.Alias = Alias) OR (User.Name = Alias) THEN BEGIN
                   Found := TRUE ;
                   SEEK(Userfile,Filesize(Userfile)) ;
                END ;
             END ;
             CLOSE(UserFile) ;

             IF Found THEN BEGIN
                Crlf ;
                Display(0,12,1,'That alias has already been used!') ;
                Crlf ;
             END ELSE BEGIN
                ResetButtons ;
                AddButton('Y') ;
                AddButton('N') ;
                SendButtons(#13) ;
                crlf ;
                sdisplay(0,15,0,'Use alias: ') ;
                display(0,14,0,formatstr(alias)) ;
                crlf ;
                sdisplay(0,10,0,'Correct? [y,n]: ') ;
                repeat
                   b := upcase(getchar) ;
                until b in ['Y','N'] ;
                display(0,15,0,b) ;
                if b = 'N' then found := true ;
             END ;
             IF NOT Found THEN BEGIN
                IF BummerList(alias) THEN Found := TRUE ;
             END ;
          UNTIL NOT Found ;
       END ELSE Alias := UserName ;
       User.Sex := 'M' ;
       User.Preferrence := 'S' ;
       User.Name := UserName ;
       User.Alias := Alias ;
       User.GamesStarted := 0 ;
       GetDate(yr,mn,dt,dy) ;
       User.LastStarted := Julian(yr,mn,dt) ;
       GamesStarted := 0 ;
       LastStarted := User.LastStarted ;
       ResetButtons ;
       AddButton('Y') ;
       AddButton('N') ;
       SendButtons(#13) ;
       crlf ;
       display(0,10,0,'This is your chance to bail out.') ;
       crlf ;
       sdisplay(0,13,0,'Would you like to join the game? [y,n]: ') ;
       repeat
          a := upcase(getchar) ;
       until a in ['Y','N'] ;
       display(0,15,0,a) ;
       if a = 'N' then halt(8) ;

       filemode := 66 ;
       fn := 'EA.DAT' ;
       ASSIGN(UserFile,fn) ;
       RESET(UserFile) ;
       SEEK(UserFile,FileSize(UserFile)) ;
       WRITEUser;
       CLOSE(UserFile) ;
    END ;
 END ;


FUNCTION GetGameNumbers : BYTE ;
VAR
   j,
   Howmany  : BYTE ;
BEGIN
   HowMany := 0 ;
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   {$I-} RESET(GameFile) ; {$I+}
   IF IOresult <> 0 THEN BEGIN
      REWRITE(GameFile) ;
      CLOSE(GameFile) ;
      GetGameNumbers := 0 ;
      Exit ;
   END ELSE BEGIN
      WHILE NOT EOF(GameFile) DO BEGIN
         READGame ;
         FOR j := 1 TO 8 DO BEGIN
            IF (GameInfo.PlayerName[j] = Alias)
            AND (NOT GameInfo.OutOfGame[j]) THEN BEGIN
               INC(HowMany) ;
               j := 8 ;
            END ;
         END ;
      END ;
      CLOSE(GameFile) ;
   END ;
   GetGameNumbers := HowMany ;
END ;


FUNCTION ShowGamesIn(y,d:BYTE) : BYTE ;
VAR
   j     : BYTE ;
   Tval  : BYTE ;
BEGIN
   FOR j := 1 TO 10 DO GamesInList[j] := 0 ;
   Tval := 0 ;
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   WHILE NOT EOF(GameFile) DO BEGIN
      READGame ;
      FOR j := 1 TO 8 DO BEGIN
         IF (GameInfo.PlayerName[j] = Alias) AND
         (NOT GameInfo.OutOfGame[j]) THEN BEGIN
            IF y = 1 THEN BEGIN          { show all games participating in }
               INC(Tval) ;
               if d=1 then sDisplay(0,12,0,'#'+ItoA(FilePos(GameFile))+' ') ;
               GamesInList[Tval] := FilePos(GameFile) ;
               j := 8 ;
            END ELSE BEGIN               { show games that can be played }
               IF (GameInfo.LastDate[j] = Date) AND
                  (GameInfo.TurnCount[j] >= Info.TurnsPerGame) THEN BEGIN
               END ELSE BEGIN
                  INC(Tval) ;
                  if d=1 then sDisplay(0,14,0,'#'+ItoA(FilePos(GameFile))+' ') ;
                  GamesInList[Tval] := FilePos(GameFile) ;
                  j := 8 ;
               END ;
            END ;
         END ;
      END ;
   END ;
   CLOSE(GameFile) ;
   IF (Tval = 0) and (d=1) THEN sDisplay(0,14,0,'None!') ;
   ShowGamesIn := Tval ;
END ;


PROCEDURE InitGameData ;
VAR
   j            : BYTE ;
   yr,mn,dt,dy  : WORD ;
   hr,min,sec,
   sec100       : WORD ;
   chx          : CHAR ;
   tstr1,
   tstr2        : STRING[12] ;
BEGIN
   GetDate(yr,mn,dt,dy) ;
   GetTime(hr,min,sec,sec100) ;
   GetDefaults ;
   WITH GameInfo DO BEGIN
      GameId := FixByte(dt)+FixByte(hr)+FixByte(min)+
                FixByte(sec)+FixByte(sec100) ;
      For j := 1 to 8 do PlayerName[j] := '' ;
      For j := 1 to 8 do PlayerScore[j] := 0 ;
      For j := 1 to 8 do TurnCount[j] := 0 ;
      For j := 1 to 8 do PlayerSquareNumber[j] := 1 ;
      For j := 1 to 8 do LastDate[j] := '' ;
      StartDate := Julian(yr,mn,dt) ;
      for j := 1 to 8 do OutOfGame[j] := false ;
      for j := 1 to 8 do InJail[j] := false ;
      for j := 1 to 8 do GetOutOfJail[j] := false ;
      for j := 1 to 8 do DartScore[j] := 0 ;
      InUse := FALSE ;
      if info.allowrestrictions then begin
         crlf ;
         sdisplay(0,15,0,'How many players will be allowed? [2..<8>]: ') ;
         repeat
            chx := getchar ;
            if chx = #13 then chx := '8' ;
         until chx in ['2','3','4','5','6','7','8'] ;
         display(0,14,0,chx) ;
         NumberOfPlayers := atoi(chx) ;
         repeat
            crlf ;
            display(0,15,0,'Enter password [5..12 chars.] for this game or press <ENTER> for none.') ;
            sdisplay(0,15,0,'> ') ;
            Tstr1 := GetInput('',1,12) ;
            if tstr1 <> '' then begin
               display(0,14,0,'Re-enter the password for verification.') ;
               sdisplay(0,14,0,'> ') ;
               Tstr2 := GetInput('*',1,12) ;
               if tstr1 <> tstr2 then begin
                  crlf ;
                  display(0,12,0,'Passwords do not match!') ;
               end else begin
                  if length(tstr1) < 5 then begin
                     crlf ;
                     display(0,12,0,'Password must be at least 5 characters!') ;
                  end ;
               end ;
            end ;
         until ((tstr1 = tstr2) and ((length(tstr1) > 4) and (length(tstr2) > 4)))
               OR (tstr1 = '') ;
         password := tstr1 ;
      end else begin
         password := '' ;
         numberofplayers := 8 ;
      end ;
   END;
END;


FUNCTION TestPassword(Gnum : BYTE) : BOOLEAN ;
VAR
   i    : BYTE ;
   tstr : string[12] ;
BEGIN
   fn := 'EA.GAM' ;
   assign(gamefile,fn) ;
   reset(gamefile) ;
   seek(gamefile,gnum-1) ;
   readgame ;
   close(gamefile) ;
   if gameinfo.password <> '' then begin
      crlf ;
      display(0,15,0,'This game is password-protected.  Please enter the password.') ;
      sdisplay(0,15,0,'> ') ;
      tstr := getinput('*',1,12) ;
      if tstr <> gameinfo.password then begin
         crlf ;
         display(0,12,0,'Incorrect password!') ;
         testpassword := false ;
         delay(2000) ;
         exit ;
      end ;
      display(0,10,0,'Access granted.') ;
      testpassword := true ;
      exit ;
   end else begin
      testpassword := true ;
      exit ;
   end ;
END ;


PROCEDURE AddPlayer(Gnum : BYTE) ;
VAR
   i   : BYTE ;
BEGIN
   fn := 'EA.GAM' ;
   ASSIGN(GameFile,fn) ;
   RESET(GameFile) ;
   SEEK(GameFile,Gnum-1) ;
   READGame ;
   FOR i := 1 TO 8 DO BEGIN
      IF GameInfo.PlayerName[i] = '' THEN BEGIN
         GameInfo.PlayerName[i] := Alias ;
         GameInfo.PlayerScore[i] := 500 ;
         GameInfo.TurnCount[i] := 0 ;
         GameInfo.PlayerSquareNumber[i] := 1 ;
         GameInfo.LastDate[i] := Date ;
         GameInfo.OutOfGame[i] := FALSE ;
         GameInfo.InJail[i] := FALSE ;
         GameInfo.GetOutOfJail[i] := FALSE ;
         SEEK(GameFile,Gnum-1) ;
         WRITEGame ;
         i := 8 ;
      END ;
   END ;
   CLOSE(GameFile) ;
END ;



FUNCTION ShowJoinGames(n:byte) : BYTE ;
{ if n = 1 then rebuild the index }
VAR
   Found     : BOOLEAN ;
   Room      : BOOLEAN ;
   j         : BYTE ;
   i         : BYTE ;
   howmany   : BYTE ;
BEGIN
   if n = 1 then begin
      FOR j := 1 TO 100 DO JoinGameList[j] := 0 ;
      i := 0 ;
      fn := 'EA.GAM' ;
      ASSIGN(GameFile,fn) ;
      RESET(GameFile) ;
      WHILE NOT EOF(GameFile) DO BEGIN
         READGame ;
         Found := FALSE ;
         FOR j := 1 TO 8 DO BEGIN
            IF GameInfo.PlayerName[j] = Alias THEN BEGIN
               Found := TRUE ;
               j := 8 ;
            END;
         END;
         IF NOT Found THEN BEGIN
            Room := FALSE ;
            FOR j := 1 TO gameinfo.numberofplayers DO BEGIN
               IF GameInfo.PlayerName[j] = '' THEN BEGIN
                  Room := TRUE ;
                  INC(i) ;
                  JoinGameList[i] := FilePos(GameFile) ;
                  IF i MOD 20 = 0 THEN Crlf ;
                  sDisplay(0,15,0,'#'+ItoA(FilePos(GameFile))+' ') ;
                  j := gameinfo.numberofplayers ;
               END;
            END;
         END;
      END;
   CLOSE(GameFile) ;
   end else begin
      i := 0 ;
      for j := 1 to 100 do begin
         if JoinGameList[j] <> 0 then begin
            sdisplay(0,15,0,'#'+ItoA(JoinGameList[j])+' ') ;
            inc(i) ;
         end ;
      end ;
   end ;
   ShowJoinGames := i ;
END;


PROCEDURE ReadMenu ;
BEGIN
   crlf ;
   sDisplay(1,15,0,'  R E A D  M E S S A G E S  ') ;
   Display(0,15,0,' ') ;
   crlf ;
   ResetButtons ;
   AddButton('A') ;
   AddButton('N') ;
   AddButton('F') ;
   AddButton('T') ;
   SendButtons(#13) ;
   sdisplay(0,14,0,'Read Messages: ') ;
   sdisplay(0,9,0,'A') ;
   sdisplay(0,3,0,'>ll, ') ;
   sdisplay(0,9,0,'N') ;
   sdisplay(0,3,0,'>ew, ') ;
   sdisplay(0,9,0,'F') ;
   sdisplay(0,3,0,'>rom You, ') ;
   sdisplay(0,9,0,'T') ;
   sdisplay(0,3,0,'>o You ') ;
   sdisplay(0,15,0,': ') ;
END ;



PROCEDURE MessageMenu ;
VAR
   jp   : char ;
BEGIN
   repeat
      clearscreen ;
      crlf ;
      ResetButtons ;
      AddButton('C') ;
      AddButton('R') ;
      AddButton('W') ;
      AddButton('X') ;
      SendButtons(#13) ;
      sDisplay(1,15,0,'  Y O U R   C H O I C E S  ') ;
      Display(0,15,0,' ') ;
      crlf ;
      sDisplay(0,14,0,'C') ;
      Display(0,11,0,'>heck your mailbox') ;
      sDisplay(0,14,0,'R') ;
      Display(0,11,0,'>ead messages') ;
      sDisplay(0,14,0,'W') ;
      Display(0,11,0,'>rite a message') ;
      sdisplay(0,11,0,'e<') ;
      sDisplay(0,14,0,'X') ;
      Display(0,11,0,'>it message menu') ;
      crlf ;
      sdisplay(0,14,0,'Select: ') ;
      repeat
         jp := upcase(getchar) ;
      until jp in ['C','R','W','X'] ;
      display(0,15,0,jp) ;
      case jp of
         'C' : begin
                  CheckMail('E') ;
               end ;
         'R' : begin
                  ReadMenu ;
                  repeat
                     jp := upcase(getchar) ;
                     if jp = #13 then jp := 'Q' ;
                  until jp in ['A','N','F','T','Q'] ;
                  display(0,15,0,jp) ;
                  case jp of
                     'A','N',
                     'F','T' : CheckMail(jp) ;
                  end ;
               end ;
         'W' : begin
                  MakeMessage('') ;
                  More('Press <any key> to continue',12) ;
               end ;
      end ;
   until jp = 'X' ;
END ;


FUNCTION SubMenu_1(GamesIn,t:BYTE) : CHAR ;
VAR
   ch    : CHAR ;
   tb,
   s_on,
   p_on,
   j_on  : BOOLEAN ;
BEGIN
   s_on := false ;
   p_on := false ;
   j_on := false ;

   if rip then local := true ;
   if rip then clearscreen ;
   Crlf ;
   sDisplay(1,15,0,'  Y O U R   C H O I C E S  ') ;
   Display(0,15,0,' ') ;
   crlf ;
   sDisplay(0,14,0,'I') ;
   Display(0,11,0,'>nstructions') ;
   if rip then local := false ;
   IF (GamesIn > 0) and (t > 0) THEN BEGIN
      p_on := true ;
      if rip then local := true ;
      sDisplay(0,14,0,'P') ;
      Display(0,11,0,'>lay A Game You''re In') ;
      if rip then local := false ;
   END ;
   IF (GamesStarted < Info.MaxGamesStarted) AND
      (GamesIn < Info.MaxParticipate) THEN BEGIN
      s_on := true ;
      if rip then local := true ;
      sDisplay(0,14,0,'S') ;
      Display(0,11,0,'>tart A New Game') ;
      if rip then local := false ;
   END ;
   IF GamesIn < Info.MaxParticipate THEN BEGIN
      j_on := true ;
      if rip then local := true ;
      sDisplay(0,14,0,'J') ;
      Display(0,11,0,'>oin A Game You''re Not In') ;
      if rip then local := false ;
   END ;
   if rip then local := true ;
   sDisplay(0,14,0,'T') ;
   Display(0,11,0,'>ournament Scores') ;
   sDisplay(0,14,0,'V') ;
   Display(0,11,0,'>iew Games (Past/Present)') ;
   sDisplay(0,14,0,'M') ;
   Display(0,11,0,'>essages') ;
   sDisplay(0,14,0,'Q') ;
   Display(0,11,0,'>uit') ;
   Crlf ;
   sDisplay(0,9,0,'Select or ') ;
   sDisplay(0,14,0,'H') ;
   sDisplay(0,9,0,'>elp: ') ;
   if rip then begin
      local := false ;
      {RipSeqON ; }
      GameScreenClear := false ;
      GameScreen('EAMAIN.RIP') ;
      GameScreenClear := true ;
      if (p_on) or (s_on) or (j_on) then begin
         SendOut('!|1B00000301DU0303000F080700020E07000000') ;
         SendOut('!|Y01000200') ;
      end ;
      if j_on then SendOut('!|1U9G48A04O2200<>Join a Game<>J') ;
      if s_on then SendOut('!|1U9G4WA05C2B00<>Start a New Game<>S') ;
      { RipSeqOFF ; }
      tb := snoop ;
      snoop := false ;
      ClearScreen ;
      sDisplay(0,10,0,'Players may participate in up to ') ;
      sDisplay(0,15,0,ItoA(Info.MaxParticipate)) ;
      sDisplay(0,10,0,' games.  Each game lasts for ') ;
      sDisplay(0,15,0,ItoA(Info.GameRetention)) ;
      Display(0,10,0,' days.') ;
      Crlf ;
      t := 0 ;
      IF GamesIn > 0 THEN BEGIN
         sDisplay(0,13,0,'You are currently participating in the following ') ;
         sDisplay(0,15,0,ItoA(GamesIn)) ;
         Display(0,13,0,' games:') ;
         crlf ;
         sDisplay(0,11,0,'Games: ') ;
         t := ShowGamesIn(1,1) ;
         crlf ;
         crlf ;
         Display(0,13,0,'Of these games, the ones you can still play today are:') ;
         crlf ;
         sDisplay(0,11,0,'Games: ') ;
         t := ShowGamesIn(2,1) ;
         crlf ;
      END ELSE BEGIN
         sDisplay(0,12,0,'You are not currently involved in any games.  ') ;
         Display(0,14,0,'Join a game already in progress.') ;
      END ;
   end ;
   if (gamesin > 0) and (t > 0) then p_on := true else p_on := false ;
   if (p_on) and (rip) then SendOut('!|1U9G3KA0402800<>Play a Game You''re In<>P') ;
   if rip then snoop := tb ;
   REPEAT
      ch   := UPCASE(GetChar) ;
      IF (ch = 'S') AND (GamesIn >= Info.MaxParticipate) THEN ch := 'z' ;
      IF (ch = 'J') AND (GamesIn >= Info.MaxParticipate) THEN ch := 'z' ;
      IF (ch = 'P') AND (t < 1) THEN ch := 'z' ;
      CASE ch OF
         'P' : IF GamesIn < 1 THEN ch := 'z' ;
         'S' : IF GamesStarted >= Info.MaxGamesStarted THEN ch := 'z' ;
      END ;
   UNTIL ch IN ['H','I','P','S','J','V','T','M','Q'] ;
   Display(0,15,0,ch) ;
   SubMenu_1 := ch ;
END ;



PROCEDURE MainMenu ;
VAR
   GamesIn         : BYTE ;
   c               : CHAR ;
   Choice          : CHAR ;
   tstr            : STRING ;
   tval            : INTEGER ;
   Found           : BOOLEAN ;
   j               : BYTE ;
   js              : STRING[2] ;
   t               : BYTE ;
   Confirm         : CHAR ;
   ch              : CHAR ;
   wch             : CHAR ;
BEGIN
   IF FirstTimer THEN BEGIN
      ClearScreen ;
      sdisplay(0,14,0,'Welcome to the game, ') ;
      display(0,15,0,formatstr(username)) ;
      YesNo ;
      Crlf ;
      sdisplay(0,15,0,'Instructions? [Y,n]: ') ;
      REPEAT
         ch := upcase(getchar) ;
         if ch = #13 then ch := 'Y' ;
      UNTIL ch IN ['Y','N'] ;
      Display(0,14,0,ch) ;
      IF ch = 'Y' THEN ShowHelp('INSTRUCT.HLP') ;
      FirstTimer := FALSE ;
   END ;
   GamesIn := GetGameNumbers ;     { how many games is player in? }
   if not rip then begin
      ClearScreen ;
      sDisplay(0,10,0,'Players may participate in up to ') ;
      sDisplay(0,15,0,ItoA(Info.MaxParticipate)) ;
      sDisplay(0,10,0,' games.  Each game lasts for ') ;
      sDisplay(0,15,0,ItoA(Info.GameRetention)) ;
      Display(0,10,0,' days.') ;
      Crlf ;
      t := 0 ;
      IF GamesIn > 0 THEN BEGIN
         sDisplay(0,13,0,'You are currently participating in the following ') ;
         sDisplay(0,15,0,ItoA(GamesIn)) ;
         Display(0,13,0,' games:') ;
         crlf ;
         sDisplay(0,11,0,'Games: ') ;
         t := ShowGamesIn(1,1) ;
         crlf ;
         crlf ;
         Display(0,13,0,'Of these games, the ones you can still play today are:') ;
         crlf ;
         sDisplay(0,11,0,'Games: ') ;
         t := ShowGamesIn(2,1) ;
         crlf ;
      END ELSE BEGIN
         sDisplay(0,12,0,'You are not currently involved in any games.  ') ;
         Display(0,14,0,'Join a game already in progress.') ;
      END ;
   end ;
   Choice := SubMenu_1(GamesIn,t) ;
   CASE Choice OF
      'I' : BEGIN
               SetupRipScreen ;
               ClearScreen ;
               ResetButtons ;
               SendButtons(#13) ;
               ShowHelp('INSTRUCT.HLP') ;
            END ;
      'H' : BEGIN
               SetupRipScreen ;
               ClearScreen ;
               ResetButtons ;
               SendButtons(#13) ;
               GameScreen('MAINMENU.HLP') ;
               holding := GetChar ;
            END ;
      'M' : BEGIN
               SetupRipScreen ;
               ClearScreen ;
               ResetButtons ;
               SendButtons(#13) ;
               MessageMenu ;
            END ;
      'V' : BEGIN
               crlf ;
               sdisplay(0,14,0,'View C>urrent or P>ast Games: ') ;
               repeat
                  wch := upcase(getchar) ;
               until wch in ['C','P'] ;
               display(0,9,0,wch) ;
               if wch = 'C' then begin
                  if rip then begin
                     local := true ;
                     clearscreen ;
                     local := false ;
                  end ;
                  SetupRipScreen ;
                  ShowBoardAgent ;
               end else ShowPastGames ;
            END ;
      'P' : BEGIN
               { Play game in progress     }
               { get valid game number     }
               { call playgame(gamenumber) }
               SetupRipScreen ;
               crlf ;
               tstr := '' ;
               TenButtons ;
               if rip then begin
                  local := true ;
                  clearscreen ;
                  local := false ;
                  sDisplay(0,13,0,'You are currently participating in the following ') ;
                  sDisplay(0,15,0,ItoA(GamesIn)) ;
                  Display(0,13,0,' games:') ;
                  crlf ;
                  sDisplay(0,11,0,'Games: ') ;
                  t := ShowGamesIn(1,1) ;
                  crlf ;
                  crlf ;
                  Display(0,13,0,'Of these games, the ones you can still play today are:') ;
                  crlf ;
                  sDisplay(0,11,0,'Games: ') ;
                  t := ShowGamesIn(2,1) ;
                  crlf ;
                  crlf ;
               end ;
               sDisplay(0,14,0,'Game number to play: ') ;
               tstr := GetInput('',1,3) ;
               IF tstr <> '' THEN BEGIN
                  tval := AtoI(tstr) ;
                  IF tval > 0 THEN BEGIN
                     fn := 'EA.GAM' ;
                     ASSIGN(GameFile,fn) ;
                     RESET(GameFile) ;
                     IF tval > FileSize(GameFile) THEN BEGIN
                        CLOSE(GameFile) ;
                        Crlf ;
                        Display(0,12,0,'Invalid entry!') ;
                        DELAY(3000) ;
                        Exit ;
                     END ;
                     SEEK(GameFile,(tval-1)) ;
                     READGame ;
                     CLOSE(GameFile) ;
                     Found := FALSE ;
                     FOR j := 1 TO 8 DO BEGIN
                        IF GameInfo.PlayerName[j] = Alias THEN BEGIN
                           Found := TRUE ;
                           j := 8 ;
                        END ;
                     END ;
                     IF Found THEN BEGIN
                        ResetButtons ;
                        AddButton('Y') ;
                        AddButton('N') ;
                        SendButtons(#13) ;
                        CRLF ;
                        sDisplay(0,10,0,'Would you like to view the game first? [y,N]: ') ;
                        REPEAT
                           c := UPCASE(GetChar) ;
                           IF c = #13 THEN c := 'N' ;
                        UNTIL c IN ['Y','N'] ;
                        Display(0,11,0,c) ;
                        IF c = 'Y' THEN ShowBoard(tval) ;
                        PlayGame(Tval) ;
                     END ELSE BEGIN
                        Crlf ;
                        Display(0,15,0,'You are not a player in that game!') ;
                     END ;
                  END ELSE BEGIN
                     Crlf ;
                     Display(0,12,0,'Invalid game number!') ;
                  END ;
               END ;
            END ;
      'S' : BEGIN
               { Start New game                         }
               { create new game record and initialize. }
               { add player to game                     }
               { then call playgame(gamenumber)         }
               SetupRipScreen ;
               fn := 'EA.GAM' ;
               ASSIGN(GameFile,fn) ;
               RESET(GameFile) ;
               IF FileSize(GameFile) > 99 THEN BEGIN
                  Crlf ;
                  Display(0,11,0,'There is not enough room to start another game!') ;
                  Crlf ;
                  More('Press <any key> to continue',12) ;
                  CLOSE(GameFile) ;
               END ELSE BEGIN
                  CLOSE(GameFile) ;
                  InitGameData ;
                  fn := 'EA.GAM' ;
                  ASSIGN(GameFile,fn) ;
                  RESET(GameFile) ;
                  SEEK(GameFile,FileSize(GameFile)) ;
                  GameInfo.PlayerName[1] := ChangeCase(Alias) ;
                  GameInfo.PlayerScore[1] := 500 ;
                  GameInfo.TurnCount[1] := 0 ;
                  GameInfo.PlayerSquareNumber[1] := 1 ;
                  GameInfo.LastDate[1] := Date ;
                  GameInfo.OutOfGame[1] := FALSE ;
                  GameInfo.InJail[1] := FALSE ;
                  GameInfo.GetOutOfJail[1] := FALSE ;
                  GameInfo.DartScore[1] := 0 ;

                  WRITEGame ;
                  j := FileSize(GameFile) ;
                  CLOSE(GameFile) ;
                  INC(GamesStarted) ;
{                 GetDate(yr,mn,dt,dy) ;
                  LastStarted := Julian(yr,mn,dt) ;
}
                  PlayGame(j) ;
               END ;
            END ;
      'J' : BEGIN
               { join game in progress but only if room }
               { get valid game number                  }
               { add player to game                     }
               { call playgame(gamenumber)              }
               SetupRipScreen ;
               ClearScreen ;
               Display(0,14,0,'There is room to join in the following games:') ;
               Crlf ;
               IF ShowJoinGames(1) < 1 THEN BEGIN
                  Display(0,12,0,'NONE') ;
                  Crlf ;
                  Display(0,15,0,'There are no games that you can join!') ;
                  Crlf ;
                  ResetButtons ;
                  SendButtons(#13) ;
                  More('Press <any key> to continue',13) ;
               END ELSE BEGIN
                  ResetButtons ;
                  for j := 0 to 9 do begin
                     str(j,js) ;
                     AddButton(js[1]) ;
                  end ;
                  SendButtons(#13) ;
                  Crlf ;
                  Crlf ;
                  sDisplay(0,13,0,'Join game number: ') ;
                  tstr := GetInPut('',1,3) ;
                  tstr := Ltrim(Rtrim(tstr)) ;
                  IF tstr <> '' THEN BEGIN
                     tval := AtoI(tstr) ;
                     IF tval > 0 THEN BEGIN
                        Found := FALSE ;
                        FOR j := 1 TO 100 DO BEGIN
                           IF JoinGameList[j] = tval THEN BEGIN
                              j := 100 ;
                              Found := TRUE ;
                           END;
                        END;
                     END ELSE BEGIN
                        CRLF ;
                        Display(0,12,0,'Invalid Entry!') ;
                        Delay(1000) ;
                        Exit ;
                     END;
                     IF Found THEN BEGIN
                        fn := 'EA.GAM' ;
                        ASSIGN(GameFile,fn) ;
                        RESET(GameFile) ;
                        SEEK(GameFile,tval-1) ;
                        READGame ;
                        CLOSE(GameFile) ;
                        ResetButtons ;
                        AddButton('Y') ;
                        AddButton('N') ;
                        SendButtons(#13) ;
                        CRLF ;
                        sDisplay(0,10,0,'Would you like to view the game first? [y,N]: ') ;
                        REPEAT
                           c := UPCASE(GetChar) ;
                           IF c = #13 THEN c := 'N' ;
                        UNTIL c IN ['Y','N'] ;
                        Display(0,11,0,c) ;
                        IF c = 'Y' THEN BEGIN
                           ShowBoard(tval) ;
                           sDisplay(0,14,0,'Would you still like to join this game? [Y,n]: ') ;
                           REPEAT
                              Confirm := UPCASE(GetChar) ;
                              IF Confirm = #13 THEN Confirm := 'Y' ;
                           UNTIL Confirm IN ['Y','N'] ;
                           Display(0,15,0,Confirm) ;
                           IF Confirm = 'N' THEN EXIT ;
                        END ;
                        if TestPassword(tval) then begin
                           AddPlayer(tval) ;
                           PlayGame(tval) ;
                        end ;
                     END ELSE BEGIN
                        CRLF ;
                        Display(0,12,0,'Invalid Entry!') ;
                     END;
                  END ;
               END ;
            END ;
      'T' : BEGIN
               crlf ;
               display(0,15,0,'One moment...') ;
               MakeTournFile ;
               ViewTournament ;
            END ;
      'Q' : BEGIN
               EndProgram := TRUE ;
               crlf ;
               display(0,15,0,'One moment...') ;
               EXIT ;
            END ;
   END ; { case }
END ;



BEGIN                          { MAIN BODY }
   Set_Retries(20,12) ;
   alias := '' ;
   FirstTimer := FALSE ;
   InAGame := FALSE ;
   numbuttons := 0 ;
   fn := '<not available>' ;
   assign(output,'') ;
   rewrite(output) ;
   Randomize ;
   Filemode := 66 ;
   InactiveVal := 5 ;
   SystemName := 'UNINITIALIZED' ;
   SysopName := 'UNINITIALIZED' ;
   UserName := 'UNINITIALIZED' ;
   ProductName := 'Eclectic Avenue '+version ;
   ForceNode := FALSE ;
   DoorExit := TrapExit ;

   IF Exist('EA.LOG') Then BEGIN
      WRITELN(' Sysop: Check error log EA.LOG') ;
   END ;
   Buffers := TRUE ;

   GameStarted := FALSE ;

   GetConfig ;

   IF DoCopy THEN Info.DropPath := CopyPath ;
   IF Info.Cname = 8 THEN GoLocal := TRUE ;
   DoorSys := Info.DoorSys ;
   Snoop := Info.Snoop ;
   Node := Info.Tnode ;
   ThisNode := Info.Tnode ;

   GetDorInfo(node,Info.DropPath) ;

   IF ANSI > 1 THEN ANSI := 1 ;
   IF GoLocal THEN BEGIN
      WRITELN(' Forcing LOCAL MODE operation') ;
      Local := TRUE ;
      DELAY(500) ;
   END ;
   IF Local THEN Snoop := TRUE ;
   SystemName := Info.SysName ;
   SysopName := Info.OpName ;
   UserName := ChangeCase(UserName) ;
   IF Local THEN ScrLen := 22 ELSE ScrLen := 24 ;

   IF DoCopy THEN BEGIN
      CASE PortNum OF
         0 : Info.IrqNum := 4 ;
         1 : Info.IrqNum := 3 ;
         2 : Info.IrqNum := 4 ;
         3 : Info.IrqNum := 3 ;
      END ;
      Info.Cname := PortNum ;
   END ;

   IF NOT Local THEN BEGIN
      IF Info.UseFossil THEN BEGIN
         IF NOT SetFossil THEN BEGIN
            WRITELN(' Could not initialize FOSSIL driver!') ;
            WRITELN(' Try loading one or using the ASYNC ENGINE!') ;
            halt(15) ;
         END ELSE WRITELN(' Revision ',FossilRev,' FOSSIL detected') ;
      END ELSE BEGIN
         UseAsync := TRUE ;
         BaudRate := GetBaudRate(BaudString) ;
         IF Info.LockRate <> 0 THEN BaudRate := Info.LockRate ;
         WRITELN(' Using ASYNC engine at ',BaudRate,' Baud') ;
         WRITELN(' Com Address: ',hex(Info.ComAddress)) ;
         WRITELN(' IRQ Number: ',Info.IrqNum) ;
         delay(2000) ;
         IF (Info.Cname = 2) OR (Info.CName = 3) THEN PS2DetectMode := PS2Ignore ;
         CASE Info.Cname OF
            0 : ComPortNameSetting := COM1 ;
            1 : ComPortNameSetting := COM2 ;
            2 : ComPortNameSetting := COM3 ;
            3 : ComPortNameSetting := COM4 ;
            4 : ComPortNameSetting := COM5 ;
            5 : ComPortNameSetting := COM6 ;
            6 : ComPortNameSetting := COM7 ;
            7 : ComPortNameSetting := COM8 ;
         END ;

         IRQVector := 8 ;
         if Info.IRQNum > 7 then IRQVector := 62 ;
         SetUART(ComPortNameSetting,Info.ComAddress,Info.IRQNum,(Info.IRQNum+IRQVector)) ;
         InitPort(P,ComPortNameSetting,BaudRate,NoParity,8,1,2000,2000,DefPortOptions) ;
         PtOptionsOff(P,PtDropModemOnClose) ;
         HWFlowEnable(P,1800,200,hfuseRts+HfRequireCts) ;
         SetDTR(P, True) ;
         SetRTS(P, True) ;
         IF AsyncStatus <> ecOk then begin
            WRITELN(#7,' ASYNC: Fatal error - Unable to initialize') ;
            Halt(15) ;
         END ;
{         CalibrateDelay ; }
      END ;
   END ELSE BEGIN
      WRITELN(' Local mode operation...') ;
      UseAsync := FALSE ;
   END ;
   SetColor(0,7,0) ;
   ClearScreen ;
   IF Info.MultiLine THEN ProductName := ProductName+'M'
     ELSE ProductName := ProductName+'S' ;
   PollTerm ;
   AddUser(Info.CommDrive,UserName,ThisNode) ;
   ClearScreen ;
   IF RIP THEN BEGIN
      IF Exist('EAOPEN.RIP') THEN BEGIN
         { RipSeqON ; }
         GameScreen('EAOPEN.RIP') ;
         { RipSeqOFF ; }
         repeat
            holding := getchar ;
         until holding = #13 ;
         Crlf ;
         SendOut('!|1K|*|#|#|#') ;
      END ;
   END ;
   If Ansi < 1 Then Begin
      sDisplay(0,15,0,'This game requires ANSI graphics. Do you wish to continue? [Y/N]: ');
      Repeat
         Holding := UpCase(getChar);
      Until Holding in ['Y','N'];
      Display(0,15,0,holding);
      If Holding = 'Y' Then Ansi := 1 Else Begin
         CRLF;
         Display(0,15,0,'Returning to '+SystemName);
         CRLF;
         Halt(10);
      END;
      ClearScreen;
   END;

(*
   IF RIP THEN BEGIN
      Snoop := false ;
      clrscr ;
      gotoxy(1,1) ;
      writeln('Remote Imaging Protocol Detected.  Disabling SNOOP mode.') ;
   END ;
*)
   if rip then local := true ;
   Crlf ; Crlf ; Crlf ;
   Display(0,15,0,Center(ProductName,79)) ;
   Display(0,15,0,Center('Copyright 1995 John Parlin',79)) ;
   sDisplay(0,15,0,Center('All rights reserved',79)) ;
   Display(0,12,0,' ') ;
   Display(0,15,0,Center('',79)) ;
   if rip then begin
      local := false ;
      { RipSeqON ;}
      tbool := snoop ;
      snoop := false ;
      gamescreen('eaintro1.rip') ;
      snoop := tbool ;
      { RipSeqOFF ;}
   end ;
   crlf ;

   Display(0,9,0,Center('Registered to '+ChangeCase(sysopname)+' of '+
                 ChangeCase(systemname),79)) ;

   if exist('alltime.dat') then begin
      assign(alltimefile,'alltime.dat') ;
      reset(alltimefile) ;
      read(alltimefile,alltime) ;
      close(alltimefile) ;
      if alltime.name <> '' then begin
         crlf ;
         sdisplay(0,15,0,' ') ;
         if not rip then
            sdisplay(1,15,0,'                            ALL TIME CASH SCORER:                            ')
         else
            sdisplay(0,15,0,'                            ALL TIME CASH SCORER:                            ') ;
         display(0,15,0,' ') ;
         crlf ;
         display(0,10,0,center(alltime.name+':  $'+commastr(alltime.totalscore),79)) ;
      end ;
      if alltime.gamename <> '' then begin
         crlf ;
         sdisplay(0,15,0,' ') ;
         if not rip then
            sdisplay(1,15,0,'                            ALL TIME GAME SCORER:                            ')
         else
            sdisplay(0,15,0,'                            ALL TIME GAME SCORER:                            ') ;
         display(0,15,0,' ') ;
         crlf ;
         display(0,10,0,center(alltime.gamename+':  '+commastr(alltime.gameswon),79)) ;
      end else crlf ;
   end ;

   if not rip then begin
      CursorPos(20,1) ;
      Space ;
   end else begin
      repeat
         ch := getchar ;
      until ch = #32 ;
   end ;

   ClearScreen ;
   IF NOT Info.MultiLine THEN BEGIN
      IF UsersOn(Info.CommDrive) > 1 THEN BEGIN
         Display(0,12,0,'This program is currently in use on another node. Multiline') ;
         Display(0,12,0,'operation is turned off.  Ask the SysOp to turn it on.') ;
         DELAY(2000) ;
         HALT(8) ;
      END ;
   END ELSE BEGIN
      IF UsersOn(Info.CommDrive) > 6 THEN BEGIN
         Display(0,12,0,'This program is currently in use on 6 lines.  Multiline') ;
         Display(0,12,0,'operation supports up to 6 lines simultaneously.') ;
         Crlf ;
         Display(0,12,0,'Try again a little later.') ;
         DELAY(2000) ;
         HALT(8) ;
      END ;
   END ;


   InitStatBars ;
   StatusLineOn := TRUE ;

   Show_Status ;

   GetUserInfo ;  {populate variable USER}

   if rip then begin
      { RipSeqON ;}
      AltFile := 'ANSFILES\EA.ANS' ;
      GameScreen('eaintro2.rip') ;
      { RipSeqOFF ;}
      ch := #0 ;
      repeat
         ch := getchar ;
      until ch = #13 ;
      SetupRipScreen ;
      YesNo ;
   end else begin
      ClearScreen;
      GameScreen('ANSFILES\EA.ans') ;
      repeat
         ch := getchar ;
      until ch = #13 ;
      ClearScreen ;
   end ;

   GameStarted := TRUE ;
   SysopKey[1] := #0 + #18 ;
   SysopProc[1] := ALT_E ;

   SysopKeysOn := TRUE ;

   StatLineA[4] := ' F1,F2,F3,F4 = Status Information' ;
   StatLineB[4] := ' ALT-E = Eject Player to BBS,  ALT-D = Toggle Snoop Mode (remote only)' ;
   Show_Status ;

   EndProgram := FALSE ;

   CheckMail('E') ;
   REPEAT
      MainMenu ;
   Until EndProgram ;
   MakeTournFile ;
   ViewTournament ;
   HALT(0) ;
END.
