UNIT EADef ;

INTERFACE

USES JPDoor32 ;

CONST
   MaxChances    = 38 ;

TYPE
   FigRec  = Record
                Tnode          : STRING[2] ;
                SysName        : STRING ;
                OpName         : STRING ;
                DoorSys        : BOOLEAN ;
                DropPath       : STRING ;
                UseFossil      : BOOLEAN ;
                CName          : BYTE ;
                ComAddress     : INTEGER ;
                IRQNum         : INTEGER ;
                LockRate       : LONGINT ;
                KeyLine        : STRING ;   { no longer used }
                AdoptedBy      : STRING ;   { no longer used }
                MultiLine      : BOOLEAN ;
                CommDrive      : STRING ;
                TextBull,
                ANSIBull       : STRING ;

                Snoop          : BOOLEAN ;
                UseHandles     : BOOLEAN ;
                MaxParticipate : BYTE ;
                MaxGamesStarted: BYTE ;
                TurnsPerGame   : BYTE ;
                GameRetention  : BYTE ;
                StartingNumber : BYTE ;
                MaxDarts       : BYTE ;
                MaxGambles     : BYTE ;
                AllowRestrictions : BOOLEAN ;
                InactiveDays   : BYTE ;
                DungeonEnable  : BYTE ;
             END ;


   UserRecord = Record
      Name            : string[35] ;
      Alias           : string[35] ;
      Sex             : char ;
      Preferrence     : char ;
      GamesStarted    : byte ;
      LastStarted     : real ;
      LastOn          : real ;
      GamesWon        : integer ;
   End ;


   PastGameRec = Record
      ClosingDate             : string[10] ;
      NumPlayers              : byte ;
      Winner                  : string[35] ;
      PlayerNames             : array [1..8] of string[35] ;
      CashScores              : array [1..8] of longint ;
      PropertyScores          : array [1..8] of longint ;
   End ;


   GameDataRec = Record
      SquareNumber            : byte ;
      Description             : string ;
      Owner                   : string ;
      PurchasePrice           : integer ;
      RentalPrice             : integer ;
      SellPrice               : integer ;
   End ;

   GameRecord = Record
      GameData                : array [1..33] of GameDataRec ;
      PlayerName              : array [1..8] of string[35] ;
      PlayerScore             : array [1..8] of longint ;
      TurnCount               : array [1..8] of integer ;
      PlayerSquareNumber      : array [1..8] of byte ;
      LastDate                : array [1..8] of string[18] ;
      StartDate               : real ;
      OutOfGame               : array [1..8] of boolean ;
      InJail                  : array [1..8] of boolean ;
      GetOutOfJail            : array [1..8] of boolean ;
      GameId                  : STRING[12] ;
      DartScore               : array [1..8] OF INTEGER ;
      InUse                   : BOOLEAN ;
      NumberOfPlayers         : BYTE ;
      Password                : STRING[12] ;
   END ;

   TournRec = Record
                 Name       : STRING[35] ;
                 TotalScore : LONGINT ;
                 GameName   : STRING[35] ;
                 GamesWon   : INTEGER ;
              END ;

   MsgRecord = RECORD
                  WhoTo,
                  From,
                  Subject      : STRING[35] ;
                  DTG          : STRING[25] ;
                  FileName     : STRING[25] ;
                  CreationDate : REAL ;
                  Private      : BOOLEAN ;
                  Received     : BOOLEAN ;
               END ;

   TrivRec = RECORD
                QuestionFile  : STRING ;
                Answer        : CHAR ;
                Worth         : INTEGER ;
             END ;

   TrivTrackRec = RECORD
                     TriviaNumber    : INTEGER ;
                  END ;

VAR
   UserFile                   : FILE OF UserRecord ;
   User                       : UserRecord ;
   GameFile                   : FILE OF GameRecord ;
   GameInfo                   : GameRecord ;
   ConfigFile                 : FILE OF FigRec ;
   Info                       : FigRec ;
   ConfigFileName             : STRING ;
   TournFile                  : FILE OF TournRec ;
   Tourn                      : TournRec ;
   AlltimeFile                : file of tournrec ;
   alltime                    : tournrec ;
   MsgFile                    : FILE OF MsgRecord ;
   Msg                        : MsgRecord ;
   TrivNumFile                : FILE OF TrivTrackRec ;
   TrivNumInfo                : TrivTrackRec ;
   TrivFile                   : FILE OF TrivRec ;
   Trivia                     : TrivRec ;
   PastGameFile               : FILE OF PastGameRec ;
   PastGame                   : PastGameRec ;
   PlayerScore                : LONGINT ;
   TurnCount                  : INTEGER ;
   PlayerSquareNumber         : BYTE ;
   DartScore                  : INTEGER ;
   LastDate                   : STRING[18] ;
   OutOfGame                  : BOOLEAN ;
   InJail                     : BOOLEAN ;
   GetOutOfJail               : BOOLEAN ;
   Alias                      : STRING[35] ;
   GamesStarted               : BYTE ;
   LastStarted                : REAL ;
   DrawFull                   : BOOLEAN ;
   FirstTimer                 : BOOLEAN ;
   GameNumber                 : BYTE ;
   InAGame                    : BOOLEAN ;
   GamesInList                : ARRAY [1..10] OF BYTE ;
   CanPlayList                : ARRAY [1..10] OF BYTE ;
   JoinGameList               : ARRAY [1..100] OF BYTE ;
   yr,mn,dt,dy                : WORD ;
   numbuttons                 : BYTE ;
   button                     : ARRAY [1..11] OF CHAR ;
   buttonchange               : BOOLEAN ;
   fn                         : STRING ;

PROCEDURE ReadPastGame ;
PROCEDURE WriteUser ;
PROCEDURE ReadUser ;
PROCEDURE WriteGame ;
PROCEDURE ReadGame ;
PROCEDURE WriteMsg ;
PROCEDURE ReadMsg ;
PROCEDURE WriteTrivNum ;
PROCEDURE ReadTrivNum ;
PROCEDURE WriteTrivia ;
PROCEDURE ReadTrivia ;
PROCEDURE MakeTournFile ;
PROCEDURE EASort(z:byte) ;
PROCEDURE GetDefaults ;



IMPLEMENTATION

Procedure GetDefaults ;
VAR
   j : byte ;
BEGIN
   fn := 'DEFAULT.BRD' ;
   assign(GameFile,fn) ;
   {$I-} reset(GameFile) ; {$I+}
   if ioresult <> 0 then begin
      rewrite(GameFile) ;
      WITH GameInfo DO BEGIN
         GameId := '0000000000' ;
         For j := 1 to 8 do PlayerName[j] := '' ;
         For j := 1 to 8 do PlayerScore[j] := 0 ;
         For j := 1 to 8 do TurnCount[j] := 0 ;
         For j := 1 to 8 do PlayerSquareNumber[j] := 1 ;
         For j := 1 to 8 do LastDate[j] := '' ;
         StartDate := 0 ;
         for j := 1 to 8 do OutOfGame[j] := false ;
         for j := 1 to 8 do InJail[j] := false ;
         for j := 1 to 8 do GetOutOfJail[j] := false ;
         for j := 1 to 8 do DartScore[j] := 0 ;
         InUse := FALSE ;
         NumberOfPlayers := 8 ;
         Password := '' ;
      END;
      FOR j := 1 TO 33 DO BEGIN
         WITH GameInfo DO BEGIN
            GameData[j].SquareNumber := j ;
            GameData[j].Owner := '';
            GameData[j].PurchasePrice := 0;
            GameData[j].RentalPrice := 0;
            GameData[j].SellPrice := 0 ;
            CASE j OF
               1    : BEGIN
                         GameData[j].Description := 'START SQUARE' ;
                         GameData[j].owner:= 'START';
                      END ;
               2    : BEGIN
                         GameData[j].Description := 'CHICKEN FARM' ;
                         GameData[j].PurchasePrice := 1000;
                         GameData[j].RentalPrice := 200;
                      END ;
               3    : BEGIN
                         GameData[j].Description := 'SALON' ;
                         GameData[j].PurchasePrice := 100;
                         GameData[j].RentalPrice := 20;
                      END ;
               4    : BEGIN
                         GameData[j].Description := 'JOE''S HOTEL' ;
                         GameData[j].PurchasePrice := 500;
                         GameData[j].RentalPrice := 100;
                      END ;
               5    : BEGIN
                         GameData[j].Description := 'LUCK SPACE' ;
                         GameData[j].owner:= 'LUCK';
                      END ;
               6    : BEGIN
                         GameData[j].Description := 'NIGHT CLUB' ;
                         GameData[j].PurchasePrice := 1000;
                         GameData[j].RentalPrice := 200;
                      END ;
               7    : BEGIN
                         GameData[j].Description := 'MOVIE THEATRE' ;
                         GameData[j].PurchasePrice := 200;
                         GameData[j].RentalPrice := 10;
                      END ;
               8    : BEGIN
                         GameData[j].Description := 'LOCAL DRUG STORE' ;
                         GameData[j].PurchasePrice := 250 ;
                         GameData[j].RentalPrice := 5 ;
                      END ;
               9    : BEGIN
                         GameData[j].Description := 'FANCY RESTARAUNT' ;
                         GameData[j].PurchasePrice := 500 ;
                         GameData[j].RentalPrice := 50 ;
                      END;
               10   : BEGIN
                         GameData[j].Description := 'CONDOMINIUMS' ;
                         GameData[j].PurchasePrice := 1800 ;
                         GameData[j].RentalPrice := 180 ;
                      END ;
               11   : BEGIN
                         GameData[j].Description := 'GOLF COURSE' ;
                         GameData[j].PurchasePrice := 800;
                         GameData[j].RentalPrice := 80 ;
                      END ;
               12   : BEGIN
                         GameData[j].Description := 'TENNIS COURTS' ;
                         GameData[j].PurchasePrice := 400 ;
                         GameData[j].RentalPrice := 40 ;
                      END ;
               13   : BEGIN
                         GameData[j].Description := 'IN JAIL' ;
                         GameData[j].owner:= 'JAIL';
                      END;
               14   : BEGIN
                         GameData[j].Description := 'GO TO START' ;
                         GameData[j].owner:= 'START' ;
                      END;
               15   : BEGIN
                         GameData[j].Description := 'TRIVIA TIME' ;
                         GameData[j].owner:= 'TRIVIA' ;
                      END;
               16   : BEGIN
                         GameData[j].Description := 'LUCK SPACE' ;
                         GameData[j].owner:= 'LUCK';
                      END;
               17   : BEGIN
                         GameData[j].Description := 'TAX TIME!' ;
                         GameData[j].owner:= 'TAXES';
                      END;
               18   : BEGIN
                         GameData[j].Description := 'LOOK OUT POINT' ;
                         GameData[j].owner:= 'POINT';
                      END;
               19   : BEGIN
                         GameData[j].Description := 'VIDEO STORE' ;
                         GameData[j].PurchasePrice := 150 ;
                         GameData[j].RentalPrice := 10 ;
                      END ;
               20   : BEGIN
                         GameData[j].Description := 'THE BANK' ;
                         GameData[j].PurchasePrice := 250 ;
                         GameData[j].RentalPrice := 25 ;
                      END ;
               21   : BEGIN
                         GameData[j].Description := 'LIQUOR STORE' ;
                         GameData[j].PurchasePrice := 300 ;
                         GameData[j].RentalPrice := 30 ;
                      END ;
               22   : BEGIN
                         GameData[j].Description := 'GAMBLING CASINO' ;
                         GameData[j].PurchasePrice := 1000;
                         GameData[j].RentalPrice := 100;
                      END;
               23   : BEGIN
                         GameData[j].Description := 'LUCK SPACE' ;
                         GameData[j].owner:= 'LUCK';
                      END;
               24   : BEGIN
                         GameData[j].Description := 'MASSAGE PARLOR' ;
                         GameData[j].PurchasePrice := 500;
                         GameData[j].RentalPrice := 30;
                      END ;
               25   : BEGIN
                         GameData[j].Description := 'BAND STAND' ;
                         GameData[j].PurchasePrice := 100;
                         GameData[j].RentalPrice := 20;
                      END;
               26   : BEGIN
                         GameData[j].Description := 'AL''S BAR' ;
                         GameData[j].PurchasePrice := 800;
                         GameData[j].RentalPrice := 75;
                      END;
               27   : BEGIN
                         GameData[j].Description := 'THEATRE (TO SEE A PLAY)' ;
                         GameData[j].PurchasePrice := 200;
                         GameData[j].RentalPrice := 20;
                      END;
               28   : BEGIN
                         GameData[j].Description := 'USED CAR DEALERSHIP' ;
                         GameData[j].PurchasePrice := 1000;
                         GameData[j].RentalPrice := 100;
                      END;
               29   : BEGIN
                         GameData[j].Description := 'BUSTED! GO TO JAIL!' ;
                         GameData[j].owner:= 'JAIL';
                      END;
               30   : BEGIN
                         GameData[j].Description := 'CLOTHIERS' ;
                         GameData[j].PurchasePrice := 500;
                         GameData[j].RentalPrice := 50;
                      END;
               31   : BEGIN
                         GameData[j].Description := 'LUCK SPACE' ;
                         GameData[j].Owner := 'LUCK' ;
                      END;
               32   : BEGIN
                         GameData[j].Description := 'HEALTH SPA' ;
                         GameData[j].PurchasePrice := 600;
                         GameData[j].RentalPrice := 60 ;
                      END;
               33   : BEGIN
                         GameData[j].Description := 'BOOK STORE' ;
                         GameData[j].PurchasePrice := 500;
                         GameData[j].RentalPrice := 50;
                      END;
            END ; {case}
         END; {with}
      END ; {for}
      WRITE(GameFile,GameInfo) ;
      CLOSE(GameFile) ;
   END ELSE BEGIN
      READ(GameFile,GameInfo) ;
      CLOSE(GameFile) ;
   END ;
END ;


Procedure ReadPastGame ;
Var
   LockStart,
   LockEnd     : LongInt ;
   Err,
   ErrCnt      : Integer ;
Begin
   ErrCnt := 0 ;
   LockStart := (filepos(PastGameFile) * Sizeof(PastGame)) + 1 ;
   LockEnd := (filepos(PastGameFile) + 1) * sizeof(PastGame) ;
   Repeat
      Inc(ErrCnt) ;
      Err := Lock(PastGameFile,lockstart,lockend) ;
   Until (err = 0) or (ErrCnt > 9999) ;
   If ErrCnt < 10000 then
   Begin
      Read(PastGameFile,PastGame) ;
      UnLock(PastGameFile,LockStart,LockEnd) ;
   End ;
End ;



Procedure WriteUser;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(userfile) * Sizeof(user)) + 1 ;
  LockEnd := (filepos(userfile) + 1) * sizeof(user) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(userfile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(userfile,user);
    UnLock(userfile,LockStart,LockEnd) ;
  End;
End;

Procedure ReadUser;
Var
  LockStart,
  LockEnd     : LongInt ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(userfile) * Sizeof(user)) + 1 ;
  LockEnd := (filepos(userfile) + 1) * sizeof(user) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(userfile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Read(UserFile,User);
    UnLock(UserFile,LockStart,LockEnd) ;
  End;
End;



Procedure WriteGame;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(gamefile) * Sizeof(gameinfo)) + 1 ;
  LockEnd := (filepos(gamefile) + 1) * sizeof(gameinfo) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(gamefile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(gamefile,gameinfo);
    UnLock(gamefile,LockStart,LockEnd) ;
  End;
End;

Procedure ReadGame;
Var
  LockStart,
  LockEnd     : LongInt ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(gamefile) * Sizeof(gameinfo)) + 1 ;
  LockEnd := (filepos(gamefile) + 1) * sizeof(gameinfo) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(gamefile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Read(gameFile,gameinfo);
    UnLock(GameFile,LockStart,LockEnd) ;
  End;
End;


Procedure WriteMsg ;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(MsgFile) * Sizeof(Msg)) + 1 ;
  LockEnd := (filepos(MsgFile) + 1) * sizeof(Msg) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(MsgFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(MsgFile,Msg) ;
    UnLock(MsgFile,LockStart,LockEnd) ;
  End ;
End ;

Procedure ReadMsg ;
Var
  LockStart,
  LockEnd     : LongInt ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(MsgFile) * Sizeof(Msg)) + 1 ;
  LockEnd := (filepos(MsgFile) + 1) * sizeof(Msg) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(MsgFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Read(MsgFile,Msg);
    UnLock(MsgFile,LockStart,LockEnd) ;
  End;
End;


Procedure WriteTrivNum ;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(TrivNumFile) * Sizeof(TrivNumInfo)) + 1 ;
  LockEnd := (filepos(TrivNumFile) + 1) * sizeof(TrivNumInfo) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(TrivNumFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(TrivNumFile,TrivNumInfo) ;
    UnLock(TrivNumFile,LockStart,LockEnd) ;
  End ;
End ;

Procedure ReadTrivNum ;
Var
  LockStart,
  LockEnd     : LongInt ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(TrivNumFile) * Sizeof(TrivNumInfo)) + 1 ;
  LockEnd := (filepos(TrivNumFile) + 1) * sizeof(TrivNumInfo) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(TrivNumFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Read(TrivNumFile,TrivNumInfo);
    UnLock(TrivNumFile,LockStart,LockEnd) ;
  End;
End;

Procedure WriteTrivia ;
Var
  LockStart,
  LockEnd     : Longint ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(TrivFile) * Sizeof(Trivia)) + 1 ;
  LockEnd := (filepos(TrivFile) + 1) * sizeof(Trivia) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(TrivFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Write(TrivFile,Trivia) ;
    UnLock(TrivFile,LockStart,LockEnd) ;
  End ;
End ;

Procedure ReadTrivia ;
Var
  LockStart,
  LockEnd     : LongInt ;
  Err,
  ErrCnt      : Integer;
Begin
  ErrCnt := 0;
  LockStart := (filepos(TrivFile) * Sizeof(Trivia)) + 1 ;
  LockEnd := (filepos(TrivFile) + 1) * sizeof(Trivia) ;
  Repeat
     Inc(ErrCnt) ;
     Err := Lock(TrivFile,lockstart,lockend) ;
  Until (err = 0) or (ErrCnt > 9999) ;
  If ErrCnt < 10000 then
  Begin
    Read(TrivFile,Trivia);
    UnLock(TrivFile,LockStart,LockEnd) ;
  End;
End;



{$I EASort}

PROCEDURE MakeTournFile ;
VAR
   Narray    : ARRAY [1..100] OF STRING[35] ;
   Sarray    : ARRAY [1..100] OF LONGINT ;
   Garray    : ARRAY [1..100] OF INTEGER ;

   j,i,x     : BYTE ;
   Found     : BOOLEAN ;
   t         : INTEGER ;
BEGIN
   if (exist('alltime.dat')) and (sizefile('alltime.dat')>0) then begin
      fn := 'ALLTIME.DAT' ;
      assign(alltimefile,'alltime.dat') ;
      reset(alltimefile) ;
      read(alltimefile,alltime) ;
      close(alltimefile) ;
   end else begin
      alltime.name := '' ;
      alltime.gamename := '' ;
      alltime.totalscore := 0 ;
      alltime.gameswon := 0 ;
   end ;

   FOR j := 1 TO 100 DO Narray[j] := 'No One' ;
   FOR j := 1 TO 100 DO Sarray[j] := 0 ;
   FOR j := 1 TO 100 DO Garray[j] := 0 ;
   fn := 'EA.GAM' ;
   if exist(fn) then begin
      ASSIGN(GameFile,fn) ;
      RESET(GameFile) ;
      if filesize(gamefile) <> 0 then begin
         WHILE NOT EOF(GameFile) DO BEGIN
            ReadGame ;
            Found := FALSE ;
            FOR i := 1 TO 8 DO BEGIN
               IF GameInfo.PlayerName[i] <> '' THEN BEGIN
                  Found := FALSE ;
                  FOR j := 1 TO 100 DO BEGIN
                     IF Narray[j] = GameInfo.PlayerName[i] THEN BEGIN
                        Found := TRUE ;
                        j := 100 ;
                     END ;
                  END ;
               END ;
               IF Found THEN BEGIN
                  FOR j := 1 TO 100 DO BEGIN
                     IF Narray[j] = GameInfo.PlayerName[i] THEN BEGIN
                        INC(Sarray[j],GameInfo.PlayerScore[i]) ;
                        IF GameInfo.DartScore[i] > 9 THEN BEGIN
                           IF ODD(GameInfo.DartScore[i]) THEN
                              t := GameInfo.DartScore[i]+1
                           ELSE
                              t := GameInfo.DartScore[i] ;
                           t := t DIV 10 ;
                           INC(Sarray[j],t) ;
                        END ;
                        FOR x := 1 TO 33 DO BEGIN
                           IF GameInfo.GameData[x].Owner =
                           GameInfo.PlayerName[i] THEN BEGIN
                              INC(Sarray[j],GameInfo.GameData[x].PurchasePrice) ;
                           END ;
                        END ;
                        j := 100 ;
                     END ;
                  END ;
               END ELSE BEGIN   { not found in array - stick it in }
                  FOR j := 1 TO 100 DO BEGIN
                     IF (Narray[j] = '') OR (Narray[j] = 'No One') THEN BEGIN
                        Narray[j] := GameInfo.PlayerName[i] ;
                        Sarray[j] := GameInfo.PlayerScore[i] ;
                        FOR x := 1 TO 33 DO BEGIN
                           IF GameInfo.GameData[x].Owner =
                           GameInfo.PlayerName[i] THEN BEGIN
                              INC(Sarray[j],GameInfo.GameData[x].PurchasePrice) ;
                           END ;
                        END ;
                        j := 100 ;
                     END ;
                  END ;
               END ;
            END ; { for i = 1 to 8 }
         END ; {while not eof(gamefile) }
      end ;
      close(gamefile) ;
   end ;
   fn := 'EA.DAT' ;
   if exist(fn) then begin
      ASSIGN(Userfile,fn) ;
      RESET(UserFile) ;
      if filesize(userfile) <> 0 then begin
         WHILE NOT eof(userfile) do begin
            readuser ;
            for j := 1 to 100 do begin
               if narray[j] = 'No One' then begin
                  narray[j] := user.alias ;
                  garray[j] := user.gameswon ;
                  sarray[j] := 0 ;
                  j := 100 ;
               end else begin
                  if narray[j] = user.alias then begin
                     garray[j] := user.gameswon ;
                     j := 100 ;
                  end ;
               end ;
            end ;
         end ;
      end ;
      close(userfile) ;
   end ;
   fn := 'EA.TRN' ;
   ASSIGN(TournFile,fn) ;
   REWRITE(TournFile) ;
   FOR j := 1 TO 100 DO BEGIN
      IF Narray[j] <> '' THEN BEGIN
         Tourn.Name := Narray[j] ;
         Tourn.TotalScore := Sarray[j] ;
         tourn.gameswon := garray[j] ;

         if tourn.totalscore > alltime.totalscore then begin
            alltime.totalscore := tourn.totalscore ;
            alltime.name := tourn.name ;
         end ;

         if tourn.gameswon > alltime.gameswon then begin
            alltime.gameswon := tourn.gameswon ;
            alltime.gamename := tourn.name ;
         end ;
         WRITE(TournFile,Tourn) ;
      END ;
   END ;
   CLOSE(TournFile) ;
   assign(alltimefile,'alltime.dat') ;
   rewrite(alltimefile) ;
   write(alltimefile,alltime) ;
   close(alltimefile) ;
END ;



BEGIN
END.
