DEFINT A-Z
'$INCLUDE: 'SUPP.BI'
'$INCLUDE: 'SCOMMON.BI'

DIM SHARED ATempLn AS STRING * 280
DIM SHARED ARow%, ACol%, AFore%, ABack%, AInsert%, ATop%, ABot%
DIM SHARED ANScolorTran%(7), AVTlookup%(255), NoRepeat$
DIM SHARED ANScolorForeStr$(7), ANScolorBackStr$(7), ANSIattr$(1, 1, 1, 1)

DIM SHARED AVTup$, AVTdown$, AVTleft$, AVTright$
DIM SHARED AVTcolor$, AVTloc$, AVTclear$
CONST ANSchars$ = "mABCDHfsuKJLM@PEFnrhl;?0123456789"  'ANSI code suffixes
CONST ANSup$ = "[A", ANSdown$ = "[B", ANSright$ = "[C", ANSleft$ = "[D"
CONST ANSclear$ = "[2J", ANSrestzone$ = "[1r"

FUNCTION AClear$ (Term%)
  IF Term% >= 3 THEN
    AClear$ = AVTclear$
    ForceColor% = -1
  ELSEIF Term% = 1 THEN
    AClear$ = escbr$ + "0m" + ANSclear$
    OldColor% = 7
  ELSEIF Term% = 2 THEN
    AClear$ = escbr$ + "m" + ANSclear$ + ANSscrollzone$(1, ChatHt%)
    OldColor% = 7
  END IF
  ForceLocate% = -1
END FUNCTION

FUNCTION AColor$ (NewColor%)
  '------------- This is the optimizing color code generator ----------------
  IF OldColor% = NewColor% THEN EXIT FUNCTION
  IF Term% >= 3 THEN   '-----AVATAR COLOR HANDLER-----
    OldInsert% = 0
    IF NewColor% < 128 THEN
      AColor$ = AVTcolor$ + CHR$(NewColor%)
    ELSE
      IF NewColor% = (OldColor% OR 128) THEN
        AColor$ = AVTblink$
      ELSE
        AColor$ = AVTcolor$ + CHR$(NewColor% AND 127) + AVTblink$
      END IF
    END IF
  ELSE '------USE ANSI HANDLER INSTEAD------
    IF ANScompatible% THEN ForceColor% = -2
    IF ForceColor% <> -2 AND NewColor% = 7 THEN
      AColor$ = escbr$ + "m"
    ELSE
      OldBold% = (OldColor% AND 8) \ 8
      NewBold% = (NewColor% AND 8) \ 8
      OldBlink% = OldColor% \ 128
      NewBlink% = NewColor% \ 128
      NewFore% = NewColor% AND 7
      NewBack% = NewColor% AND 112
      Colrs$ = ";0" + ANSIattr$(0, 0, NewBold%, NewBlink%)
      IF NewFore% <> 7 OR ForceColor% = -2 THEN Colrs$ = Colrs$ + ANScolorForeStr$(NewFore%)
      IF NewBack% <> 0 OR ForceColor% = -2 THEN Colrs$ = Colrs$ + ANScolorBackStr$(NewBack% \ 16)
      IF ForceColor% = 0 AND NewBold% >= OldBold% AND NewBlink% >= OldBlink% THEN
        Colr2$ = ANSIattr$(OldBold%, OldBlink%, NewBold%, NewBlink%)
        IF (OldColor% AND 7) <> NewFore% THEN Colr2$ = Colr2$ + ANScolorForeStr$(NewFore%)
        IF (OldColor% AND 112) <> NewBack% THEN Colr2$ = Colr2$ + ANScolorBackStr$(NewBack% \ 16)
        IF LEN(Colr2$) < LEN(Colrs$) THEN Colrs$ = Colr2$
      END IF
      AColor$ = escbr$ + MID$(Colrs$, 2) + "m"
    END IF
  END IF
  OldColor% = NewColor%
  ForceColor% = 0
END FUNCTION

SUB AInit

  'The below is a lookup table for AVT codes for Aprint routine.
  AVTlookup%(1) = 2    'A
  AVTlookup%(2) = 1    'B
  AVTlookup%(3) = 1    'C
  AVTlookup%(4) = 1    'D
  AVTlookup%(5) = 1    'E
  AVTlookup%(6) = 1    'F
  AVTlookup%(7) = 1    'G
  AVTlookup%(8) = 3    'H
  AVTlookup%(9) = 1    'I
  AVTlookup%(10) = 6   'J
  AVTlookup%(11) = 6   'K
  AVTlookup%(12) = 4   'L
  AVTlookup%(13) = 5   'M
  AVTlookup%(14) = 1   'N
  'AVTlookup%(25) = -2  'Y

  'The following are IBM-PC to ANSI color translation tables.
  ANScolorTran%(0) = 0
  ANScolorTran%(1) = 4
  ANScolorTran%(2) = 2
  ANScolorTran%(3) = 6
  ANScolorTran%(4) = 1
  ANScolorTran%(5) = 5
  ANScolorTran%(6) = 3
  ANScolorTran%(7) = 7
  FOR I% = 0 TO 7
    ANScolorForeStr$(I%) = ";3" + LTRIM$(STR$(ANScolorTran%(I%)))
    ANScolorBackStr$(I%) = ";4" + LTRIM$(STR$(ANScolorTran%(I%)))
  NEXT

  'The below is the ANSI bold and blink attribute lookup table for the
  'efficient color-changing code function, AColor$.
  '  First #: Old bold flag      Third #: New bold flag
  ' Second #: Old blink flag    Fourth #: New blink flag
  ANSIattr$(0, 0, 0, 0) = ""
  ANSIattr$(0, 0, 0, 1) = ";5"
  ANSIattr$(0, 0, 1, 0) = ";1"
  ANSIattr$(0, 0, 1, 1) = ";1;5"
  ANSIattr$(0, 1, 0, 0) = ";0"
  ANSIattr$(0, 1, 0, 1) = ""
  ANSIattr$(0, 1, 1, 0) = ";0;1"
  ANSIattr$(0, 1, 1, 1) = ";1"
  ANSIattr$(1, 0, 0, 0) = ";0"
  ANSIattr$(1, 0, 0, 1) = ";0;5"
  ANSIattr$(1, 0, 1, 0) = ""
  ANSIattr$(1, 0, 1, 1) = ";5"
  ANSIattr$(1, 1, 0, 0) = ";0"
  ANSIattr$(1, 1, 0, 1) = ";0;5"
  ANSIattr$(1, 1, 1, 0) = ";0;1"
  ANSIattr$(1, 1, 1, 1) = ""

  'The following are constants for AVATAR codes.
  AVTcolor$ = AVT$ + CHR$(1):       AVTloc$ = AVT$ + CHR$(8)
  AVTup$ = AVT$ + CHR$(3):          AVTdown$ = AVT$ + CHR$(4)
  AVTleft$ = AVT$ + CHR$(5):        AVTright$ = AVT$ + CHR$(6)
  AVTclear$ = AVTcolor$ + CHR$(7) + CHR$(12)

  'The following are other constants.
  NoRepeat$ = CHR$(22) + CHR$(25) + CHR$(27)
  ARow% = 1
  ACol% = 1
  AFore% = 7
  ABack% = 0
  ATop% = 1
  ABot% = ScrHt%
  SetScrSize ScrWid%, ScrHt%
  LOCATE , , 1, 6, 7
END SUB

FUNCTION ALocate$ (FromRow%, FromCol%, NewRow%, NewCol%)
  'Use an ForceLocate% of value -1 to force a full location code.
  IF FromCol% = NewCol% AND FromRow% = NewRow% THEN
    IF ForceLocate% = 0 THEN EXIT FUNCTION
  END IF

  'If an Esc[#;#r scroll zone is set in VT102 mode.
  IF Term% = 2 THEN
    Doit% = 0
    IF NewRow% < OldTop% OR NewRow% > OldBot% THEN
      Doit% = -1
    ELSEIF ForceLocate% = 0 AND (FromRow% < OldTop% OR FromRow% > OldBot%) THEN
      Doit% = -1
    END IF
    IF Doit% THEN
      ATemp$ = ANSscrollzone$(1, ChatHt%) + escbr$ + LTRIM$(STR$(NewRow%))
      IF NewCol% = 1 THEN
        ALocate$ = ATemp$ + "H"
      ELSE
        ALocate$ = ATemp$ + ";" + LTRIM$(STR$(NewCol%)) + "H"
      END IF
      ForceLocate% = 0
      OldRow% = FromRow%: OldCol% = FromCol%
      EXIT FUNCTION
    END IF
  END IF

  'Forced absolute locate of cursor.
  IF ForceLocate% THEN
    IF Term% >= 3 THEN
      ALocate$ = AVTloc$ + CHR$(NewRow%) + CHR$(NewCol%)
      OldInsert% = 0
    ELSE
      IF NewCol% = 1 THEN
        ALocate$ = escbr$ + LTRIM$(STR$(NewRow%)) + "H"
      ELSE
        ALocate$ = escbr$ + LTRIM$(STR$(NewRow%)) + ";" + LTRIM$(STR$(NewCol%)) + "H"
      END IF
    END IF
    ForceLocate% = 0
    OldRow% = FromRow%: OldCol% = FromCol%
    EXIT FUNCTION
  END IF

  'The following creates 4 different codes to find out the most efficent one.
  Code1$ = "": Code2$ = "": Code3$ = "": Code4$ = ""
  HOffs% = NewCol% - FromCol%: HDiff% = ABS(HOffs%)
  VOffs% = NewRow% - FromRow%: VDiff% = ABS(VOffs%)

  '2:Characters or backspaces.
  IF NewRow% = FromRow% AND HDiff% <= 10 THEN
    IF OldInsert% = 0 AND OldColor% = WColr%(Cwin%) THEN
      TextLine$ = ScanScr$(NewRow%, ScrWid%)
      IF HOffs% > 0 THEN
        Code2$ = MID$(TextLine$, FromCol%, HDiff%)
      ELSE
        IF MID$(TextLine$, FromCol% - HDiff%, HDiff% + 1) = SPACE$(HDiff% + 1) THEN Code2$ = STRING$(HDiff%, CHR$(8))
      END IF
    END IF
  END IF

  IF Term% >= 3 THEN '--- AVATAR codes possiblities ---
    '1:Absolute locate
    Code1$ = AVTloc$ + CHR$(NewRow%) + CHR$(NewCol%)

    '3:Relative locate
    IF HDiff% = 1 AND VDiff% = 0 THEN
      IF HOffs% = 1 THEN Code3$ = AVTright$ ELSE Code3$ = AVTleft$
    ELSEIF VDiff% = 1 AND HDiff% = 0 THEN
      IF VOffs% = 1 THEN Code3$ = AVTdown$ ELSE Code3$ = AVTup$
    END IF

    '4:Carrige return and linefeeds
    IF OldInsert% = 0 AND NewCol% = 1 THEN
      IF VOffs% >= 0 THEN
        Code4$ = CHR$(13) + STRING$(VDiff%, CHR$(10))
      ELSEIF VOffs% = -1 THEN
        Code4$ = CHR$(13) + AVTup$
      END IF
    END IF
    OldInsert% = 0
  ELSE               '--- ANSI code possibilites ---
    '1:Absolute locate
    IF NewCol% = 1 THEN
      Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + "H"
    ELSE
      Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + ";" + LTRIM$(STR$(NewCol%)) + "H"
    END IF

    '3:Relative locate
    IF HOffs% > 0 THEN  'Horizontal
      IF HDiff% = 1 THEN Code3$ = ANSright$ ELSE Code3$ = escbr$ + LTRIM$(STR$(HDiff%)) + "C"
    ELSEIF HOffs% < 0 THEN
      IF HDiff% = 1 THEN Code3$ = ANSleft$ ELSE Code3$ = escbr$ + LTRIM$(STR$(HDiff%)) + "D"
    END IF
    IF VOffs% > 0 THEN  'Vertical
      IF VDiff% = 1 THEN Code3$ = Code3$ + ANSdown$ ELSE Code3$ = Code3$ + escbr$ + LTRIM$(STR$(VDiff%)) + "B"
    ELSEIF VOffs% < 0 THEN
      IF VDiff% = 1 THEN Code3$ = Code3$ + ANSup$ ELSE Code3$ = Code3$ + escbr$ + LTRIM$(STR$(VDiff%)) + "A"
    END IF

    '4:Carrige return and linefeeds (and relative cursor movement)
    IF VOffs% >= 0 THEN
      IF FromCol% = 1 THEN Code4$ = "" ELSE Code4$ = CHR$(13)
      Code4$ = Code4$ + STRING$(VDiff%, CHR$(10))
      IF NewCol% = 2 THEN
        Code4$ = Code4$ + ANSright$
      ELSEIF NewCol% > 2 THEN
        Code4$ = Code4$ + escbr$ + LTRIM$(STR$(NewCol% - 1)) + "C"
      END IF
    ELSEIF NewCol% = 1 THEN
      IF FromCol% = 1 THEN Code4$ = "" ELSE Code4$ = CHR$(13)
      IF VDiff% = 1 THEN
        Code4$ = Code4$ + ANSup$
      ELSE
        Code4$ = Code4$ + escbr$ + LTRIM$(STR$(VDiff%)) + "A"
      END IF
    END IF
  END IF

  MostEff$ = Code1$
  IF LEN(Code2$) THEN IF LEN(Code2$) < LEN(MostEff$) THEN MostEff$ = Code2$
  IF LEN(Code3$) THEN IF LEN(Code3$) < LEN(MostEff$) THEN MostEff$ = Code3$
  IF LEN(Code4$) THEN IF LEN(Code4$) < LEN(MostEff$) THEN MostEff$ = Code4$
  ALocate$ = MostEff$
  OldRow% = FromRow%
  OldCol% = FromCol%
END FUNCTION

FUNCTION ANSscrollzone$ (ZTop%, ZBot%)
  IF ZTop% = OldTop% AND ZBot% = OldBot% THEN EXIT FUNCTION
  ANSscrollzone$ = escbr$ + LTRIM$(STR$(ZTop%)) + ";" + LTRIM$(STR$(ZBot%)) + "r"
  OldTop% = ZTop%
  OldBot% = ZBot%
  ForceLocate% = -1
END FUNCTION

DEFSNG A-Z
SUB Aprint (Astring$) STATIC
  'This subroutine prints ANSI as well as the AVATAR/0+ codes according to the
  'AVATAR standard in the document FSC-0025/FSC-0037.
  ADisplay% = 1
  DO WHILE ADisplay% <= LEN(Astring$)
    IF (ANScode% OR AVTcode%) = 0 THEN
      NewDisp% = ContCode%(ADisplay%, Astring$)
      IF NewDisp% <> ADisplay% THEN
        Aoutput$ = MID$(Astring$, ADisplay%, NewDisp% - ADisplay%)
        Leng% = ChatWid% - OldCol% + 1
        Temp$ = LEFT$(Aoutput$, Leng%)
        DO
          IF Leng% > LEN(Aoutput$) THEN
            IF AInsert% THEN
              GetBlock2 VARSEG(ATempLn), VARPTR(ATempLn), CSRLIN, POS(0), CSRLIN, ChatWid% - LEN(Temp$)
              PRINT Temp$;
              PutBlock2 VARSEG(ATempLn), VARPTR(ATempLn), CSRLIN, POS(0), CSRLIN, ChatWid%
            ELSE
              PRINT Temp$;
            END IF
            EXIT DO
          ELSE
            PRINT Temp$;
            IF POS(0) = 1 THEN
              LOCATE , 1
              ARow% = CSRLIN
              IF ARow% = ABot% THEN
                ScrollBlock 0, 1, AFore%, ABack%, ATop%, 1, ABot%, ChatWid%
              ELSE
                IF ARow% < ChatHt% THEN LOCATE ARow% + 1
              END IF
            END IF
          END IF
          Temp$ = MID$(Aoutput$, Leng% + 1, ChatWid%)
          Leng% = Leng% + ChatWid%
        LOOP
        ACol% = POS(0)
        ARow% = CSRLIN
        ADisplay% = NewDisp%
      END IF
      AChar$ = MID$(Astring$, ADisplay%, 1)
      IF ADisplay% <= LEN(Astring$) THEN
        SELECT CASE ASC(AChar$)
        CASE 22: AVTcode% = -1                'Other AVATAR code
        CASE 27: ANScode% = 1
        CASE 25: AVTcode% = -3                '^Y Repeat character
        CASE 8
          IF ACol% > 1 THEN
            ACol% = ACol% - 1
            LOCATE , ACol%
            ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ACol%
          END IF
        CASE 13
          ACol% = 1
          LOCATE , 1
        CASE 10, 11
          IF ARow% = ABot% THEN
            ScrollBlock 0, 1, AFore%, ABack%, ATop%, 1, ABot%, ChatWid%
          ELSE
            IF ARow% < ChatHt% THEN ARow% = ARow% + 1: LOCATE ARow%, ACol%
          END IF
        CASE 9
          ACol% = ACol% - ((ACol% - 1) MOD 8) + 8
          IF ACol% < ChatWid% THEN LOCATE , ACol% ELSE ACol% = ChatWid%
        CASE 12
          LOCATE ATop%, 1
          COLOR 3, 0
          AFore% = 3
          ABack% = 0
          ARow% = ATop%
          ACol% = 1
          AInsert% = 0
          ScrollBlock 0, 0, 3, 0, ATop%, 1, ABot%, ChatWid%
        CASE 7
          SOUND 0, 0
          SOUND 300, .1
          SOUND 450, .2
          SOUND 600, .5
        END SELECT
      END IF
    ELSEIF AVTcode% THEN
'********************** AVATAR CODE HANDLING SECTION ************************
      AChar$ = MID$(Astring$, ADisplay%, 1)
      SELECT CASE AVTcode%
      CASE IS > 1        'Building AVT string
        DO
          AVTstring$ = AVTstring$ + AChar$
          AVTcode% = AVTcode% - 1
          IF AVTcode% <= 1 THEN EXIT DO
          IF ADisplay% = LEN(Astring$) THEN EXIT DO
          ADisplay% = ADisplay% + 1
          AChar$ = MID$(Astring$, ADisplay%, 1)
        LOOP
      CASE -1            'New AVT string
        AVTcode% = AVTlookup%(ASC(AChar$))
        AVTstring$ = AChar$
      CASE -3            'Repeat character ^Y
        AVTrptchar$ = AChar$
        AVTcode% = -4
      CASE -4
        IF INSTR(NoRepeat$, AVTrptchar$) = 0 THEN
          Astring$ = MID$(Astring$, ADisplay% + 1)
          ADisplay% = 0
          IF ASC(AChar$) + LEN(Astring$) < 8192 THEN Astring$ = STRING$(ASC(AChar$), AVTrptchar$) + Astring$
        END IF
        AVTcode% = 0
      END SELECT
      IF AVTcode% = 1 THEN
        SELECT CASE ASC(AVTstring$)
        CASE 1        '^V^A<A>            Set color attribute
          AValue% = ASC(AChar$)
          AFore% = (AValue% AND 15) + (AValue% AND 128) \ 8
          ABack% = (AValue% AND 112) \ 16
          COLOR AFore%, ABack%
        CASE 2        '^V^B               Set blink on
          AFore% = AFore% OR 16
          COLOR AFore%
        CASE 3        '^V^C               Cursor up
          IF ARow% > 1 THEN ARow% = ARow% - 1
          LOCATE ARow%, ACol%
        CASE 4        '^V^D               Cursor down
          IF ARow% < ChatHt% THEN ARow% = ARow% + 1
          LOCATE ARow%, ACol%
        CASE 5        '^V^E               Cursor left
          IF ACol% > 1 THEN ACol% = ACol% - 1
          LOCATE , ACol%
        CASE 6        '^V^F               Cursor right
          IF ACol% < ChatWid% THEN ACol% = ACol% + 1
          LOCATE , ACol%
        CASE 7        '^V^G               Clear to end of line
          ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ChatWid%
        CASE 8        '^V^H<Y,X>          Locate cursor
          ARow% = ASC(MID$(AVTstring$, 2))
          ACol% = ASC(AChar$)
          IF ARow% = 0 THEN ARow% = 1 ELSE IF ARow% > ChatHt% THEN ARow% = ChatHt%
          IF ACol% = 0 THEN ACol% = 1 ELSE IF ACol% > ChatWid% THEN ACol% = ChatWid%
          LOCATE ARow%, ACol%
        CASE 9        '^V^I               Set insert mode on
          AInsert% = -1
        CASE 10, 11   '^V^J<L,Y,X,Y2,X2>  Scroll block L lines up
                      '^V^K<L,Y,X,Y2,X2>  Scroll block L lines down
          IF ASC(AVTstring$) = 10 THEN Sscr% = 0 ELSE Sscr% = 1
          Slines% = ASC(MID$(AVTstring$, 2))
          Srow1% = ASC(MID$(AVTstring$, 3))
          Scol1% = ASC(MID$(AVTstring$, 4))
          Srow2% = ASC(MID$(AVTstring$, 5))
          Scol2% = ASC(AChar$)
          ScrollBlock Sscr%, Slines%, AFore%, ABack%, Srow1%, Scol1%, Srow2%, Scol2%
        CASE 12, 13   '^V^L<A,Y,X>        Clear block to attribute A
                      '^V^M<A,C,Y,X>      Fill block to attribute A, char C
          AValue% = ASC(MID$(AVTstring$, 2)) OR (AFore% AND 16) * 8
          AFore% = (AValue% AND 15) + (AValue% AND 128) \ 8
          ABack% = (AValue% AND 112) \ 16
          Srow% = ASC(RIGHT$(AVTstring$, 2)) - 1
          Scol% = ASC(AChar$) - 1
          COLOR AFore%, ABack%
          IF ASC(AVTstring$) = 12 THEN
            ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow% + Srow%, ACol% + Scol%
          ELSE
            FillBlock AValue%, ASC(MID$(AVTstring$, 3)), ARow%, ACol%, ARow% + Srow%, ACol% + Scol%
          END IF
        CASE 14       '^V^N               Delete character
          IF ACol% < ChatWid% THEN
            GetBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, ACol% + 1, ARow%, ChatWid%
            PutBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, ACol%, ARow%, ChatWid% - 1
          END IF
          ScrollBlock 0, 0, AFore%, ABack%, ARow%, 80, ARow%, 80
        END SELECT
        IF AInsert% THEN IF ASC(AVTstring$) <> 25 AND ASC(AVTstring$) <> 9 THEN AInsert% = 0
        AVTcode% = 0
      END IF
    ELSE
'*********************** ANSI CODE HANDLING SECTION *************************
      AChar$ = MID$(Astring$, ADisplay%, 1)
      IF ANScode% = 2 THEN
        ANScode% = 0
        SELECT CASE INSTR(ANSchars$, AChar$)
        CASE IS > 21
          IF LEN(ANSseq$) < 256 THEN ANSseq$ = ANSseq$ + AChar$ ELSE MID$(ANSseq$, 256) = AChar$
          ANScode% = 2
        CASE 1       'm' SetColors
          IF ANSseq$ = "" THEN ANSseq$ = "0"
          DO WHILE LEN(ANSseq$)
            ATemp% = VAL(ANSseq$)
            SELECT CASE ATemp%
            CASE 30 TO 37: AFore% = (AFore% AND 24) OR ANScolorTran%(ATemp% - 30)
            CASE 40 TO 47: ABack% = ANScolorTran%(ATemp% - 40)
            CASE 0: AFore% = 7: ABack% = 0     ' reset colors
            CASE 1: AFore% = AFore% OR 8       ' high intensity
            CASE 5: AFore% = AFore% OR 16      ' blink
            CASE 8: AFore% = ABack%            ' invisible
            CASE 7                             ' reverse video
              ATemp2% = AFore% AND 7
              AFore% = (AFore% AND 24) OR ABack%
              ABack% = ATemp2%
            END SELECT
            ATemp% = INSTR(ANSseq$, ";")
            IF ATemp% THEN ANSseq$ = MID$(ANSseq$, ATemp% + 1) ELSE ANSseq$ = ""
          LOOP
          COLOR AFore%, ABack%
        CASE 2       'A' CursorUp
          ATemp% = VAL(ANSseq$)
          IF ATemp% < 1 THEN ATemp% = 1
          IF ARow% >= ATop% AND (ARow% - ATemp%) <= ATop% THEN
            ARow% = ATop%
          ELSE
            ARow% = ARow% - ATemp%
            IF ARow% < 1 THEN ARow% = 1
          END IF
          LOCATE ARow%, ACol%
        CASE 3       'B' CursorDown
          ATemp% = VAL(ANSseq$)
          IF ATemp% < 1 THEN ATemp% = 1
          IF ARow% <= ABot% AND (ARow% + ATemp%) >= ABot% THEN
            ARow% = ABot%
          ELSE
            ARow% = ARow% + ATemp%
            IF ARow% > ChatHt% THEN ARow% = ChatHt%
          END IF
          LOCATE ARow%, ACol%
        CASE 4       'C' CursorRight
          ATemp% = VAL(ANSseq$)
          IF ATemp% < 1 THEN ACol% = ACol% + 1 ELSE ACol% = ACol% + ATemp%
          IF ACol% > ChatWid% THEN ACol% = ChatWid%
          LOCATE ARow%, ACol%
        CASE 5       'D' CursorLeft
          ATemp% = VAL(ANSseq$)
          IF ATemp% < 1 THEN ACol% = ACol% - 1 ELSE ACol% = ACol% - ATemp%
          IF ACol% < 1 THEN ACol% = 1
          LOCATE ARow%, ACol%
        CASE 6, 7    'H', 'f' CursorLocate
          ATemp% = INSTR(ANSseq$, ";")
          IF ATemp% THEN
            ACol% = VAL(MID$(ANSseq$, ATemp% + 1))
            IF ACol% < 1 THEN ACol% = 1 ELSE IF ACol% > ChatWid% THEN ACol% = ChatWid%
          ELSE
            ACol% = 1
          END IF
          ARow% = VAL(ANSseq$)
          IF ARow% < 1 THEN ARow% = 1 ELSE IF ARow% > ChatHt% THEN ARow% = ChatHt%
          LOCATE ARow%, ACol%
        CASE 8       's' SaveCursorPosn
          ASavRow% = CSRLIN
          ASavCol% = POS(0)
        CASE 9       'u' ResetCursorPosn
          IF ASavRow% < 1 THEN ASavRow% = 1
          IF ASavCol% < 1 THEN ASavCol% = 1
          ACol% = ASavCol%
          ARow% = ASavRow%
          LOCATE ARow%, ACol%
        CASE 10      'K' SmallErase
          ATemp% = VAL(ANSseq$)
          SELECT CASE ATemp%  'clear line 0=to end, 1=to begin, 2=full
          CASE 0: ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ChatWid%
          CASE 1: ScrollBlock 0, 0, AFore%, ABack%, ARow%, 1, ARow%, ACol%
          CASE 2: ScrollBlock 0, 0, AFore%, ABack%, ARow%, 1, ARow%, ChatWid%
          END SELECT
        CASE 11      'J' BigErase
          ATemp% = VAL(ANSseq$)
          SELECT CASE ATemp%  'clear screen 0=to end, 1=to begin, 2=full
          CASE 2     '2J' Clear whole screen
            ScrollBlock 0, 0, AFore%, ABack%, 1, 1, ChatHt%, ChatWid%
            LOCATE 1, 1
            ARow% = 1
            ACol% = 1
          CASE 1     '1J' Clear to end of screen
            ScrollBlock 0, 0, AFore%, ABack%, ARow%, 1, ARow%, ACol%
            IF ARow% > 1 THEN ScrollBlock 0, 0, AFore%, ABack%, 1, 1, ARow% - 1, ChatWid%
          CASE 0     '0J' Clear to beginning of screen
            ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ChatWid%
            IF ARow% < ChatHt% THEN ScrollBlock 0, 0, AFore%, ABack%, ARow% + 1, 1, ChatHt%, ChatWid%
          END SELECT
        CASE 14, 15  '@' InsertSpace,  'P' DeleteChar
          ATemp% = VAL(ANSseq$)
          IF ATemp% < 1 THEN ATemp% = 1
          Aoffs% = ACol% + ATemp%
          IF Aoffs% <= ChatWid% THEN
            IF AChar$ = "@" THEN     'InsertSpace
              GetBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, ACol%, ARow%, ChatWid% - ATemp%
              PutBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, Aoffs%, ARow%, ChatWid%
              ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ACol% + ATemp% - 1
            ELSE                     'DeleteChar
              GetBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, Aoffs%, ARow%, ChatWid%
              PutBlock2 VARSEG(ATempLn), VARPTR(ATempLn), ARow%, ACol%, ARow%, ChatWid% - ATemp%
              ScrollBlock 0, 0, AFore%, ABack%, ARow%, ChatWid% - ATemp% + 1, ARow%, ChatWid%
            END IF
          ELSE
            ScrollBlock 0, 0, AFore%, ABack%, ARow%, ACol%, ARow%, ChatWid%
          END IF
        CASE 19     'r' Set scrolling region
          ATemp% = INSTR(ANSseq$, ";")
          ABot% = 0
          IF ATemp% THEN ABot% = VAL(MID$(ANSseq$, ATemp% + 1)) AND 255
          ATop% = VAL(ANSseq$) AND 255
          IF ABot% = 0 THEN ABot% = ChatHt%
          IF ATop% > ChatHt% OR ATop% > ABot% THEN
            ATop% = 1
            ABot% = ChatHt%
          ELSE
            IF ATop% = 0 THEN ATop% = 1
            IF ABot% > ChatHt% THEN ABot% = ChatHt%
          END IF
          ARow% = 1
          ACol% = 1
          LOCATE 1, 1
        END SELECT
      ELSE
        IF AChar$ = "[" THEN
          ANScode% = 2
          ANSseq$ = ""
        ELSE
          SELECT CASE AChar$
          CASE "D", "E"    'Linefeed / Next Line
            IF AChar$ = "E" THEN ACol% = 1
            Astring$ = CHR$(10) + MID$(Astring$, ADisplay% + 1): ADisplay% = 0
          CASE "M"         'Reverse Linefeed
            IF ARow% = ATop% THEN
              ScrollBlock 1, 1, AFore%, ABack%, ATop%, 1, ABot%, ChatWid%
            ELSE
              IF ARow% > 1 THEN ARow% = ARow% - 1
            END IF
          END SELECT
          LOCATE ARow%, ACol%
          ANScode% = 0
        END IF
      END IF
    END IF
    ADisplay% = ADisplay% + 1
  LOOP
  OldRow% = ARow%
  OldCol% = ACol%
  OldInsert% = AInsert%
END SUB

DEFINT A-Z
FUNCTION ASaveLoc$ (SFlag%) STATIC
  '0 means to save cursor location, 1 means to restore cursor location.
  IF SFlag% THEN
    ForceLocate% = -1
    ASaveLoc$ = ALocate$(OldRow%, OldCol%, OldLocRow%, OldLocCol%)
  ELSE
    OldLocRow% = OldRow%
    OldLocCol% = OldCol%
  END IF
END FUNCTION

