; FOSSIL Routines, etc for general modem use.
; Declarations are for BASIC but can be easily modified for other languages.
; Copyright July 1992 by Mark D. Rejhon
;
;
; The following are the QuickBASIC declarations for the subroutines.
;
; DECLARE SUB CLocate (BYVAL CRow%, BYVAL CCol%)
; DECLARE SUB CReadLocate (CRow%, CCol%)
; DECLARE SUB FBaudRate (BYVAL Port%, FRate&, FParm$)
; DECLARE SUB FInitialize (BYVAL Port%, Erred%)
; DECLARE SUB FClose (BYVAL Port%)
; DECLARE SUB FDtr (BYVAL Port%, BYVAL State%)
; DECLARE SUB FOutFlush (BYVAL Port%)
; DECLARE SUB FOutClear (BYVAL Port%)
; DECLARE SUB FInClear (BYVAL Port%)
; DECLARE SUB FSend (BYVAL Port%, SendMessage AS STRING)
; DECLARE SUB FSendBlock (BYVAL Port%, SendMessage AS STRING, NumChars%)
; DECLARE SUB FSendChar (BYVAL Port%, Char AS STRING)
; DECLARE FUNCTION FRead$ (BYVAL Port%)
; DECLARE FUNCTION FInkey$ (BYVAL Port%)
; DECLARE FUNCTION FOutStat% (BYVAL Port%)
; DECLARE FUNCTION FInStat% (BYVAL Port%)
; DECLARE FUNCTION FCarrier% (BYVAL Port%)
; DECLARE SUB FBuffInfo (BYVAL Port%, InBuffSize%, InBuffChars%, OutBuffSize%, OutBuffChars%)
;
;
.8086
.MODEL MEDIUM, PASCAL, OS_DOS
.DATA

BuffLen         EQU  100h         ;Maximum length of Buffer
StringLen       WORD 0            ;String descriptor - Length
StringOffs      WORD 0            ;String descriptor - Offset
Buffer          BYTE BuffLen+1 DUP(0)  ;String Buffer,
                                       ;used by FBuffInfo and FRead

.CODE

Pushit MACRO                            ;Macro for saving regs and flags
        pushf
        push bx
        push cx
        push ds
        push es
ENDM
Popit MACRO                             ;Macro for restoring regs and flags
        pop es
        pop ds
        pop cx
        pop bx
        popf
        ret
ENDM

; SUB - Locates the cursor
CLocate PROC Row:WORD, Col:WORD
        Pushit
        mov     ax, Row                 ;Cursor row
        mov     cx, Col                 ;Cursor column
        mov     dh, al
        mov     dl, cl
        dec     dh                      ;Translates from 1,1 orgin to 0,0 orgin
        dec     dl
        mov     bx, 0h
        mov     ax, 0200h               ;Cursor locate function
        int     10h                     ;Video interrupt
        Popit
CLocate ENDP

; SUB - Reads the cursor's location
CReadLocate PROC Row:WORD, Col:WORD
        Pushit
        mov     bx, 0h
        mov     ax, 0300h               ;Read cursor location function
        int     10h                     ;Video interrupt
        mov     ax, 0                   ;These 4 lines convert bytes into words
        mov     cx, 0
        mov     al, dh
        mov     cl, dl
        inc     al                      ;Translates from 0,0 orgin to 1,1 orgin
        inc     cl
        mov     bx, Row                 ;Get address of integer
        mov     [bx], ax                ;Returns row
        mov     bx, Col                 ;Get address of integer
        mov     [bx], cx                ;Returns column
        Popit
CReadLocate ENDP

; SUB - Set baud rate and parity/stop bits. FParm is in the format "8N1".
FBaudRate PROC Port:WORD, FRate:WORD, FParm:WORD
        Pushit
        mov     bx, FRate
        mov     dx, [bx+2]
        cmp     dx, 0
        jnz     BaudReset
        mov     cx, [bx]
        mov     al, 01000000y           ;300 baud
        cmp     cx, 300
        je      BaudSet
        mov     al, 01100000y           ;600 baud
        cmp     cx, 600
        je      BaudSet
        mov     al, 10000000y           ;1200 baud
        cmp     cx, 1200
        je      BaudSet
        mov     al, 10100000y           ;2400 baud
        cmp     cx, 2400
        je      BaudSet
        mov     al, 11000000y           ;4800 baud
        cmp     cx, 4800
        je      BaudSet
        mov     al, 11100000y           ;9600 baud
        cmp     cx, 9600
        je      BaudSet
        mov     al, 00000000y           ;19200 baud
        cmp     cx, 19200
        je      BaudSet
        mov     al, 00100000y           ;38400 baud
        cmp     cx, 38400
        je      BaudSet
BaudReset:
        mov     al, 10100000y           ;2400 baud
        mov     WORD PTR [bx], 2400
        mov     WORD PTR [bx+2], 0
BaudSet:
        mov     bx, FParm               ;Get string descriptor's offset
        mov     cx, [bx]                ;Get string length
        mov     bx, [bx+2]              ;Get actual string's offset
        cmp     cx, 3                   ;Makes sure string is 3 chars
        jne     ResetParm               ;Resets to '8N1' if not
        mov     dl, 00000000y           ;1 stop bit
        cmp     BYTE PTR [bx+2], '1'
        je      StopSet
        mov     dl, 00000100y           ;2 stop bits
        cmp     BYTE PTR [bx+2], '2'
        jne     ResetString
StopSet:
        mov     dh, 00000000y           ;No parity
        cmp     BYTE PTR [bx+1], 'N'
        je      ParitySet
        mov     dh, 00011000y           ;Even parity
        cmp     BYTE PTR [bx+1], 'E'
        je      ParitySet
        mov     dh, 00001000y           ;Odd parity
        cmp     BYTE PTR [bx+1], 'O'
        jne     ResetString
ParitySet:
        mov     cl, 00000000y           ;5 data bits
        cmp     BYTE PTR [bx], '5'
        je      DataSet
        mov     cl, 00000001y           ;6 data bits
        cmp     BYTE PTR [bx], '6'
        je      DataSet
        mov     cl, 00000010y           ;7 data bits
        cmp     BYTE PTR [bx], '7'
        je      DataSet
        mov     cl, 00000011y           ;8 data bits
        cmp     BYTE PTR [bx], '8'
        jne     ResetString
DataSet:
        or      al, cl                  ;Add data bits
        or      al, dl                  ;Add stop bits
        or      al, dh                  ;Add parity
        jmp     ParmSet
ResetString:
        mov     BYTE PTR [bx], '8'       ;Resets the string to '8N1'
        mov     BYTE PTR [bx+1], 'N'     ;Resets the string to '8N1'
        mov     BYTE PTR [bx+2], '1'
ResetParm:
        or      al, 00000011y           ;'8N1' parameter
ParmSet:
        mov     dx, Port                ;COM port
        mov     ah, 00h                 ;Baud rate/parity/SB function
        int     14h
        Popit
FBaudRate ENDP

; SUB - Initializes a COM port.
FInitialize PROC Port:WORD, Erred:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     bx, 0
        mov     ax, 0400h               ;Initialize function
        int     14h                     ;Initializes
        cmp     ax, 01954h
        je      Exist                   ;FOSSIL not installed
        mov     bx, Erred               ;Get address of error code variable
        mov     WORD PTR [bx], -1       ;Return code of -1
        jmp     FossDone
Exist:  mov     cx, 0
        mov     cl, bh
        mov     bx, Erred               ;Get address of error code variable
        mov     [bx], cx                ;Move revision number into return code
FossDone:
        Popit
FInitialize ENDP

; SUB - Closes a COM port.
FClose PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0500h               ;Close function
        int     14h
        Popit
FClose ENDP

; SUB - Changes the state of the DTR
FDtr PROC Port:WORD, State:WORD
        Pushit
        mov     al, 0                   ;DTR is FALSE by default
        cmp     State, 0                ;Is desired state to be FALSE or TRUE
        jz      DropDtr                 ;Skips if DTR is to be FALSE
        mov     al, 1                   ;DTR is TRUE
DropDtr:
        mov     dx, Port                ;COM port
        mov     ah, 06h                 ;DTR function
        int     14h
        Popit
FDtr ENDP

; SUB - Flushes outgoing buffer. (Waits for outgoing buffer to finish flowing)
FOutFlush PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0800h               ;Outgoing flush function
        int     14h
        Popit
FOutFlush ENDP

; SUB - Purges the outgoing buffer.
FOutClear PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0900h               ;Outgoing purge function
        int     14h
        Popit
FOutClear ENDP

; SUB - Purges the incoming buffer.
FInClear PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0A00h               ;Incoming purge function
        int     14h
        Popit
FInClear ENDP

; FUNCTION - Check for carrier detect signal.
FCarrier PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0300h               ;Status request function
        int     14h
        mov     bx, 0
        test    al, 80h                 ;Checks Carrier Detect Bit
        jz      NoCarrier               ;Skips if Carrier Detect FALSE
        mov     bx, 1                   ;Carrier Detect is TRUE
NoCarrier:
        mov     ax, bx                  ;Return Carrier Detect value
        Popit
FCarrier ENDP

; FUNCTION - Check if characters are in outgoing buffer.
; 0 = empty, 1 = characters in it, 2 = buffer is full
FOutStat PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0300h               ;Status request function
        int     14h
        mov     bx, 0                   ;Buffer is clear
        test    ah, 40h                 ;Checks output buffer status
        jnz     OutBuffer               ;Skips if empty
        mov     bx, 1                   ;Characters in buffer
        test    ah, 20h                 ;Checks if output buffer is full
        jnz     OutBuffer               ;Skips if not full
        mov     bx, 2                   ;Buffer is full
OutBuffer:
        mov     ax, bx                  ;Return output buffer status value
        Popit
FOutStat ENDP

; FUNCTION - Check if characters are in incoming buffer.
; 0 = empty, 1 = characters in it, 2 = buffer is overrun
FInStat PROC Port:WORD
        Pushit
        mov     dx, Port                ;COM port
        mov     ax, 0300h               ;Status request function
        int     14h
        mov     bx, 0                   ;Buffer is clear
        test    ah, 01h                 ;Checks input buffer status
        jz      InBuffer                ;Skips if empty
        mov     bx, 1                   ;Characters in buffer
        test    ah, 02h                 ;Checks if input buffer overrun
        jz      InBuffer                ;Skips if not full
        mov     bx, 2                   ;Buffer is full
InBuffer:
        mov     ax, bx                  ;Return input buffer status value
        Popit
FInStat ENDP

; SUB - Gets information from the bufferFlushes outgoing buffer. (Waits for outgoing buffer to finish flowing)
FBuffInfo PROC Port:WORD, InBuffSize:WORD, InBuffChars:WORD, OutBuffSize:WORD, OutBuffChars:WORD
        Pushit
        push    di
        mov     dx, @data
        mov     es, dx                  ;Make es the same as code segment
        mov     di, OFFSET Buffer       ;Indicate the offset of the info buffer
        mov     cx, 20h                 ;Length of info buffer
        mov     dx, Port                ;COM port
        mov     ax, 1B00h               ;Driver status info function
        int     14h
        mov     cx, WORD PTR Buffer[08h]    ;Size of input buffer
        mov     bx, InBuffSize
        mov     [bx], cx                ;Save size of input buffer
        sub     cx, WORD PTR Buffer[0Ah]    ;Subtract number of chars free
        mov     bx, InBuffChars
        mov     [bx], cx                ;Save number of chars in input buffer
        mov     cx, WORD PTR Buffer[0Ch]    ;Size of output buffer
        mov     bx, OutBuffSize
        mov     [bx], cx                ;Save size of output buffer
        sub     cx, WORD PTR Buffer[0Eh]    ;Subtract number of chars free
        mov     bx, OutBuffChars
        mov     [bx], cx                ;Save number of chars in output buffer
        pop     di
        Popit
FBuffInfo ENDP

; SUB - Writes a string to the outgoing buffer
FSend PROC Port:WORD, SendMessage:WORD
        Pushit
        mov     ax, ds                  ;Make es equal to ds
        mov     es, ax
        mov     bx, SendMessage         ;Get offset of string descriptor
        mov     cx, [bx]                ;Get length of string
        cmp     cx, 0                   ;Makes sure string is not zero length
	jz	NoString		;Skips if no string
        mov     di, [bx+2]              ;Get offset of string
        mov     dx, Port                ;COM port
        mov     ax, 01900h              ;function to write block to buffer
        int     14h
NoString:
        Popit
FSend ENDP

; SUB - Writes a string to the outgoing buffer, and return the number of
; characters that were successfully written to the outgoing buffer.
FSendBlock PROC Port:WORD, SendMessage:WORD, NumChars:WORD
        Pushit
        mov     ax, ds                  ;Make es equal to ds
        mov     es, ax
        mov     bx, SendMessage         ;Get offset of string descriptor
        mov     cx, [bx]                ;Get length of string
        cmp     cx, 0                   ;Makes sure string is not zero length
	jz	NoBlock 		;Skips if no string
        mov     di, [bx+2]              ;Get offset of string
        mov     dx, Port                ;COM port
        mov     ax, 01900h              ;function to write block to buffer
        int     14h
        mov     bx, NumChars
        mov     [bx], ax                ;Return actual # of chars transmitted
NoBlock:
        Popit
FSendBlock ENDP

; SUB - Transmits a single character.
FSendChar PROC Port:WORD, Char:WORD
        Pushit
        mov     ax, ds                  ;Make es equal to ds
        mov     es, ax
        mov     bx, Char                ;Get offset of string descriptor
        mov     cx, [bx]                ;Get length of string
        cmp     cx, 0                   ;Makes sure string is not zero length
	jz	NoChar			;Skips if no character
        mov     cx, 1                   ;One character
        mov     di, [bx+2]              ;Get offset of string
        mov     dx, Port                ;COM port
        mov     ax, 01900h              ;function to write block to buffer
        int     14h
NoChar:
        Popit
FSendChar ENDP

; FUNCTION - Reads a string from the incoming buffer.
FRead PROC Port:WORD
        Pushit
        mov     dx, @data               ;Get data section
        mov     ds, dx                  ;Put into ds and es
        mov     es, dx
        mov     di, OFFSET Buffer       ;Gets offset of custom string
        mov     StringOffs, di          ;Store in string descriptor
        mov     cx, BuffLen             ;Request maximum string length
        mov     dx, Port                ;COM port
        mov     ax, 01800h              ;function to read block from buffer
        int     14h
        mov     StringLen, ax           ;Sets string length to read chars
        mov dx, @data                   ;Segment of string descriptor
        mov ax, OFFSET StringLen        ;Offset of string descriptor
        Popit
FRead ENDP

; FUNCTION - Read a character from the incoming buffer.
FInkey PROC Port:WORD
        Pushit
        mov     dx, @data               ;Get data section
        mov     ds, dx                  ;Put into ds and es
        mov     es, dx
        mov     di, OFFSET Buffer       ;Gets offset of custom string
        mov     StringOffs, di          ;Store in string descriptor
        mov     cx, 1                   ;Request 1 character
        mov     dx, Port                ;COM port
        mov     ax, 01800h              ;function to read block from buffer
        int     14h
        mov     StringLen, ax           ;Actual length of string
        mov     dx, @data               ;Segment of string descriptor
        mov     ax, OFFSET StringLen    ;Offset of string descriptor
        Popit
FInkey ENDP

END

