#include "uu.h"

void extract(char *name);
void get_path(int fd);
void make(char *name);

char work[200], SOld[200], SNew[200];

void compfiles(void)
begin
char oldline[200];
char newline[200];
int count = 0;
FILE * New;
FILE * Old;
FILE * Diff;
New = fopen(SNew, "r+t");
Old = fopen(SOld, "r+t");
if(New==NULL)
   begin
   cprintf("Error Opening %s\r\n", SNew);
   exit(4);
   end
if(Old==NULL)
   begin
   cprintf("Error Opening %s\r\n", SOld);
   exit(5);
   end
Diff = fopen("Comp.Map","w+t");
if(Diff==NULL)
   begin
   cputs("Error Opening COMP.MAP\r\n");
   exit(6);
   end
while((fgets(newline, 200, New))!=NULL)
   begin
   int llen = strlen(newline);
   int diff = 0;
   if((fgets(oldline, 200, Old))==NULL) strcpy(oldline,"");
   if(llen!=strlen(oldline)) diff = 1;
   if(!diff)
      if((strncmp(oldline, newline, llen))!=0) diff = 1;
   if(!diff) continue;
   if(oldline[0]!=NULL)
      fprintf(Diff,"Old: %s", oldline);
   fprintf(Diff,"New: %s\r\n", newline);
   count++;
   end
fcloseall();
cprintf("%d lines differing, details in COMP.MAP.\r\n", count);
end

void main(int argc, char * argv[])
begin
cputs("\r\nUltimate Universe Strings Version Comparator ver 1.0\r\n");
if(argc<2)
   begin
   cputs("\r\n");
   cputs("Syntax: UUWDCOMP OldStringsFile NewStringsFile\r\n\r\n");
   exit(1);
   end

strcpy(SOld, argv[1]);
strcpy(SNew, argv[2]);
if((access(SOld, 0))!=0)
   begin
   cprintf("Can't Find OldStringsFile: %s\r\n\r\n", SOld);
   exit(2);
   end
if((access(SNew, 0))!=0)
   begin
   cprintf("Can't Find NewStringsFile: %s\r\n\r\n", SNew);
   exit(3);
   end
compfiles();
end

