#!/bin/sh
# zmh.sh  28 Nov 07  Robert J. Clay 
# What to run during fidonet zmh
#
BBBSDIR=/opt/bbbs
WORKDIR=$BBBSDIR/work
SCRIPTS=$BBBSDIR/scripts

cd $BBBSDIR

#
echo Temporarily Offline for Maintenance > $WORKDIR/bbbs.noc  #
echo Temporarily Offline for Maintenance > $WORKDIR/bbbsd.noc  #

# take BBBS programs offline
/usr/bin/sudo /usr/bin/killall -HUP bbbs

# kill messages by content
$SCRIPTS/bmkill.sh

#  Message Conferences maintenance
$BBBSDIR/bbbs bpc t	# scan for & fix bad areas
$BBBSDIR/bbbs bogus r      # ensure that all mail is scanned out
$BBBSDIR/bbbs bpc b	# pack areas to min-max msgs
$BBBSDIR/bbbs bpc r Netmail	# Repair as neccessary & renumber Netmail conf
#  Netmail Tracker
$BBBSDIR/bbbs bmt
#  Pack the environmental settings file
$BBBSDIR/bbbs bsetpack
#
rm $WORKDIR/bbbs.noc    #
rm $WORKDIR/bbbsd.noc    #
#
# put BBBS programs online again
/usr/bin/sudo /opt/bbbs/scripts/sh/in.bbbsd

# get nntp
/usr/bin/at now -q f -f $SCRIPTS/sh/getnntp.sh
# back up bbbs configs etc.
/usr/bin/at now -q f -f $SCRIPTS/adm/bubbbs.sh
# run files maintenance
$SCRIPTS/filesmaint.sh
#
exit 0