#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "os.h"
#include "cmdline.h"

extern struct option_t options[];
extern struct value_t values[];
extern int num_options;

int cmdline(int argc, char *argv[])
{
  int t, g;
   
  for(g = 0;g < num_options;g++)
    values[g].used = 0;
   
  for(t = 1;t < argc;t++) {
    for(g = 0;g < num_options;g++) {
      if(!strcmp(argv[t], options[g].name)) {
	values[g].used++;
	if(options[g].type == OPTION)
	  break;
	
	if(options[g].type == OPTION_INT) {
	  t++;
	  if(t == argc || !isdigit(*argv[t]))
	    init_error("option \"%s\" requires numeric argument", argv[t - 1]); 
	  values[g].i = atoi(argv[t]);
	  break;
	}
	
	if(options[g].type == OPTION_STRING) {
	  t++;
	  if(t == argc)
	    init_error("option \"%s\" requires an argument", argv[t - 1]);
	  values[g].s = (char *)malloc(strlen(argv[t]));
	  strcpy(values[g].s, argv[t]);
	  break;
	}
	 
      }
    }
     
    if(g == num_options)
      return 1;
  }
   
  return 0;
}
