#include <ctype.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <termios.h>
#include <unistd.h>
#include "os.h"
#include "modem.h"
#include "status.h"
#include "varlist.h"

#define DOOR_CHUNK 128
#undef DEBUG_DOOR 

#ifdef DEBUG_DOOR
static FILE *debug;
#endif

#define transfer (old_busy == BUSY_DOWNLOAD || old_busy == BUSY_UPLOAD)

extern vmodem *modem, *spymodem;
extern varlist list;
extern int remote, node;
extern struct status_t *status_p;

static int run_door_tty(char *);
static int run_door_pty(char *);

int in_door = 0;
pid_t door_pid;

char pty_name[20], tty_name[20];
int pty_fd, tty_fd;

int get_pty()
{
  char letter, *number;
  
  //                0123456789
  strcpy(tty_name, "/dev/tty??");
  strcpy(pty_name, "/dev/pty??");
  
  for(letter = 'a';letter <= 'z';letter++) {
    pty_name[8] = letter;
    tty_name[8] = letter;
    
    for(number = "0123456789abcdef";*number;number++) {
      pty_name[9] = *number;
      tty_name[9] = *number;
      
      pty_fd = open(pty_name, O_RDWR);
      if(pty_fd == -1)
        continue;
      else
        return 0;
    }
  }
  
  return 1;    
}

#ifdef DEBUG_DOOR
void debug_dump(char *s, int l)
{
  int t;

  for(t = 0;t < l;t++) {
    if(!iscntrl(s[t]))
      fputc(s[t], debug);
    else
      fprintf(debug, "[%X]", (unsigned char)s[t]);
  }
}
#endif

int run_door(char *door)
{
// Hang on... I think I've just comitted a bit of a faux pas...
  if(isatty(modem -> fd))
    return run_door_tty(door);
  else
    return run_door_pty(door);
}

static int run_door_pty(char *door)
{
  int args = 1, result, status, ret, n, old_busy, modem_fd, max_fd, 
    spy_fd = -1, null_fd, last_fd, dead = 0;
  char *arg[100], buf[16], *buffer;
  fd_set ifd;
  struct timeval tv;

  tv.tv_sec  = 1;
  tv.tv_usec = 0;

  old_busy = status_p -> busy;
  
  buffer = (char *)malloc(DOOR_CHUNK);
   
  dprintf(">door: %s\n", door);
#ifdef DEBUG_DOOR
  if(old_busy == BUSY_UPLOAD)
    debug = fopen("../bb.debug", "w");
  else
    debug = fopen("bb.debug", "w");
  fprintf(debug, "\nOutput from: %s\n", door);
#endif
   
  arg[0] = strtok(door, " ");
   
  while((arg[args++] = strtok(NULL, " ")) && args < 99);
  if(!args)
    return 1;
  
  arg[99] = NULL;
  
  sprintf(buf, "%d", number("lines"));
  setenv("LINES", buf, 1);
  sprintf(buf, "%d", number("rows"));
  setenv("COLUMNS", buf, 1);

  if(get_pty())
    return 1;

// This is from the MC 3.2.1 source. It works, too. Thank God for 
// the GPL, you won't find this in any manuals ;-)
#if defined(TIOCSWINSZ)
  struct winsize tty_size;
  tty_size.ws_row = number("lines");
  tty_size.ws_col = number("rows");
  tty_size.ws_xpixel = tty_size.ws_ypixel = 0;
  ioctl(pty_fd, TIOCSWINSZ, &tty_size);
#endif

  door_pid = fork();

  if(door_pid == 0) { /* door */
    tty_fd = open(tty_name, O_RDWR);
    if(tty_fd == -1) {
      fprintf(stderr, "bb (door): could not open %s\n", tty_name);
      raise(SIGKILL);
    }
    
    close(pty_fd);
    setsid();
    
    if(dup2(tty_fd, 0) == -1 || dup2(tty_fd, 1) == -1) {
      perror("dup2");
      raise(SIGKILL);
    }
    
    if(transfer) {
      if(spymodem) {
	if(dup2(spymodem -> fd, 2) == -1) {
	  perror("dup2");
	  raise(SIGKILL);
	}
      }
      else {
	null_fd = open("/dev/null", O_RDWR);
	if(dup2(null_fd, 2) == -1) {
	  perror("dup2");
	  raise(SIGKILL);
	}
      }
    }
    else
      dup2(tty_fd, 2);
    
    execvp(arg[0], arg);
    raise(SIGKILL);
  }
  else if(door_pid == -1) { /* fork error */
    fatal_error("cannot fork");
  }
  else { /* parent */
    dprintf(">pid = %d\n", door_pid);

    if(!transfer)
      busy(BUSY_DOOR);

    in_door = 1;
    modem -> sig(0);

    if(spymodem && !transfer)
      spy_fd = spymodem -> fd;
      
    modem_fd = modem -> fd;

    if(modem_fd > pty_fd)
      max_fd = modem_fd;
    else
      max_fd = pty_fd;
      
    if(spymodem && spy_fd > max_fd)
      max_fd = spy_fd;
      
    while(!dead) {
      FD_ZERO(&ifd);
      FD_SET(pty_fd, &ifd);
      FD_SET(modem_fd, &ifd);
      if(spymodem && spy_fd != -1)
        FD_SET(spy_fd, &ifd);

      if(waitpid(door_pid, &status, WNOHANG))
	dead = 1;
            
      if(!dead)
	ret = select(max_fd + 1, &ifd, NULL, NULL, NULL);
      else
	ret = select(max_fd + 1, &ifd, NULL, NULL, &tv);

      if(ret == -1 && errno == EINTR) // clock tick
        continue;

      if(ret == -1) {
        perror("select");
        fatal_error("select error");
      }
      
      if(FD_ISSET(pty_fd, &ifd)) {
	if(last_fd != pty_fd) {
	  last_fd = pty_fd;
	  n = read(pty_fd, buffer, DOOR_CHUNK);
	  if(n <= 0)
	    continue;
#ifdef DEBUG_DOOR
	  fprintf(debug, "\nO: ");
	  debug_dump(buffer, n);
#endif
	  write(modem_fd, buffer, n);
	  if(spymodem && !transfer)
	    write(spymodem -> fd, buffer, n);
	}
      }
      else
	last_fd = -1;
      
      if(FD_ISSET(modem_fd, &ifd)) {
	if(last_fd != modem_fd) {
	  last_fd = modem_fd;
	  n = read(modem_fd, buffer, DOOR_CHUNK);
	  if(n > 0) {
	    write(pty_fd, buffer, n);
#ifdef DEBUG_DOOR
	    fprintf(debug, "\nI: ");
	    debug_dump(buffer, n);
#endif
	  }
	}
      }
      else
	last_fd = -1;

      if(spymodem && FD_ISSET(spy_fd, &ifd)) {
        n = read(spy_fd, buffer, DOOR_CHUNK);
        if(n > 0)
          write(pty_fd, buffer, n);
      }    
    }
  }
  
  close(pty_fd);
#ifdef DEBUG_DOOR
  fclose(debug);
#endif

  if(!transfer)
    busy(old_busy);

  in_door = 0;

  if(WIFEXITED(status))
    result = WEXITSTATUS(status);
  else
    result = 1;
    
  modem -> init();
  if(modem -> type == DEV_LOCAL && !remote)
    modem -> sig(1);
  
  free(buffer);
   
  return result;
}

static int run_door_tty(char *door)
{
  int args = 1, result, status, ret, old_busy, null_fd;
  char *arg[100], buf[16];

  old_busy = status_p -> busy;
  
  dprintf(">door: %s\n", door);

  arg[0] = strtok(door, " ");   
  while((arg[args++] = strtok(NULL, " ")) && args < 99);
  if(!args)
    return 1;
  
  arg[99] = NULL;
  
  sprintf(buf, "%d", number("lines"));
  setenv("LINES", buf, 1);
  sprintf(buf, "%d", number("rows"));
  setenv("COLUMNS", buf, 1);

  door_pid = fork();

  if(door_pid == 0) { /* door */
    modem -> sig(0);
    dup2(modem -> fd, 0);
    dup2(modem -> fd, 1);

    if(spymodem)
      dup2(spymodem -> fd, 2);
    else { // &!#!(#%ING SZ!!!
      null_fd = open("/dev/null", O_RDWR);
      dup2(null_fd, 2);
    }

    execvp(arg[0], arg);
    raise(SIGKILL);
  }
  else if(door_pid == -1) { /* fork error */
    fatal_error("cannot fork");
  }
  else { /* parent */
    if(!transfer)
      busy(BUSY_DOOR);

    in_door = 1;
    
    // This will have to do for now
    for(;;) {
      ret = wait(&status);
      if(ret == door_pid)
	break;
    }    
  }

  if(!transfer)
    busy(old_busy);

  in_door = 0;

  if(WIFEXITED(status))
    result = WEXITSTATUS(status);
  else
    result = 1;
    
  modem -> init();
  if(modem -> type == DEV_LOCAL && !remote)
    modem -> sig(1);
  
  return result;
}

void kill_door()
{
  int t;
  pid_t p;
   
  if(!in_door)
    return;
     
  /* Doors get 5 seconds to clean up */
  if(kill(door_pid, SIGTERM))
    perror("kill");

  for(t = 0;t < 5;t++) { 
    p = waitpid(door_pid, NULL, WNOHANG);
    if(p)
      return; /* door is dead (could be an error, but who cares?) */
    usleep(1000000);
  }
   
  kill(door_pid, SIGKILL);
}

