#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "status.h"

struct status_t *status_p NULL;
struct pool_t *status_pool = NULL;
int pool_id, node;

int init_pool(int create)
{
  key_t key;
  int t;
  struct shmid_ds info;

  key = ftok(KEYFILE, 42);
  pool_id = shmget(key, sizeof(struct pool_t), SHM_PERM);

  if(pool_id != -1) {
    status_pool = (struct pool_t *)shmat(pool_id, 0, 0);
    
    if(status_pool == (struct pool_t *) -1) {
      perror("shmat");
      return 1;
    }
  }
  else if(create) {
    pool_id = shmget(key, sizeof(struct pool_t), SHM_PERM | IPC_CREAT);
    if(pool_id == -1) {
      perror("shmget");
      return 1;
    }

    status_pool = (struct pool_t *)shmat(pool_id, 0, 0);
    if(status_pool == (struct pool_t *) -1) {
      perror("shmat");
      return 1;
    }

    status_pool -> nodes = 0;
    for(t = 0;t < MAX_NODES;t++)
      status_pool -> status[t].pid = 1; // can't be legal (= init)
  }
  else
    return 1;

  shmctl(pool_id, IPC_STAT, &info);
  if(info.shm_nattch == 1) { // Bugs`r'Us, so...
    status_pool -> nodes = 0;
    for(t = 0;t < MAX_NODES;t++)
      status_pool -> status[t].pid = 1;
  }

  return 0;
}

int initstatus()
{
  if(status_pool -> nodes >= MAX_NODES)
    return 1;

  status_pool -> nodes++;
  status_p = &(status_pool -> status[node]);
  status_p -> flags = 0;
  status_p -> pid = getpid();

  return 0;
}

void killstatus()
{
  struct shmid_ds info;

  if(status_pool == NULL || status_pool == (struct pool_t *) -1)
    return;

  status_pool -> nodes--;
  status_p -> pid = 1;

  shmctl(pool_id, IPC_STAT, &info);

  if(status_pool -> nodes == 0 && info.shm_nattch == 1) {
    shmctl(pool_id, IPC_RMID, NULL);
    shmdt((char *)status_pool);
  }

  status_pool = NULL;
}

int probe_node()
{
  int t;

  for(t = 0;t < MAX_NODES;t++)
    if(status_pool -> status[t].pid == 1)
      return t;

  return -1;
}

status_t *attach_other(int n)
{
  return &(status_pool -> status[n]);
}




