#ifndef _ALLIANCE_C_
#define _ALLIANCE_C_

#include "bf.h"

void create_alliances(void)
{

  char STR1[256];
  struct stat buf;
  FILE *allfile;
  alliancerec allrec;

  allfile = NULL;
  sprintf(STR1, "%s/Alliances", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating Alliances");
	  sprintf(STR1, "%s/Alliances", CONFDIR);
	  allfile = ioobj.bopen(STR1, "wb");
	  if (allfile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  strcpy(allrec.name, "Magi");
	  strcpy(allrec.password, "alpha");
	  allrec.num = 100;
	  fwrite(&allrec, sizeof(alliancerec), 1, allfile);
	  ioobj.bclose(allfile);
	  chmod(STR1,0775);
  }
}

void disband_alliance()
{
  Player *uptr, *uptr2;
  Castle *cptr;
  alliancerec *aptr2, *aptr;
  boolean found;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("error!!");
  if (uptr->alliance == 0) {
   ioobj.sstrcr("You must create an alliance before ");
   ioobj.sstrcr("You may disband one.");
  } else if (uptr->allianceleader == false) {
   ioobj.sstrcr("You are not the leader of your");
   ioobj.sstrcr("team.  Only the leader (creator)  may disband a team");
  } else {
   ioobj.sstrcr("Team disbanded!");
    cptr = castles;
    while (cptr != NULL) {
      if (cptr->alliance == uptr->alliance)
	cptr->alliance = 0;
      cptr = cptr->next;
    }
    aptr = alliances;
    aptr2 = alliances;
    while (!found) {
      if (aptr->num == uptr->alliance)
	found = true;
      else {
	aptr2 = aptr;
	aptr = aptr->next;
      }
    }
    if (aptr == alliances) {
      aptr2 = aptr2->next;
      alliances = aptr2;
    } else
      aptr2->next = aptr->next;
    free(aptr);
    uptr2 = players;
    while (uptr2 != NULL) {
      if (uptr2->alliance == uptr->alliance)
	uptr2->alliance = 0;
      uptr2 = uptr2->next;
    }
  }
  ioobj.waitcr();
}

void get_alliances(alliancerec **alliances)
{
  FILE *allfile;
  alliancerec allrec, *aptr;
  char STR1[256];

  allfile = NULL;
  sprintf(STR1, "%s/Alliances", CONFDIR);
  allfile = ioobj.bopen(STR1, "rb");
  if (allfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  while (!feof(allfile)) {
    if (fread(&allrec, sizeof(alliancerec), 1, allfile) > 0)
    {
	    aptr = (alliancerec *)malloc(sizeof(alliancerec));
	    strcpy(aptr->name, allrec.name);
	    aptr->num = allrec.num;
	    strcpy(aptr->password, allrec.password);
	    aptr->next = *alliances;
	    *alliances = aptr;
    }
  }
  ioobj.bclose(allfile);
  allfile = NULL;
}



boolean findalliance( char *name, alliancerec **alliance)
{
  alliancerec *gptr;
  boolean found;

  gptr = alliances;
  found = false;
  while (gptr != NULL && !found) {
    if (!strcmp(gptr->name, name)) {
      found = true;
      *alliance = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}
void join_alliance()
{
  Player *uptr;
  char c[256], p[256];
  alliancerec *aptr;
  Castle *cptr;
  char STR1[256];
  char STR2[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("error!");
  if (uptr->alliance != 0) {
   ioobj.sstrcr("You are already part of an alliance.  You must quit");
   ioobj.sstrcr("your current alliance to join another");
  } else if (uptr->alliance == 0 && uptr->allianceleader)
   ioobj.sstrcr("You must wait one day after quitting one alliance to join another");
  else {
   ioobj.sstrcr("You are about to join an alliance.");
   ioobj.sstrcr("What is the name of the alliance?");
   ioobj.sstrcr("The name must be exactly correct.   Upper and lower");
   ioobj.sstrcr("case letters must match correctly");
    ioobj.cr();
   ioobj.sstrcr(" 1-------10--------20--------30");
    ioobj.sstr("|");
    strcpy(c,"");
    ioobj.gstr(c, 31L);
    if (!findalliance(c, &aptr))
     ioobj.sstrcr("Alliance name not found.");
    else {
      ioobj.sstr("Password: ");
      strcpy(p,"");
      ioobj.gstr(p, 8L);
      sprintf(p, "%.8s", strcpy(STR1, p));
      if (strcmp(p, aptr->password))
	ioobj.sstrcr("Password incorrect.");
      else {
	ioobj.sstrcr("Password accepted");
	ioobj.sstrcr("You are now the part of ");
	sprintf(STR2, "%s alliance ", aptr->name);
	ioobj.sstrcr(STR2);
	cptr = castles;
	while (cptr != NULL) {
	  if (!strcmp(cptr->alias, uptr->alias))
	    cptr->alliance = aptr->num;
	  cptr = cptr->next;
	}
	uptr->alliance = aptr->num;
	strcpy(uptr->alliancename, aptr->name);
	uptr->allianceleader = false;
      }
    }
  }
  ioobj.waitcr();
}

void kick_out(Player *uptr)
{
  char c[256];
  Player *uptr1;
  boolean found;
  char STR2[44];

  ioobj.clear_scr();
  if (uptr->alliance == 0)
   ioobj.sstrcr("You're not in an alliance.  ");
  else {
    if (!uptr->allianceleader)
     ioobj.sstrcr(
	"You must be an alliance leader before you can kick someone off your team.");
    else {
      ioobj.sstr("Enter characters to search for in player name: ");
      strcpy(c,"");
      ioobj.gstr(c, 20L);
      uptr1 = players;
      found = false;
      while (uptr1 != NULL && !found) {
	if (search(uptr1->alias, c) &&
	    uptr1->alliance == uptr->alliance)
	  found = true;
	else
	  uptr1 = uptr1->next;
      }
      if (!found)
	ioobj.sstrcr("Player not found!");
      else {
	sprintf(STR2, "Player found: %s", uptr1->alias);
	ioobj.sstrcr(STR2);
	ioobj.sstr("Is this the person you wish removed from your alliance? ");
	if (yesno()) {
	  *uptr1->alliancename = '\0';
	  uptr1->alliance = 0;
	  uptr1->allianceleader = false;
	 ioobj.sstrcr("Player successfully removed from alliance.");
	}
      }
    }
  }
  ioobj.waitcr();
}

void lend()
{
  Player *uptr1, *uptr2, *uptr3;
  char c[256];
  char s[256];
  long amount;
  int count;
  boolean found;
  long totalplayers, hischoice;
  char STR3[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr1))
   ioobj.sstrcr("error!");
  uptr2 = players;
  found = false;
  while (uptr2 != NULL && !found) {
    if (uptr2->sector == currentsector &&
	strcmp(uptr2->alias, uptr1->alias) &&
	uptr2->alliance == uptr1->alliance)
      found = true;
    else
      uptr2 = uptr2->next;
  }
  if (!found) {
   ioobj.sstrcr("You haven't got another alliance member in the same sector.");
   ioobj.sstrcr("You must have another alliance member in the");
   ioobj.sstrcr("same sector to give something to him.");
  } else {
   ioobj.sstrcr("You may give to:");
    totalplayers = 0;
    uptr3 = players;
    while (uptr3 != NULL) {
      if (uptr3->sector == currentsector &&
	  strcmp(uptr3->alias, uptr1->alias) &&
	  uptr3->alliance == uptr1->alliance) {
	totalplayers++;
	sprintf(STR3, "%ld.  %s", totalplayers, uptr3->alias); 
	ioobj.sstrcr(STR3);
      }
      uptr3 = uptr3->next;
    }
    ioobj.sstr("Who would you like to give to? ");
    strcpy(s,"");
    ioobj.gstr(s, 1L);
    stringtonum(s, &hischoice);
    if (hischoice > totalplayers)
     ioobj.sstrcr("Invalid choice.");
    else {
      uptr3 = players;
      count = 0;
      while (count < hischoice) {
	if (uptr3->sector == currentsector &&
	    strcmp(uptr3->alias, uptr1->alias) &&
	    uptr3->alliance == uptr1->alliance)
	  count++;
	if (count < hischoice)
	  uptr3 = uptr3->next;
      }
      uptr2 = uptr3;
      ioobj.sstr("Would you like to give gold or warriors?");
      strcpy(c,"");
      ioobj.gstr(c, 1L);
      if (uncase(c[0]) == 'g') {
	ioobj.sstr("How much gold? ");
        strcpy(c,"");
	ioobj.gstr(c, 6L);
	stringtonum(c, &amount);
	amount = labs(amount);
	if (amount > uptr1->gold)
	 ioobj.sstrcr("You don't have that much gold!");
	else {
	  uptr2->gold += amount;
	  uptr1->gold -= amount;
	 ioobj.sstrcr("Your comrade thanks you for the gold.");
	}
      } else {
	ioobj.sstr("How many warriors? ");
        strcpy(c,"");
	ioobj.gstr(c, 6L);
	stringtonum(c, &amount);
	amount = labs(amount);
	if (amount > uptr1->armysize)
	 ioobj.sstrcr("You don't have that many warriors!");
	else {
	  uptr2->armysize += amount;
	  uptr1->armysize -= amount;
	 ioobj.sstrcr("Your comrade thanks you for the warriors.");
	}
      }
    }
  }
  ioobj.waitcr();
}


void list_alliances(Player *players)
{
  Player *uptr, *player;
  boolean done;
  alliancerec *aptr;
  char STR1[256];
  char STR2[38];

  ioobj.clear_scr();
  uptr = players;
  if (!find_player_by_name(playername, &player))
    ioobj.sstrcr("Error!");
  aptr = alliances;
  while (aptr != NULL && !done) {
    uptr = players;
    sprintf(STR1, "Alliance: %s", aptr->name);
    ioobj.sstrcr(STR1);
    ioobj.cr();
    ioobj.sstrcr("Members: ");
    while (uptr != NULL && !done) {
      if (uptr->alliance == aptr->num) {
	sprintf(STR2, "%20s", uptr->alias);
	ioobj.sstrcr(STR2);
      }
      uptr = uptr->next;
    }
    ioobj.cr();
    ioobj.cr();
    aptr = aptr->next;
    ioobj.waitcr();
    ioobj.clear_scr();
  }
  ioobj.sstrcr("End of listing.");
  ioobj.waitcr();
}

void new_alliance()
{
  Castle *cptr;
  Player *uptr;
  alliancerec *aptr2, *aptr;
  long high;
  char c[32];
  boolean done;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("Error!");
  if (uptr->alliance != 0) {
   ioobj.sstrcr("You are already in an alliance. ");
    ioobj.cr();
   ioobj.sstrcr("You must quit your old alliance to create a new one");
  } else if (uptr->alliance == 0 && uptr->allianceleader == true) {
   ioobj.sstrcr("You must wait a day after quitting one alliance ");
   ioobj.sstrcr("to create another.");
  } else {
    ioobj.sstr("Do you want to create a new alliance?");
    if (yesno()) {
      aptr = (alliancerec *)malloc(sizeof(alliancerec));
      done = false;
      while (!done) {
	ioobj.sstrcr("Please enter a name for your alliance");
	ioobj.sstrcr("The name may be up to 30 characters in length.");
	ioobj.cr();
	ioobj.sstrcr("1-------10--------20--------30");
        strcpy(c,"");
	ioobj.gstr(c, 31L);
	if (findalliance(c, &aptr) || c[0] == ' ') {
	  done = false;
	 ioobj.sstrcr("I'm sorry, but that name is already taken.  Please choose another");
	} else {
	  done = true;
	  strcpy(aptr->name, c);
	}
      }
      aptr2 = alliances;
      high = 0;
      while (aptr2 != NULL) {
	if (aptr2->num > high)
	  high = aptr2->num;
	aptr2 = aptr2->next;
      }
      aptr->num = high + 1;
     ioobj.sstrcr("You may now enter a password for ");
     ioobj.sstrcr("Your team.");
     ioobj.sstrcr("1------8");
        strcpy(c,"");
      ioobj.gstr(c, 8L);
      sprintf(aptr->password, "%.8s", c);
      aptr->next = alliances;
      alliances = aptr;
      uptr->alliance = aptr->num;
      strcpy(uptr->alliancename, aptr->name);
      uptr->allianceleader = true;
      cptr = castles;
      while (cptr != NULL) {
	if (!strcmp(cptr->alias, uptr->alias))
	  cptr->alliance = uptr->alliance;
	cptr = cptr->next;
      }
     ioobj.sstrcr("Your alliance has been successfully created.");
     ioobj.sstrcr("May your alliance always come out ahead.");
    }
  }
  ioobj.waitcr();
}

void new_password(Player **uptr)
{
  char p[256];
  alliancerec *aptr;
  char STR1[256];

  ioobj.clear_scr();
  if ((*uptr)->alliance == 0) {
   ioobj.sstrcr("You are not in an alliance.  ");
   ioobj.sstrcr("Join or create an alliance before you try to change the password. ");
  } else if (!(*uptr)->allianceleader)
   ioobj.sstrcr(
      "You are not the leader of your alliance.  Only the leader may change the password.");
  else {
    if (!findalliance((*uptr)->alliancename, &aptr))
     ioobj.sstrcr("Alliance name not found.");
    else {
      ioobj.sstr("Old password: ");
        strcpy(p,"");
      ioobj.gstr(p, 8L);
      sprintf(p, "%.8s", strcpy(STR1, p));
      if (strcmp(p, aptr->password))
	ioobj.sstrcr("Password incorrect.  Password change aborted.");
      else {
	ioobj.sstrcr("Password accepted.");
	ioobj.sstr("New password: ");
        strcpy(p,"");
	ioobj.gstr(p, 8L);
	sprintf(p, "%.8s", strcpy(STR1, p));
	strcpy(aptr->password, p);
	sprintf(STR1, "Your new team password is: %s", p);
	ioobj.sstrcr(STR1);
      }
    }
  }
  ioobj.waitcr();
}




void quit_alliance()
{
  Player *uptr;
  Castle *cptr;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("Error!");
  if (uptr->alliance == 0) {
   ioobj.sstrcr("You are not part of an alliance at this time.");
   ioobj.sstrcr("It is not possible to quit a nonexistant alliance.");
    ioobj.waitcr();
    return;
  }
  if (uptr->allianceleader) {
   ioobj.sstrcr(
      "Sire, you are the head of the alliance!  You must disband the alliance to quit.");
    ioobj.waitcr();
    return;
  }
  ioobj.sstr("Are you sure you want to quit your current alliance? ");
  if (yesno()) {
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->alliance = 0;
      cptr = cptr->next;
    }
    uptr->alliance = 0;
    uptr->allianceleader = true;
    strcpy(uptr->alliancename, "none");
  }
  ioobj.waitcr();
}




#endif // _ALLIANCE_C_

