/* From iioobj.gstr file "castle.pas" */

#ifndef _CASTLE_C_
#define _CASTLE_C_


#include "bf.h"

void addcastle(Castle castle, Castle **castles)
{
  Castle *gptr;

  gptr = (Castle *)malloc(sizeof(Castle));
  gptr->sector = castle.sector;
  strcpy(gptr->name, castle.name);
  gptr->armor = castle.armor;
  gptr->weapon = castle.weapon;
  strcpy(gptr->oldowner, castle.oldowner);
  gptr->defend = castle.defend;
  strcpy(gptr->alias, castle.alias);
  gptr->attacked = castle.attacked;
  gptr->newgold = castle.newgold;
  strcpy(gptr->attackedby, castle.attackedby);
  gptr->alliance = castle.alliance;
  gptr->oil = castle.oil;
  gptr->moat = castle.moat;
  gptr->wall = castle.wall;
  gptr->towers = castle.towers;
  gptr->region = castle.region;
  gptr->region_sub = castle.region_sub;
  gptr->next = *castles;
  *castles = gptr;
  if (!find_castle_by_o_a(castle.alias, &gptr)) {
    ioobj.sstrcr("Error!  Castle not found!");
    ioobj.waitcr();
  }
}

void add_target_castles()
{
  FILE *castlefile;
  long count, walcnt, oilcnt, moatcnt, defcnt;
  Castle castle;
  struct stat buf;
  char STR1[256];
  char STR2[86];
  char STR3[54];

  castlefile = NULL;
  sprintf(STR1, "%s/Castles", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	ioobj.sstrcr("Creating castles");
	sprintf(STR1, "%s/Castles", CONFDIR);
	castlefile = ioobj.bopen(STR1, "wb");
	if (castlefile == NULL)
	{
		perror(STR1);
		exit_game(1);
	}
	for (count = 1; count <= 16; count++) {
		castle.sector = abs(rand() % boardsize) + 1;
		major_castles(count, &castle);
		sprintf(STR2, "%s",castle.name);
		sprintf(STR1, "%.31s", STR2);
		strcpy(castle.name, STR1);
		sprintf(STR3, "%s", castle.alias);
		sprintf(STR1, "%.30s", STR3);
		strcpy(castle.alias, STR1);
		castle.armor = 10;
		castle.weapon = 10;
		strcpy(castle.oldowner, "sysop");
		castle.oil = 5;
		castle.castype = 0;
		castle.moat = 5;
		castle.wall = 25;
		castle.towers = 1;
		castle.defend = abs(rand() % 15000) + 5000;
		castle.alliance = 100;
		strcpy(castle.attackedby, "none");
		fwrite(&castle, sizeof(Castle), 1, castlefile);
	}
	walcnt = 5;
	oilcnt = 1000;
	moatcnt = 10;
	defcnt = 5000;
	for (count = 1; count <= 16; count++) {
		castle.sector = boardsize + count;
		target_castles(count, &castle);
		sprintf(STR3, "%s", castle.name);
		sprintf(STR1, "%.31s", STR3);
		strcpy(castle.name, STR1);
		sprintf(STR3, "%s", castle.alias);
		sprintf(STR1, "%.30s", STR3);
		strcpy(castle.alias, STR1);
		castle.armor = count + 4;
		castle.weapon = count + 4;
		castle.castype = 0;
		strcpy(castle.oldowner, "sysop");
		castle.oil = oilcnt;
		oilcnt += 50;
		castle.moat = moatcnt;
		moatcnt += 5;
		castle.wall = walcnt + 4;
		castle.towers = count / 3;
		castle.defend = (long)abs(rand() % 20000) + defcnt;
		defcnt += 50000L;
		castle.alliance = 99;
		strcpy(castle.attackedby, "none");
		fwrite(&castle, sizeof(Castle), 1, castlefile);
	}
	ioobj.bclose(castlefile);
    }
    sprintf(STR1, "%s/Castles", CONFDIR);
    chmod(STR1,0775);
}

boolean attack_castle(void)
{
  boolean Result;
  Castle *castle;
  boolean tmpmen, tmpweapon;
  long mmen, totalarmy;
  boolean init;
  long x, oillost, tmp, tmp1, tmp2, castlelost, totcaslost;
  char strng[256], c[256];
  long hoil, hmen;
  boolean dead, done, playerwon, found;
  Player *player, *uptr, *WITH;
  char STR2[256], STR3[256];
  long FORLIM;
  long t;

  done = false;
  ioobj.clear_scr();
  dead = false;
  mmen = 0;
  tmpweapon = false;
  tmpmen = false;
  init = true;
  playerwon = false;
  if (!find_player_by_name(playername, &player))
    ioobj.sstrcr("can't find player!");
  else if (!find_castle_in_sector(currentsector, &castle)) {
    ioobj.sstrcr("There is no castle for you to attack. ");
    ioobj.cr();
    ioobj.sstrcr("Look again.");
    dead = false;
    ioobj.waitcr();
  } else if (!strcmp(castle->alias, player->alias) ||
	     (castle->alliance == player->alliance &&
	      player->alliance != 0)) {
    ioobj.sstrcr("You can't attack one of your own castles!");
    ioobj.sstrcr("either quit from your alliance, or look at your stats again.");
    dead = false;
    ioobj.waitcr();
  } else {
    WITH = player;   /*with*/
    if (WITH->armysize <= 1) {
      ioobj.clear_scr();
      ioobj.sstrcr("The castle's warriors have ambushed you!");
      ioobj.sstrcr("but, because you had no warriors with you, you were not able to fight");
      ioobj.sstrcr("off the attackers.  Their swords rip you to ribbons.  ");
      ioobj.sstrcr("perhaps in your next life, you'll deem to bring your warriors . ");
      player->killed = 1;
      player->armysize = 1;
      strcpy(player->killedby, castle->name);
      player->dead = true;
      player->gold = 0;
      dead = true;
      done = true;
      ioobj.waitcr();
    } else if (castle->defend <= 1) {
      ioobj.clear_scr();
      ioobj.sstrcr("You have attacked the castle.  But, there are no warriors on the walls!");
      ioobj.sstrcr("you walk in the door, and wonder why someone left this castle");
      ioobj.sstrcr("untenanted.  Well, that was an easy castle to take.");
      playerwon = true;
      player->experience += 2000;
      if (castle->alliance != 99) {
	strcpy(castle->oldowner, castle->alias);
	strcpy(castle->alias, player->alias);
	castle->alliance = player->alliance;
	castle->armor = player->armor;
	castle->weapon = player->weapon;
	castle->defend = 1;
	player->armysize--;
      }
      done = true;
      ioobj.waitcr();
    }
    totcaslost = 0;
    if (castle->alliance == 99) {
      hmen = castle->defend;
      hoil = castle->oil;
    }
    while (!done) {
      ioobj.clear_scr();
      sprintf(STR2, "The castle has %ld", castle->defend);
      ioobj.sstr(STR2);
      sprintf(STR3, " warriors and walls %ld feet tall ", castle->wall);
      ioobj.sstrcr(STR3);
      if (castle->towers > 0) {
	  sprintf(STR2, "You also see %ld tower%c above the battlements.",castle->towers,castle->towers>1?'s':'\0');
	  ioobj.sstrcr(STR2);
      }
      if (castle->moat > 0) {
	  sprintf(STR3, "There is a %ld foot wide moat in front of the walls.",castle->moat);
	  ioobj.sstrcr(STR3);
      }
      ioobj.cr();
      sprintf(STR3, "You have %ld warriors.", player->armysize);
      ioobj.sstr(STR3);
      if (mmen > 0) {
	sprintf(STR2, "You also have %ld skeletons ", mmen);
	ioobj.sstrcr(STR2);
      }
      ioobj.cr();
      tmp = (long)floor(0.02 * castle->defend + 0.03 * castle->defend +
			lrand48() % labs(castle->defend + 1) * 0.02 +
			(castle->defend - player->armysize) * 0.01 +
			castle->armor * 0.04 * castle->defend +
			castle->weapon * 0.05 * castle->defend + 0.5);
      if (tmp < 0) {
	tmp = abs(rand() % labs(castle->defend + 1));
      }
      if (tmp > player->armysize)
	tmp = player->armysize;
      tmp2 = tmp;
      if (tmpmen) {
	if (tmp > mmen) {
	  tmp1 = mmen;
	  tmp2 = tmp / 2 + tmp / 2 - mmen;
	} else {
	  tmp1 = tmp;
	  tmp2 = 0;
	}
	if (player->male)
	  ioobj.sstr("Prince,");
	else
	  ioobj.sstr("Princess, ");
        ioobj.sstrcr("Your advisors agree that you will lose ");
	sprintf(STR2, "%ld skeletons, and", tmp1);
	ioobj.sstrcr(STR2);
	sprintf(STR2, "%ld of your own men.", tmp2);
	ioobj.sstrcr(STR2);
      } else {
	if (player->male)
	  ioobj.sstrcr("Prince, your advisors agree that you will lose ");
	else
	  ioobj.sstrcr("Princess, your advisors agree that you will lose ");
	sprintf(STR2, "%ld warriors to the defenders, and  ", tmp2);
	ioobj.sstrcr(STR2);
      }
      t = (long) abs(rand() % 50 * (player->armor - 4) * labs(castle->wall - 5));
      sprintf(STR2, "%ld men to the battlements,", t);
      ioobj.sstrcr(STR2);
      if (castle->moat > 0) {
	  t = abs(rand() % 40 * (player->armor - 5) * labs(castle->moat - 6));
	sprintf(STR2, "%ld men to the moat,", t);
	ioobj.sstrcr(STR2);
      }
      ioobj.sstrcr("and more, depending on the other fortifications.");
      ioobj.cr();
      ioobj.sstrcr("You may run, attack, or cast a  spell. ");
      ioobj.sstr("Your choice? ");
      strcpy(strng,"");
      ioobj.gstr(strng, 1L);
      sprintf(c, "%c", uncase(strng[0]));
      if (c[0] == 'r') {
	ioobj.cr();
	ioobj.sstrcr("Attack aborted");
	ioobj.cr();
	if (tmpmen)
	  ioobj.sstrcr("All of your skeletons dissolve into the ground...");
	if (tmpweapon) {
	  player->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing..");
	}
	dead = false;
	done = true;
	ioobj.waitcr();
	continue;
      }
      if (c[0] == 'c') {
	if (WITH->mweapon <= 0 && WITH->mwarriors <= 0) {
	  ioobj.sstrcr("You do not have any fight spells.");
	  ioobj.waitcr();
	  continue;
	}
	ioobj.sstrcr("You may use the following: ");
	ioobj.sstrcr("0. none");
	if (WITH->mweapon > 0)
	  ioobj.sstrcr("1. Magic weapon spell");
	if (WITH->mwarriors > 0)
	  ioobj.sstrcr("2. Magic warriors");
	ioobj.sstr("your choice? ");
      strcpy(c,"");
	ioobj.gstr(c, 1L);
	if (c[0] == '0')
	  ioobj.sstrcr("Spell aborted.");
	else if (c[0] == '1') {
	  if (WITH->mweapon <= 0)
	    ioobj.sstrcr("What?");
	  else if (tmpweapon)
	    ioobj.sstrcr("Another magic weapon spell would do us no good sire.");
	  else {
	    WITH->mweapon--;
	    if (abs(rand() % 100) < 10 || castle->alliance == 99) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("the spell fizzles out before it can take effect.");
	    } else {
	      tmpweapon = true;
	      player->weapon *= 5;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      ioobj.sstrcr("Your weapons are glowing crimson red!");
	    }
	  }
	  ioobj.waitcr();
	} else if (c[0] == '2') {
	  if (WITH->mwarriors <= 0)
	    ioobj.sstrcr("what?");
	  else {
	    WITH->mwarriors--;
	    if (abs(rand() % 100) < 10 || castle->alliance == 99) {
	      ioobj.sstrcr("Your mages bend to the task, but to no avail.");
	      ioobj.sstrcr("the spell fizzles out before it can take effect.");
	      ioobj.sstrcr("I guess you'll have to fight this round without spells.");
	    } else {
	      tmpmen = true;
	      mmen += 15000;
	      ioobj.sstrcr("Your journeyman mages bend to the task.  ");
	      ioobj.sstrcr("They succeed!");
	      ioobj.sstrcr("Fifteen thousand skeletons dig themselves from");
	      ioobj.sstrcr("The ground, and join your troops.");
	      ioobj.waitcr();
	    }
	  }
	}
	ioobj.waitcr();
	continue;
      }
      totalarmy = WITH->armysize + mmen;
      castlelost = (long)floor((WITH->str - 12) * 0.02 * totalarmy +
			       (WITH->chrs - 12) * 0.005 * totalarmy +
			       (WITH->int_ - 12) * 0.005 * totalarmy +
			       WITH->level * 0.02 * totalarmy +
			       lrand48() % totalarmy * 0.1 +
			       (totalarmy - castle->defend) * 0.03 +
			       (WITH->armor - 2) * 0.005 * totalarmy +
			       (WITH->weapon - 2) * 0.005 * totalarmy + 0.5);
      castlelost /= labs(castle->wall - 10) + 1;
      if (castlelost > castle->defend)
	castlelost = castle->defend;
      totcaslost += castlelost;
      if (tmpmen) {
	if (mmen - tmp > 0) {
	  if (castle->moat > 0) {
	    tmp += abs(rand() % 55) * labs(player->armor - 4) *
		   labs(castle->moat - 2);
	  }
	} else if (castle->moat > 0) {
	  tmp2 += abs(rand() % 55) * labs(player->armor - 4) *
		  labs(castle->moat - 4);
	}
	if (mmen - tmp > 0) {
	  if (castle->towers > 0) {
	    tmp += abs(rand() % 100) * labs(10 - player->armor) *
		   labs(castle->towers);
	  }
	} else if (castle->towers > 0) {
	  tmp2 += abs(rand() % 100) * labs(10 - player->armor) *
		  labs(castle->towers);
	}
	if (mmen - tmp > 0) {
	  tmp += abs(rand() % 45) * labs(player->armor - 5) *
		 labs(castle->wall - 10);
	} else {
	  tmp2 += abs(rand() % 45) * labs(player->armor - 5) *
		  labs(castle->wall - 10);
	}
      } else {
	if (castle->moat > 0) {
	  tmp2 += abs(rand() % 55) * labs(player->armor - 4) *
		  labs(castle->moat - 4);
	}
	if (castle->towers > 0) {
	  tmp2 += abs(rand() % 100) * labs(10 - player->armor) *
		  labs(castle->towers);
	}
	tmp2 += abs(rand() % 45) * labs(player->armor - 5) *
		labs(castle->wall - 10);
      }
      oillost = 0;
      if (castle->oil > 0) {
	FORLIM = castle->oil;
	for (x = 1; x <= FORLIM; x++) {
	  oillost += abs(rand() % 75);
	}
	castle->oil = 0;
      }
      tmp2 += oillost;
      if (tmp > mmen)
	tmp = mmen;
      if (tmp2 >= totalarmy || player->armysize <= 1) {
	player->killed = player->armysize;
	player->armysize = 1;
	strcpy(player->killedby, castle->name);
	player->dead = true;
	dead = true;
	done = true;
	uptr = players;
	found = false;
	while (uptr != NULL && !found) {
	  if (!strcmp(uptr->alias, castle->alias))
	    found = true;
	  else
	    uptr = uptr->next;
	}
	if (found)
	  uptr->gold += player->gold;
	strcpy(castle->attackedby, player->alias);
	castle->attacked = true;
	castle->newgold += player->gold;
	player->gold = 0;
      } else {
	player->armysize -= tmp2;
	if (tmpmen) {
	  mmen -= tmp1;
	  if (mmen <= 0)
	    mmen = 0;
	}
      }
      if (castlelost >= castle->defend) {
	if (dead)
	  castle->defend /= 2;
	else {
	  playerwon = true;
	  if (find_player_by_alias(castle->alias, &uptr) && !uptr->dead &&
	      uptr->sector == currentsector) {
	    if (uptr->incastle) {
	      ioobj.sstrcr("You have found the owner of this castle!");
	      ioobj.sstrcr("He was found trying to escape through a secret tunnel.");
	      ioobj.sstrcr("you take his armor and weapon, and have him beheaded.");
	      ioobj.sstrcr("perhaps he will not hide in his castle in the future.");
	      uptr->dead = true;
	      if (uptr->weapon > player->weapon && uptr->alliance != 100) {
		ioobj.sstrcr("You find a great cache of weapons in the castle");
		ioobj.sstrcr("of your foe.  you throw away your old weapons");
		ioobj.sstrcr("and happily grab his fine weapons.");
		tmp = uptr->weapon;
		uptr->weapon = player->weapon;
		player->weapon = tmp;
		switchw(*uptr, *player);
	      }
	      if (uptr->armor > player->armor && uptr->alliance != 100) {
		ioobj.sstrcr("In the conquered castle, you find many new suits of armor.");
		ioobj.sstrcr("with the glee of a child on christmas morning, you don");
		ioobj.sstrcr("your new armor.");
		ioobj.sstrcr("You thank your dead opponent for his thoughtfulness.");
		tmp = uptr->armor;
		uptr->armor = player->armor;
		player->armor = tmp;
		switcha(*uptr, *player);
	      }
	    }
	  }
	  if (castle->alliance != 99) {
	    strcpy(castle->oldowner, castle->alias);
	    strcpy(castle->alias, player->alias);
	    castle->alliance = player->alliance;
	    castle->armor = player->armor;
	    castle->weapon = player->weapon;
	    castle->defend = 1;
	  } else
	    give_reward(&player);
	  done = true;
	}
      }
      if (dead) {
	ioobj.sstrcr("The castle's defenders rained death upon you and your army.");
	ioobj.sstrcr("In the process, your army was defeated.");
	ioobj.sstrcr("The casualty list included your name.");
	ioobj.sstrcr("Due to your deceased condition, the castle defenders walk out,");
	ioobj.sstrcr("And take all of your gold.  better luck next time.");
	ioobj.sstrcr("You will be able to play again tomorrow");
	if (tmpmen)
	  ioobj.sstrcr("All of your skeletons dissolve into the ground...");
	if (tmpweapon) {
	  player->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing..");
	}
	quit = true;
	ioobj.waitcr();
	continue;
      }
      if (playerwon) {
	sprintf(STR2, "You lost %ld warriors.", tmp2);
	ioobj.sstrcr(STR2);
	ioobj.sstrcr("But, you defeated the defenders of the castle. ");
	WITH->goldfound = (int)fabs(totcaslost / (abs(rand() & 1) + 1));
	player->experience += totcaslost * 20 * castle->castype;
	sprintf(STR3, "You gained %ld experience points from the battle.", totcaslost*20);
	ioobj.sstrcr(STR3);
	player->gold += WITH->goldfound;
	done = true;
	sprintf(STR3, "Your army found %ld gold pieces. ", WITH->goldfound);
	ioobj.sstrcr(STR3);
	ioobj.cr();
	if (tmpweapon) {
	  WITH->weapon /= 5;
	  ioobj.sstrcr("Your weapons stop glowing blue...");
	}
	if (tmpmen)
	  ioobj.sstrcr("All of the skeletons dissolve at the end of the battle");
	check_for_win();
	ioobj.waitcr();
	continue;
      }
      sprintf(STR3, "You lost %ld", tmp2);
      ioobj.sstr(STR3);
      if (oillost > 0) {
	ioobj.sstrcr(" warriors to the defenders, along with ");
	sprintf(STR3, "%ld warriors to burning oil.", oillost);
	ioobj.sstrcr(STR3);
      } else
	ioobj.sstrcr(" warriors to the defenders.");
      if (tmpmen) {
	sprintf(STR2, "You also lost %ld skeletons", tmp1);
	ioobj.sstrcr(STR2);
	if (mmen <= 0)
	  tmpmen = false;
      }
      ioobj.cr();
      sprintf(STR2, "The castle lost %ld warriors.", castlelost);
      ioobj.sstrcr(STR2);
      ioobj.cr();
      castle->defend -= castlelost;
      ioobj.sstr("Do you want to continue the battle? ");
      if (!yesno())
	done = true;
    }  /*while*/
    if (castle->alliance == 99) {
      castle->defend = hmen;
      castle->oil = hoil;
    }
  }
  Result = dead;
  check_for_level(player);
  return Result;
}  /*function*/

void buy_castle()
{
  Castle *cptr;
  Player *uptr;
  char s[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
   ioobj.sstrcr("Error!");
  if (uptr->gold + uptr->bank < 50000*theoptions.difficulty) {
   sprintf(s,"New castles cost %ld gold pieces to build.  You do not have that much money.",(long)50000*theoptions.difficulty);
   ioobj.sstrcr(s);
   ioobj.sstrcr("Please come back when you have enough money.");
  } else if (find_castle_in_sector(currentsector, &cptr)) {
   ioobj.sstrcr("There is already a castle in this sector.  ");
   ioobj.sstrcr("Please put your castle in another sector.");
  } else {
   sprintf(s,"Castles cost %ld gold pieces to build.  ",(long)50000*theoptions.difficulty);
   ioobj.sstrcr(s);
    ioobj.sstr("Are you sure you want to create a new castle? ");
    if (yesno()) {
      if (uptr->gold < 50000*theoptions.difficulty) {
	ioobj.cr();
	ioobj.sstrcr("Some of your bank funds were used to");
	ioobj.sstrcr("Finance the new project.");
	uptr->bank += uptr->gold - 50000*theoptions.difficulty;
	uptr->gold = 0;
	give_castle(&castles, currentsector);
      } else {
	ioobj.sstrcr("Castle created!");
	uptr->gold -= 50000*theoptions.difficulty;
	give_castle(&castles, currentsector);
      }
    }
  }
  ioobj.waitcr();
}

void castle_name( Castle *castle)
{
  long ranum;

  ranum = abs(rand() % 50) + 1;
  switch (ranum) {

  case 1:
    strcpy(castle->name, "Beiun");
    break;

  case 2:
    strcpy(castle->name, "Hion");
    break;

  case 3:
    strcpy(castle->name, "Gima");
    break;

  case 4:
    strcpy(castle->name, "Nema");
    break;

  case 5:
    strcpy(castle->name, "Erim");
    break;

  case 6:
    strcpy(castle->name, "Om-ir");
    break;

  case 7:
    strcpy(castle->name, "Wadvir");
    break;

  case 8:
    strcpy(castle->name, "Tionnis");
    break;

  case 9:
    strcpy(castle->name, "Alepantir");
    break;

  case 10:
    strcpy(castle->name, "Mir-ar");
    break;

  case 11:
    strcpy(castle->name, "Tiomis");
    break;

  case 12:
    strcpy(castle->name, "Efinoc");
    break;

  case 13:
    strcpy(castle->name, "Druid's keep");
    break;

  case 14:
    strcpy(castle->name, "Minkor");
    break;

  case 15:
    strcpy(castle->name, "Binom");
    break;

  case 16:
    strcpy(castle->name, "Wazin");
    break;

  case 17:
    strcpy(castle->name, "Parik");
    break;

  case 18:
    strcpy(castle->name, "Klymen");
    break;

  case 19:
    strcpy(castle->name, "Virme");
    break;

  case 20:
    strcpy(castle->name, "Feoer");
    break;

  case 21:
    strcpy(castle->name, "Harca");
    break;

  case 22:
    strcpy(castle->name, "Lokas");
    break;

  case 23:
    strcpy(castle->name, "Verre");
    break;

  case 24:
    strcpy(castle->name, "D'Artagnan");
    break;

  case 25:
    strcpy(castle->name, "Kyrna");
    break;

  case 26:
    strcpy(castle->name, "Parom");
    break;

  case 27:
    strcpy(castle->name, "Raggin");
    break;

  case 28:
    strcpy(castle->name, "Tyoonis");
    break;

  case 29:
    strcpy(castle->name, "Helium");
    break;

  case 30:
    strcpy(castle->name, "J'Marl");
    break;

  case 31:
    strcpy(castle->name, "D'Inoc");
    break;

  case 32:
    strcpy(castle->name, "Deoan");
    break;

  case 33:
    strcpy(castle->name, "Youca");
    break;

  case 34:
    strcpy(castle->name, "Jurca");
    break;

  case 35:
    strcpy(castle->name, "B'Meroen");
    break;

  case 36:
    strcpy(castle->name, "Gaelon");
    break;

  case 37:
    strcpy(castle->name, "Gaemic");
    break;

  case 38:
    strcpy(castle->name, "Gaetom");
    break;

  case 39:
    strcpy(castle->name, "Weerdn");
    break;

  case 40:
    strcpy(castle->name, "Edeoi");
    break;

  case 41:
    strcpy(castle->name, "Toica");
    break;

  case 42:
    strcpy(castle->name, "Baer");
    break;

  case 43:
    strcpy(castle->name, "D'Montague");
    break;

  case 44:
    strcpy(castle->name, "Liceon");
    break;

  case 45:
    strcpy(castle->name, "Gideol");
    break;

  case 46:
    strcpy(castle->name, "Effoan");
    break;

  case 47:
    strcpy(castle->name, "Ophir");
    break;

  case 48:
    strcpy(castle->name, "Yo-ug");
    break;

  case 49:
    strcpy(castle->name, "Eanor's Keep");
    break;

  case 50:
    strcpy(castle->name, "Hades");
    break;

  default:
    strcpy(castle->name, "Thor's Keep");
    break;
  }
}

void change_castle_name()
{
  char c[256], f[256];
  Player *player;
  Castle *cptr, *cptr2;
  boolean found;

 ioobj.sstrcr("Characters to search for in castle name? ");
 ioobj.sstrcr(" 1-------10--------20--------30");
  ioobj.sstr("|");
      strcpy(f,"");
  ioobj.gstr(f, 31L);
  cptr = castles;
  found = false;
  while (cptr != NULL && !found) {
    if (search(cptr->name, f))
      found = true;
    else
      cptr = cptr->next;
  }
  if (!find_player_by_name(playername, &player))
   ioobj.sstrcr("error!");
  if (cptr == NULL || strcmp(cptr->alias, player->alias))
   ioobj.sstrcr("Castle not found.");
  else {
   ioobj.sstrcr("What would you like to change the name to?");
   ioobj.sstrcr(" 1-------10--------20--------30");
    ioobj.sstr("|");
      strcpy(c,"");
    ioobj.gstr(c, 31L);
    if (strlen(c) < 3)
     ioobj.sstrcr("I'm sorry, but that name is already taken.  Name change aborted.");
    else {
      found = false;
      cptr2 = castles;
      while (cptr2 != NULL) {
	if (!strcmp(cptr2->name, c)) {
	 ioobj.sstrcr("That name is already taken.  Name change aborted.");
	  found = true;
	}
	cptr2 = cptr2->next;
      }
      if (!found) {
	strcpy(cptr->name, c);
	ioobj.sstrcr("Name changed!");
      }
    }
  }
  ioobj.waitcr();
}

void check_castles( Player *uptr)
{
  Castle *cptr1, *cptr2;
  long count, count2;
  char STR2[256];

  cptr1 = castles;
  count = 0;
  while (cptr1 != NULL) {
    if (!strcmp(cptr1->alias, uptr->alias))
      count++;
    cptr1 = cptr1->next;
  }
  if (count <= 10/theoptions.difficulty)
    return;
  cptr = castles;
  cptr2 = cptr;
  ioobj.sstrcr("In your abscence, a great rash of tornadoes hit the kingdom.");
  ioobj.sstrcr("In this great tragedy, you lost the following castles:");
  count2 = count - 10/theoptions.difficulty;
  while (cptr != NULL && count2 > 0) {
    if (!strcmp(cptr->alias, uptr->alias)) {
      cptr->defend = (cptr->defend - abs(rand() % 5000))/theoptions.difficulty;
      ioobj.sstrcr(cptr->name);
      sprintf(STR2, "%ld men escaped the chaos to re-join your army.", cptr->defend);
      ioobj.sstrcr(STR2);
      uptr->armysize += cptr->defend;
      if (cptr == castles) {
	castles = cptr->next;
	cptr2 = castles;
      } else
	cptr2->next = cptr->next;
      free(cptr);
      cptr = cptr2;
      count2--;
    }
    cptr2 = cptr;
    cptr = cptr->next;
  }
  ioobj.waitcr();
}


void delete_castle()
{
  Castle *cptr1, *cptr2;
  boolean found;
  char s[256];

  ioobj.sstr("Please enter the castle's name to delete ");
      strcpy(s,"");
  ioobj.gstr(s, 31L);
  cptr1 = castles;
  cptr2 = castles;
  found = false;
  while (cptr1 != NULL && !found) {
    if (!strcmp(cptr1->name, s))
      found = true;
    else {
      cptr2 = cptr1;
      cptr1 = cptr1->next;
    }
  }
  if (cptr1 == NULL)
   ioobj.sstrcr("Castle not found!");
  else {
    if (cptr2 != castles)
      cptr2->next = cptr1->next;
    else
      castles = cptr1->next;
    free(cptr1);
   ioobj.sstrcr("Castle deleted!");
  }
  ioobj.waitcr();
}

void destroy_castle()
{
  long cost;
  Castle *cptr, *cptr2, *dptr, *nptr;
  Player *uptr;
  char STR2[256], STR3[256];

  ioobj.clear_scr();
  if (!find_castle_in_sector(currentsector, &nptr))
    ioobj.sstrcr("There is no castle for you to destroy in this sector!");
  else if (!find_player_by_name(playername, &uptr))
    exit_game(0);
  else if (strcmp(uptr->alias, nptr->alias)) {
    ioobj.sstrcr("You do not own this castle.  you may not destroy a castle that");
    ioobj.sstrcr("is not yours.");
    ioobj.waitcr();
  } else {
    ioobj.sstrcr("You enter a construction shop.");
    ioobj.sstrcr("A large foreman waves you in, and sits you down at his desk.");
    ioobj.sstrcr("He speaks:");
    ioobj.sstrcr("\"You may hire my crew to destroy this castle\"");
    sprintf(STR3, "He pulls out and examines a folder with %s written on it.",
	    nptr->name);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr("after some thought, he speaks again:");
    switch (nptr->castype) {

    case 1:
      cost = 50000*theoptions.difficulty;
      break;

    case 2:
      cost = 90000L*theoptions.difficulty;
      break;

    case 3:
      cost = 190000L*theoptions.difficulty;
      break;

    case 4:
      cost = 270000L*theoptions.difficulty;
      break;

    default:
      nptr->castype = 1;
      cost = 50000L*theoptions.difficulty;
      break;
    }
    sprintf(STR2, "It will cost %ld gp to destroy this castle.", cost);
    ioobj.sstrcr(STR2);
    if (cost > uptr->gold) {
      ioobj.sstrcr("The foreman says: \"It is obvious that you do not have the money.\"");
      ioobj.sstrcr("Please come back when you have the money for my services.");
    } else {
      ioobj.sstrcr("The foreman asks:");
      ioobj.sstr("Are you sure you wish to destroy this castle? ");
      if (yesno()) {
	uptr->gold -= cost;
	ioobj.sstrcr("The men work many nights and days to dismember this castle.");
	ioobj.sstrcr("After many weeks of work, they have levelled the castle.");
	cptr = castles;
	cptr2 = castles;
	while (strcmp(cptr->name, nptr->name)) {
	  cptr2 = cptr;
	  cptr = cptr->next;
	}
	uptr->armysize += cptr->defend;
	if (cptr == castles) {
	  castles = cptr->next;
	  cptr2 = castles;
	  dptr = cptr;
	} else {
	  cptr2->next = cptr->next;
	  dptr = cptr;
	}
	free(dptr);
      } else {
	ioobj.sstrcr("The foreman escorts you to the door:");
	ioobj.sstrcr("Please come back when you're serious about castle destruction.");
      }
    }
  }
  ioobj.waitcr();
}

boolean find_castle_in_sector(long sector, Castle **casle)
{
  Castle *cptr;
  boolean fnd;


  cptr = castles;
  fnd = false;
  while (cptr != NULL && !fnd) {
    if (cptr->sector == sector) {
      *casle = cptr;
      fnd = true;
    } else
      cptr = cptr->next;
  }
  return fnd;
}

boolean find_castle_by_o_a(char *aliasname, Castle **castle)
{
  Castle *gptr;
  boolean found;

  gptr = castles;
  found = false;
  while (gptr != NULL && !found) {
    if (!strcmp(gptr->alias, aliasname)) {
      found = true;
      *castle = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}

boolean find_castle_by_n(char *name, Castle **castle)
{
  Castle *gptr;
  boolean found;

  gptr = castles;
  found = false;
  while (gptr != NULL && !found) {
    if (!strcmp(gptr->name, name)) {
      found = true;
      *castle = gptr;
    } else
      gptr = gptr->next;
  }
  return found;
}


void fortify_castle()
{
  Player *uptr;
  long num, dum;
  Castle *cptr;
  long thetype;
  char c[256], s[256], thestr[256];
  char STR2[256], STR3[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  if (!find_castle_in_sector(currentsector, &cptr)) {
    ioobj.sstrcr("There is no castle in this sector.");
    ioobj.sstrcr("Please look again.");
    ioobj.waitcr();
  } else if (strcmp(cptr->alias, uptr->alias)) {
    ioobj.sstrcr("You do not own this castle.");
    ioobj.sstrcr("You cannot fortify a castle you do not own.");
    ioobj.waitcr();
  } else {
    ioobj.sstrcr("You enter the castle engineer's shop.");
    ioobj.sstrcr("It is a very large place with tons of granite, marble and other assorted");
    ioobj.sstrcr("Fine stone in attendance.  you walk up to the engineer.");
    ioobj.sstrcr("He says \"Welcome, sire, to my humble place of business.");
    ioobj.sstrcr(
      "May I help you?  We specialize in the strengthening of castles, and excel at ");
    ioobj.sstrcr("the building of impregnable fortresses.\"");
    sprintf(STR3,"Milord, my books say that this castle currently has a moat %ld feet wide,", cptr->moat);
    ioobj.sstrcr(STR3);
    sprintf(STR3, "%ld towers, a wall %ld feet tall, and ", cptr->towers, cptr->wall);
    ioobj.sstrcr(STR3);
    sprintf(STR2, "%ld oil casks.", cptr->oil);
    ioobj.sstrcr(STR2);
    sprintf(STR3, "You have %ld gold pieces.", uptr->gold);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr(" You request a price list, which he gladly gives you . ");
    ioobj.sstrcr("Number           Type            Price for one unit (in gp)");
    ioobj.sstrcr("-----------------------------------------------------");
    sprintf(STR3,"1.             Burning Oil %25ld",(long)250*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"2.             Expand Moat %25ld",(long)3000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"3.             Extend Wall %25ld",(long)6000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"4.             Build Tower %25ld",(long)100000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    ioobj.cr();
    ioobj.sstrcr("All building will be done as quickly as possible.");
    ioobj.sstr("Your choice, sire? ");
      strcpy(s,"");
    ioobj.gstr(s, 2L);
    stringtonum(s, &dum);
    if (dum > 0 && dum < 5) {
      switch (dum) {

      case 1:
	if (uptr->gold < 250*theoptions.difficulty)
	  ioobj.sstrcr("Milord!  You cannot afford any burning oil!");
	else {
	  ioobj.sstr("How many oil casks would you like? ");
      strcpy(c,"");
	  ioobj.gstr(c, 5L);
	  stringtonum(c, &num);
	  if (num * 250*theoptions.difficulty > uptr->gold)
	    ioobj.sstrcr(
	      "You cannot afford that many.  Please come back when you're serious.");
	  else {
	    ioobj.sstrcr("Your oil casks have been delivered.");
	    uptr->gold -= num * 250*theoptions.difficulty;
	    cptr->oil += num;
	  }
	}
	break;

      case 2:
	if (uptr->gold < 5000*theoptions.difficulty)
	  ioobj.sstrcr("Milord!  You cannot afford to expand your moat!");
	else {
	  ioobj.sstr("How many feet wider would you like your moat? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &num);
	  if (num * 5000*theoptions.difficulty > uptr->gold)
	    ioobj.sstrcr(
	      "You cannot afford that much.  Please come back when you're serious.");
	  else {
	    sprintf(STR2, "Your moat is now %s feet wider.", s);
	    ioobj.sstrcr(STR2);
	    uptr->gold -= num * 5000*theoptions.difficulty;
	    cptr->moat += num;
	  }
	}
	break;

      case 3:
	if (uptr->gold < 6000*theoptions.difficulty)
	  ioobj.sstrcr("Milord!  You cannot afford to increase your wall!");
	else {
	  ioobj.sstr("How many feet taller would you like your wall? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &num);
	  if (num * 6000*theoptions.difficulty > uptr->gold) {
	    ioobj.sstrcr("You cannot afford that much of an increase.");
	    ioobj.sstrcr("Please come back when you have the money to do so.");
	  } else {
	    ioobj.sstrcr("Your wall has been fortified.");
	    uptr->gold -= num * 6000*theoptions.difficulty;
	    cptr->wall += num;
	  }
	}
	break;

      case 4:
	if (uptr->gold < 100000L*theoptions.difficulty) {
	  if (cptr->towers > 0)
	    ioobj.sstrcr("Milord!  You cannot afford a tower.");
	  else
	    ioobj.sstrcr("Milord!  You cannot afford another tower!");
	} else {
	  ioobj.sstr("How many towers would you like to add to your castle? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &num);
	  if (num * 100000L*theoptions.difficulty > uptr->gold) {
	    ioobj.sstrcr("You cannot afford that many towers.");
	    ioobj.sstrcr("Please come back when you have the money to do so.");
	  } else {
	    uptr->gold -= num * 100000L*theoptions.difficulty;
	    cptr->towers += num;
	    sprintf(STR3, "Your castle now has %ld towers.", cptr->towers);
	    ioobj.sstrcr(STR3);
	  }
	}
	break;
      }
      ioobj.sstrcr("The engineer thanks you for your business.");
      get_castle_type(cptr, thestr, &thetype);
      cptr->castype = thetype;
    }
  }
  ioobj.sstrcr("You leave the building.");
  ioobj.waitcr();
}

void get_castles(Castle **castles)
{
  FILE *castlefile;
  Castle castle;
  char STR1[256];

  castlefile = NULL;
  sprintf(STR1, "%s/Castles", CONFDIR);
  castlefile = ioobj.bopen(STR1, "rb");
  if (castlefile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  while (!feof(castlefile)) {
    if (fread(&castle, sizeof(Castle), 1, castlefile) == 1)
   	 addcastle(castle, castles);
  }
  ioobj.bclose(castlefile);
}

void get_castle_type(Castle *cptr, char *s, long *thetype)
{
  if (cptr->wall < 20) {
    strcpy(s, "Outpost");
    *thetype = 0;
    return;
  }
  if (cptr->wall >= 20 && cptr->wall < 40) {
    strcpy(s, "Keep");
    *thetype = 1;
    return;
  }
  if (cptr->wall >= 40 && cptr->wall < 60) {
    if (cptr->moat > 0 && cptr->towers > 1) {
      strcpy(s, "Stronghold");
      *thetype = 2;
    } else {
      strcpy(s, "Keep");
      *thetype = 1;
    }
    return;
  }
  if (cptr->wall >= 60 && cptr->moat > 19 && cptr->towers > 2) {
    strcpy(s, "Fortress");
    *thetype = 3;
  } else {
    strcpy(s, "Stronghold");
    *thetype = 2;
  }
}

void give_castle(Castle **castles, long sec)
{
  Player *gptr;
  boolean done;
  Castle castle, *cptr;
  long tmp;
  char STR2[256];


  if ((sec != 0) & find_castle_in_sector(sec, &cptr))
    sec = 0;
  if (!find_player_by_name(playername, &gptr))
    ioobj.sstrcr("Player not found in give castle");
  if (sec == 0) {
    tmp = gptr->sector;
    while (find_castle_in_sector(tmp, &cptr) || find_teleporter_in_sector(tmp)) {
      tmp = abs(rand() % (boardsize - 1)) + 1;
    }
  } else
    tmp = sec;
  castle.sector = tmp;
  gptr->sector = tmp;
  done = false;
  while (!done) {
    ioobj.sstrcr("Please enter a name for your castle.");
    ioobj.sstrcr("       1-------10--------20--------30");
    ioobj.sstr("Castle |");
      strcpy(castle.name,"");
    ioobj.gstr(castle.name, 31L);
    if (strlen(castle.name) < 3)
      done = false;
    else
      done = true;
    if (find_castle_by_n(castle.alias,&cptr))
    {
         ioobj.sstrcr("I'm sorry, but that name is already taken.");
         ioobj.sstrcr("Please choose another name.");
	 done = false;
	 continue;
    }
    strcpy(castle.alias, gptr->alias);
    castle.defend = 1;
    strcpy(castle.oldowner, "none");
    castle.attacked = false;
    castle.oil = 0;
    castle.wall = 10;
    castle.moat = 0;
    castle.castype = 0;
    castle.towers = 0;
    castle.newgold = 0;
    castle.alliance = gptr->alliance;
    castle.armor = gptr->armor;
    castle.weapon = gptr->weapon;
    strcpy(castle.attackedby, "none");
    if (tmp != sec && done) {
      sprintf(STR2, "Your new castle is in sector %ld",  tmp);
      ioobj.sstrcr(STR2);
    }
  }
  ioobj.waitcr();
  addcastle(castle, castles);
}

void major_castles(long number, Castle *castle)
{
  switch (number) {

  case 1:
    strcpy(castle->name, "Thrag");
    strcpy(castle->alias, "Sagoth");
    break;

  case 2:
    strcpy(castle->name, "Trion-Magra");
    strcpy(castle->alias, "Montak");
    break;

  case 3:
    strcpy(castle->name, "Esiron");
    strcpy(castle->alias, "Kimron");
    break;

  case 4:
    strcpy(castle->name, "Prokion");
    strcpy(castle->alias, "Mag");
    break;

  case 5:
    strcpy(castle->name, "Dagra-Meth");
    strcpy(castle->alias, "Trione");
    break;

  case 6:
    strcpy(castle->name, "Thagma-Dagron");
    strcpy(castle->alias, "Magta");
    break;

  case 7:
    strcpy(castle->name, "Tormor-Re");
    strcpy(castle->alias, "Bigna");
    break;

  case 8:
    strcpy(castle->name, "Iontis");
    strcpy(castle->alias, "Mirnon");
    break;

  case 9:
    strcpy(castle->name, "Threusis");
    strcpy(castle->alias, "Nom");
    break;

  case 10:
    strcpy(castle->name, "Drakus-Trag");
    strcpy(castle->alias, "Kor");
    break;

  case 11:
    strcpy(castle->name, "Flyion-Mitro");
    strcpy(castle->alias, "Rapyn");
    break;

  case 12:
    strcpy(castle->name, "Sanctuary");
    strcpy(castle->alias, "Bytha");
    break;

  case 13:
    strcpy(castle->name, "Hol");
    strcpy(castle->alias, "Dion");
    break;

  case 14:
    strcpy(castle->name, "Nekus");
    strcpy(castle->alias, "Dagra");
    break;

  case 15:
    strcpy(castle->name, "Rockma-Flon");
    strcpy(castle->alias, "Figon");
    break;

  case 16:
    strcpy(castle->name, "Bakra-Dur");
    strcpy(castle->alias, "Tyoona");
    break;
  }
}

void move_em(Castle **castles, boolean watch)
{
  long tmp;
  Castle *gptr, *trptr;

  gptr = *castles;
  if (watch)
	  ioobj.sstrcr("Moving Castles..");
  while (gptr != NULL) {
    if (gptr->alliance == 100) {
      tmp = abs(rand() % boardsize) + 1;
      while (find_castle_in_sector(tmp, &trptr)) {
	tmp = abs(rand() % (boardsize - 1)) + 1;
      }
      gptr->sector = tmp;
    }
    gptr = gptr->next;
  }
}


void target_castles(long number, Castle *castle)
{
  switch (number) {

  case 1:
    strcpy(castle->name, "Bizelle");
    strcpy(castle->alias, "The Keepers");
    break;

  case 2:
    strcpy(castle->name, "Tratis");
    strcpy(castle->alias, "The Keepers");
    break;

  case 3:
    strcpy(castle->name, "Mermae");
    strcpy(castle->alias, "The Keepers");
    break;

  case 4:
    strcpy(castle->name, "Mirpeon");
    strcpy(castle->alias, "The Keepers");
    break;

  case 5:
    strcpy(castle->name, "Piraen");
    strcpy(castle->alias, "The Keepers");
    break;

  case 6:
    strcpy(castle->name, "Neomat");
    strcpy(castle->alias, "The Keepers");
    break;

  case 7:
    strcpy(castle->name, "Ariton");
    strcpy(castle->alias, "The Keepers");
    break;

  case 8:
    strcpy(castle->name, "Neto");
    strcpy(castle->alias, "The Keepers");
    break;

  case 9:
    strcpy(castle->name, "Pato");
    strcpy(castle->alias, "The Keepers");
    break;

  case 10:
    strcpy(castle->name, "Oen");
    strcpy(castle->alias, "The Keepers");
    break;

  case 11:
    strcpy(castle->name, "Talis");
    strcpy(castle->alias, "The Keepers");
    break;

  case 12:
    strcpy(castle->name, "Sman");
    strcpy(castle->alias, "The Keepers");
    break;

  case 13:
    strcpy(castle->name, "Terid");
    strcpy(castle->alias, "The Keepers");
    break;

  case 14:
    strcpy(castle->name, "Kia");
    strcpy(castle->alias, "The Keepers");
    break;

  case 15:
    strcpy(castle->name, "Feomin");
    strcpy(castle->alias, "The Keepers");
    break;

  case 16:
    strcpy(castle->name, "Bizelle");
    strcpy(castle->alias, "The Keepers");
    break;
  }
}

void take_men(void)
{
  long tl, warriors;
  char s[256];
  long max;
  boolean done;
  Player *uptr;
  Castle *cptr;
  long thetype;
  char STR2[256];

  if (!find_castle_in_sector(currentsector, &cptr))
    return;
  if (!find_player_by_name(playername, &uptr))
    return;
  if (strcmp(uptr->alias, cptr->alias)) {
   ioobj.sstrcr("You do not own this castle. ");
   ioobj.sstrcr("You may not take troops that are not yours. ");
    ioobj.cr();
    ioobj.waitcr();
    return;
  }
  done = false;
  while (!done) {
    ioobj.clear_scr();
    sprintf(STR2, "You have %ld warriors in your army.", uptr->armysize);
    ioobj.sstrcr(STR2);
    ioobj.cr();
    sprintf(STR2, "Your castle has %ld warriors defending it.", cptr->defend);
    ioobj.sstrcr(STR2);
    get_castle_type(cptr, s, &thetype);
    cptr->castype = thetype;
    switch (thetype) {

    case 0:
      max = 20000*theoptions.difficulty;
      break;

    case 1:
      max = 50000L*theoptions.difficulty;
      break;

    case 2:
      max = 80000L*theoptions.difficulty;
      break;

    case 3:
      max = 100000L*theoptions.difficulty;
      break;
    }
    ioobj.cr();
    sprintf(STR2, "Your castle can hold %ld warriors.", max);
    ioobj.sstrcr(STR2);
    ioobj.cr();
    ioobj.sstr("Would you like to take or leave warriors? (t/l) ");
    strcpy(s,"");
    ioobj.gstr(s, 1L);
    if (uncase(s[0]) == 't')
      tl = -1;
    else if (uncase(s[0]) == 'l')
      tl = 1;
    else 
    {
	ioobj.waitcr();
	return;
    }
    ioobj.sstr("Number of warriors? ");
    strcpy(s,"");
    ioobj.gstr(s, 9L);
    stringtonum(s, &warriors);
    if (tl <= 0) {
      if (cptr->defend < warriors)
	ioobj.sstrcr("There aren't that many warriors in the castle.  Try again. ");
      else {
	done = true;
	cptr->defend -= warriors;
	uptr->armysize += warriors;
      }
    } else if (uptr->armysize < warriors)
     ioobj.sstrcr("There aren't that many warriors in your army.  Try again.");
    else if (warriors + cptr->defend > max) {
      done = true;
     ioobj.sstrcr("Your castle can not hold that many.");
     ioobj.sstrcr("The maximum has been assigned to the castle.");
     ioobj.sstrcr("For a castle to hold more warriors, it must be a larger type.");
      uptr->armysize -= max - cptr->defend;
      cptr->defend += max - cptr->defend;
    } else {
      done = true;
      uptr->armysize -= warriors;
      cptr->defend += warriors;
    }
    ioobj.waitcr();
  }
}

#endif // _CASTLE_C_
