/* From iioobj.gstr file "loadsave.pas" */

#ifndef _LOAD_C_
#define _LOAD_C_


#include "bf.h"

void check_for_battlefield()
{

//  if (!reg) {
    if (1) {
    rowlength = 27;
    territorysize = 3;
    boardsize = 729;
  } else {
    territorysize = 10;
    rowlength = 100;
    boardsize = 10000;
  }
  /* check for battlefield file */
  create_battlefield();
  /* create princes */
  rollrogues();
  /* create castles */
  add_target_castles();
  /* create villages */
  create_villages();
  /* create alliances if necessary */
  create_alliances();
  /* create teleporters */
  create_teleporters();
  /* create messages */
  create_messages();
  /* create armies */
  create_armies();
}  /*procedure*/

void exit_game(int retval)
{
	ioobj.term_mode(0);	/* return to non-blocking */
	exit(retval);
}

void get_sectors(sectorrec *sectors)
{
  FILE *infile;
  sectorrec sector;
  char STR1[256];
  int x;


  infile = NULL;
  sprintf(STR1, "%s/Sectors", CONFDIR);
  infile = ioobj.bopen(STR1, "rb");
  if (infile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  x = 0;
  while (!feof(infile)) {
    if (fread(&sector, sizeof(sectorrec), 1, infile) == 1)
    {
	    if (x < MAX_SECTOR + KEEPERS)
		    memcpy(&sectors[x++],&sector,sizeof(sectorrec));
    	    if (x > MAX_SECTOR + KEEPERS)
	    {
	    	ioobj.ap_log("bf: Too many sectors in sector file.");
	    }
    }
  }
  ioobj.bclose(infile);
}

void get_teleporters(telerec **teleporters)
{
  FILE *infile;
  telerec *gptr, telrec;
  char STR1[256];


  infile = NULL;
  sprintf(STR1, "%s/Teleporters", CONFDIR);
  infile = ioobj.bopen(STR1, "rb");
  if (infile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  while (!feof(infile)) {
    if (fread(&telrec, sizeof(telerec), 1, infile) == 1)
    {
	    gptr = (telerec *)malloc(sizeof(telerec));
	    gptr->sector = telrec.sector;
	    gptr->next = *teleporters;
	    *teleporters = gptr;
    }
  }
  ioobj.bclose(infile);
  chmod(STR1,0775);
}

void read_options(void)
{
  FILE *infile;
  char s[256];

  infile = NULL;
  sprintf(s, "%s/Battlefield Options",CONFDIR);
  infile = ioobj.bopen(s, "r");
  if (infile == NULL)
  {
        perror(s);
	exit_game(1);
  }
  fscanf(infile,"%d\n",&theoptions.timelimit);
  fscanf(infile,"%d\n",&theoptions.entries);
  fscanf(infile,"%d\n",&theoptions.messagelimit);
  fscanf(infile,"%d\n",&theoptions.daystorun);
  fscanf(infile,"%d\n",&theoptions.daysingame);
  fscanf(infile,"%d\n",&theoptions.firstime);  // firstime -- first entry
  fscanf(infile,"%d\n",&theoptions.difficulty);
  fscanf(infile,"%d\n",&theoptions.scores);
  fscanf(infile,"%s\n",theoptions.scorespath);
  fscanf(infile,"%d\n",&theoptions.sysopacl);
  fscanf(infile,"%ld\n",&theoptions.date);
  ioobj.bclose(infile);
  chmod(s,0775);
}


void reset_game(boolean win, boolean kind)
{
  FILE *outfile;
  time_t now;
  char datestr[256], s[256];
  int x;
  Player *player, *uptr;
  char STR1[256];
  char filenames[8][20] = {"Alliances","Armies","Castles","Princes","Scrolls","Sectors","Teleporters","Villages"};

  outfile = NULL;
  if (win) {
      sprintf(STR1, "%s/Battlefield Victories", CONFDIR);
      outfile = ioobj.bopen(STR1, "w");
    if (outfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
    if (!find_player_by_name(playername, &uptr))
      ioobj.sstrcr("Unable to find player!");
    time(&now);
    strcpy(datestr,ctime(&now));
    if (kind) {
      fprintf(outfile, "The winner on %s", datestr);
      fprintf(outfile, " was: \n");
      fprintf(outfile, "     %s  a.k.a. %s\n",
	      uptr->alias, uptr->name);
      fprintf(outfile, "Who won the game by himself.  Congratulations to %s\n",
	      uptr->name);
      fprintf(outfile,"who is the new King of Thaniphir!");
      putc('\n', outfile);
    } else {
      if (uptr->alliance == 0) {
	fprintf(outfile, "The winner on %s", s);
	fprintf(outfile, " was: \n");
	fprintf(outfile, "     %s  a.k.a. %s\n",
		uptr->alias,  uptr->name);
	fprintf(outfile,
		"Who won the game by himself.  Congratulations to %s\n",
		uptr->name);
        fprintf(outfile,"who is the new King of Thaniphir!");
	putc('\n', outfile);
      } else {
	player = players;
	fprintf(outfile, "The winners on %s", s);
	fprintf(outfile, " were: \n");
	fprintf(outfile, "the alliance of %s\n\n", uptr->alliancename);
	while (player != NULL) {
	  if (player->alliance == uptr->alliance)
	    fprintf(outfile, "     %s  a.k.a. %s\n\n",
		    player->alias, player->name);
	  player = player->next;
	}
	fprintf(outfile, "Congratulations to %s\n", uptr->alliancename);
	fprintf(outfile, "They are the new rulers of the Thaniphir\n");
      }
    }
    ioobj.sstrcr("Congratulations!  You are now the new King of Thaniphir!");
    ioobj.waitcr();
    ioobj.bclose(outfile);
    sprintf(STR1, "%s/Battlefield Victories", CONFDIR);
    chmod(STR1,0775);
  }
  theoptions.daystorun = theoptions.daysingame;
  remove_busy();
  save_options();
  // now delete all of the game files
  for(x=0; x<8; x++)
  {
  	sprintf(STR1,"%s/%s",CONFDIR,filenames[x]);
  	unlink(STR1);
  }
  exit_game(0);
}


void save_options()
{
  FILE *infile;
  char s[255];

  infile = NULL;
  sprintf(s, "%s/Battlefield Options",CONFDIR);
  infile = ioobj.bopen(s, "w");
  if (infile == NULL)
  {
        perror(s);
	exit_game(1);
  }
  fprintf(infile,"%d\n",theoptions.timelimit);
  fprintf(infile,"%d\n",theoptions.entries);
  fprintf(infile,"%d\n",theoptions.messagelimit);
  fprintf(infile,"%d\n",theoptions.daystorun);
  fprintf(infile,"%d\n",theoptions.daysingame);
  fprintf(infile,"%d\n",theoptions.firstime);  // firstime -- first entry
  fprintf(infile,"%d\n",theoptions.difficulty);
  fprintf(infile,"%d\n",theoptions.scores);
  fprintf(infile,"%s\n",theoptions.scorespath);
  fprintf(infile,"%d\n",theoptions.sysopacl);
  fprintf(infile,"%ld\n",theoptions.date);
  ioobj.bclose(infile);
  chmod(s,0775);
}

void save_game(void)
{
  Player *uptr1, *uptr2;
  Castle *cptr1, *cptr2;
  alliancerec *aptr1, *aptr2;
  Village *vptr1, *vptr2;
  Army *arptr1, *arptr2;
  telerec *telptr1, *telptr2;
  bfMessage *mptr1, *mptr2;
  long now;
  FILE *playerfile;
  FILE *castlefile;
  FILE *allfile;
  FILE *mesfile;
  FILE *arfile;
  FILE *vilfile;
  FILE *telefile;
  char STR1[256];


  sprintf(STR1, "%s/Princes", CONFDIR);
  playerfile = ioobj.bopen(STR1, "wb");
  if (playerfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  uptr1 = players;
  while (uptr1 != NULL) {
    fwrite(uptr1, sizeof(Player), 1, playerfile);
    uptr2 = uptr1;
    uptr1 = uptr1->next;
    free(uptr2);
  }
  ioobj.bclose(playerfile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Castles", CONFDIR);
  castlefile = ioobj.bopen(STR1, "wb");
  if (castlefile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  cptr2 = castles;
  while (cptr2 != NULL) {
    fwrite(cptr2, sizeof(Castle), 1, castlefile);
    cptr1 = cptr2;
    cptr2 = cptr2->next;
    free(cptr1);
  }
  ioobj.bclose(castlefile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Alliances", CONFDIR);
  allfile = ioobj.bopen(STR1, "wb");
  if (allfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  aptr2 = alliances;
  while (aptr2 != NULL) {
    fwrite(aptr2, sizeof(alliancerec), 1, allfile);
    aptr1 = aptr2;
    aptr2 = aptr2->next;
    free(aptr1);
  }
  ioobj.bclose(allfile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Armies", CONFDIR);
  arfile = ioobj.bopen(STR1, "wb");
  if (arfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  arptr2 = armies;
  while (arptr2 != NULL) {
    fwrite(arptr2, sizeof(Army), 1, arfile);
    arptr1 = arptr2;
    arptr2 = arptr2->next;
    free(arptr1);
  }
  ioobj.bclose(arfile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Villages", CONFDIR);
  vilfile = ioobj.bopen(STR1, "wb");
  if (vilfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  vptr1 = villages;
  while (vptr1 != NULL) {
    fwrite(vptr1, sizeof(Village), 1, vilfile);
    vptr2 = vptr1;
    vptr1 = vptr1->next;
    free(vptr2);
  }
  ioobj.bclose(vilfile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Teleporters", CONFDIR);
  telefile = ioobj.bopen(STR1, "wb");
  if (telefile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  telptr1 = teleporters;
  while (telptr1 != NULL) {
    telptr1->sector = abs(rand() % boardsize) + 1;
    fwrite(telptr1, sizeof(telerec), 1, telefile);
    telptr2 = telptr1;
    telptr1 = telptr1->next;
    free(telptr2);
  }
  ioobj.bclose(telefile);
  chmod(STR1,0775);
  sprintf(STR1, "%s/Scrolls", CONFDIR);
  mesfile = ioobj.bopen(STR1, "wb");
  if (mesfile == NULL)
    {
	perror(STR1);
	exit_game(1);
    }
  time(&now);
  mptr1 = scrolls;
  while (mptr1 != NULL) {
    if ((now - mptr1->day) / 86400L < theoptions.messagelimit && !mptr1->deleted)
      fwrite(mptr1, sizeof(bfMessage), 1, mesfile);
    mptr2 = mptr1;
    mptr1 = mptr1->next;
    free(mptr2);
  }
  ioobj.bclose(mesfile);
  chmod(STR1,0775);
}


void dispose_storage(void)
{
  Player *uptr1, *uptr2;
  Castle *cptr1, *cptr2;
  alliancerec *aptr1, *aptr2;
  Army *arptr1, *arptr2;
  Village *vptr1, *vptr2;
  telerec *telptr1, *telptr2;



  uptr1 = players;
  while (uptr1 != NULL) {
    uptr2 = uptr1;
    uptr1 = uptr1->next;
    free(uptr2);
  }
  cptr2 = castles;
  while (cptr2 != NULL) {
    cptr1 = cptr2;
    cptr2 = cptr2->next;
    free(cptr1);
  }
  aptr2 = alliances;
  while (aptr2 != NULL) {
    aptr1 = aptr2;
    aptr2 = aptr2->next;
    free(aptr1);
  }
  arptr2 = armies;
  while (arptr2 != NULL) {
    arptr1 = arptr2;
    arptr2 = arptr2->next;
    free(arptr1);
  }
  vptr1 = villages;
  while (vptr1 != NULL) {
    vptr2 = vptr1;
    vptr1 = vptr1->next;
    free(vptr2);
  }
  telptr1 = teleporters;
  while (telptr1 != NULL) {
    telptr2 = telptr1;
    telptr1 = telptr1->next;
    free(telptr2);
  }
}


#endif _LOAD_C_
