/* From iioobj.gstr file "messages.pas" */


#ifndef _MESSAGES_C_
#define _MESSAGES_C_

#include "bf.h"

void add_message(bfMessage **scrolls, bfMessage mes)
{
  bfMessage *mptr;

  mptr = (bfMessage *)malloc(sizeof(bfMessage));
  strcpy(mptr->message, mes.message);
  strcpy(mptr->fromwho, mes.fromwho);
  strcpy(mptr->towho, mes.towho);
  mptr->day = mes.day;
  mptr->mesnum = mes.mesnum;
  mptr->alliance = mes.alliance;
  mptr->deleted = false;
  mptr->broadcast = mes.broadcast;
  mptr->next = *scrolls;
  *scrolls = mptr;
}


void check_for_messages(Player *player)
{
  long highest;
  char *c;
  bfMessage *mptr;
  char STR2[256];

  mptr = scrolls;
  highest = 0;
  while (mptr != NULL) {
    if ((!strcmp(mptr->towho, player->alias) ||
	 mptr->alliance == player->alliance ||
	 mptr->broadcast) && mptr->mesnum > player->himsg) {
      sprintf(STR2, "Sire, you have a message from %s", mptr->fromwho);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("You open the wax seal on the scroll..");
      ioobj.sstrcr("The scroll says: ");
      ioobj.cr();
      sprintf(STR2, "To: %s", mptr->towho);
      ioobj.sstrcr(STR2);
      ioobj.cr();
      c = mptr->message;
      while (*c != 0) {
	ioobj.sch(*c);
	if ((c - mptr->message) % 78 == 0 && c != mptr->message)
	{
      		ioobj.cr();
	}
	c++;
      }
      ioobj.cr();
      ioobj.waitcr();
    }
    if (mptr->mesnum > highest)
      highest = mptr->mesnum;
    mptr = mptr->next;
  }
  player->himsg = highest;
}


void create_messages(void)
{

  char STR1[256];
  struct stat buf;
  FILE *mesfile;
  bfMessage mes;

  // create a dummy message welcoming everybody to the game
  strcpy(mes.message,"Welcome to BattleField!");
  strcpy(mes.fromwho, "The Game");
  strcpy(mes.towho, "all");
  time(&mes.day);
  mes.mesnum = 1;
  mes.alliance = -1;
  mes.deleted = false;
  mes.broadcast = true;
  mesfile = NULL;
  sprintf(STR1, "%s/Scrolls", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating message base..");
	  sprintf(STR1, "%s/Scrolls", CONFDIR);
	  mesfile = ioobj.bopen(STR1, "wb");
	  if (mesfile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  fwrite(&mes, sizeof(bfMessage), 1, mesfile);
	  ioobj.bclose(mesfile);
	  chmod(STR1,0775);
  }
}

void findhighnum(bfMessage *scrolls, long *highnum)
{
  bfMessage *mptr;

  *highnum = 1;
  mptr = scrolls;
  if (mptr == NULL)
    *highnum = 1;
  else {
    while (mptr != NULL) {
      if (mptr->mesnum > *highnum)
	*highnum = mptr->mesnum;
      mptr = mptr->next;
    }
  }
  *highnum = labs(*highnum);
}

void get_messages(bfMessage **scrolls)
{
  bfMessage mes;
  FILE *mesfile;
  char STR1[256];

  sprintf(STR1, "%s/Scrolls", CONFDIR);
  mesfile = ioobj.bopen(STR1, "rb");
  if (mesfile == NULL)
  { 
	perror(STR1);
	exit_game(1);
  }
  if (!feof(mesfile)) {
    while (!feof(mesfile)) {
      if (fread(&mes, sizeof(bfMessage), 1, mesfile) == 1)
	      add_message(scrolls, mes);
    }
  }
  ioobj.bclose(mesfile);
  mesfile = NULL;
}  

void scribes_guild(bfMessage **scrolls, Player **uptr, boolean town)
{
  char c[256];
  bfMessage mes;
  Player *uptr2;
  alliancerec *aptr;
  boolean exit;
  long num;
  boolean done;
  long datetoday;
  char STR1[256];

  ioobj.clear_scr();
  exit = false;
  if (town) {
    ioobj.sstrcr("You walk into a small building with a scroll on the");
    ioobj.sstrcr("sign above the door.  Inside, there are many desks with");
    ioobj.sstrcr("scribes working dilligently to copy scrolls.");
    ioobj.sstrcr("Upon walking up to the counter, a small man says to you: ");
    ioobj.sstrcr("Welcome to the Scribe's Inn.  We are the messengers");
    ioobj.sstrcr("of  Thaniphir.  Here is our price list.");
    ioobj.sstrcr("1.  Personal scrolls                             10gp.");
    ioobj.sstrcr("2.  Alliance scrolls                            100gp.");
    ioobj.sstrcr("3.  Kindom-wide scrolls                         200gp.");
    ioobj.sstr("Your choice, milord? ");
    strcpy(c,"");
    ioobj.gstr(c, 1L);
    if (c[0] == '1') {
      if ((*uptr)->gold < 10) {
	ioobj.sstrcr("Milord!  You do not have the gold to pay for ");
	ioobj.sstrcr("Our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 10;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.alliance = -1;
	  mes.broadcast = false;
	  ioobj.sstrcr("Enter \"x\" to exit.");
	  ioobj.sstr("Who would you like this message sent to? ");
	strcpy(c,"");
	  ioobj.gstr(c, 31L);
	  sprintf(c, "%.30s", strcpy(STR1, c));
	  if (!find_player_by_alias(c, &uptr2)) {
	    if (uncase(c[0]) == 'x') {
	      done = true;
	      exit = true;
	    }
	    else
		    ioobj.sstrcr("There is no royalty by that name.");
	    ioobj.waitcr();
	    continue;
	  }
	  if (exit)
	    continue;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  strcpy(mes.towho, c);
	  ioobj.sstrcr("An apprentice runs up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    } else if (c[0] == '2') {
      if ((*uptr)->gold < 100) {
	ioobj.sstrcr("Milord!  You do not have the gold to pay for ");
	ioobj.sstrcr("our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 100;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.broadcast = false;
	  ioobj.sstrcr("Enter \"x\" to exit.");
	  ioobj.sstr("Who would you like this message sent to? ");
	strcpy(c,"");
	  ioobj.gstr(c, 31L);
	  if (!findalliance(c, &aptr)) {
	    if (uncase(c[0]) == 'x') {
	      done = true;
	      exit = true;
	    }
	    else
		    ioobj.sstrcr("There is no alliance by that name.");
	    ioobj.waitcr();
	    continue;
	  }
	  if (exit)
	    continue;
	  mes.alliance = aptr->num;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  sprintf(mes.towho, "%.30s", c);
	  ioobj.sstrcr("An apprentice runs up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    } else if (c[0] == '3') {
      if ((*uptr)->gold < 200) {
	ioobj.sstrcr("Milord!  you do not have the gold to pay for ");
	ioobj.sstrcr("Our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 200;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.broadcast = true;
	  strcpy(c, "all");
	  mes.alliance = -1;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  sprintf(mes.towho, "%.30s", c);
	  ioobj.sstrcr("An apprentice runs up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    }
  } else {
    ioobj.sstrcr("You walk into a large building with a scroll made of gold");
    ioobj.sstrcr("leaf above the door.  Inside, there are many opulent desks with");
    ioobj.sstrcr("master scribes working dilligently to copy scrolls.");
    ioobj.sstrcr("When you walk up to the counter, a fat man says: ");
    ioobj.sstrcr("Welcome to the scribe's emporium.  We are the messengers");
    ioobj.sstrcr("of  Thaniphir.  Here is our price list.");
    ioobj.sstrcr("1.  Personal scrolls                             20gp.");
    ioobj.sstrcr("2.  Alliance scrolls                            200gp.");
    ioobj.sstrcr("3.  Kindom-wide scrolls                         400gp.");
    ioobj.sstr("Your choice, milord? ");
	strcpy(c,"");
    ioobj.gstr(c, 1L);
    if (c[0] == '1') {
      if ((*uptr)->gold < 20) {
	ioobj.sstrcr("Milord!  You do not have the gold to pay for ");
	ioobj.sstrcr("our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 20;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.alliance = -1;
	  mes.broadcast = false;
	  ioobj.sstrcr("Enter \"x\" to exit.");
	  ioobj.sstr("Who would you like this message sent to? ");
	strcpy(c,"");
	  ioobj.gstr(c, 31L);
	  if (!find_player_by_alias(c, &uptr2)) {
	    if (uncase(c[0]) == 'x') {
	      done = true;
	      exit = true;
	    }
	    else
		    ioobj.sstrcr("There is no royalty by that name.");
	    ioobj.waitcr();
	    continue;
	  }
	  if (exit)
	    continue;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  strcpy(mes.towho, c);
	  ioobj.sstrcr("A master scribe saunters up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    } else if (c[0] == '2') {
      if ((*uptr)->gold < 200) {
	ioobj.sstrcr("Milord!  You do not have the gold to pay for ");
	ioobj.sstrcr("our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 200;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.broadcast = false;
	  ioobj.sstrcr("Enter \"x\" to exit.");
	  ioobj.sstr("Who would you like this message sent to? ");
	strcpy(c,"");
	  ioobj.gstr(c, 31L);
	  if (!findalliance(c, &aptr)) {
	    if (uncase(c[0]) == 'x') {
	      done = true;
	      exit = true;
	    }
	    else
		    ioobj.sstrcr("There is no alliance by that name.");
	    ioobj.waitcr();
	    continue;
	  }
	  if (exit)
	    continue;
	  mes.alliance = aptr->num;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  sprintf(mes.towho, "%.30s", c);
	  ioobj.sstrcr("A master scribe saunters up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    } else if (c[0] == '3') {
      if ((*uptr)->gold < 400) {
	ioobj.sstrcr("Milord!  You do not have the gold to pay for ");
	ioobj.sstrcr("our services.  Please come back when you have money.");
	exit = true;
      } else {
	(*uptr)->gold -= 400;
	done = false;
	while (!done) {
	  time(&datetoday);
	  mes.day = datetoday;
	  findhighnum(*scrolls, &num);
	  mes.mesnum = num + 1;
	  mes.broadcast = true;
	  strcpy(mes.towho, "all");
	  mes.alliance = -1;
	  strcpy(mes.fromwho, (*uptr)->alias);
	  ioobj.sstrcr("A master scribe saunters up to you with a stencil and a blank scroll.");
	  ioobj.sstrcr("He begins writing..");
	  ioobj.sstr(":");
	strcpy(c,"");
	  ioobj.gstr(c, 200L);
	  ioobj.sstrcr("He repeats back:");
	  ioobj.sstrcr(c);
	  ioobj.sstr("Is this what you want, sire?");
	  if (yesno())
	    done = true;
	  strcpy(mes.message, c);
	}
      }
    }
  }
  if (!exit)
    add_message(scrolls, mes);
}


#endif _MESSAGES_C_
