// Filename:   bbsint.C
// Contents:   the bbs interface object methods
// Author:     Greg Shaw
// Created:        7/12/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSINT_C_
#define _BBSINT_C_

#include "bbshdr.h"

#undef DEBUG

#ifdef ROCAT
// monitor connection object
extern moncon mon_obj;
#endif

// Method: constructor
// Purpose:    initialize all variables and attempt to connect to sysop process
// Input:  none
// Output: none
// Author: Greg Shaw
// Created:    7/12/93

bbsint::bbsint()
{

#ifdef ROCAT
//	if (!mon_obj.connected())
//		mon_obj.connect_mon();  // try to connect to monitor
#endif
	tcgetattr(0, &rbuf);        // get regular mode termio stuff
	term_mode(1);               // turn on nonblocking i/o
};


// Method: char_avail
// Purpose:    return true if a character is available (depending on port)
// Input:  who - 0 for IPC (from monitor) 1 for from user
//		wait -- how long to wait
// Output: 1 for character available, 0 for no char available
// Author: Greg Shaw
// Created:    7/12/93

int bbsint::char_avail(int who, int wait)
{
	struct fd_set fds;
	struct timeval waittime;

	waittime.tv_sec = 0;
	waittime.tv_usec = 100*wait;
	if (!who)                   // ipc.
	{
		return(0);	// ipc doesn't work at this point
		#ifdef DEBUG
		printf("ipc check\r\n");
		fflush(stdout);
		#endif
#ifdef ROCAT
//		if (mon_obj.connected())
//			return(mon_obj.msg_avail(0,0));
#endif
	}
	else                        // normal user
	{
		#ifdef DEBUG
		printf("serial check\r\n");
		fflush(stdout);
		#endif
		FD_ZERO(&fds);
		FD_SET(fileno(stdin), &fds);
		select(FD_SETSIZE,&fds,NULL,NULL,&waittime);
		return(FD_ISSET(fileno(stdin),&fds));
	}
	return(0);
}


// Method: cr
// Purpose:    send a carriage return to the user (and sysop if applicable)
// Input:  none
// Output: see purpose.
// Author: Greg Shaw
// Created:    7/12/93

void bbsint::cr(void)
{
	char crmsg[] = "\r\n";

#ifdef ROCAT
//	mon_obj.send_monitor(crmsg);
#endif 
	printf(crmsg);
};


// Method: gstr_starsecho
// Purpose:    get a string from the user with stars as echo
// Input:  maxlen - the maximum length of a string to enter
// Output: str - the string (as entered by user)
// Author: Greg Shaw
// Created:    4/10/95

int bbsint::gstr_starsecho(char *str, int maxlen)
{
	char tstr[255];
	char   c;
	int    offset;              // offset into string
	char   bsstr[] =            // backspace
	{
		0x8,0x20,0x8,0
	};
	char   ststr[] =            // star
	{
		0x8,'*',0
	};

	offset = 0;
	while (c = gch(1), !iseol(c))
	{
		if (c != 0)
		{
			if (c == '\b' || c == 0x7f)
			{
				if (offset > 0)
				{
					offset--;
					sstr(bsstr);
				}
				sstr(bsstr);
				sstr(bsstr);
			}
			else if (offset < maxlen)
			{
				tstr[offset++] = c;
				sstr(ststr);
			}
		}
	}
	tstr[offset] = 0;
	strcpy(str,tstr);
	return(0);
};


// Method: gstr
// Purpose:    get a string from the user
// Input:  maxlen - the maximum length of a string to enter
// Output: str - the string (as entered by user)
// Author: Greg Shaw
// Created:    7/12/93

int bbsint::gstr(char *str, int maxlen)
{
	char tstr[255];
	char   c;
	int    offset;              // offset into string
	char   bsstr[] =            // backspace
	{
		0x8,0x20,0x8,0
	};
	char   bestr[] =            // beep
	{
		0x7,0
	};

	strcpy(tstr,str);
	offset = strlen(tstr);
	sstr(tstr);
	while (c = gch(1), !iseol(c))
	{
		if (c != 0)
		{
			if (c == '\b' || c == 0x7f)
			{
				if (offset > 0)
				{
					offset--;
					sstr(bsstr);
				}
				sstr(bsstr);
				sstr(bsstr);
			}
			else if (offset < maxlen)
				tstr[offset++] = c;
			else
			{
				sstr(bsstr);
				sstr(bestr);
			}
		}
	}
	tstr[offset] = 0;
	strcpy(str,tstr);
	return(0);
};

// Method: gch
// Purpose:    get a character from the user/sysop (if available)
// Input:  none
// Output: a character, if available, or 0 if one not available
// Author: Greg Shaw
// Created:    7/12/93

char bbsint::gch(int wait)
{
	char   msg[255];            // room for message
	char   c;                   // room for message

	if (char_avail(0,wait))        // has monitor sent something to me?
	{
		return(0);
		#ifdef DEBUG
		printf("monitor avail\r\n");
		fflush(stdout);
		#endif
		// get message
#ifdef ROCAT
//		if (c = mon_obj.get_char(), c != -1)
//			return(c);
#endif
	} else
	if (char_avail(1,wait))        // something available at serial port?
	{
		#ifdef DEBUG
		printf("serial avail\r\n");
		fflush(stdout);
		#endif
		c = fgetc(stdin);
		if (c > 0)
		{
			msg[0] = c;
			msg[1] = 0;
#ifdef ROCAT
//			mon_obj.send_monitor(msg);
#endif
			return(c);
		}
	}
	return(0);
};


// Method: sch
// Purpose:    send a char to the user
// Input:  ch - character to send to user
// Output: (to user)
// Author: Greg Shaw
// Created:    7/12/93

void bbsint::sch(char ch)
{
	char newstr[2] = {ch,0};

#ifdef ROCAT
//	mon_obj.send_monitor(newstr);
#endif
	fwrite(newstr,2,1,stdout);
};


// Method: sstr
// Purpose:    send a string to the user
// Input:  str - the string to send
// Output: (to user)
// Author: Greg Shaw
// Created:    7/12/93

int bbsint::sstr(char *msg)
{
//	if (!mon_obj.connected())
//		mon_obj.connect_mon();  // try to connect (if not already connected)
//	mon_obj.send_monitor(msg);
	fwrite(msg,strlen(msg),1,stdout);
	fflush(stdout);
	return(0);
};


// Method: sstr
// Purpose:    send a string to the user
// Input:  str - the string to send
// Output: (to user)
// Author: Greg Shaw
// Created:    7/12/93

int bbsint::sstrcr(char *msg)
{

//	if (!mon_obj.connected())
//		mon_obj.connect_mon();  // try to connect (if not already connected)
//	mon_obj.send_monitor(msg);
	fwrite(msg,strlen(msg),1,stdout);
	cr();
	fflush(stdout);
	return(0);
};


// Method: sstr
// Purpose:    send a string to the user
// Input:  str - the string to send
// Output: (to user)
// Author: Greg Shaw
// Created:    7/12/93

int bbsint::sysopstrcr(char *msg)
{
//	char crmsg[] = {'\r','\n', 0};

#ifdef ROCAT
//	mon_obj.send_monitor(msg);
//	mon_obj.send_monitor(crmsg);
#endif
	return(0);
};


// Function:   term_mode
// Purpose:    set the terminal mode to timeout on a read
// Input:  none
// Output: none (terminal mode is changed)
// Author: Greg Shaw
// Created:    7/19/93

void bbsint::term_mode(int type)
{
	struct termios tbuf;

	if (!type)                  // go to regular mode
	{
		if (tstate != 0)
			tcsetattr(0, TCSANOW, &rbuf);
		tstate = 0;
	}
	else
	{
		if (tstate != 1)        // regular mode
		{
			tcgetattr(0, &tbuf);

			tbuf.c_cc[4] = 1;   /* VMIN */
			tbuf.c_cc[5] = 0;   /* VTIME */
			tbuf.c_lflag &= ~(ICANON);

			tcsetattr(0, TCSANOW, &tbuf);
		}
		tstate = 1;
	}
	return;
}


#endif                          // _BBSINT_C_







