// Filename:	filelock.h
// Contents:	the file locking object used by the bbs system to
//             automatically implement file locking everywhere.
// Author:	Greg Shaw
// Created:	7/24/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _FLOCK_H_
#define _FLOCK_H_

#include "bbshdr.h"             // include all headers

// Object:	filelock
// Purpose:	implement automatic file locking in the bbs
// Attributes:	none
// Methods:
// Notes:	This object will automatically do file locking on any
//		number of files.
// Author:	Greg Shaw
// Created:	7/24/93

class filelock:	public errlog   // inherited from errlog
{
	FILE *file_list[MAX_FILES]; // list of open files
	// set a file lock
	int	set_lock(char type, int fptr);
	int 	clear_lock(int fptr);       // clear all locks on file
	public:
		filelock();             // constructor
		~filelock();            // destructor
		// open a file
		FILE *bopen(char *path, char *mode);
	int	bclose(FILE *fptr);     // close a file
};


#endif                          // _FLOCK_H_







