// Filename:	msqldb.C
// Contents:	the msql database access object methods
// Author:	Greg Shaw
// Created:	2/14/96

#ifndef _MSQLDB_C_
#define _MSQLDB_C_

#include "bbshdr.h"

#ifdef USE_DATABASE

// single socket:
static int dbsock = 0;	// database socket
static int dbconnected = 0;	// are we connected?


// Function:    constructor
// Purpose:     initialize the database connectivity object
// Input:       none
// Output:      none
// Author:      Greg Shaw
// Created:     4/25/96

msqldb::msqldb()
{
	dbsock = 0;	// no sock yet
	dbconnected = 0;
}

// Function:    connect
// Purpose:     connect to the database and select the messages database
// Input:       dbname - the database to connect to
// Output:      0 for failure, 1 for success
// Author:      Greg Shaw
// Created:     3/6/96

int msqldb::connect(char *dbname)
{
        char tmpstr[255];

        if (!dbconnected)
        {
                // connect to database
                if (dbsock = dbopen(dbhost()), dbsock == -1)
                {
// no error if not using the database
#ifdef USE_DATABASE
                        sprintf(tmpstr,"Unable to connect to database on %s",dbhost());
                        ap_log(tmpstr);
#endif
                        return(0);
                }
                else
                        // now select the messages database itself
                        if (selectdb(dbsock,dbname) == -1)
                        {
                                sprintf(tmpstr,"Unable to connect to database %s: %s",dbname,dberror());
                                ap_log(tmpstr);
                        }
                        return(1);

        }
        return(0);
}

// Function:	dbclose
// Purpose:	close the connection to the database engine
// Input:	sock - the currently open socket
// Output:	none
// Author:	Greg Shaw
// Created:	2/14/96

void msqldb::dbclose(int sock)	// close connection
{
	msqlClose(sock);
}

// Function:	dataseek
// Purpose:	set the current row pointer to another record
// Input:	result - the result pointer for the query
//		pos - the position indicator (0..rows)
// Output:	none
// Author:	Greg Shaw
// Created:	2/14/96

void	 msqldb::dataseek(m_result *result, int pos)	// seek in query
{
	msqlDataSeek(result,pos);
}

// Function:	dberror
// Purpose:	return the error code for the database
// Input:	none
// Output:	a string with the database error message
// Author:	Greg Shaw
// Created:	2/14/96

char *msqldb::dberror(void)
{
	return(msqlErrMsg);
}

// Function:    disconnect
// Purpose:     disconnect to the database
// Input:       none
// Output:      0 for failure, 1 for success
// Author:      Greg Shaw
// Created:     3/6/96

void msqldb::disconnect(void)
{
        if (dbconnected)
                dbclose(dbsock);
}


// Function:	fetchfield
// Purpose:	return a single field of a row
// Input:	result - the result pointer for the query
// Output:	the field
// Author:	Greg Shaw
// Created:	2/14/96

m_field *msqldb::fetchfield(m_result *result)	// get field
{
	return(msqlFetchField(result));
}

// Function:	fetchrow
// Purpose:	return an entire row of a query
// Input:	result - the result pointer for the query
// Output:	the row pointer for the row
// Author:	Greg Shaw
// Created:	2/14/96

m_row	 msqldb::fetchrow(m_result *result)	// get row
{
	return(msqlFetchRow(result));	
}


// Function:	fieldseek
// Purpose:	set the field position to a particular field
// Input:	result - the result pointer for the query
//		pos - the position (0..fields-1)
// Output:	the field
// Author:	Greg Shaw
// Created:	2/14/96

void	 msqldb::fieldseek(m_result *result, int pos)	// seek in row
{
	msqlFieldSeek(result,pos);
}


// Function:	freeresult
// Purpose:	free the storage used by a previous query
// Input:	result - the result pointer for the query
// Output:	none
// Author:	Greg Shaw
// Created:	2/14/96

void msqldb::freeresult(m_result *result)	// free stored result
{
	msqlFreeResult(result);
}

// Function:	get_sock
// Purpose:	return the database connection socket
// Input:	sock - where to put the socket
// Output:	sock or 0 for no connection
// Author:	Greg Shaw
// Created:	5/25/96

int msqldb::get_sock(char *dbname)
{
	if (!dbconnected)
		connect(dbname);
	return(dbsock);
}

// Function:	listdbs
// Purpose:	return a list of the databases available
// Input:	sock - the database connection socket
// Output:	a result pointer
// Author:	Greg Shaw
// Created:	2/14/96

m_result *msqldb::listdbs(int sock)			// list databases
{
	return(msqlListDBs(sock));
}

// Function:	listtables
// Purpose:	return a list of the tables in the database
// Input:	result - the result pointer for the query
// Output:	the field
// Author:	Greg Shaw
// Created:	2/14/96

m_result *msqldb::listtables(int sock)		// list tables in database
{
	return(msqlListTables(sock));
}

// Function:	listfields
// Purpose:	return a list of the fields in a table
// Input:	sock - the database socket pointer
//		tablename - the table to examine
// Output:	a result pointer
// Author:	Greg Shaw
// Created:	2/14/96

m_result *msqldb::listfields(int sock, char *tablename)	// list fields
{
	return(msqlListFields(sock,tablename));
}

// Function:	numfields 
// Purpose:	return the number of fields selected in query
// Input:	result - the result pointer for the query
// Output:	see above
// Author:	Greg Shaw
// Created:	2/14/96

int	 msqldb::numfields(m_result *result)	// number of fields selected
{
	return(msqlNumFields(result));
}


// Function:	numrows 
// Purpose:	return the number of rows selected in query
// Input:	result - the result pointer for the query
// Output:	see above
// Author:	Greg Shaw
// Created:	2/14/96

int	 msqldb::numrows(m_result *result)	// number of rows selected
{
	return(msqlNumRows(result));
}


// Function:	dbopen
// Purpose:	open a connection to the database engine
// Input:	host - the host running the msql database
// Output:	returns any errors found
// Author:	Greg Shaw
// Created:	2/14/96

int msqldb::dbopen(char *host)	// open connection to database engine
{
	return(msqlConnect(host));
}

// Function:	query
// Purpose:	send a query to the database
// Input:	sock - the socket connect to the database engine
//		query - the text of the SQL query
// Output:	returns any errors found
// Author:	Greg Shaw
// Created:	2/14/96

int	 msqldb::query(int sock, char *query)	// send query to database
{
	return(msqlQuery(sock,query));
}

// Function:	rows
// Purpose:	return the number of rows returned in previous query
// Input:	result - the result pointer for the query
// Output:	see above
// Author:	Greg Shaw
// Created:	2/14/96

int	 msqldb::rows(m_result *result)		// number of rows selected
{
	return(msqlNumRows(result));
}


// Function:	selectdb
// Purpose:	select a particular database
// Input:	sock - the socket connect to the database engine
//		dbname - the database name
// Output:	returns any errors found
// Author:	Greg Shaw
// Created:	2/14/96

int msqldb::selectdb(int sock, char *dbname)	// connect to database
{
	return(msqlSelectDB(sock,dbname));
}

// Function:	storeresult
// Purpose:	store the results of a query (so that more queries may
//		follow).
// Input:	none
// Output:	returns a result pointer
// Author:	Greg Shaw
// Created:	2/14/96

m_result *msqldb::storeresult(void)		// store result of query
{
	return(msqlStoreResult());
}

#endif // USE_DATABASE

#endif // _MSQLDB_C_
