// Filename:	msqllock.h
// Contents:	the object definition for the msql locking system
// Author:	Greg Shaw
// Created:	5/25/96

#ifndef _MSQLLOCK_H_
#define _MSQLLOCK_H_

#include "bbshdr.h"

// Table names within the database:
#define LOCK_TABLE_NAME		"lock"

// time to wait between lock attempts
#define LOCK_WAIT		3	// 3 seconds
#define TABLE_LOCK		-1	// lock entire table

// Structure:	MsgLock
// Contents:	the locking structure used within the database for coherancy
//		table_name - the name of the table being locked
//		record_id - the record id of the record being locked 
//			(-1 for entire table lock)
//		date - date of lock (unix format)
//		username - login name of user holding lock
// Author:	Greg Shaw
// Created:	2/14/96
// NOTE: 	this record isn't actually used

typedef	struct msglock
{
	char 	table_name[50];	// name of table
	int	record_id;	// record id of locked record
				// -1 for locked table
	int	date;		// date of lock
	char	username[11];	// user who holds lock
	struct	msglock *next;	// next msglock
} MsgLock;


// Object:	msqllock
// Purpose:	interface between msql and message system record format
// Attributes:	
// Methods:
// Author:	Greg Shaw
// Created:	2/14/96

class msqllock : public msqldb
{
	int 	dbsock;		// database socket
public:
	msqllock();		// constructor
	~msqllock();		// destructor

	int	clear_lock(char *table, int id); // clear a lock

	char	*get_lock_owner(char *table, int id); // get owner of existing lock

	int	lock_set(char *table, int id); // is a lock already set?

		// set a lock
	int	set_lock(char *table, int id, int date, char *username);
	
};






#endif // _MSQLLOCK_H_
