{ OCT 97 - Release Notes                                         }
{ Page sysop & Chat routine                                      }

(* ----------------------------------------------------------------------- *)
(* |                                                                     | *)
(* ----------------------------------------------------------------------- *)
Unit Page;

Interface

Uses  Dos, Crt, Data, Fossil, Display, CDrop, Dates, ErrorLog, Colours, Libs,
      WaitTix;

function PageSysop: Boolean;
procedure Chats;

implementation

{ Scroll BBS Screen Up One Line }
procedure ScrollUp;
begin
   Regs.AH := $06;
   Regs.AL := $01; { Lines To Scroll }
   Regs.BH := $00; { Colour Attribute For New Line / Black }
   Regs.CH := $01; { Top Row  / 1 }
   Regs.CL := $00; { Left Column / 0 }
   Regs.DH := $18; { Bottom Row / 25 }
   Regs.DL := $50; { Right Column / 80 }
   Intr($10, Regs);
end;


procedure ControlScreen(Flag : Byte);
Var
  X, Y : Integer;
begin
  Y := WhereY; { Store Current Cursor Posistions }
  X := WhereX;
  Case Flag of
    0 : begin { Increment Screen Up One }
          ScrollUp;
        end;
  end; { Case End }
end;

procedure Print(buffer : String);
Var
  Stringlen, Y : Integer;
begin
  Y := WhereY;
  If Local Then
     begin
      If (Buffer = Chr(10)) and (Y = 25) then ControlScreen(0)
       Else
         Disp(Buffer);
     end
  Else
     begin
       Stringlen := 0;
       StringLen := Length(Buffer);
       For Loop  := 1 to Stringlen do
          begin
            If not FCarrier then NoCarrier;
            SendFChar(Ord(Buffer[Loop])); { Introlisation String To Modem }
            If (Buffer[Loop] = Chr(10)) and (Y = 25) then
              begin
                ControlScreen(0);
              end
            Else
              begin
                AnsiChar(Ord(Buffer[Loop]));
             end;
          end;
      end;
end;

procedure LineFeed;
begin
  Print(Chr(13));
  Print(Chr(10));
end;

procedure LocalPrint(Buffer : String);
begin
  If Local = False then
    begin
      Local := True;
      Print(Buffer);
      Local := False;
    end
  Else
    begin
      Print(Buffer);
    end;
end;

function GetSec : word;
Var h,m,S,hu : Word;
begin
  GetTime(h,m,s,hu);
  GetSec := s;
end;

procedure Chats;
Var
  Buffer   : String;
  KeyIn    : Integer;
  Key      : Integer;
  Chat     : Boolean;
  ChatFile : Text;
begin
  Assign(ChatFile, 'CHAT.LOG');
  {$I-} Append(ChatFile); {$I+}
  If IOResult <> 0 then
    begin
      Rewrite(ChatFile);
      Writeln(ChatFile);
      Writeln(ChatFile,'CHAT LOG CREATED : ', Today);
      Writeln(ChatFile);
      Writeln(ChatFile,'------- CHAT TO ',UserInfo.UserName,' --------');
     end
  Else
    begin
      Writeln(ChatFile);
      Writeln(ChatFile,'------- CHAT TO ',UserInfo.UserName,' --------');
    end;
  LineFeed;
  Print('------- Sysop Online -------');
  LineFeed;
  LocalPrint('** Sysop Press F2 To End Chat **');
  LineFeed;
  Buffer := '';
  Key    := 0;
  Chat   := False;
  Repeat
    If Local Then
      begin
        KeyIn := Ord(ReadKey);
        Case Chr(KeyIn) of
          #0 : begin
                 Case ReadKey of
                   #60 : Chat := True;
                 end; { Case End }
               end;
        end; { Case End }
      end
      Else
        begin
          KeyIn := 0;
          If not FCarrier then
            begin
              NoCarrier;
            end
          Else
            If Keypressed then
              begin
                KeyIn := Ord(ReadKey);
                Case Chr(KeyIn) of
                  #0 : begin
                         Case ReadKey of
                           #60 : Chat := True;
                         end; { Case End }
                       end;
                end; { Case End }
              end
            Else
             begin
               If PeakFChar <> 0 Then  { Checks Port For Key Press }
                 begin
                   KeyIn := ReadFChar;
                 end;
             end;
          end;
        Case KeyIn of
        32..125 : begin
                    Print(Chr(KeyIn));
                    Write(ChatFile,Chr(KeyIn));
                   end;
                8 : begin
                     If Key > 0 then
                       begin
                         If Echo then
                           begin
                              Print(Chr(KeyIn));
                              Print(Chr($20));
                              Print(Chr(KeyIn));
                           end;
                         Delete(Buffer, Key, 1);
                         Dec(Key);
                      end;
                   end;
              13 : begin
                     LineFeed;
                     Writeln(ChatFile);
                   end;
       end; { Case End }
  Until Chat = True;
  If InputReady then PurgeInput;
  LineFeed;
  Print('---- Thanks For The Chat ----');
  Writeln(ChatFile,'------- CHAT FINISHED --------');
  LineFeed;
  Wait(100);
  Close(ChatFile);
end;

function ScrollLock: Boolean;
var
  KeyFlag : byte absolute $0040:$0017;
Begin
  if KeyFlag and $10 = 0 then
    begin
      ScrollLock := True;
    end
  else
    begin
      ScrollLock := False;
    end;
end;

function SysopOut: boolean;
Var
  GetLine  : Char;
  PFile    : Text;
  TextGrab,
  FileName,
  Path     : String;
begin
  if (ScrollLock) then { Check For Scroll Lock Pressed }
   begin
     SysopOut := True;
   end
  else
   begin
     SysopOut := False;
     LineCount :=0;
     TextGrab  := '';
     If BBSCfg.SysDir[Length(BBSCfg.SysDir)] = '\' then
       begin
         Path := BBSCfg.SysDir;
       end
     Else
       begin
         Path := BBSCfg.SysDir + '\';
       end;
     case(UserInfo.UserAnsi) of
           1 : FileName := Path + 'SYSOUT.ANS';
           2 : FileName := Path + 'SYSOUT.AVT';
        else   FileName := Path + 'SYSOUT.TXT';
     end; { Case end }
     Assign(PFile, FileName);
     {$I-} Reset(PFile); {$I+}
     If IOResult <> 0 then
       begin
         LogError('Unable To Open ' + FileName);
         Writeln(FileName,' File Not Found');
       end
     Else
      begin
        ClearDisplay;
        While not eof(PFile) do
         begin
           Read(PFile, GetLine);
            If Local then
               begin
                 Disp(Getline); { Display Local Only }
               end
            Else
               begin
                 If not FCarrier then
                   begin
                     NoCarrier;
                   end;
                  SendFChar(Ord(Getline)); { Send To Modem }
                end;
            end;
         Close(PFile);
       end;
   end;
end;

function PageSysop: Boolean;
Var
  Step, Steps : byte;
  Chat : Boolean;
begin
  PageSysop := False;
  if (sysopOut) then
   begin
     Chat := False;
     LineFeed;
     Print('Paging System Operater > ');
     for Steps := 0 to 5 do
        begin
          for Step :=0 to 3 do
            begin
              Sound(500);
              Print('.');
              Wait(3);
           end;
        Sound(600);
        Wait(5);
     end;
     Nosound;
     LineFeed;
     Print('Waiting For Answer...');
     LineFeed;
     Colour(FYellow);
     LocalPrint('**** Sysop Press Any Key To Chat ****');
     LineFeed;
     Repeat
      Step := GetSec;
    Until Step < 50;
    Repeat
     Steps := GetSec;
     If KeyPressed Then Chat := True;
    Until (Steps = Step + 5) or (Chat = True);
    If Chat then
     begin
       Chats;
     end
   Else
     begin
       LineFeed;
       LineFeed;
       Colour(FCyan);
       Print('Sorry, Unable To Contact Sysop.');
       LineFeed;
       Colour(FWhite);
       Print('Would You Like To Leave A E-Mail To ' + BBSCfg.SysopFirst + ' ' + BBSCfg.SysopSec + '? ');
       Colour(FYellow);
       Colour(BBlack);
       Response := ReadKB(2);
       if (Response = 'Y') then
        begin
          PageSysop := True;
        end;
     End;
  end
  else
   begin
     LineFeed;
     LineFeed;
     Colour(FWhite);
     Colour(BBlack);
     Print('Would You Like To Leave A E-Mail To ' + BBSCfg.SysopFirst + ' ' + BBSCfg.SysopSec + '? ');
     Colour(FYellow);
     Response := ReadKB(2);
     if (Response = 'Y') then
      begin
        PageSysop := True;
      end;
   end;
end;
end.
