(* Setup BBS v1.04 *)
(* (C) Simon Horton 1995 *)

{ OCT 97 - Release Notes                                         }
{ This is the configuration program for Sauron                   }
{ NOT FINISHED                                                   }

Program SetupBBS;

Uses Crt, Formed, Data, LIBS, Wins, ESU;

Type
  Page1 = Record
    rec1  : String[15]; { Sysop First Name }
    rec2  : String[15]; { Sysop Second Name }
    rec3  : String[30]; { BBS Name }
    rec4  : String[20]; { BBS Telephone }
    rec5  : Integer;    { Calls }
    rec5a : Byte;       { Node Number }
    rec5b : string[1];  { MultiNode   }
end;

Type
  Page2 = Record
    rec6   : Integer;    { NuLevel   }
    rec7,                { IdleTime  }
    rec8,                { MaxUsers  }
    rec9   : Word;       { MaxMsg    }
    rec10,               { LogFile   }
    rec11  : String[12]; { ErrFile   }
    rec12,               { SysDir    }
    rec13,               { ScriptDir }
    rec14,               { MenuDir   }
    rec15,               { BBSMailDir}
    rec16,               { MsgDir    }
    rec17,               { TempDir   }
    rec17a : String[30]; { NodeDir   }
end;

type
  Page3 = record
    rec18  : Integer;    { Com Port  }
    rec19  : LongInt;    { Baud Rate }
    rec20,
    rec21,
    rec22  : String[50]; { AT Strings     }
    rec22a : String[20]; { Answear String }
    rec23  : String[1];  { Lock Board     }
end;

type
  Page4 = record
    rec24,               { Level 1 Time Limit }
    rec25,               { Level 1 Call Limit }
    rec26,               { Level 2 Time Limit }
    rec27,               { Level 2 Call Limit }
    rec28,               { Level 3 Time Limit }
    rec29,               { Level 3 Call Limit }
    rec30,               { Level 4 Time Limit }
    rec31,               { Level 4 Call Limit }
    rec32,               { Level 5 Time Limit }
    rec33,               { Level 5 Call Limit }
    rec34,               { Level 6 Time Limit }
    rec35,               { Level 6 Call Limit }
    rec36,               { Level 7 Time Limit }
    rec37,               { Level 7 Call Limit }
    rec38,               { Level 8 Time Limit }
    rec39,               { Level 8 Call Limit }
    rec40,               { Level 9 Time Limit }
    rec41  : Word;       { Level 9 Call Limit }
end;

type
  Page5 = record
    rec43,              { Directory Path             }
    rec44,              { Directory Area Name        }
    rec45 : string[30]; { File List & Path           }
    rec46,              { Uploads Allowed            }
    rec47 : string[1];  { DownLoads Allowed          }
    rec48 : integer;    { Minimum Level Access       }
end;

Var
  F        : Form;
  Page_1   : Page1;
  Page_2   : Page2;
  Page_3   : Page3;
  Page_4   : Page4;
  Page_5   : Page5;

  NextPage : Boolean;
  Page     : word;
  PB,
  Typ      : word;
  Buf      : string;
  X1,
  Y1       : Byte;

procedure At(X, Y : byte; Buffer : String);
begin
   GotoXY(X,Y);
   Write(Buffer);
end;

procedure Button(X,Y,Flag : byte; Texts : String);
begin
  If Typ <> 3 then
    begin
      X1  := X;
      Y1  := y;
      Buf := Texts;
   end;
  Case Flag of
     1 : begin
           BCol(Cyan);
           TCol(White);
           At(X,Y,'                  ');
           BCol(Blue);
           TCol(Black);
           Write('');
           At(X,Y+1,' ');
           BCol(Cyan);
           TCol(White);
           At(X + 1,Y,Texts);
         end;
     2 : begin
           BCol(White);
           TCol(Black);
           At(X,Y,'                  ');
           BCol(Blue);
           TCol(Black);
           Write('');
           At(X,Y+1,' ');
           BCol(White);
           At(X + 1,Y,Texts);
         end;
     3 : begin
           BCol(Blue);
           TCol(7);
           At(X ,Y,'  ');
           At(X + 1,Y+1,' ');
           Delay(100);
           BCol(White);
           TCol(Black);
           At(X,Y,'                  ');
           BCol(Blue);
           TCol(Black);
           Write('');
           At(X,Y+1,' ');
           BCol(White);
           At(X + 1,Y,Texts);
         end;
  end; {Case End}
end;

procedure MainScreen;
begin
  BCol(Blue);
  ClrScr;
  TCol(White);
  BCol(Cyan);
  GotoXY(1,1);
  ClrEol;
  Write(' Sauron Host Configuration ');
  At(72,1,'Ver 1.04');
  GotoXY(1,25);
  ClrEol;
  Button(4,4,1,'SYSTEM SETUP (1)');
  Button(4,7,1,'SYSTEM SETUP (2)');
  Button(4,10,1,'     MODEM');
  Button(4,13,1,'');
  Button(4,16,1,'  SYSTEM EVENTS');
  Button(4,19,1,'');
  Button(4,22,1,'SYSTEM STATISTICS');
  Button(32,4,1,'  TIME & CALLS');
  Button(32,7,1,'   EDIT USERS');
  Button(32,10,1,'');
  Button(32,13,1,'');
  Button(32,16,1,'');
  Button(32,19,1,'');
  Button(32,22,1,'');
  Button(60,4,1,'EDIT FILE AREAS');
  Button(60,7,1,'CREATE FILE AREAS');
  Button(60,10,1,'CREATE FILE LISTS');
  Button(60,13,1,'ADD FILES TO LIST');
  Button(60,16,1,'    SORT LIST');
  Button(60,19,1,'    DOS SHELL');
  Button(60,22,1,'   EXIT TO DOS');
end;


procedure Page01;
begin
  Page_1.rec1  := BBSCfg.SysopFirst;
  Page_1.rec2  := BBSCfg.SysopSec;
  Page_1.rec3  := BBSCfg.BBSName;
  Page_1.rec4  := BBSCfg.BBSTele;
  Page_1.rec5  := BBSCfg.Calls;
  Page_1.rec5a := BBSCfg.Node;
  if BBSCfg.MultiNode then
    begin
      Page_1.rec5b := 'Y';
    end
  else
    begin
      Page_1.rec5b := 'N';
    end;

  F.Init(8, 3, 73, 21);
  F.Add(New(FStrPtr, Init(3, 3, '           Sysop First Name :  ', 15)));
  F.Add(New(FStrPtr, Init(3, 5, '          Sysop Second Name :  ', 15)));
  F.Add(New(FStrPtr, Init(3, 7, '           Name Of Your BBS :  ', 30)));
  F.Add(New(FStrPtr, Init(3, 9, '  Your BBS Telephone Number :  ', 20)));
  F.Add(New(FIntsPtr, Init(3, 11, '  Number Of Calls To System :  ',0,3333)));
  F.Add(New(FBytePtr, Init(3, 13, ' (0 For Single) Node Number :  ',1,255)));
  F.Add(New(FStrPtr, Init(3, 15, 'Are You Running multi Nodes :  ',1)));
  F.Put(Page_1);
  F.Show(True);
  BCol(7);
  TCol(1);
  GotoXY(2,1);
  Write('SYSTEM CONFIGURATION');
  TCol(Red);
  GotoXY(2,17);
  Write('ESC - Exit');

  if F.Edit = CEsc then
    begin
      F.Get(Page_1);
      BBSCfg.SysopFirst := Page_1.rec1;
      BBSCfg.SysopSec   := Page_1.rec2;
      BBSCfg.BBSName    := Page_1.rec3;
      BBSCfg.BBSTele    := Page_1.rec4;
      BBSCfg.Calls      := Page_1.rec5;
      BBSCfg.Node       := Page_1.rec5a;
      If Upcase(Page_1.rec5b[1]) = 'Y' then
        begin
          BBSCfg.MultiNode := True;
        end
      Else
        begin
          BBSCfg.MultiNode := False;
        end;
    end;
  CloseBox;
  F.Done;
end;

procedure Page02;
begin
  Page_2.Rec6   := BBSCfg.NULevel;
  Page_2.Rec7   := BBSCfg.IdleTime;
  Page_2.Rec8   := BBSCfg.MaxUsers;
  Page_2.Rec9   := BBSCfg.MaxMsg;
  Page_2.Rec10  := BBSCfg.LogFile;
  Page_2.Rec11  := BBSCfg.ErrFile;
  Page_2.Rec12  := BBSCfg.SysDir;
  Page_2.Rec13  := BBSCfg.ScriptDir;
  Page_2.Rec14  := BBSCfg.MenuDir;
  Page_2.Rec15  := BBSCfg.BBSMailDir;
  Page_2.Rec16  := BBSCfg.MsgDir;
  Page_2.Rec17  := BBSCfg.TempDir;
  PAge_2.Rec17a := BBSCfg.NodeDir;

  F.Init(2,3,78,22);
  F.Add(New(FIntsPtr, Init(3, 3, '   New User Level :  ',1,9)));
  F.Add(New(FWordPtr, Init(26, 4, '  User Idle Time In Minutes :  ',1,999)));
  F.Add(New(FWordPtr, Init(3, 5, '     Maximum Number Of Users Allowed  :  ',1,999)));
  F.Add(New(FWordPtr, Init(3, 6, ' Maximum Number Of Messages Per Area  :  ',1,999)));
  F.Add(New(FStrPtr, Init(3, 7, ' User Log File :  ',12)));
  F.Add(New(FStrPtr, Init(36, 8, 'Error Log File :  ',12)));

  F.Add(New(FStrPtr, Init(6,11, '   System Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,12, '   Script Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,13, '     Menu Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,14, ' BBS Mail Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,15, '  Message Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,16, '  Tempory Directory : ',30)));
  F.Add(New(FStrPtr, Init(6,17, '     Node Directory : ',30)));

  F.Put(Page_2);
  F.Show(True);

  BCol(7);
  TCol(1);
  GotoXY(2,1);
  Write('SYSTEM CONFIGURATION');

  if F.Edit = CEsc then
    begin
      F.Get(Page_2);
      BBSCfg.NULevel    := Page_2.Rec6;
      BBSCfg.IdleTime   := Page_2.Rec7;
      BBSCfg.MaxUsers   := Page_2.Rec8;
      BBSCfg.MaxMsg     := Page_2.Rec9;
      BBSCfg.LogFile    := Page_2.Rec10;
      BBSCfg.ErrFile    := Page_2.Rec11;
      BBSCfg.SysDir     := Page_2.Rec12;
      BBSCfg.ScriptDir  := Page_2.Rec13;
      BBSCfg.MenuDir    := Page_2.Rec14;
      BBSCfg.BBSMailDir := Page_2.Rec15;
      BBSCfg.MsgDir     := Page_2.Rec16;
      BBSCfg.TempDir    := Page_2.Rec17;
      BBSCfg.NodeDir    := Page_2.Rec17a;
    end;
  F.Done;
  CloseBox;
end;

procedure Page03;
Var
  Done : Boolean;
begin
  Page_3.rec18 := BBSCfg.ComPort;
  Case BBSCfg.BaudRate of
      7 : Page_3.Rec19 := 19200;
     35 : Page_3.Rec19 := 38400;
     71 : Page_3.Rec19 := 300;
     99 : Page_3.Rec19 := 600;
    131 : Page_3.Rec19 := 1200;
    163 : Page_3.Rec19 := 2400;
    195 : Page_3.Rec19 := 4800;
    231 : Page_3.Rec19 := 9600;
  end;
  Page_3.rec20  := BBSCfg.InitString1;
  Page_3.rec21  := BBSCfg.InitString2;
  Page_3.rec22  := BBSCfg.InitString3;
  Page_3.rec22a := BBSCfg.InitAnswear;
  if BBSCfg.LockBaud then
    begin
      Page_3.Rec23 := 'Y';
    end
  Else
    begin
      Page_3.rec23 := 'N';
    end;
  F.Init(3, 4, 77, 22);
  F.Add(New(FIntsPtr, Init(2, 3, '       Com Port :  ',0,3)));
  F.Add(New(FIntPtr, Init(2, 5, '      Baud Rate :  ',1,44444)));
  F.Add(New(FStrPtr, Init(2, 7, '  Init String 1 :  ', 50)));
  F.Add(New(FStrPtr, Init(2, 9, '  Init String 2 :  ', 50)));
  F.Add(New(FStrPtr, Init(2, 11, '  Init String 3 :  ', 50)));
  F.Add(New(FStrPtr, Init(2, 13, ' Answear String :  ', 20)));
  F.Add(New(FStrPtr, Init(2, 15, ' Lock Baud Rate :  ', 1)));
  F.Put(Page_3);
  F.Show(True);

  BCol(7);
  TCol(1);
  GotoXY(2,1);
  Write('MODEM CONFIGURATION');
  TCol(Magenta);
  GotoXY(24,3);
  Write('Port : 0 - 3');
  GotoXY(28,5);
  Write('Baud : 300 600 1200 4800 9600 19200 38400');
  GotoXY(24,15);
  Write('May Be Required For High Speed Modems');
  TCol(Red);
  GotoXY(2,17);
  Write('ESC - Exit & Save');
  Repeat
    if F.Edit = CEsc then
      begin
        Done := True;
        F.Get(Page_3);
        BBSCfg.ComPort := Page_3.rec18;
        If Page_3.Rec19 = 19200 then
          begin
            BBSCfg.Baudrate := 7;
          end
        Else
          begin
            If Page_3.Rec19 = 38400 then
              begin
                BBSCfg.Baudrate := 35;
               end
             Else
               begin
                 If Page_3.Rec19 = 300 then
                   begin
                     BBSCfg.Baudrate := 71;
                   end
                 Else
                   begin
                     If Page_3.Rec19 = 600 then
                       begin
                         BBSCfg.Baudrate := 99;
                       end
                     Else
                       begin
                         If Page_3.Rec19 = 1200 then
                           begin
                             BBSCfg.Baudrate := 131;
                           end
                         Else
                           begin
                             If Page_3.Rec19 = 2400 then
                               begin
                                 BBSCfg.Baudrate := 163;
                               end
                             Else
                               begin
                                 If Page_3.Rec19 = 4800 then
                                   begin
                                     BBSCfg.Baudrate := 195;
                                   end
                                 Else
                                   begin
                                     If Page_3.Rec19 = 9600 then
                                       begin
                                         BBSCfg.Baudrate := 231;
                                       end
                                     Else
                                       Begin
                                         TCol(Black);
                                         BCol(7);
                                         GotoXY(28,5);
                                         Write('<');
                                         BCol(Green);
                                         TCol(White);
                                         Write(' INVALID BAUD RATE ');
                                         Sound(890);
                                         Delay(1000);
                                         NoSound;
                                         Delay(2500);
                                         TCol(Magenta);
                                         BCol(7);
                                         GotoXY(28,5);
                                         Write('Baud : 300 600 1200 4800 9600 19200 38400');
                                         Done := False;
                                       end;
                                   end;
                               end;
                           end;
                       end;
                   end;
               end;
           end;
  BBSCfg.InitString1 := Page_3.Rec20;
  BBSCfg.InitString2 := Page_3.rec21;
  BBSCfg.InitString3 := Page_3.rec22;
  BBSCfg.InitAnswear := Page_3.rec22a;
  if UpCase(Page_3.Rec23[1]) = 'Y' then
    begin
      BBSCfg.LockBaud := True;
    end
  Else
    begin
      BBSCfg.LockBaud := False;
    end;
 end;
  Until Done;
  F.Done;
  CloseBox;
end;

procedure Page04;
begin

  Page_4.Rec24 := BBSCfg.L1T;
  Page_4.Rec25 := BBSCfg.L1C;
  Page_4.Rec26 := BBSCfg.L2T;
  Page_4.Rec27 := BBSCfg.L2C;
  Page_4.Rec28 := BBSCfg.L3T;
  Page_4.Rec29 := BBSCfg.L3C;
  Page_4.Rec30 := BBSCfg.L4T;
  Page_4.Rec31 := BBSCfg.L4C;
  Page_4.Rec32 := BBSCfg.L5T;
  Page_4.Rec33 := BBSCfg.L5C;
  Page_4.Rec34 := BBSCfg.L6T;
  Page_4.Rec35 := BBSCfg.L6C;
  Page_4.Rec36 := BBSCfg.L7T;
  Page_4.Rec37 := BBSCfg.L7C;
  Page_4.Rec38 := BBSCfg.L8T;
  Page_4.Rec39 := BBSCfg.L8C;
  Page_4.Rec40 := BBSCfg.L9T;
  Page_4.Rec41 := BBSCfg.L9C;

  F.Init(9,3,72,23);
  F.Add(New(FWordPtr, Init(3, 3, 'Minutes Per Day Level 1 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,3, 'Calls Per Day Level 1 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 5, 'Minutes Per Day Level 2 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,5, 'Calls Per Day Level 2 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 7, 'Minutes Per Day Level 3 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,7, 'Calls Per Day Level 3 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 9, 'Minutes Per Day Level 4 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,9, 'Calls Per Day Level 4 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 11, 'Minutes Per Day Level 5 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,11, 'Calls Per Day Level 5 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 13, 'Minutes Per Day Level 6 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,13, 'Calls Per Day Level 6 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 15, 'Minutes Per Day Level 7 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,15, 'Calls Per Day Level 7 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 17, 'Minutes Per Day Level 8 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,17, 'Calls Per Day Level 8 : ',0,999)));
  F.Add(New(FWordPtr, Init(3, 19, 'Minutes Per Day Level 9 : ',0,999)));
  F.Add(New(FWordPtr, Init(35,19, 'Calls Per Day Level 9 : ',0,999)));
  F.Put(Page_4);
  F.Show(True);

  BCol(7);
  TCol(1);
  GotoXY(2,1);
  Write('USER TIME LIMITS & CALLS PER DAY');

  if F.Edit = CEsc then
    begin
      F.Get(Page_4);
      BBSCfg.L1T := Page_4.Rec24;
      BBSCfg.L1C := Page_4.Rec25;
      BBSCfg.L2T := Page_4.Rec26;
      BBSCfg.L2C := Page_4.Rec27;
      BBSCfg.L3T := Page_4.Rec28;
      BBSCfg.L3C := Page_4.Rec29;
      BBSCfg.L4T := Page_4.Rec30;
      BBSCfg.L4C := Page_4.Rec31;
      BBSCfg.L5T := Page_4.Rec32;
      BBSCfg.L5C := Page_4.Rec33;
      BBSCfg.L6T := Page_4.Rec34;
      BBSCfg.L6C := Page_4.Rec35;
      BBSCfg.L7T := Page_4.Rec36;
      BBSCfg.L7C := Page_4.Rec37;
      BBSCfg.L8T := Page_4.Rec38;
      BBSCfg.L8C := Page_4.Rec39;
      BBSCfg.L9T := Page_4.Rec40;
      BBSCfg.L9C := Page_4.Rec41;
    end;
  F.Done;
  CloseBox;
end;

procedure Page05;
Var
  Done : Boolean;
  Step,
  Max,
  Min,
  Cur  : integer;
  Key  : Char;
begin
  Box(24,5,57,20,White + (7 * 16), 3, True);
  OffCursor;
  BCol(7);
  TCol(Black);
  ClrScr;
  For Step := 1 to 14 do
   begin
     if Step < AreaSize - 1 then
       begin
         Seek(FileArea, Step - 1);
         Read(FileArea, Areas);
         At(2,Step,Areas.DirDes);
       end;
   end;
  Step := 0;
  Max  := AreaSize - 1;
  Min  := 1;
  Cur  := 1;
  Done := False;
  Seek(FileArea, 0);
  Read(FileArea, Areas);
  TCol(White);
  BCol(Cyan);
  At(1,1,'                               ');
  At(2,1, Areas.DirDes);
  repeat
    Key := ReadKey;
    case Key of
      #0 : begin
             Key := ReadKey;
             Case Key of
              #72 : begin
                      If Step > 0 then
                        begin
                          TCol(0);
                           BCol(7);
                           At(1,Cur,'                               ');
                           At(2,Cur, Areas.DirDes);
                        end;
                      If Cur > Min then
                        begin
                          Dec(Step);
                          Seek(FileArea, Step);
                          Read(FileArea, Areas);
                          TCol(15);
                          BCol(Cyan);
                          Dec(Cur);
                          At(1,Cur,'                               ');
                          At(2,Cur, Areas.DirDes);
                        end
                      Else
                        begin
                          If Step > 0 then
                            begin
                              { ScrollDn(24,5,55,18,White + (7 * 16)); }
                              Dec(Step);
                              Seek(FileArea, Step);
                              Read(FileArea, Areas);
                              TCol(15);
                              BCol(Cyan);
                              At(1,Min,'                               ');
                              At(2,Min, Areas.DirDes);
                            end
                          Else
                            begin
                            end;
                        end;
                    end;
              #80 : begin
                      If Step < AreaSize - 1 then
                        begin
                          TCol(0);
                           BCol(7);
                           At(1,Cur,'                               ');
                           At(2,Cur, Areas.DirDes);
                        end;
                      If Cur < Max then
                        begin
                          Inc(Step);
                          Seek(FileArea, Step);
                          Read(FileArea, Areas);
                          TCol(15);
                          BCol(Cyan);
                          Inc(Cur);
                          At(1,Cur,'                               ');
                          At(2,Cur, Areas.DirDes);
                        end
                      Else
                        begin
                          If Step < AreaSize - 1 then
                            begin
                              { ScrollUp(24,5,55,18,White + (7 * 16)); }
                              Inc(Step);
                              Seek(FileArea, Step);
                              Read(FileArea, Areas);
                              TCol(15);
                              BCol(Cyan);
                              At(1,Max,'                               ');
                              At(2,Max, Areas.DirDes);
                            end
                          Else
                            begin
                            end;
                        end;
                    end;
             end; { Case End }
           end;
     #13 : begin
             Done := True;
           end;
    end; { Case End }
  until Done;
  OnCursor;
  CloseBox;
  Seek(FileArea, Step);
  Read(FileArea, Areas);

  Page_5.rec43 := Areas.Dir;
  Page_5.rec44 := Areas.DirDes;
  Page_5.rec45 := Areas.FileLst;

  if Areas.Uploads = 1 then
    begin
      Page_5.rec46 := 'Y';
    end
  Else
    begin
      Page_5.rec46 := 'N';
    end;
  if Areas.Dnloads = 1 then
    begin
      Page_5.rec47 := 'Y';
    end
  Else
    begin
      Page_5.rec47 := 'N';
    end;
  Page_5.rec48 := Areas.Access;

  F.Init(13,4,68,22);
  F.Add(New(FStrPtr, Init(3, 5, '   Directory Path : ',30)));
  F.Add(New(FStrPtr, Init(3, 7, ' Area Description : ',30)));
  F.Add(New(FStrPtr, Init(3, 9, ' File List & Path : ',30)));
  F.Add(New(FStrPtr, Init(3, 11, '  UpLoads Allowed : ',1)));
  F.Add(New(FStrPtr, Init(3, 13, '  DnLoads Allowed : ',1)));
  F.Add(New(FIntsPtr, Init(3, 15, ' Min Access Level : ',1,9)));

  F.Put(Page_5);
  F.Show(True);

  BCol(7);
  TCol(0);
  At(3, 3, ' Directory Number : ');
  TCol(White);
  Write(Areas.DirNo);

  TCol(1);
  BCol(7);
  GotoXY(2,1);
  Write('EDIT FILE AREA');
  GotoXY(2,17);
  Write('ESC - Exit');
  if F.Edit = CEsc then
    begin
      F.Get(Page_5);
      Areas.Dir     := Page_5.rec43;
      Areas.DirDes  := Page_5.rec44;
      Areas.FileLst := Page_5.rec45;
      if UpCase(Page_5.rec46[1]) = 'Y' then
        begin
          Areas.UpLoads := 1;
        end
      Else
        begin
          Areas.Uploads := 0;
        end;
     if UpCase(Page_5.rec47[1]) = 'Y' then
        begin
          Areas.DnLoads := 1;
        end
     Else
        begin
          Areas.DnLoads := 0;
        end;
     Areas.Access := Page_5.rec48;
     Seek(FileArea, Step);
     Write(FileArea, Areas);
   end;
  CloseBox;
end;

procedure Page06;
begin
  Page_5.rec43 := '';
  Page_5.rec44 := '';
  Page_5.rec45 := '';
  Page_5.rec46 := 'N';
  Page_5.rec47 := 'N';
  Page_5.rec48 := 1;

  F.Init(13,4,68,22);
  F.Add(New(FStrPtr, Init(3, 5, '   Directory Path : ',30)));
  F.Add(New(FStrPtr, Init(3, 7, ' Area Description : ',30)));
  F.Add(New(FStrPtr, Init(3, 9, ' File List & Path : ',30)));
  F.Add(New(FStrPtr, Init(3, 11, '  UpLoads Allowed : ',1)));
  F.Add(New(FStrPtr, Init(3, 13, '  DnLoads Allowed : ',1)));
  F.Add(New(FIntsPtr, Init(3, 15, ' Min Access Level : ',1,9)));

  F.Put(Page_5);
  F.Show(True);

  BCol(7);
  TCol(0);
  At(3, 3, ' Directory Number : ');
  TCol(White);
  Write(AreaSize + 1);

  TCol(1);
  BCol(7);
  GotoXY(2,1);
  Write('ADD FILE AREA');
  GotoXY(2,17);
  Write('F2 - Save  ESC - Exit');
  if F.Edit = CSave then
    begin
      F.Get(Page_5);
      Areas.DirNo   := AreaSize + 1;
      Areas.Dir     := Page_5.rec43;
      Areas.DirDes  := Page_5.rec44;
      Areas.FileLst := Page_5.rec45;
      if UpCase(Page_5.rec46[1]) = 'Y' then
        begin
          Areas.UpLoads := 1;
        end
      Else
        begin
          Areas.Uploads := 0;
        end;
     if UpCase(Page_5.rec47[1]) = 'Y' then
        begin
          Areas.DnLoads := 1;
        end
     Else
        begin
          Areas.DnLoads := 0;
        end;
     Areas.Access := Page_5.rec48;
     Seek(FileArea, AreaSize);
     Write(FileArea, Areas);
     Inc(AreaSize);
   end;
  CloseBox;
end;

procedure EditUsers;
Var
  Step,
  Max  : integer;
  Key  : String;
begin
  Box(10,4,50,6,White + (7 * 16), 3, True);
  BCol(7);
  ClrScr;
  TCol(Black);
  BCol(7);
  Write(' ENTER USER NUMBER : ');
  Key := ReadKB(10);
  Val(Key, Step, Max);
  if (Step > UserSize - 1) or (Step < 1) then
    begin
      CloseBox;
      Beep;
      PopUp('INVALID USER NUMBER');
    end
  Else
    begin
      CloseBox;
      EditUser(Step);
    end;
end;

Var
  Done : Boolean;
  Key  : Char;
  Area : Byte;
begin
  ConfigFile := Paramstr(1);
  if Paramcount = 0 then
    begin
      TextBackground(BLACK);
      TextColor(WHITE);
      ClrScr;
      TextBackground(BLUE);
      ClrEol;
      Writeln(' Sauron Host BBS Setup Version 1.04               (C)Simon C Horton 1995 - 1996');
      TextBackground(BLACK);
      Writeln;
      Writeln('                       NO CONFIGURATION FILE SPECIFIED');
      Writeln;
      Writeln('     USAGE: Setupbbs < Configuration File >      EG: Setupbbs Node1.cfg');
      Writeln;
      TextColor(7);
      Halt(1);
    end;
  Done := False;
  OpenDataFiles;
  MainScreen;
  OffCursor;
  PB   := 1;
  Typ  := 2;
  Area := 1;
  Button(4,4,Typ,'SYSTEM SETUP (1)');
  Repeat
    Key := ReadKey;
    case Key of
      #0 : begin
             Key := ReadKey;
             case Key of
                #72 : begin { Arrow Up }
                        If WhereY > 4 then
                          begin
                            Dec(PB);
                          end
                        Else
                          begin
                            PB := PB + 6;
                          end;
                      end;
                #75 : begin { Arrow Left }
                        Case Area of
                          1 : begin
                                Area := 3;
                                PB := PB + 14;
                              end;
                          2 : begin
                                Area := 1;
                                PB := PB - 7;
                              end;
                          3 : begin
                                Area := 2;
                                PB := PB - 7;
                              end;
                        end; { Case End }
                      end;
                #77 : begin { Arrow Right }
                        Case Area of
                          1 : begin
                                Area := 2;
                                PB := PB + 7;
                              end;
                          2 : begin
                                Area := 3;
                                PB := PB + 7;
                              end;
                          3 : begin
                                Area := 1;
                                PB := PB - 14;
                              end;
                        end; { Case End }
                      end;
                #80 : begin { Arrow Down }
                        If WhereY < 22 then
                          begin
                            Inc(PB);
                          end
                        Else
                          Begin
                            PB := PB - 6;
                          end;
                      end;
             end; { Case End }
           end;
     #13 : begin
             Typ := 3;
           end;
    end; { Case End }
  Case PB of
    1 : begin
          Button(X1,Y1,1,Buf);
          Button(4,4,Typ,'SYSTEM SETUP (1)');
          If Typ = 3 then
            begin
              OnCursor;
              Page01;
              Typ := 2;
              OffCursor;
            end;
        end;
    2 : begin
           Button(X1,Y1,1,Buf);
           Button(4,7,Typ,'SYSTEM SETUP (2)');
           If Typ = 3 then
            begin
              OnCursor;
              Page02;
              Typ := 2;
              OffCursor;
            end;
        end;
   3 : begin
         Button(X1,Y1,1,Buf);
         Button(4,10,Typ,'     MODEM');
         If Typ = 3 then
            begin
              OnCursor;
              Page03;
              OffCursor;
              Typ := 2;
            end;
       end;
   4 : begin
         Button(X1,Y1,1,Buf);
         Button(4,13,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
   5 : begin
         Button(X1,Y1,1,Buf);
         Button(4,16,Typ,'  SYSTEM EVENTS');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
   6 : begin
         Button(X1,Y1,1,Buf);
         Button(4,19,Typ,'');
       end;
   7 : begin
         Button(X1,Y1,1,Buf);
         Button(4,22,Typ,'SYSTEM STATISTICS');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
   8 : begin
         Button(X1,Y1,1,Buf);
         Button(32,4,Typ,'  TIME & CALLS');
         If Typ = 3 then
            begin
              OnCursor;
              Page04;
              OffCursor;
              Typ := 2;
            end;
       end;
   9 : begin
         Button(X1,Y1,1,Buf);
         Button(32,7,Typ,'   EDIT USERS');
         If Typ = 3 then
            begin
              OnCursor;
              EditUsers;
              OffCursor;
              Typ := 2;
            end;
       end;
  10 : begin
         Button(X1,Y1,1,Buf);
         Button(32,10,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  11 : begin
         Button(X1,Y1,1,Buf);
         Button(32,13,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  12 : begin
         Button(X1,Y1,1,Buf);
         Button(32,16,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  13 : begin
         Button(X1,Y1,1,Buf);
         Button(32,19,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  14 : begin
         Button(X1,Y1,1,Buf);
         Button(32,22,Typ,'');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  15 : begin
         Button(X1,Y1,1,Buf);
         Button(60,4,Typ,' EDIT FILE AREA');
         If Typ = 3 then
            begin
              OnCursor;
              Page05;
              OffCursor;
              Typ := 2;
            end;
       end;
  16 : begin
         Button(X1,Y1,1,Buf);
         Button(60,7,Typ,'CREATE FILE AREA');
         If Typ = 3 then
            begin
              OnCursor;
              Page06;
              OffCursor;
              Typ := 2;
            end;
       end;
  17 : begin
         Button(X1,Y1,1,Buf);
         Button(60,10,Typ,'CREATE FILE LISTS');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  18 : begin
         Button(X1,Y1,1,Buf);
         Button(60,13,Typ,'ADD FILES TO LIST');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  19 : begin
         Button(X1,Y1,1,Buf);
         Button(60,16,Typ,'    SORT LIST');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  20 : begin
         Button(X1,Y1,1,Buf);
         Button(60,19,Typ,'    DOS SHELL');
         If Typ = 3 then
            begin
              Typ := 2;
            end;
       end;
  21 : begin
         Button(X1,Y1,1,Buf);
         Button(60,22,Typ,'   EXIT TO DOS');
         If Typ = 3 then
            begin
              Done := True;
            end;
       end;
  end; { Case End }
  Until Done;
  OnCursor;
  Seek(SBBSCFG,0);
  Write(SBBSCFG,BBSCFG);
  CloseDataFiles;
end.