{ OCT 97 - Release Notes                                         }

unit wins;

interface

uses dos, crt;

procedure OffCursor;
procedure OnCursor;
procedure Box(x1, y1, x2, y2, col,btype : byte ; ShadowFlag : boolean);
procedure CloseBox;
procedure Popup(Message : String);

implementation

Type
      scr          = array[1..2000] of
                       record
                          character : char;
                          attribute : byte;
                       end;

      scrprt       = ^scr;


Const
  BoxCol    = White + (Blue * 16);
  TextCol   = LightCyan;
  tl : string[5] = '+';  tr : string[5] = '+';
  bl : string[5] = '+';  br : string[5] = 'ٽ+';
  hs : string[5] = '-';  vs : string[5] = '|';

var
  scrbuff,
  savescreen             : scrprt;
  OldX,Oldy,BoxW,
  OldText,Lines          : Byte;
  Regs                   : Registers;

procedure OnCursor;
begin
  Regs.ax := 1 shl 8;
  Regs.cx := 6 shl 8 + 7;
  intr($10,Regs);
end;

procedure OffCursor;
begin
  Regs.ax := 1 shl 8;
  Regs.cx := 14 shl 8;
  intr($10,Regs);
end;

procedure position(x,y,col : byte; ch : char);
var
  i : word;
begin
  i := ((((y - 1) * 80) + (x - 1)) + 1);
  scrbuff^[i].attribute := col;
  scrbuff^[i].character := ch;
end;

Procedure Save_Screen;
begin
  Oldx := Wherex;
  OldY := wherey;
  OldText := TextAttr;
  if (mem[0000:0449] = $7) then
     scrbuff := ptr($b000,0000)
  else
     scrbuff := ptr($b800,0000);
  if memavail >= sizeof(scr) then
    begin
       New(SaveScreen);
       savescreen^ := scrbuff^;
    end
  else
    begin
      writeln('Not Enough Memory To Open Window');
      halt(1);
    end;
    OnCursor;
end;


procedure shadow(X, Y : integer);
begin
  GotoXY(X,Y - 1);
  regs.AH := $08;
  regs.BH := $00;
  Intr($10, regs);
  if (Regs.AL >= 219) and (Regs.AL <= 223) then
    begin
      TextAttr := Black + Black and $7f;
    end
  Else
    begin
      TextAttr := Black + 7 and $7f;
    end;
  Y := regs.AL;
  Write(chr(Y));
end;

procedure box(x1,y1,x2,y2,col,btype : byte ; ShadowFlag : Boolean);
var
   i : word;
   temp : String[80];
begin
  Save_Screen;
  OffCursor;
  position(x1,y1,col,tl[btype]);
  position(x2,y1,col,tr[btype]);
  position(x1,y2,col,bl[btype]);
  position(x2,y2,col,br[btype]);
  if ShadowFlag then shadow(x2 + 1, y2 + 1);
  for i := (x1 + 1) to (x2 - 1) do
    begin
      position(i,y1,col,hs[btype]);
      position(i,y2,col,hs[btype]);
      if ShadowFlag then shadow(i, y2 + 2);
    end;
  if ShadowFlag then
    begin
      shadow(i + 1, y2 + 2);
      shadow(i + 2, y2 + 2);
    end;
  for i := (y1 + 1) to (y2 - 1) do
    begin
      position(x1,i,col,vs[btype]);
      position(x2,i,col,vs[btype]);
      if ShadowFlag then shadow(x2 + 1 , i + 1);
    end;
  fillchar(temp[1],x2-x1-1,32);
  temp[0] := chr(x2-x1-1);
  textAttr := BoxCol;
  window(x1 + 1, y1 + 1, x2 - 1, y2 - 1);
  OnCursor;
end;

procedure CloseBox;
begin
  scrbuff^ := savescreen^;
  Dispose(SaveScreen);
  Window(1,1,80,25);
  TextAttr := OldText;
  Gotoxy(OldX,OldY);
end;

Procedure popup(Message : String);
Var
  i,j    : Byte;
Begin
  i := Length(message);
  j := 40 - (i shr 1);
  box(j-2,10,j+i+1,12,White + (Green * 16),3, true);
  TextBackGround(Green);
  ClrScr;
  GotoXy(2,1);
  Write(message);
  Delay(2500);
  CloseBox;
end;

end.
