#undef _MBOX




/* ix/MBox (tools.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #TY tty()             find out your tty number
   #UP upcased()         convert a string to upcased characters
   #SC strcopy()         cut a pattern out of a string
   #CY crypted()         encrypt a string
   #DR datereconv()      convert a long to a data string
   #TR timereconv()      convert a long to a time string
   #NS num_stripped()    delete all numeric chars from a string
   #HL headline()        show a headline
   #TN ttyna()           find out your tty name
   #BC bigcopy()         cut a pattern out of a gib string
   #CL clearline()       delete a line on a terminal
   #IN isin()            check if a char is in a string
   #AN ansi2()           print terminal codes out of "/etc/termcap"
   #TA termansi()        return a terminal code of "/etc/termcap"
   #SG sgrep             find a pattern in a string
   #AF aftol()           convert a float in a string into a long

   Contact <volkers@unnet.wupper.de> for help! */




#ifdef STERMIOS
#ifdef _SINIX             
#include <curses.h>       /* SINIX SVR4.1 prefers this instead of <termcap.h> */
#else 
#ifndef _SCO
#include <termcap.h>
#else
#include <curses.h>	  /* UNIX SVR4.2 prefers this instead of <termcap.h> */
			  /* As does SCO 3.2.4.3 ... */
#endif
#endif

#endif


#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <string.h>


#ifndef UNSIGNED
#if !defined(_MINIX) || defined(_ESTDIO)
#define UNSIGNED unsigned
#else
#define UNSIGNED
#endif
#endif

#ifdef _MBOX
#define EXTERN
#include "mbox.h"
#else
#define VERSION "Tools.C"
#define CR 13
#define TOL01_MSG	"Sonntag"
#define TOL02_MSG	"Montag"
#define TOL03_MSG	"Dienstag"
#define TOL04_MSG	"Mittwoch"
#define TOL05_MSG	"Donnerstag"
#define TOL06_MSG	"Freitag"
#define TOL07_MSG	"Samstag"
#define TOL08_MSG	"Momentchen"
#endif
#ifdef STRING
#undef STRING
#endif

#ifdef LONGSTRING
#undef LONGSTRING
#endif

#define STRING 81
#define LONGSTRING 256

UNSIGNED char headinfo[STRING];






/* #UP - Upcaseing all characters in string [st].

   This function returns the upcased string. */

UNSIGNED char *upcased(st)
unsigned char st[];		/* !!! unsigned, NOT UNSIGNED !!! */
{
  static UNSIGNED char s[STRING];

  int i = 0;

#ifdef _PROFILE
  profile( "upcased()" );
#endif

  strcpy(s, (UNSIGNED char *) strcopy(st, 0, STRING));

  while (s[i] != '\0') {
	if (s[i] > 127) {
		if (s[i] == 132) s[i] = 142; /* IBM/DOS, ATARI ST */
		if (s[i] == 148) s[i] = 153;
		if (s[i] == 122) s[i] = 154;
		if (s[i] == 228) s[i] = 196; /* ISO-8859-1, AMIGA */
		if (s[i] == 246) s[i] = 214;
		if (s[i] == 252) s[i] = 220;
	}
	else{
		if (s[i] > 96) s[i] -= 32;
	}
	i++;
  }

  return (UNSIGNED char *) s;
}




/* #BC - Cut a part out of a long string [st].

   [v] describes the first position in [st], [b] stands for the last
   position. 

   This function returns the part between [v] and [b] as a long string. */

UNSIGNED char *bigcopy(st, v, b)
UNSIGNED char st[];
int v, b;
{
  static UNSIGNED char s[LONGSTRING];

  int i = 0, j;

#ifdef _PROFILE
  profile( "bigcopy()" );
#endif

  if (b > LONGSTRING) b = LONGSTRING;

  for (j = v; j <= b; j++) {
	s[i] = st[j];
	i++;
  }
  s[i] = '\0';

  return (UNSIGNED char *) s;
}





/* #AN - Get a termcap entry or convert a command to terminal code.

   [code]   ->  'INIT'   = get a complete termcap entry and store it
                command  = find the command and show the code

   [x, y]   ->  if command is 'cm' (Cursor move), than the cursor is
                moved to [y],[x].

   This function returns -1 if terminal is not known, 1 if command 
   couldn't be found, or 0 is everything is ok. */

static UNSIGNED char buf[1024];


int ansi(code)			/* for compatibility reasons */
UNSIGNED char code[];
{

#ifdef _PROFILE
  profile( "ansi()" );
#endif

  ansi2(code, 0, 0);
}

int ansi2(code, x, y)
UNSIGNED char code[];
int x, y;
{
  UNSIGNED char *getenv();
  static UNSIGNED char s[STRING];
  UNSIGNED char *p = s;
  UNSIGNED char *term;

#ifdef _PROFILE
  profile( "ansi2()" );
#endif

#ifdef _MBOX
  term = TERMINAL;
#else
  term = getenv("TERM");
#endif

  if ((x == -1) && (y == -1)) {
	if (tgetent(buf, code) != 1) return -1;
  }
  if (strcomp("INIT", code) == 0) {
	if (tgetent(buf, term) != 1) return -1;
  }
  if (strcomp("cm", code) == 0) {
	if (tgetstr(code, &p) == 0) return 1;
	sprintf(s,(UNSIGNED char *) tgoto( s, (x -1), (y -1) ));

        if((s[0] == '2') || (s[0] == '5') ||(s[0] == '3')){ 
            strcpy(s, (UNSIGNED char *) strcopy(s, 1, STRING));
        }	
	printf("%s", s);
	return 0;
  }
  else{
	if (tgetstr(code, &p) == 0) return 1;
  }

  if((s[0] == '2') || (s[0] == '5') ||(s[0] == '3')){ 
            strcpy(s, (UNSIGNED char *) strcopy(s, 1, STRING));
  }
              
  printf("%s", s);

  return 0;
}



/* #TA - Get a termcap entry or convert a command to terminal code.

   [code]   ->  'INIT'   = get a complete termcap entry and store it
                command  = find the command and show the code

   This function returns the terminal code or '\0'. */

UNSIGNED char *termansi(code)
UNSIGNED char code[];
{
  UNSIGNED char *getenv();
  UNSIGNED char s[STRING];
  UNSIGNED char *p = s;
  UNSIGNED char *term;

#ifdef _PROFILE
  profile( "termansi()" );
#endif

#ifdef _MBOX
  term = TERMINAL;
#else
  term = getenv("TERM");
#endif

  if (strcomp("INIT", code) == 0) {
	if (tgetent(buf, term) != 1) return (UNSIGNED char *) '\0';
  }
  if (tgetstr(code, &p) == 0) return (UNSIGNED char *) '\0';

  return (UNSIGNED char *) s;
}









/* #CY - Encrypt a string [st].

   This function returns the encrypted string. */

UNSIGNED char *crypted(st)
UNSIGNED char st[];
{
  static UNSIGNED char s[STRING];
  int i = 0, a = 2; 

  strcpy(s, (UNSIGNED char *) strcopy(st, 0, STRING));

  while (s[i] != '\0') {
	s[i] = (s[i] / a) + 32;
	i++;
	a++;
	if (a > 5) a = 2;
  }

  return (UNSIGNED char *) s;
}








/* #DR - Converting a (long) date into a string.

   This function returns a date string. */

UNSIGNED char *datereconv(l)
long l;
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];


  if (l < 19000000)
	sprintf(s, "%ld", 1900000L + l);
  else
	sprintf(s, "%ld", l);

  strcpy(t, (UNSIGNED char *) strcopy(s, 6, 7));
  strcat(t, ".");
  strcat(t, (UNSIGNED char *) strcopy(s, 4, 5));
  strcat(t, ".");
  strcat(t, (UNSIGNED char *) strcopy(s, 0, 3));

  return (UNSIGNED char *) t;
}





/* #TR - Converting a (long) time into a string.

   This function returns a time string. */

UNSIGNED char *timereconv(i)
int i;
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];


  if (i < 10000)
	sprintf(s, "%04.4d00", i);
  else
	sprintf(s, "%06.6d", i);

  strcpy(t, (UNSIGNED char *) strcopy(s, 0, 1));
  strcat(t, ":");
  strcat(t, (UNSIGNED char *) strcopy(s, 2, 3));
  strcat(t, ":");
  strcat(t, (UNSIGNED char *) strcopy(s, 4, 5));

  return (UNSIGNED char *) t;
}






/* #NS - Strip of all numerics of a string [s].

   This function returns the stripped string. */

UNSIGNED char *numstripped(s)
UNSIGNED char s[];
{
  static UNSIGNED char t[STRING];
  int i = 0, a = 0;

  while (s[i] != '\0') {
	if (((s[i] > 64) && (s[i] < 127)) || (s[i] == ' ') || (s[i] == '-')) {
		t[a] = s[i];
		a++;
	}
	i++;
  }
  t[a] = '\0';

  return (UNSIGNED char *) t;
}








/* #HL - Display a text [line] as headline. */

void headline(line)
UNSIGNED char line[];
{
  UNSIGNED char ex[255];
  int i;


  strcpy(ex, line);
  i = 0;
  while(line[i] != '\0'){
	if(line[i] == '^'){
		strcpy(ex, (UNSIGNED char *) strcopy(line, 0, (i-1)));
		line[i] = ' ';
	}
	i++;
  }
  strcpy(headinfo, ex);
  sprintf(ex, "%s                                                                          ", line);
  ex[79] = '\0';
  if (ansi2("cl", 0, 0) != -1) {
	if (ansi2("mr", 0, 0) == 1) {
		if (ansi2("so", 0, 0) == 1) { 
			printf("\n\n------  %s  ------\n\n", line);
			return;
		}
	}
	printf("%s\n", ex);
	if (ansi2("me", 0, 0) == 1) {
		ansi2("se", 0, 0);
	}
  }
  else {
	printf("\n\n\n\n\n------  %s  ------\n\n", line);
  }
}







/* #TY - Find the number of a terminal.

   This function returns the number of a terminal. */

int tty()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i, l, a, b;


  strcpy(s, (UNSIGNED char *) ttyname(0));
  l = strlen(s);
  i = l;

  while ((s[l] != 'y') && (l > 0)) l--;

  l++;
  a = 0;

  for (b = l; b < i; b++) {
	t[a] = s[b];
	a++;
  }
  t[a] = '\0';

  return atoi(t);
}




/* #TN - Find the name of a terminal.

   This function returns the name of a terminal. */

UNSIGNED char *ttyna()
{
  static UNSIGNED char s[STRING];
  static UNSIGNED char t[STRING];
  int i, j, l;


  strcpy(s, (UNSIGNED char *) ttyname(0));

  l = strlen(s) + 1;

  i = 0; 
  while(s[i] != '\0'){
	if(s[i] == '/') j = i + 1;
	i++;
  }
  (void) strcpy(t, (UNSIGNED char *) strcopy(s, j, l));
  
  return (UNSIGNED char *) t;
}




/* #CL - Clear a screenline. */
 
void clearline()
{
  printf("%c", CR);
  if (ansi2("ce", 0, 0) == 1) {
	printf("                                                               ");
  }
  printf("%c", CR);
}




/* #IN - Check if a character [c] is in a string [pattern].

   This function returns 0 if the char isn't included or a number > 0
   otherwise. */

int isin( pattern, c )
UNSIGNED char pattern[];
int c;
{
  int i = 0;
  int ok = 0;

  while((pattern[i] != '\0') && (ok == 0)){
	if(pattern[i] == c) ok++;	
	i++;
  }
  
  return (int) ok;  
}





/* #SG - Check if a pattern [pattern] is in a string [source].

   This function returns 0 if the sign isn't included or a number > 0
   otherwise. */

int sgrep( source, pattern )
UNSIGNED char source[];
UNSIGNED char pattern[];
{
  UNSIGNED char t[STRING];
  int i = 0;
 
  while(source[i] != 0){
	if(source[i] == pattern[0]){
		strcpy(t, (UNSIGNED char *) strcopy(source, i, strlen(source)));
		if(strcomp(pattern, t) == 0) return (int) i + 1;
	}
	i++;
  }

  return (int) 0;
}


/* #AF - Converts a String into a float ... */

long aftol( s )
UNSIGNED char s[];
{
  UNSIGNED char t[STRING];
  int i = sgrep(s, "."); 	/* Decimal point, Germany */ 

  if(i == 0) sgrep(s, ",");	/* Decimal point, Elsewhere */

  strcpy(t, (UNSIGNED char *) strcopy(s, 0, (i-2)));
  strcat(t, (UNSIGNED char *) strcopy(s, (i), strlen(s)));

  return (long) atol( t );
}



int strcomp(s, t)
UNSIGNED char s[], t[];
{
  int i = 0, a = 0;
  UNSIGNED char s1, t1;

#ifdef _PROFILE
  profile( "strcomp()" );
#endif

  while (s[i] != '\0') {
	s1 = s[i];
	t1 = t[i];
	if (t1 > 96) 
		if (t1 < 123) t1 -= 32;
	if (s1 > 96)
		if (s1 < 123) s1 -= 32;
	if (t1 != s1) a++;
	i++;
  }

  return (int) a;
}




UNSIGNED char *strcopy(st, v, b)
UNSIGNED char st[];
int v, b;
{
  static UNSIGNED char s[STRING];

  int i = 0, j;

#ifdef _PROFILE
  profile( "strcopy()" );
#endif

  if(b > STRING) b = STRING;

  for (j = v; j <= b; j++) {
	s[i] = st[j];
	i++;
  }
  s[i] = '\0';

  return (UNSIGNED char *) s;
}



int mbrename(alt, neu)
UNSIGNED char alt[], neu[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[LONGSTRING];

  if(rename(alt, neu) == 0) return 0;

  fp = fopen(neu, "w");
  if (fp == NULL) {
	return -1;
  }
  ff = fopen(alt, "r");
  if (ff == NULL) {
	return -2;
  }
  
  while(fgets(s, LONGSTRING, ff) != NULL)
	fputs(s, fp);

  fclose(fp);
  fclose(ff);

  unlink(alt);

  return 0;
}
