

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>


#include "mbox.h"
#include "proto.h"


#include "s_global.h"
#include "language.h"



/* #HB - Make a headline ;-) */

void headblock( hl, le )
UNSIGNED char hl[], le[];
{
  UNSIGNED char ex[LONGSTRING];

  strcpy(ex, (UNSIGNED char *) le);
  strcat(ex, (UNSIGNED char *) "                                                                              ");
  ex[79] = 0;

  headline( hl );

  if(ZOPT.OPT->USER.terminal == ISO6429){
	if(ansi2( "X1", 0, 0 ) == 0){
		printf( "%s\n", ex);
		ansi2( "me", 0, 0 );
		return;
	}
  }
  printf("%s\n", le);
  printf("===============================================================================\n");
}









void MakeClean(mode)
int mode;
{
  UNSIGNED char s[STRING],tmp[STRING];
  int fpid;

  chdir( ZOPT.OPT->HOME );
  sprintf(s, "%s/etc/spool/whatdoes.%s", ZOPT.OPT->HOME, (UNSIGNED char *) ttyna());
  unlink( s );

  sprintf(s, "%s/surf.%d", TMP, getpid());
  unlink(s);

		sprintf(tmp, "%s/show%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/%d.l2", TMP, getpid());
		unlink(tmp);		
		sprintf(tmp, "%s/subscribe.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/surf.%d", TMP, getpid());
		unlink(tmp);
    if ((!mode)&&(0))
    {

		                                     
		sprintf(tmp,"rm -rf %s/tmp/%d >/dev/null 2 >&1",ZOPT.OPT->HOME,ZOPT.OPT->USER.id);  
		ssystem(tmp);		
		
		sprintf(tmp,"rm -rf %s/tmp/qwk/%d >/dev/null 2 >&1",ZOPT.OPT->HOME,ZOPT.OPT->USER.id);  
		ssystem(tmp);				
		

		sprintf(tmp,"rm -rf %s/tmp/%d.qwk >/dev/null 2 >&1",ZOPT.OPT->HOME,getpid());  
		ssystem(tmp);		
		

		sprintf(tmp,"rm -rf %s/tmp/%d.qwk >/dev/null 2 >&1",ZOPT.OPT->HOME,getpid());  
		ssystem(tmp);	
		

		sprintf(tmp,"rm -rf %s/tmp/%d.msg >/dev/null 2 >&1",ZOPT.OPT->HOME,getpid());  
		ssystem(tmp);					
		
		sprintf(tmp,"rm -rf %s/tmp/dir%d >/dev/null 2 >&1",ZOPT.OPT->HOME,getpid());
		ssystem(tmp);

   
		
    } /* !sigcath */		
		

}



















/* #CA - Isolate the argument(s) from an input line [s]. */

UNSIGNED char *cut_arg(s)
UNSIGNED char s[];
{
  static UNSIGNED char arg[STRING];
  int i = 0, a = 0;

#ifdef _PROFILE
  profile( "cut_arg()" );
#endif

  while (s[i] > 32) i++;
  if (s[i] == 0) return (UNSIGNED char *) "";

  while (s[i] == 32) i++;

  while (s[i] != 0) {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = 0;

  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = 0;
  }

  return (UNSIGNED char *) arg;
}




/* #RA - Calculate the telecom rates and build up a prompt.

   This function returns the prompt line. */

UNSIGNED char *rates()
{
  static UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int dif=0;
  int n1=0, n2=0, r1=0, r2=0, w1=0, w2=0;
  struct tm *timeptr=NULL;

  time(&ZOPT.OPT->time_now);
  dif = ZOPT.OPT->time_now - ZOPT.OPT->time_start;

  n1 = dif / ZOPT.OPT->NZNT;
  n1++;
  n1 *= ZOPT.OPT->TARIF;
  n2 = dif / ZOPT.OPT->NZBT;
  n2++;
  n2 *= ZOPT.OPT->TARIF;
  r1 = dif / ZOPT.OPT->RZNT;
  r1++;
  r1 *= ZOPT.OPT->TARIF;
  r2 = dif / ZOPT.OPT->RZBT;
  r2++;
  r2 *= ZOPT.OPT->TARIF;
  w1 = dif / ZOPT.OPT->WZNT;
  w1++;
  w1 *= ZOPT.OPT->TARIF;
  w2 = dif / ZOPT.OPT->WZBT;
  w2++;
  w2 *= ZOPT.OPT->TARIF;

  timeptr = localtime(&ZOPT.OPT->time_now);
  sprintf(t, "%s", asctime(timeptr));

  if ((t[0] == 'S') || (timeptr->tm_hour > 18) || (timeptr->tm_hour < 8)) {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n2), flt(n2), fix(r2), flt(r2), fix(w2), flt(w2));
  }
  else {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n1), flt(n1), fix(r1), flt(r1), fix(w1), flt(w1));
  }

  return (UNSIGNED char *) s;
}




/* #LG - Updates users database after user has left the BBS. */

void logout()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING],tmp[STRING];
  int a;
  
     strcpy(s, (UNSIGNED char *) mydate(0));
     s[10] = 0;
     strcpy(ZOPT.OPT->USER.lastlog, s);
     strcpy(s, (UNSIGNED char *) mytime(1));
     ZOPT.OPT->USER.lasttime = timeconv(s);



  time(&ZOPT.OPT->time_now);
  ZOPT.OPT->USER.elapsed += (long) (ZOPT.OPT->time_now - ZOPT.OPT->time_start);


  sprintf(ZOPT.OPT->USER.abused, "%ld", ZOPT.OPT->IDX_SIZE);

   
  

  ZOPT.OPT->USER.seq--;		
  /*if( (RIP_ON)) */ init_user( GetText("MAI01_MSG"), 0 );



 control( GetText("MAI02_MSG"), 3);

  chdir( ZOPT.OPT->HOME );

  if(ZOPT.OPT->USER.level <= ADMIN_LEV){ 
  
  	UpdateRatio();
		
	sprintf(t, "%s/mbstat.%d", TMP, getpid());
	ff = fopen(t, "w" );
	if(ff == NULL){
		nerror("main.c", 257, "logout", "Can't write to", t);
	}
	time(&ZOPT.OPT->time_now);
	fprintf(ff, "%s %-8.8s %ld\n", (UNSIGNED char *) mydate( 1 ), (UNSIGNED char *) ttyna(), (ZOPT.OPT->time_now - ZOPT.OPT->time_start));

	a = 0;

	fp = fopen( MBSTAT, "r" );
	if(fp == NULL){
		nerror("main.c", 266, "logout", "Can't read", MBSTAT);
	}
	while((fgets(s, STRING, fp) != NULL) && (a < (PRO_ENTRIES * 3))){
		fputs(s, ff);
		a++;
	}
	fclose(fp);
	fclose(ff);
	mbrename( t, MBSTAT );
  }
  if (ZOPT.OPT->RIP_ON) LOGOUT();
  if (ZOPT.OPT->NNTP_ON) close_server();		
  chdir(ZOPT.OPT->HOME);
  MakeClean(0);
		

}





/* #IT - Gets and sorts commands in and sets user levels. */

void init()
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char udcc[STRING];
  int udcl;
  UNSIGNED char udcp[STRING];
  int b = 0;
  int ok = 0;

  ff = fopen(UDCS, "r");
  if (ff == NULL) {
	nerror("main.c", 115, "init", "Can't read", UDCS);
	exit(0);
  }  
  while((fgets(s, STRING, ff) != NULL) && (s[0] != '='));
  if(fgets(s, STRING, ff) != NULL) ok = 1;
  sscanf(s, "%s %d %s %s", udcc, &udcl, udcp, t);
  if(udcc[0] > 96) udcc[0] -= 32;
  strcat(udcp, " "); strcat(udcp, t);

  fp = fopen(ZOPT.OPT->BEFEHLE, "r");
  if (fp == NULL) {
	printf("\n%s (%s)\n(commands for langauge not found)\n",ZOPT.OPT->BEFEHLE,  GetText("MAI02aMSG"));
	exit( 0 );
  }
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%d %d %d %d %s", &ZOPT.OPT->BEF[b].id, &ZOPT.OPT->BEF[b].in, 
          &ZOPT.OPT->BEF[b].ex, &ZOPT.OPT->BEF[b].prototyp, ZOPT.OPT->BEF[b].befehl) > 0) 
   {

	if (ZOPT.OPT->BEF[b].id == 160) ZOPT.OPT->MAILOUT_LEV = ZOPT.OPT->BEF[b].ex;	  /* MAIL/BRIEF		 */
/*	if (ZOPT.OPT->BEF[b].id == 125) ZOPT.OPT->ADMIN_LEV = ZOPT.OPT->BEF[b].ex;	  ADMIN		 */
	if (ZOPT.OPT->BEF[b].id == 230) ZOPT.OPT->WRITE_EX_LEV = ZOPT.OPT->BEF[b].ex;   /* WRITE/SCHREIBEN */
	if (ZOPT.OPT->BEF[b].id == 230) ZOPT.OPT->WRITE_IN_LEV = ZOPT.OPT->BEF[b].in;	  /* WRITE/SCHREIBEN	*/
	if (ZOPT.OPT->BEF[b].id == 998) ZOPT.OPT->WRITE_INTERNAT = ZOPT.OPT->BEF[b].in; /* ~MAIL_DUMMY	*/
	if (ZOPT.OPT->BEF[b].id == 195) ZOPT.OPT->PD_D_LEV = ZOPT.OPT->BEF[b].in;       /* ~PD		*/
	if (ZOPT.OPT->BEF[b].id == 195) ZOPT.OPT->PD_U_LEV = ZOPT.OPT->BEF[b].ex;	  /* ~PD		*/
	if (ZOPT.OPT->BEF[b].id == 240) ZOPT.OPT->EXE_LEV = ZOPT.OPT->BEF[b].ex;	  /* EXEC/SHELL		*/
/*	if (ZOPT.OPT->BEF[b].id == 320) GUEST_LEV = ZOPT.OPT->BEF[b].in;	  VERSION		*/
	if (ZOPT.OPT->BEF[b].id == 130) ZOPT.OPT->BB1 = b;
	if (ZOPT.OPT->BEF[b].id == 150) ZOPT.OPT->BB2 = b;
	if (ZOPT.OPT->BEF[b].id == 160) ZOPT.OPT->BB3 = b;
	if (ZOPT.OPT->BEF[b].id == 170) ZOPT.OPT->BB4 = b;
	if (ZOPT.OPT->BEF[b].id == 210) ZOPT.OPT->BB5 = b;
	if (ZOPT.OPT->BEF[b].id == 180) ZOPT.OPT->BB6 = b;
	if (ZOPT.OPT->BEF[b].id == 190) ZOPT.OPT->BB7 = b;
	if (ZOPT.OPT->BEF[b].id == 200) ZOPT.OPT->BB8 = b;
	if (ZOPT.OPT->BEF[b].id == 270) ZOPT.OPT->BB9 = b;

	if((ok == 1) && (ZOPT.OPT->BEF[b].prototyp == 1) && (udcc[0] < ZOPT.OPT->BEF[b].befehl[0])){
		ZOPT.OPT->BEF[(b+1)].id = ZOPT.OPT->BEF[b].id;
		ZOPT.OPT->BEF[(b+1)].in = ZOPT.OPT->BEF[b].in;
		ZOPT.OPT->BEF[(b+1)].ex = ZOPT.OPT->BEF[b].ex;
		ZOPT.OPT->BEF[(b+1)].prototyp = ZOPT.OPT->BEF[b].prototyp;
		strcpy(ZOPT.OPT->BEF[(b+1)].befehl, (UNSIGNED char *) ZOPT.OPT->BEF[b].befehl);
		ZOPT.OPT->BEF[b].id = 1000;
		ZOPT.OPT->BEF[b].in = udcl;
		ZOPT.OPT->BEF[b].ex = udcl;
		ZOPT.OPT->BEF[b].prototyp = 1;
		strcpy(ZOPT.OPT->BEF[b].befehl, (UNSIGNED char *) udcc);
		strcpy(ZOPT.OPT->BEF[b].pfad, (UNSIGNED char *) udcp);
		 b++;
		if(fgets(s, STRING, ff) == NULL) ok = 0;
		sscanf(s, "%s %d %s %s", udcc, &udcl, udcp, t);
		if(udcc[0] > 96) udcc[0] -= 32;
		strcat(udcp, " "); strcat(udcp, t);
	}

	b++;
	if (b >= MAX_BEF) {
		nerror("main.c", 85, "init", "Definition MAX_BEF", "to small");
	}
  }
  ZOPT.OPT->BEF[b].id = -1;

  fclose(fp);
  fclose(ff);
/*  _init_sfileman();*/
}


#ifdef SFILEMAN_USED 
void _init_sfileman()
{

  FILE *fp=NULL;
  FILE *ff=NULL;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char udcc[STRING];
  int udcl;
  UNSIGNED char udcp[STRING];
  int b = 0;
  int ok = 0;

  chdir(ZOPT.OPT->HOME);

  fp = fopen(SFILE_BEFEHLE, "r");
  if (fp == NULL) {
	printf("\n%s\n\n",  GetText("MAI02aMSG"));
	exit( 0 );
  }
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%d %d %d %d %s", &ZOPT.OPT->SBEF[b].id, &ZOPT.OPT->SBEF[b].in, &ZOPT.OPT->SBEF[b].ex, 
  &ZOPT.OPT->SBEF[b].prototyp, ZOPT.OPT->SBEF[b].befehl) > 0) 
  {
         /* 
	if (SBEF[b].id == 270) BB9 = b;
         */
	if((ok == 1) && (ZOPT.OPT->SBEF[b].prototyp == 1)&& (udcc[0] < ZOPT.OPT->SBEF[b].befehl[0])){
		ZOPT.OPT->SBEF[(b+1)].id = ZOPT.OPT->SBEF[b].id;
		ZOPT.OPT->SBEF[(b+1)].in = ZOPT.OPT->SBEF[b].in;
		ZOPT.OPT->SBEF[(b+1)].ex = ZOPT.OPT->SBEF[b].ex;
		ZOPT.OPT->SBEF[(b+1)].prototyp = ZOPT.OPT->SBEF[b].prototyp;
		strcpy(ZOPT.OPT->SBEF[(b+1)].befehl, (UNSIGNED char *) ZOPT.OPT->SBEF[b].befehl);
		ZOPT.OPT->SBEF[b].id = 1000;
		ZOPT.OPT->SBEF[b].in = udcl;
		ZOPT.OPT->SBEF[b].ex = udcl;
		ZOPT.OPT->SBEF[b].prototyp = 1;
		strcpy(ZOPT.OPT->SBEF[b].befehl, (UNSIGNED char *) udcc);
		strcpy(ZOPT.OPT->SBEF[b].pfad, (UNSIGNED char *) udcp);
		b++;
		if(fgets(s, STRING, ff) == NULL) ok = 0;
		sscanf(s, "%s %d %s %s", udcc, &udcl, udcp, t);
		if(udcc[0] > 96) udcc[0] -= 32;
		strcat(udcp, " "); strcat(udcp, t);	
	}

	b++;
	if (b >= MAX_BEF) {
		nerror("main.c", 85, "init_sfileman", "Definition MAX_BEF", "to small");
	}
  }
  ZOPT.OPT->SBEF[b].id = -1;

  fclose(fp);
  fclose(ff);
}

#endif




/* #FO - Where to store/display log information. */

void fixoutput()
{
  UNSIGNED char s[STRING];

  FILE *fp;

  strcpy(s, CONSOLE); 

  if(strcomp("REDIRECT",CONSOLE) == 0){
	fp = fopen( CDIRECTFL, "r" );
	if(fp != NULL){
		fgets(s, STRING, fp);
		fclose(fp);
		
	}
   }
   strcpy(ZOPT.OPT->CONSOLE_REDIRECT, (UNSIGNED char *) stripped(s));
}




/* #CI - Check the ix/MBox installation */

void do_checkit( s, t )
UNSIGNED char s[], t[];
{
  UNSIGNED char l[LONGSTRING];

  struct stat fst;

  if(t[0] == 0)
	sprintf(l, "%s .............................................", s);
  else
	sprintf(l, "%s [%s] ........................................", s, t);
  l[40] = 0;
  printf("%c%s check", TAB, l);
  if(stat(s, &fst) != 0)
    {
        sprintf(l,"/usr/bin/%s",s);
        if(stat(l, &fst) != 0)
        {
             sprintf(l,"/usr/local/bin/%s",s);
             if(stat(l, &fst) != 0)
             {
                   sprintf(l,"/bin/%s",s);
                   if(stat(l, &fst) != 0)
                   {
                        sprintf(l,"%s/etc/%s",ZOPT.OPT->HOME,s);
                        if(stat(l, &fst) != 0)
                        {
                          sprintf(l,"%s/bin/%s",ZOPT.OPT->HOME,s);
                          if(stat(l, &fst) != 0)
                          {
	                     printf(" - not found!\n");
                     	  } else  printf("ed.\n");                        
                   	} else  printf("ed.\n");
                   } else  printf("ed.\n");
             }else  printf("ed.\n");
        }else  printf("ed.\n");
    }
  else	printf("ed.\n");
}


void do_chperm(uid,gid, s )
int uid,gid;
UNSIGNED char s[];
{
  UNSIGNED char l[LONGSTRING];
  UNSIGNED char t[STRING];

  struct stat fst;

  sprintf(t, "%s/%s", (UNSIGNED char *) ZOPT.OPT->HOME, s);

  sprintf(l, "%s .............................................", t);
  l[28] = 0;
  printf("%c%s check", TAB, l);

  if(stat(s, &fst) != 0){
	printf(" - not found!\n");
  }
  else{
	printf(" UID %d, GID %d, SETUID %d", fst.st_uid, fst.st_gid, fst.st_mode & S_ISUID);  

	if((fst.st_uid == uid) && (fst.st_gid == gid) /*&& (fst.st_mode & S_ISUID)*/)
		printf(" - OK.\n");
	else
		printf(" - WRONG!!!\n");
  }
}

void do_chrange( s, min, max, val )
UNSIGNED char s[];
int min, max;
{
  UNSIGNED char l[LONGSTRING];

  sprintf(l, "%s .............................................", s);
  l[30] = 0;
  printf("%c%s check", TAB, l);
  if((val > min) && (val < max))
	printf("ed.\n");
  else
	printf(" - out of range (%d < %d > %d)\n", min, val, max);
}


void checkit()
{  
  UNSIGNED char s[2*STRING];
  UNSIGNED char l[LONGSTRING];
  UNSIGNED char t[STRING];
 
  int i;

  FILE *fp;



  headline( " CHECKIT " );

  printf("\n1. Terminals\n\n");


  for(i = 1; i < 6; i++){

	switch(i){
		case 1:	strcpy(l, "ansi");
			strcpy(ZOPT.OPT->TERMINAL, "ansi");
			break;
		case 2:	strcpy(l, "vt100");
			strcpy(ZOPT.OPT->TERMINAL, "vt100");
			break;
		case 3: strcpy(l, "vt52");
			strcpy(ZOPT.OPT->TERMINAL, "vt52");
			break;
		case 4: strcpy(l, "unknown");
			strcpy(ZOPT.OPT->TERMINAL, "un");
			break;
		case 5:	strcpy(l, "ansi-color");
			strcpy(ZOPT.OPT->TERMINAL, "ansi-color");
			break;
	}

	strcat(l, " .....................................................");
	l[40]  = 0; 
        printf("%c%s check", TAB, l);

	if(ansi2( "INIT", 0, 0 ) == -1)
		printf(" - not known!\n");
	else
		printf("ed.\n");
  }

  fp = fopen(TERMIS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", TERMIS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while(fgets(s, STRING, fp) != NULL){ 

	if(s[0] < 65) continue;
	sscanf(s, "%s", &t);
	sprintf(l, "%s ...................................................", t);
	l[40]  = 0; 
        printf("%c%s check", TAB, l);

	if(ansi2( "INIT", 0, 0 ) == -1)
		printf(" - not known!\n");
	else
		printf("ed.\n");
  }

  fclose(fp);


  printf("\n");
  more();

  printf("\n\n2. Directories\n\n");

  do_checkit( "./lib", "" );
  do_checkit( "./etc", "" );
  do_checkit( "./usr", "" );
  do_checkit( "./upload", "" );
  do_checkit( "./download", "" );
  do_checkit( "./lib/.find", "" );
  do_checkit( "./lib/.find/.cdrom", "" );
  do_checkit( "./cdrom/sfile", "" );
  do_checkit( "./etc/languages/msg", "" );
  do_checkit( TMP, "TMP" );
  do_checkit( GLOBAL_TMP, "GLOBAL_TMP" );
  /*do_checkit( NEWS, "NEWS" );*/
  do_checkit( MAILDROP, "MAILDROP" );

  printf("\n");
  more();

  printf("\n\n3. Vital Files\n\n");

  do_checkit( "./etc/newsgroups","" );
/*  do_checkit( NNGROUPS, "NNGROUPS" );*/
  do_checkit( ZOPT.OPT->BEFEHLE, "BEFEHLE" );
  do_checkit( SFILE_BEFEHLE, "SFileManager-Befehle");
  do_checkit( ZOPT.OPT->HILFE, "HILFE" );
  do_checkit( ZOPT.OPT->KURZHILFE, "KURZHILFE" );
  do_checkit( SEQ, "SEQ" );
  do_checkit( CALLS, "CALLS" );
  do_checkit( UDBASE, "UDBASE" );
  do_checkit( UDSEQ, "UDSEQ" );

  printf("\n");
  more();
  
  printf("\n\n4. Supporting Tools\n\n");

  do_checkit( RSH, "RSH" );
  /*
  sprintf(s,"%s/%s",ZOPT.OPT->BIN,MB_DAEMON);
  if (ZOPT.OPT->NNTP_ON==0)
    do_checkit( s, "MB_DAEMON" );
  */
  do_checkit( FAVORITE_EDITOR, "FAVORITE_EDITORS" );
  do_checkit( PRINTER, "PRINTER" );
  do_checkit( UUDECODE, "UUDECODE" );
  do_checkit( SX, "SX" );
  do_checkit( RX, "RX" );

  strcpy(s, ZOPT.OPT->TAR);
  i = 0; 
  while((s[i] != ' ') && (s[i] != 0)) i++;
  s[i] = 0;
  do_checkit( s, "TAR" );

  printf("\n\n5. Permissions\n\n");
  do_chperm(ROOT_UID,ROOT_GID, "bin/xmd" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/bbs.update" );
  do_chperm(ROOT_UID,GUEST_GID, "bin/add.newuser" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/lynx" );
  do_chperm(GUEST_GID+1,GUEST_GID, "bin/bbslogd" );
  do_chperm(GUEST_GID+1,GUEST_GID, "bin/qwkd" );
  do_chperm(GUEST_GID+1,GUEST_GID, "bin/uqwk" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/sfileman.index" );
  do_chperm(GUEST_GID+1,GUEST_GID, "bin/bbs_mail" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/bbs.update" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/bbs.list" );
  do_chperm(ROOT_UID,ROOT_GID, "bin/bbs.who" );
  do_chperm(GUEST_GID+1,GUEST_GID, "bin/chatd" );

  printf("\n");
  more();

  printf("\n\n6. Editors [%s]\n\n", EDITORS);
  
  fp = fopen(EDITORS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", EDITORS);
  }
  i = 0;
  while((fgets(s, 2*STRING, fp) != NULL) && (s[0] != '='));

  while (fgets(s,STRING,fp) > 0)
  {
	if (!strpos("bled",s)) {
	  strcpy(s,cut_arg(cut_leer(strings(s))));
	  strcpy(s,(char *) cut_bef(s));
	  do_checkit( s, "" );
	 }
	 else {
	  sprintf(s,"%s/bled",ZOPT.OPT->BIN);
	  do_checkit( s, "" );
	 }
  }
  fclose(fp);


  printf("\n");
  more();

  printf("\n7. Games [%s]\n\n", GAMES);
  
  fp = fopen(GAMES, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", GAMES);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s", t, s) > 0){
	do_checkit( s, "" );
  }
  do_checkit( "/usr/games/fortune", "Fortune" );
  fclose(fp);


  printf("\n");
  more();

  printf("\n8. Packers [%s]\n\n", PACKERS);
  
  fp = fopen(PACKERS, "r");
  if (fp == NULL) {
	nerror("main.c", 100, "intro", "Can't read", PACKERS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s %s %s %s", t, s, t, t, t) > 0){
	do_checkit( s, "" );
  }
  fclose(fp);


  printf("\n");
  more();

  printf("\n9. Dimensions\n\n");
  
  do_chrange( "MAX_PER_NG", 10, 32000, (int) MAX_PER_NG);
  do_chrange( "PRO_ENTRIES", 10, 32000, (int) PRO_ENTRIES);
  do_chrange( "MAX_TERMINALS", 1, 32000, (int) MAX_TERMINALS);
  do_chrange( "MAX_BEF", 99, 1001, (int) MAX_BEF);
  do_chrange( "MAX_MAK", 49, 200, (int) MAX_MAK);

  printf("\n\n");
  init_user( "Returning", 0 );

  printf("\n\n");
}



/* #MA - The mother of all that mess ... */

int bbs_main()
{
  UNSIGNED char s[STRING];
  FILE *fp;
  int i;

  struct stat fst;

  nice(BBS_TASK_PRI);

  setgid(GUEST_GID);		
  setuid(GUEST_GID); 

  if ((getuid()!=GUEST_GID)||(getgid()!=GUEST_GID))
  {
    nerror("bbs.main.c", 792, "bbs_main()", "(UID or GID) != 1000", "invalid BBS-ID, please check you login uid=gid=1000");
  }
  
#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
  setbuf(stdin, NULL);
#endif


  ZOPT.OPT=(struct  GLOBAL_OPT_TYP*) malloc(sizeof(struct  GLOBAL_OPT_TYP)); /*((struct GLOBAL_OPT_TYP *) &OPT);*/
/*  ZOPT.VOPT=malloc(sizeof(struct  VOPT_TYP)); */
  ZOPT.ansi=( struct ANSI_COLOR_TYP *)  malloc(sizeof( struct ANSI_COLOR_TYP));


  if (ZOPT.OPT==NULL) nerror("main.c", 158, "main()", "Can't malloc memory", "(ZOPT.OPT)");
  if (ZOPT.ansi==NULL) nerror("main.c", 158, "main()", "Can't malloc memory", "(ZOPT.ansi)");
  SetAnsiColor(0);

  ReadGBLSetting();

  
  ZOPT.OPT->tree_top=ZOPT.OPT->tree_cur=NULL;
  
#ifdef _PROFILE
  profile( "+" );
#endif

  ZOPT.OPT->ROT13_MODUS   = 0;
  ZOPT.OPT->IP_CAUSED_HUP = 0;

  ReadGBLSetting();
  sprintf(ZOPT.OPT->UUINCOMING,"%s/tmp/.uud",ZOPT.OPT->HOME);
  printf("\n");  
  
  if (chdir(ZOPT.OPT->HOME)!=0)
  {
     	printf("\nserious problem:\n");
	printf("\nbbs-binaries are configured for bbs-home-path:  ");
	printf("\nHOME=\"%s\"!",ZOPT.OPT->HOME);	
	printf("\nYou have to fix this NOW \"~bbs/tbbs.setup\"! RTFM: READ THE README!!!\n\n");
	return -1;
  }; 
  


  ZOPT.OPT->OLDUID = getuid();
  ZOPT.OPT->OLDGID = getgid();
  
  strcpy(ZOPT.OPT->MYNAME, (UNSIGNED char *) "J. Random Loser");
  
  /* nntp - init */
  ZOPT.OPT->last_put[0]=0;
  ZOPT.OPT->nntp_line[0]=0;
  ZOPT.OPT->nntp_rd_fp = NULL;
  ZOPT.OPT->nntp_wr_fp = NULL;
  	ZOPT.OPT->NNTP_ON=
  	ZOPT.NNTP_CHECK_ON=ZOPT.GET_NNTP_CHECK_ON=
  	ZOPT.OPT->ende	=ZOPT.fpid= 0;
  ZOPT.OPT->nrc_list=NULL;
  ZOPT.OPT->act_list=NULL;  
  time((time_t *) &ZOPT.NNTP_TIMEOUT);
  
  strcpy(ZOPT.OPT->BRETT, "PM");  
  
  ZOPT.OPT->S_PLUS=0;
  ZOPT.OPT->CONSOLE_ON=0;
  ZOPT.OPT->RIP_OK=0;
  ZOPT.OPT->dis=NULL;
  ZOPT.OPT->dis_gruppe[0]=0;
  ZOPT.OPT->DQUIT=0;
  ZOPT.OPT->t_init=0;
  ZOPT.OPT->QWK_ANZ=0;  /* Anzahl der QWK-Pakete  im tmp.pfad */
  ZOPT.OPT->CD_HOME=0;
  ZOPT.OPT->ENDE=0;
  ZOPT.OPT->AENDERUNG=0;                      /* BBS-Index-Liste nach Beenden neu oder */
  ZOPT.OPT->INCOMING=0;
  ZOPT.OPT->WAIT_FOR_INDEX=1;                     /* auf index-Daemon warten */
  ZOPT.OPT->QWK_NO_BRK=0;                         /* kein Abbfruch des QWK durch INT */
  
  ZOPT.OPT->act_fd=NULL;
  ZOPT.OPT->ngrem_list=NULL;
  ZOPT.OPT->NEW_NEWSRC=0;
     
  strcpy(ZOPT.OPT->ORGANIZATION, _ORGANIZATION);
  strcpy(ZOPT.OPT->system ,       _SYSTEM);
  strcpy(ZOPT.OPT->UUCPSITE,     _UUCPSITE);
  strcpy(ZOPT.OPT->UUCPID2,      _UUCPID2);
  strcpy(ZOPT.OPT->UUCPID1,      _UUCPID1);
  strcpy(ZOPT.OPT->NAT_DOMAIN1, (unsigned char *) GetASection(0,"[mail_domain]","nat1")); /*_NAT_DOMAIN1*/
  strcpy(ZOPT.OPT->NAT_DOMAIN2, (unsigned char *) GetASection(0,"[mail_domain]","nat2")); /*_NAT_DOMAIN2*/
  strcpy(ZOPT.OPT->NAT_DOMAIN3, (unsigned char *) GetASection(0,"[mail_domain]","nat3")); /*_NAT_DOMAIN3*/

/*
  printf("\ndomain1..3=(%s) (%s) (%s)\n",ZOPT.OPT->NAT_DOMAIN1,ZOPT.OPT->NAT_DOMAIN2,ZOPT.OPT->NAT_DOMAIN1);
  sleep(3);
*/
  
  strcpy(ZOPT.OPT->UUCPBANG,     _UUCPBANG);
  strcpy(ZOPT.OPT->PHONE,        _PHONE);
  strcpy(ZOPT.OPT->LOCATION,     _LOCATION);
  strcpy(ZOPT.OPT->SMARTHOST,    _SMARTHOST);
  strcpy(ZOPT.OPT->NEWS_MINIMUM, _NEWS_MINIMUM);
  strcpy(ZOPT.OPT->NEWS_LEVEL1,  _NEWS_LEVEL1);
  strcpy(ZOPT.OPT->PMS_TTY,      _PMS_TTY);
  strcpy(ZOPT.OPT->GREP,         _GREP);
  strcpy(ZOPT.OPT->UUX,          _UUX); 
  strcpy(ZOPT.OPT->TAR,          _TAR);
  strcpy(ZOPT.OPT->SORTEDCUT,    _SORTEDCUT);
  strcpy(ZOPT.OPT->SECONDCUT,    _SECONDCUT);
  strcpy(ZOPT.OPT->THIRDCUT,     _THIRDCUT);
  ZOPT.OPT->TARIF = (int) _TARIF;
  ZOPT.OPT->NZNT  = (int) _NZNT;
  ZOPT.OPT->NZBT  = (int) _NZBT;
  ZOPT.OPT->RZNT  = (int) _RZNT;
  ZOPT.OPT->RZBT  = (int) _RZBT;
  ZOPT.OPT->WZNT  = (int) _WZNT;
  ZOPT.OPT->WZBT  = (int) _WZBT;
  /*ZOPT.OPT->DIRECT_UPLOAD_LEVEL=16;*/

  ZOPT.OPT->UMLAUT = 0;

  ZOPT.OPT->chat_socket=0;
  ZOPT.OPT->usrproc_top				=NULL;
  ZOPT.OPT->T_ERRMAIL				=0;
  ZOPT.OPT->USE_AREAS				=0;
  ZOPT.OPT->B_MODE				=0;
  ZOPT.OPT->index_on				= 1;
  ZOPT.OPT->time_start=ZOPT.OPT->time_now	=0;
  ZOPT.OPT->SFILEMAN				=0;
  ZOPT.OPT->ende				= 0;   /* BBS 'hochfahren' ... */
  ZOPT.OPT->RELOGIN				= 0;   /* kein RELOGIN */
  ZOPT.OPT->cdrom_test 				= 1;
  ZOPT.OPT->max_art				= 10;
  ZOPT.OPT->max_art_sum 			= 100;
  ZOPT.OPT->qwk_hidden				= 0;
  ZOPT.OPT->qwk_blank				= 1;
  ZOPT.OPT->qwk_usr_daemon 			= 0;
  ZOPT.OPT->max_qwk_pack			= 5;
  ZOPT.OPT->RIP_ON				=0;
  QWK.anz	 				= 10;
  QWK.qwk_group					= 1;
  QWK.qwk_blank					= 1;
  QWK.TL 					= NULL;
  QWK.s_anz					= 1024;
  QWK.packer					= 0;
  QWK.mail					= 1;
  QWK.news					= 1;
  strcpy(ZOPT.OPT->sysop,QWK_SYSOP);
  strcpy(ZOPT.OPT->city,QWK_CITY);
  strcpy(ZOPT.OPT->bbs_id,QWK_BBS_ID);
  


  strcpy(ZOPT.OPT->REFLECT_NG,   _REFLECT_NG);

  if(get_cfg() == -1)
	write_cfg();


  ZOPT.OPT->IM_SYSOP=0;

  if ((getuid()!=GUEST_GID)||(getgid()!=GUEST_GID))
   {
   	printf("\nSerious problem #1 (tty:%s)!\n",ttyname(0));
	printf("\nYour UID/GID is (%d/%d) and not bbs.bbs (%d/%d)! ",getuid(),getgid(),GUEST_GID,GUEST_GID);
	printf("\nPlease login now from getty with \"bbs\"!");	
	printf("\nYou have to fix this NOW! RTFM: READ THE README!!!\n\n");
	return -1;
   }


  if(chdir( TMP ) == -1){
	printf("\nYou have to \"make inst\" first!\n\n");
	return -1;
  }
  chdir( ZOPT.OPT->HOME );

  sprintf(s, "%s/setuid.%d", TMP, getpid());
  fp = fopen( s, "w" );
  if(fp != NULL){
  	fprintf(fp, "Here we go ...");
	fclose(fp);
  }
 
  i = stat(s, &fst);
  unlink( s );
  if(fp == NULL){
	printf("\nSerious problem #2 !\n");
	printf("\nThe [mbox] is owned by (%d.%d)", getuid(), getgid());
	printf("\nand can't write to '%s/tmp'\n",ZOPT.OPT->HOME );		
	printf("\nYou have to fix this NOW! RTFM: READ THE tbbs-README!!!\n\n");
	return -1;
  }
  fp = fopen( UDBASE, "r" );
  if(fp == NULL){
	strcpy(ZOPT.OPT->TERMINAL, "ansi");
	ansi2("INIT", 0, 0);

	headline( MAI03_MSG );
	ansi2("md", 0, 0);
	printf("\n%s", MAI04_MSG);
	printf("\n%s", MAI05_MSG);
	printf("\n%s", MAI06_MSG);
	printf("\n");
	printf("\n%s", MAI07_MSG);
	printf("\n%s", MAI08_MSG);
	printf("\n%s\n\n", MAI09_MSG);
	ansi2("me", 0, 0);

	postfach( "#1" );
	postfach( "#2" );
	printf("\n wait...\n");
	sleep(4);
  }
  else{
	fclose(fp);
  }

  fixoutput();
  ZOPT.OPT->RIP_ON=0;

  StrLog("\nintro()....");
  intro( 0 );
  SetAnsiColor(1);
  get_makros();
  LoadBadWord();
  StrLog("...done");
  ctrlx();
  GetTalkReq();  /* SetTTYPerm */
if (!ZOPT.OPT->RIP_ON)  
{
  control("RIP=FALSE",0);
  StrLog("\nloop()....");StrLog(ZOPT.OPT->BRETT);
  loop();
}  
else 
{	
  control("RIP=TRUE",0);
  StrLog("\nrip_loop()...\n");
   rip_loop();
   printf("\n!|*|#|#|#\n"); fflush(stdout);
} 
WriteNewsrc(0);
sprintf(s,"%s/tmp/dir%d",ZOPT.OPT->HOME,getpid());
rmdir((char *) s);
                        
  logout();
  noctrlx();
  
  ansi("md");
  printf("\n\n%s\n\n",  GetText("MAI11_MSG"));
  ansi("me");
  printf("\e(B"); /* set unix character set */

  return 0;
}







