/* 

   This C source code contains the following functions:

   #CT control()          detailed log of users activities
   #WD whodo()            builds a file for the "who" commands 
   #PF profile()          debugging only - I need it, you don't!

*/


#include <stdio.h>

#ifndef VU
#include "mbox.h"
#include "s_global.h"
#else
#include "../mbox.h"
#include "../s_global.h"
#endif


/*#include <stdlib.h>*/
#include <unistd.h>


#define _DATESTAMP
unsigned char WHATIS[STRING];	/* letzes Kommando: fuer RIPTerm-BadCmd */

/* #CT - Creating a log output.

   The [text] is shown together with terminal port and other data.

   If [mode] is < '99', the output is shown on CONSOLE, otherwise
   it's send to CPRN. See "mbox.h" for further information. */  

FILE *contfp = NULL;

void control(text, mode)
UNSIGNED char text[];
int mode;
{
unsigned char hh[LONGSTRING];

  chdir( ZOPT.OPT->HOME);
  if ((mode < 99)||(mode==199)) {

	if ((ZOPT.OPT->USER.level < ADMIN_LEV)||(mode==199))
	{
	        sprintf(hh,"%s/etc/log/%s.%s",ZOPT.OPT->HOME,ZOPT.OPT->CONSOLE_REDIRECT,ttyna());
		contfp = fopen(hh, "a");
		if (contfp == NULL) 
		{
			printf("\n\n%s [%s]\n\n", GetText("CTL01_MSG"), hh);
			exit(-1);
		}
#ifdef _DATESTAMP
                if ((mode!=199)||(ZOPT.OPT->USER.level<ADMIN_LEV))
		fprintf(contfp, "%s %s >  %s\n", mydate(1), mytime(1),  text);
		 else
		fprintf(contfp, "%s %s >  %s (Admin-Access: Logging-STOP)\n", mydate(1), mytime(1),  text);
#else
		fprintf(contfp, "t-bbs: (%s:) %s\n", ttyna(), text);
#endif
		fflush(contfp);
		fclose(contfp);
	} 

  }
  if (mode == 99) { /* error */
        sprintf(hh,"%s/etc/errlog/%s",ZOPT.OPT->HOME,CPRN);
	contfp = fopen(hh, "a");
	if (contfp == NULL) {
		printf("\n\n%s [%s]\n\n", GetText("CTL01_MSG"), hh);
		exit(-1);
	}
	fprintf(contfp, "\n%s  -  %s\n", mydate(1), mytime(1));
	fprintf(contfp, "t-bbs: (%s:) %s\n", ttyna(), text);
	fflush(contfp);
	fclose(contfp);
  }
}





void zcontrol(text, mode) 
UNSIGNED char text[]; int mode; 
{ 
unsigned char hh[LONGSTRING];

chdir(ZOPT.OPT->HOME); 
if (mode < 99) {

	if(ZOPT.OPT->USER.level < 10){
                sprintf(hh,"%s/etc/errlog/%s",ZOPT.OPT->HOME,ZOPT.OPT->CONSOLE_REDIRECT); 
                contfp= fopen(hh, "a"); 
                if (contfp == NULL) {
			printf("\n\n%s [%s]\n\n", CTL01_MSG, hh); exit(-1);
                        
                        }
		fprintf(contfp, "t-bbs: (%s:) %s\n", ttyna(), text); 
		
		fflush(contfp); fclose(contfp); 
	}

  } if (mode == 99) {
        sprintf(hh,"%s/etc/errlog/%s",ZOPT.OPT->HOME,CPRN); contfp = fopen(hh, "a");
        if (contfp == NULL) {
		printf("\n\n%s [%s]\n\n", CTL01_MSG, hh); exit(-1); }
        fprintf(contfp, "\n%s - %s\n", mydate(1), mytime(1));
        fprintf(contfp, "t-bbs: (%s:) %s\n", ttyna(), text); fflush(contfp);
        fclose(contfp); }
}





/* #WD - Building up a file for later user by "portinfo()".

   The argument [text] contains users latest activity. */

void whodo(text)
UNSIGNED char text[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

chdir(ZOPT.OPT->HOME);
if (strlen(text)>0)
{
  strcpy(WHATIS,text);

  sprintf(s, "%s/etc/spool/whatdoes.%s", ZOPT.OPT->HOME, (UNSIGNED char *) ttyna());
  strcpy(t, (UNSIGNED char *) timereconv( ZOPT.OPT->THISTIME ));
  t[5] = 0;

  fp = fopen(s, "w");
  if (fp == NULL) {
	nerror("control.c", 44, "whodo", "Can't write to", s);
  }
  if (strpos("login",text)==1)
   strcpy(s, "nobody (login)");
  else
   sprintf(s, "%s (%s)", ZOPT.OPT->USER.name, ZOPT.OPT->USER.nick);

  fprintf(fp, "%-32.32s %8.8s   %-5.5s   %s\n%d\n", s, 
  		ttyna(), t, text,getpid()); 
  if  (strpos("login",text)!=1)
  {
  if ((ZOPT.OPT->RIP_ON)||(ZOPT.OPT->S_PLUS)) control(s, 0) ;
  }
  fclose(fp);
 }
  control(text,3); /* natuerlich auch in LOGFILE */
}




/* #PF - Profiling the performance of the C code.

   The call of [function] (contains the name of a C function inside the
   BBS) is dumped. */

FILE *profile_file = NULL;

void profile( function )
UNSIGNED char function[];
{
  if(function[0] == '+'){
	profile_file = fopen( "/tmp/profile", "w" );
	if(profile_file == NULL){
		printf("SHIT");
		exit(0);
	}
	return;
  }

  if(function[0] == '-'){
	fclose( profile_file );
	return;
  }

  fprintf(profile_file, "%s\n", function);  
}
