
/*
 *	%Z% %M%	%I% %D% %Q%
 *
 *	Copyright (C) 1990 by Christian Schlichtherle
 *			      (chriss@attron.ruhr.sub.org)
 *
 *	%M% - C module for getch(S).
 *
 *	"getch" is a DOS and curses(S) like function which reads
 *	a UNSIGNED character and returns immediately without waiting for
 *	newline.
 *
 * 	getch() - Gets a UNSIGNED character.
 * 	This function gets one UNSIGNED character and immediately returns
 * 	without waiting for newline. The UNSIGNED character is not echoed.
 * 	This function can be used best when you want to input only one
 * 	UNSIGNED character within canonical input or if you need this function
 * 	only very rarely.
 * 	EOF is returned on errors or if an ignored signal occured.
 *	
 *	Modificated by andreas@xenox.w.open.de 06/20/92 Xenox
 */
#ifdef  VGA_GRAFIK

#ifdef VU
#include "defs.h"
#else
#include "../defs.h"
#endif

#endif



#include <sys/types.h>
#include <stdio.h>    
#include <errno.h>

#ifndef _SYS7
#include <sys/ioctl.h>

#ifdef _LINUX
#include <termio.h>
#else
#ifdef _BSD
#include <sys/termios.h>
#else
#include <sys/termio.h>
#endif
#endif


#endif 


#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
/*#include <stdlib.h>*/
#include <strings.h>

#ifndef VU
#include "mbox.h"
#include "proto.h"
#undef NOTERM 
#include "s_global.h"
#include "language.h"
#else
#include "../mbox.h"
#include "../proto.h"
#undef NOTERM 
#include "../s_global.h"
#include "../language.h"
#endif

static int	set = 0;
#include <sys/types.h>

#ifdef _LINUX
#include <linux/time.h>
#endif




#ifndef  VGA_GRAFIK
int getch()
{
 return ((int ) bgetch());
}
#endif

int	bgetch()
{
	int	c;

#ifdef _PROFILE
  profile( "bgetch()" );
#endif

	if (!set) {
			/* Get old terminal mode. */
		if (get_oldmode() == -1)
			return (EOF);

		tnew = told;
			/* Don't execute this part anymore. */
		set = 1;
	}

		/* Set new terminal mode. */
	if (set_newmode() == -1)
		return (EOF);

		/* 
		 * Read one character. The orginal function used 
		 * read(0, &c, 1) but getchar is a macro 
		 * and faster. Xenox Fri Jun 19 20:44:46 DST 1992
		 */
	c = getchar();

        set_oldmode();

	return ((int)c);
}





int	hgetch()
{
	int	c;

#ifdef _PROFILE
  profile( "bgetch()" );
#endif

	if (!set) {
			/* Get old terminal mode. */
		if (get_oldmode() == -1)
			return (EOF);

		tnew = told;
			/* Don't execute this part anymore. */
		set = 1;
	}

		/* Set new terminal mode. */
	if (set_newhmode() == -1)
		return (EOF);

		/* 
		 * Read one character. The orginal function used 
		 * read(0, &c, 1) but getchar is a macro 
		 * and faster. Xenox Fri Jun 19 20:44:46 DST 1992
		 */
	c = getchar();

        set_oldmode();

	return ((int)c);
}








int	h_getch()
{
	int	c;


	if (!set) {
		if (get_oldmode() == -1)
			return (EOF);
		tnew = told;
		set = 1;
	}

		/* Set new terminal mode. */
	if (set_new_hidden_mode() == -1)
		return (EOF);

/*	c = getchar();*/
	read(0, (char *) &c, 1) ;

        set_oldmode();

	return ((int)c);
}



#define FALSE 0
#define STDIN stdin
#define TRUE 1

/*
 * read one character from the user
 */
char readc(void) {
/*
    unsigned char ch;
    int readkey = 0, readstdin = 0, readbbs_s;
    fd_set fds;
    int bbs_s=0;
*/    
#ifdef TTTTTTTTTTTT
    while (!readkey) 
    {
        readbbs_s = FALSE;

        FD_ZERO(&fds);
        FD_SET(STDIN, &fds);
        FD_SET(bbs_s, &fds);

        while (select(bbs_s, &fds, NULL, NULL, NULL) == -1);
        if (FD_ISSET(bbs_s, &fds)) readbbs_s = TRUE;
        if (FD_ISSET(STDIN, &fds)) readstdin = TRUE;
    
        if (readstdin) 
        {
            /*line = 1;*/
            ch = getchar();
            
            /* else if (((ch >= 32) && (ch <= 127)) || (ch == 21) ||
                       (ch == 10) || (ch == 13) || (ch == '\t') || (ch == 8)) 
                       {
            */           
            return ch;
            /*
            } else {
                readkey = FALSE;
            }
            */
        }
    }
    /* should never be reached */
    /*assert(FALSE);*/
#endif    
    return  (hgetch()) ;
}