#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>
#include <string.h>

#include "prototypes.h"

int sw_do_alias=0;
int sw_do_zalias=0;
int sw_do_expire=0;
int sw_do_rmail=0;
int sw_do_boerde=0;
int sw_notest=1;
int sw_muell_voll =1;
int sw_do_clean=0;
int sw_muell_on =1;
int sw_do_top=0;
int sw_do_month=0;
int sw_ip_all=0;
int do_qwk=0;
int sw_do_perm=0;

/*
 *  Determine runtime options
 */


void BadFlag (c)
char *c;
{
	fprintf (stderr, "%s: bad flag: %s\n", "bbs.update", c);
	do_help();
	exit (-14);
}





void CommandOptions (argc, argv)
int argc;
char *argv[];
/*
 *  Override options from command line
 */
{
	int i;

        if (argc==1) do_help();
         
	for (i=1; i<argc; i++)
	{
               
                
		switch (argv[i][0])
		{
		
		case '+':
			switch (argv[i][1])
			{
			case 'a':	sw_do_alias = 1;
					break;
			case 'b':	sw_do_zalias = 1;
					break;
					
			case 'e':	sw_do_expire = 1;
					break;
					
			case 'q':	do_qwk = 1;
					break;					
			case 'c':	sw_do_clean = 1;
					break;										
		        
			case 'r':	sw_do_rmail = 1;
					break;	
			case 'x':	sw_do_boerde = 1;
					break;		
			case 'y':	sw_ip_all = 1;
					break;											
			case 'w':	sw_do_top = 1;
					break;	
			case 'v':	sw_do_month = 1;
					break;	
																			
		        case 'f':	sw_muell_on = 0; /*--> ignore!!!! ?? ->0*/ 
					break;		
     					
		        case 'o':	sw_notest = 0;
					break;										
		        case 'd':	sw_muell_voll = 0;
					break;		
		        case 'p':	sw_do_perm = 1;
					break;										
		        

			default:	BadFlag (argv[i]);
					break;
			}
			break;

		case '-':
			do_help();
			break;

		default:
			BadFlag (argv[i]);
			break;
		}
	}


return;
}







void do_help()
{
  
 printf("\n\n+++++ bbs.update v1.2pl8 +++++\n");
 printf("bbs-update-daemon for tbbs-project                     <runge@nina.boerde.de>\n");
 printf("-----------------------------------------------------------------------------\n");
 printf("possible options:\n");
 
 printf("misc:\n");
 printf("+a       automatic-update for bbs-entry (in '/etc/aliases')\n");
 printf("+o       for a-option: test for more (multiple) user-entrys \n"); 
 printf("+b       bbs-entry with Nickname; additional (in '/etc/aliases')\n");
 printf("+c       check (is a bbs-user oneline?) and clear all bbs-tmp-files\n");
  
 
 printf("user-expire:\n");
 printf("+e       automatic-user-expire (change expire-date by setup)\n");
 printf("+f       for user-expire: enable check for invalid user-entrys\n");
 printf("+d       for user-expire+f-option: enable check for call-number/birtday\n");

 printf("statistic:\n");
 printf("+r       make rmail-statitic-mail for postmatster(sysop)\n");
 printf("+q       make qwk/soup-statitic-mail for postmatster(sysop)\n");
 
 printf("for www-cgi:\n");
 printf("+w       make top-caller-statistic (for WWW)\n");
 printf("+v       make mouth-statistic (for WWW)\n");
 
 printf("ip-list (for Lynx):\n");
 printf("+x       update a user-list \"./etc/list.ip_access\" for enable ip-access\n");
 printf("+y       for '+x'-option (enable IN-members+ip-access for all bbs-user)\n");
 printf("-----setup-options-----------------------------------------------------------\n");
 printf("+p       change all permissions (for old bbs-installations) for new bbs-version\n");
 exit(-3);
}




