/*
   This C source code contains the following functions:

   #SC sigcatch()        catch signals to handle them within the BBS
   #LP loop()            main loop of the BBS

   Contact <volkers@unnet.wupper.de> for help! */







   
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>


#include "../mbox.h"
#include "../s_global.h"
#include "../language.h"
#include "../compile.h"
#include "../uqwk/uqwk.h"

#undef ISSUE_RELOG  /* bei dem Relogin auf dem heimischen bbs-terminal auch die issue Info anzeigen */


#define TIMEKILL_USR
#undef NEWPDSOFT  /* neue Rip-FileBase verwenden in Neuhausen */


extern int SFILEMAN;

extern int T_ERRMAIL;
struct stat fst;
int HomePC=0;
extern int USR_WARNUNG;
extern int RELOGIN;






/* #SC - Catch signals and react.

   [sig] tells the number of the signal which leads to this call. */





void RipCityWhodo(arg)
unsigned char *arg;
{
unsigned char kk[STRING];

 sprintf(kk,"%s %s",RIPCITYNAM,arg);
 whodo(kk);
}




void RipHbf()
{
unsigned char s[STRING];

 RipCityWhodo(GetText("RIP150"));
 sprintf(s,"%s/%s/city/hbf/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 printf("!|@C81H%s\n",ZOPT.OPT->system);
 sprintf(s,"%s/%s/city/hbf/2",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);

 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);  
 
}






void RipCityAktiv()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP151"));
 sprintf(s,"%s/%s/city/aktiv/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}





void RipCityBoerse()
{

unsigned char s[STRING];
 RipCityWhodo(GetText("RIP152"));
 sprintf(s,"%s/%s/city/boerse/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCityUBahn()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP153"));
 sprintf(s,"%s/%s/city/ubahn/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}





void RipCityEWA()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP154"));
 sprintf(s,"%s/%s/city/ewa/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCityCafe()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP155"));
 sprintf(s,"%s/%s/city/cafe/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCityHaus()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP156"));
 sprintf(s,"%s/%s/city/haus/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void RipCityCenter()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP157"));
 sprintf(s,"%s/%s/city/zentrum/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}

void RipCityCenter2()
{
unsigned char s[STRING];

 RipCityWhodo(GetText("RIP158"));
 sprintf(s,"%s/%s/city/zent2/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void RipCityEpcot()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP159"));
 sprintf(s,"%s/%s/city/epcot/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}





void RipCityEpcot1()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP160"));
 sprintf(s,"%s/%s/city/epcot1/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}





void RipCityGang()
{
unsigned char s[STRING];
 RipCityWhodo(GetText("RIP161"));
 sprintf(s,"%s/%s/city/gang/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void RipCityGallerie()
{
unsigned char _s[STRING];

 RipCityWhodo(GetText("RIP162"));
 sprintf(_s,"%s/%s/gallerie/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,_s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void Rip_Raum(raum)
int raum;
{
unsigned char _s[STRING];

 RipCityWhodo(GetText("RIP162"));
 sprintf(_s,"%s/%s/city/gallerie.raeume/",ZOPT.OPT->HOME,RIPDIR);
 printf("\n!|E|1K|=0000001|S036|W0|*\n");
 switch (raum)
 {
 case 1:strcat(_s,"r1");
 	break;
 case 2:strcat(_s,"r2");
 	break;
 case 3:strcat(_s,"r3");
 	break;
 case 4:strcat(_s,"r4");
 	break;
 case 5:strcat(_s,"r5");
 	break;
 case 6:strcat(_s,"r6");
 	break;
 case 15:strcat(_s,"boom");
 	break;
 case 100:strcat(_s,"g1");
 	break; 	
 case 101:strcat(_s,"g2");
 	break;
 case 201:Rip_Bild(1);
 	  break;
 case 202:Rip_Bild(2);
 	  break; 	  
 case 203:Rip_Bild(3);
 	  break; 	  
 case 204:Rip_Bild(4);
 	  break; 	  
 case 205:Rip_Bild(5);
 	  break; 	  
 case 206:Rip_Bild(6);
 	  break; 
 case 207:Rip_Bild(7);
 	  break; 	  	  
 case 208:Rip_Bild(8);
 	  break; 	  
 case 209:Rip_Bild(9);
 	  break; 	  
 case 210:Rip_Bild(10);
 	  break; 	   	  
 case 211:Rip_Bild(11);
 	  break; 	   	  
 }

 RipPrintFile(0 /* cat-mode*/,_s);
 chdir(ZOPT.OPT->HOME);
 if (raum!=15) gets(ZOPT.OPT->ripcmd); else strcpy(ZOPT.OPT->ripcmd,"r1^m");
}


void RipCityShopping()
{
 RipCityWhodo(GetText("RIP163"));
 NoImpl("Oneline-Shopping Support ");
}

void RipCityMusikHall()
{
 RipCityWhodo(GetText("RIP164"));
 NoImpl("MusikHall-Support ");
}


void RipCityInfoCenter()
{
 RipCityWhodo(GetText("RIP165"));
  NoImpl("CityInfoCenter-Support ");
}

int RipTestCity(akt)
int akt;  /* aktivitaet, ob Rip-Screen, oder nur Abbruch */
{
unsigned char _s[STRING];

sprintf(_s,"%s/%s/city",ZOPT.OPT->HOME,RIPDIR);
if (!chdir((char *) _s)) {
			return(1);
  }			
if (!akt) return(0);
sprintf(_s,"%s/%s/barrier/Mediapolis",ZOPT.OPT->HOME,RIPDIR);
RipPrintFile(0 /* cat-mode*/,_s);
return(0);
}


void RipCityGemeinde()
{
unsigned char s[STRING];

  RipCityWhodo(GetText("RIP166"));
 sprintf(s,"%s/%s/city/gemeinde/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}











void RipCityHbfIntro()
{
 RipCityWhodo(GetText("RIP167"));
 printf("\n!|1K|*|1I1O3T010108EARTH3.ICN|1C0U5U463M0|c0E|1P1O3T000|1P1O3M000|1P1S3F000|1P1W38000|1P2431000|1P2C2U000|1P2O2N000|1P302G000|1P3G29000|1P4422000|1P4S1V000|1P5G1S000|1P641Q000|1P6K1O000|1P701O000\n");
 printf("!|1P7G1O000|1P7W1Q000|1P8K1S000|1P981V000|1P9W22000|1PAC29000|1PAS2G000|Y08000400|1PB42N000|1PBG2U000|1PBO31000|1PBW38000|1PC03F000|@342JHerzlich willkommen in|1PC43M000|1PC43T000|1PC640000|1PC447000\n");
 printf("!|1PC44E000|1PC04L000|1PBW4S000|1PBO4Z000|1PBG56000|1PB45D000|1PAS5K000|1PAC5R000|1P9W5Y000|1P9865000|1P8K68000|1P7W6A000|1P7G6C000|1P706C000|1P6K6C000|1P6468000|1P5G68000|1P4S65000|1P445Y000\n");
 printf("!|1P3G5R000|1P305K000|1P2O5D000|1P2C56000|1P244Z000|1P1W4S000|1P1O4E000|1P1O47000|1P1M40000|W00|=00000001|c09|Y08000500\n");
 printf("!|@5O45%s|S0100|B0000100T|B1B002A10|c0E|Y02000500\n",ZOPT.OPT->system);
 printf("!|@4I5FExperimental Prototype   City Of Tomorrow|L935R9Q5R\n");
 printf("!|1M000C7Y4Z911100000cm_haus^m|1B000002007K030F000F080700000F07000000\n");
 printf("!|1U0E804Y900000<><>|1C007U5A9P0|1M01CT7YHG911100000cm_ewa^m|1PCH7U000\n");
 printf("!|1M026M7YB9911100000cm_hbf^m|1P6A7U000|c00|Y01000200|@1386 Wohnung\n");
 printf("!|Y01000100|@7O7YMediopolis|@768FHauptbahnhof|@DT7XEinwohner|@DT8Dmeldeamt\n");
 printf("!|w00152J1611|#|#|#\n");

 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}








void RipCityGemeind()
{
unsigned char s[STRING];

 RipCityWhodo(GetText("RIP168"));
 
 sprintf(s,"%s/%s/city/gemeind/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}


void RipCityNeuhausen()
{

unsigned char s[STRING];

 RipCityWhodo(GetText("RIP169"));
 sprintf(s,"%s/%s/city/neuhausen/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCityEWAEntry()
{
/*  NoImpl("Einwohnermeldeamt noch nicht verwirkicht");*/
 RipCityWhodo(GetText("RIP170"));
 Rip_Setup();
}


void RipCityWahlBuero()
{
RipCityWhodo(GetText("RIP171"));
  NoImpl("WahlBuero noch nicht verwirkicht");
}



void RipCityBeschlussBuero()
{
RipCityWhodo(GetText("RIP172"));
  NoImpl("Beschluss-Buero noch nicht verwirkicht");
}



void RipCityEinwohnerPolitik()
{
RipCityWhodo(GetText("RIP173"));
  NoImpl("Einwohnerpolitik noch nicht verwirkicht");
}




void RipCitySenat()
{
RipCityWhodo(GetText("RIP174"));
  NoImpl("Senat noch nicht verwirkicht");
}

void RipCityHilfe()
{
RipCityWhodo(GetText("RIP175"));
 NoImp("Hilfe zu den Rip-Grafiken (Beschreibungen)"); 
}



void RipCityKontaktBoerse()
{
RipCityWhodo(GetText("RIP176"));
 NoImp("Kontakt-Boerse-Option"); 
}



void RipCityOneLineHilfe()
{
RipCityWhodo(GetText("RIP177"));
  NoImp("OneLine-Hilfe zu Stadtsystem"); 
}





void RipCityPost()
{
unsigned char s[STRING];

RipCityWhodo(GetText("RIP178"));

 sprintf(s,"%s/%s/city/post/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCityKontakt()
{
unsigned char s[STRING];

RipCityWhodo(GetText("RIP179"));

 sprintf(s,"%s/%s/city/kontakt/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}




void RipCitySoftShop()
{
unsigned char s[STRING];
RipCityWhodo(GetText("RIP180"));

 sprintf(s,"%s/%s/city/software/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void RipCityHomePC()
{
unsigned char s[STRING];

RipCityWhodo(GetText("RIP181"));

 sprintf(s,"%s/%s/city/home.pc/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
}



void RipCityWohnung()
{
unsigned char s[STRING];

RipCityWhodo(GetText("RIP182"));
 sprintf(s,"%s/%s/city/wohn/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}


void RipCityAufzug1()
{
unsigned char s[STRING];

RipCityWhodo(GetText("RIP183"));

 sprintf(s,"%s/%s/city/aufzug1/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
 gets(ZOPT.OPT->ripcmd);
}



void RipCityAufzugAnimation()
{
unsigned char s[STRING];

 sprintf(s,"%s/%s/city/aufzug1/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
}

void RipCityAufzugAnimationOeffnen()
{
unsigned char s[STRING];

 sprintf(s,"%s/%s/city/aufzug1.oeffnen/1",ZOPT.OPT->HOME,RIPDIR);
 RipPrintFile(0 /* cat-mode*/,s);
 chdir(ZOPT.OPT->HOME);
}






void RipCityCmd()
{
unsigned char s[STRING];

 ZOPT.OPT->RIPMAIL_ON=0; 
 if (ZOPT.OPT->ripcmd[0]==0) return;
 if (strpos("cm_aktiv",ZOPT.OPT->ripcmd)>0){      /* Aktivitaeten-Plan */
 	                         	RipCityAktiv();
     }  else
 if (strpos("cm_help",ZOPT.OPT->ripcmd)>0) {
 			
 			RipCityHilfe();
 			strcpy(ZOPT.OPT->ripcmd,"cm_hbf");
     } else
 if (strpos("cm_ewa_entry",ZOPT.OPT->ripcmd)>0) {  /* Vorhalle der EWA */
 					RipCityEWAEntry(); 
 					strcpy(ZOPT.OPT->ripcmd,"cm_ewa");
     } else     
 if (strpos("cm_help2",ZOPT.OPT->ripcmd)>0) {
 			RipCityOneLineHilfe();
 			strcpy(ZOPT.OPT->ripcmd,"cm_hbf"); 			
     } else
 if (strpos("cm_kontakt",ZOPT.OPT->ripcmd)>0) {
 					RipCityKontakt(); 
      } else
 if (strpos("cm_zent2",ZOPT.OPT->ripcmd)>0) {
 					RipCityCenter2();
     } else      
 if (strpos("cm_zentrum",ZOPT.OPT->ripcmd)>0) {
 					RipCityCenter();
     } else
 if (strpos("cm_spiele",ZOPT.OPT->ripcmd)>0) {
 					RipCityAufzugAnimationOeffnen();
 					RipCityWhodo(GetText("RIP188"));
 					Rip_Game();
 					strcpy(ZOPT.OPT->ripcmd,"cm_zent2"); 					
     } else
 if (strpos("gin",ZOPT.OPT->ripcmd)>0) {
 					Rip_ViewBilder();
 					strcpy(ZOPT.OPT->ripcmd,"cm_gallerie");     
     } else          
 if (strpos("r1",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(1);
     } else               
  if (strpos("r2",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(2);
     } else          
  if (strpos("r3",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(3);
     } else          
  if (strpos("r4",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(4);
     } else          
  if (strpos("r5",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(5);
     } else          
 if (strpos("r6",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(6);
     } else          
 if (strpos("g1",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(100);
     } else               
 if (strpos("g2",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(101);
     } else               
 if (strpos("b10",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(210);
 					strcpy(ZOPT.OPT->ripcmd,"g2^m");     
     } else    
 if (strpos("b11",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(211);
 					strcpy(ZOPT.OPT->ripcmd,"r3^m");     
     } else    
     
 if (strpos("b1",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(201);
 					strcpy(ZOPT.OPT->ripcmd,"r1^m");     
     } else    
 if (strpos("b2",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(202);
 					strcpy(ZOPT.OPT->ripcmd,"r1^m");     
     } else    
 if (strpos("b3",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(203);
 					strcpy(ZOPT.OPT->ripcmd,"r1^m");     
     } else    
 if (strpos("b4",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(204);
 					strcpy(ZOPT.OPT->ripcmd,"r2^m");     
     } else    
 if (strpos("b5",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(205);
 					strcpy(ZOPT.OPT->ripcmd,"r2^m");     
     } else    
 if (strpos("b6",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(206);
 					strcpy(ZOPT.OPT->ripcmd,"r6^m");     
     } else    
 if (strpos("b7",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(207);
 					strcpy(ZOPT.OPT->ripcmd,"r6^m");     
     } else    
 if (strpos("b8",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(208);
 					strcpy(ZOPT.OPT->ripcmd,"r6^m");     
     } else    
 if (strpos("b9",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(209);
 					strcpy(ZOPT.OPT->ripcmd,"r6^m");     
     } else    
                                                                                                                                                     
 if (strpos("bubble",ZOPT.OPT->ripcmd)>0) {
 					Rip_Raum(15);
 					
     } else          
 if (strpos("cm_gallerie",ZOPT.OPT->ripcmd)>0) {
 					RipCityAufzugAnimationOeffnen();
 					RipCityGallerie();
     } else
 if (strpos("cm_shopping",ZOPT.OPT->ripcmd)>0) {
 					RipCityAufzugAnimationOeffnen();	
 					RipCityShopping();
 					strcpy(ZOPT.OPT->ripcmd,"cm_zent2"); 					
     } else 	 					
 if (strpos("cm_musik",ZOPT.OPT->ripcmd)>0) {
 					RipCityAufzugAnimationOeffnen();
					RipCityMusikHall(); 
 					strcpy(ZOPT.OPT->ripcmd,"cm_zent2"); 					
    } else
 if (strpos("cm_info",ZOPT.OPT->ripcmd)>0) {
 					RipCityAufzugAnimationOeffnen();
					Rip_Info();
 					strcpy(ZOPT.OPT->ripcmd,"cm_zent2"); 					
    } else    					
 if (strpos("cm_Infozent",ZOPT.OPT->ripcmd)>0) {   /* info Center in Kaufhaus */
					RipCityInfoCenter();
					strcpy(ZOPT.OPT->ripcmd,"cm_zent2");
    } else    					    
 if (strpos("cm_reden",ZOPT.OPT->ripcmd)>0) {
 					RipCityCafe();
 					
     } else
 if (strpos("cm_talk",ZOPT.OPT->ripcmd)>0) {      /* Talk / Charter /IRC */  
 					RipCityWhodo(GetText("RIP187"));
 					Rip_Talk();
 					strcpy(ZOPT.OPT->ripcmd,"cm_reden");
     } else
  if (strpos("cm_epcot1",ZOPT.OPT->ripcmd)>0) {
 					RipCityEpcot1(); 
     } else          
  if (strpos("cm_epcot",ZOPT.OPT->ripcmd)>0) {
 					RipCityEpcot(); 
     } else

 if (strpos("cm_gemeinde",ZOPT.OPT->ripcmd)>0) {
 					RipCityGemeinde(); 
     } else
 if (strpos("cm_gemeind",ZOPT.OPT->ripcmd)>0) {
 					RipCityGemeind(); 
     } else
 if (strpos("cm_hbfintro",ZOPT.OPT->ripcmd)>0) {
 					RipCityHbfIntro(); 
     } else     
 if (strpos("cm_wallstr",ZOPT.OPT->ripcmd)>0) {
 					RipCityBoerse();
     } else
 if (strpos("cm_wohnung",ZOPT.OPT->ripcmd)>0) {
 					RipCityWohnung();
     } else     
 if (strpos("cm_ewa",ZOPT.OPT->ripcmd)>0) {
 					RipCityEWA();
     } else
 if (strpos("cm_ubahn",ZOPT.OPT->ripcmd)>0) {
 					RipCityUBahn();
     } else
 if (strpos("cm_byer",ZOPT.OPT->ripcmd)>0) {  /* BBS-logout */
        				ZOPT.OPT->ende=1;					
     } else    
 if (strpos("cm_sysop",ZOPT.OPT->ripcmd)>0) {
 					Rip_MultiUser();
 		        		strcpy(ZOPT.OPT->ripcmd,"cm_epcot1");
    } else
  if (strpos("cm_tools",ZOPT.OPT->ripcmd)>0) {
  					RipCityWhodo(GetText("RIP189"));
 					Rip_Tools();
 		        		strcpy(ZOPT.OPT->ripcmd,"cm_epcot1");
    } else
 if (strpos("cm_haus",ZOPT.OPT->ripcmd)>0) {
 
 					RipCityHaus();
    } else
 if (strpos("cm_an",ZOPT.OPT->ripcmd)>0) {
 					RipCityKontaktBoerse();
 					strcpy(ZOPT.OPT->ripcmd,"cm_kontakt");
    } else
 if (strpos("cm_hbf",ZOPT.OPT->ripcmd)>0) {
			RipHbf(); 
    } else    
 if (strpos("cm_boerse",ZOPT.OPT->ripcmd)>0) {
					RipCityBoerse();
 					strcpy(ZOPT.OPT->ripcmd,"cm_wallstr");			
    } else    
 if (strpos("cm_bank",ZOPT.OPT->ripcmd)>0) {
 					RipCityWhodo(GetText("RIP190"));	
					Rip_Konto(); 
 					strcpy(ZOPT.OPT->ripcmd,"cm_wallstr");								
    } else    
 if (strpos("cm_alias",ZOPT.OPT->ripcmd)>0) { /* alias */
 				Rip_Statistik();
 				strcpy(ZOPT.OPT->ripcmd,"cm_epcot1"); 			
     } else
 if (strpos("cm_statist",ZOPT.OPT->ripcmd)>0) { /* statistik */
 				Rip_Statistik();
 				strcpy(ZOPT.OPT->ripcmd,"cm_epcot1");
     } else
 if (strpos("cm_info",ZOPT.OPT->ripcmd)>0) {  /* user-infos */
 				Rip_BBSStatist1();
 				strcpy(ZOPT.OPT->ripcmd,"cm_epcot1"); 			
     } else
 if (strpos("cm_qwk",ZOPT.OPT->ripcmd)>0) {  /*qwk-support */
 				RipCityWhodo(GetText("RIP191"));
 				Rip_Qwk();
 				strcpy(ZOPT.OPT->ripcmd,"cm_epcot1"); 			
     } else

 if (strpos("cm_gang",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 					RipCityGang(); 
     } else
     
 if (strpos("cm_cal",ZOPT.OPT->ripcmd)>0) {  /* altueller Kalender */
                                        RipClean();
                                        
                                        rip_cal();
 					DrawRipEnter();
 					gets(s);
 					strcpy(ZOPT.OPT->ripcmd,"cm_wohnung");
     } else          
 if (strpos("cm_email1",ZOPT.OPT->ripcmd)>0) {  /* aus Post-Shop */
 					Rip_Mail();
 					strcpy(ZOPT.OPT->ripcmd,"cm_post");
     } else
 if (strpos("cm_email2",ZOPT.OPT->ripcmd)>0) {  /* aus Wohnung */
 					RipCityWhodo(GetText("RIP192"));
 					Rip_Mail();
 					strcpy(ZOPT.OPT->ripcmd,"cm_wohnung");
     } else     
 if (strpos("cm_news2",ZOPT.OPT->ripcmd)>0) {  /* News aus Wohnung */
 					RipCityWhodo(GetText("RIP193"));
 					Rip_News();
 					strcpy(ZOPT.OPT->ripcmd,"cm_wohnung");
     } else     
 if (strpos("cm_homepc",ZOPT.OPT->ripcmd)>0) {  /* PC aus Wohnung */
 					RipCityHomePC();
 					HomePC=1;
 					ZOPT.OPT->USER.terminal=5; /* ANSI fuer RIP */
 					sprintf(ZOPT.OPT->TERMINAL, "ansi-color");
 					init_user("",0);
 					ansi2("mr", 0, 0);
 					printf("\n%s\n\n",GetText("LOP56_MSG")); 
 					ansi2("me", 0, 0);
 					printf("%s\n\n",GetText("LOP57_MSG"));
 					DummyIntro();
 					loop();
 					HomePC=0;
 					strcpy(ZOPT.OPT->ripcmd,"cm_wohnung");
 					ZOPT.OPT->ende=0;
 					ZOPT.OPT->USER.terminal=6; /*wieder zurueck auf RIP */ 
 					init_user(GetText( "ADM97_MSG" ),0);
     } else
 if (strpos("cm_fax",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 					Rip_Fax(); 
 					strcpy(ZOPT.OPT->ripcmd,"cm_post");
     } else
 if (strpos("cm_cityruf",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 					Rip_Cityruf(); 
 					strcpy(ZOPT.OPT->ripcmd,"cm_post");
     } else
     
     
#ifndef NEWPDSOFT     
 if (strpos("cm_test",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_name",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_text",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_down",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
  if (strpos("cm_batch",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_upload",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_bupl",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else    
 if (strpos("cm_fileae",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
 if (strpos("cm_con",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else     
 if (strpos("cm_new",ZOPT.OPT->ripcmd)>0) {  /* aus Software-Shop */
 			RipHbf(); 
     } else
#endif /* NEWPDSOFT*/     
     
 if (strpos("cm_soft",ZOPT.OPT->ripcmd)>0) {  /* Software-Shop */
 					/*RipCitySoftShop(); */
 					Rip_FileBase();
 					strcpy(ZOPT.OPT->ripcmd,"cm_neu");
     } else          
 if (strpos("cm_wahl",ZOPT.OPT->ripcmd)>0) {  /* wahl-Buero */
 					RipCityWahlBuero();
 					strcpy(ZOPT.OPT->ripcmd,"cm_gemeinde");			
     } else
 if (strpos("cm_beschl",ZOPT.OPT->ripcmd)>0) {  /* Beschluss-Buero */
 					RipCityBeschlussBuero();
 					strcpy(ZOPT.OPT->ripcmd,"cm_gemeinde");			
     } else     
  if (strpos("cm_ewpolit",ZOPT.OPT->ripcmd)>0) {  /* aus dem Senat ??? */
 					RipCityEinwohnerPolitik();
 					strcpy(ZOPT.OPT->ripcmd,"cm_gemeinde");			
     } else
 if (strpos("cm_senat",ZOPT.OPT->ripcmd)>0) {  /* ser Senat */
					RipCitySenat();
 					strcpy(ZOPT.OPT->ripcmd,"cm_gemeinde");			 
 } else
 if (strpos("cm_post",ZOPT.OPT->ripcmd)>0) {  /* die Post-Stelle */
 					RipCityPost(); 
     } else     
 if (strpos("intro",ZOPT.OPT->ripcmd)>0) {  /* Intro-Screen */
 					longjmp(ZOPT.OPT->jmpenv,1); 
     } else          
 if (strpos("cm_aufzu1",ZOPT.OPT->ripcmd)>0) {  /* Der Aufzug im City-Zentrum-Kaufhaus */
 					RipCityAufzug1(); 
     } else          
 if (strpos("cm_aufzug",ZOPT.OPT->ripcmd)>0) {  /* Der Aufzug im City-Zentrum-Kaufhaus */
 		        RipCityAufzug1(); 
     } else               
 if (strpos("cm_sto",ZOPT.OPT->ripcmd)>0) {  /* Der Aufzug im City-Zentrum-Kaufhaus */
 			RipCityAufzug1(); 
     } else               
 if (strpos("cm_neu",ZOPT.OPT->ripcmd)>0) {   /* neuhausen */
 					RipCityNeuhausen(); 
     } else RipHbf();    
                               
}


void DummyIntro() 		/* fuer den 'Home-PC' im Haus */
{

  ansi2("so", 0, 0);  /*mr*/
  printf("\n%-14.14s: ", GetGbl("INT01_MSG"));
  ansi2("me", 0, 0);
  printf(" %s", ZOPT.OPT->ORGANIZATION);
	
  ansi2("so", 0, 0);
  printf("\n%-14.14s: ", GetGbl("INT02_MSG"));
  ansi2("me", 0, 0);
  printf(" %s %s %s", VERSION, PATCHLEVEL,AUTOR_0);


  ansi2("so", 0, 0);
  printf("\n%-14.14s: ", GetGbl("INT02a_MSG"));
  ansi2("me", 0, 0);
  printf(" %s", COPYWRITE);


  ansi2("so", 0, 0);
  printf("\n%-14.14s: ", GetGbl("INT03_MSG"));
  ansi2("me", 0, 0);
  printf(" %s\n\n", ZOPT.OPT->system);

#ifdef ISSUE_RELOG
  sprintf(s,"%s/etc/issue",ZOPT.OPT->HOME);
  fp = fopen(s, "r" );  /* issue-info */
  if(fp != NULL){
        sprintf(s,"cat %s/etc/issue",ZOPT.OPT->HOME);
	printf("\n\n");
	ssystem(s);
  }
#endif        
    printf("\n\n%-14.14s: ", GetGbl("GBL04_MSG"));
    printf("%s\n",ZOPT.OPT->USER.name);
    printf("\n%s: ", GetGbl("GBL09_MSG"));
    printf("*********\n");

}