/* tbbs (s_nntp.c) by Sylvio Runge 05/95  

   This C source code contains the following functions:

*/




/*------------ DEBUG-FLAGS !!!! -------------------------------------------*/
#undef NNTP_DEBUG       /* volle debug-Info in allen Files */
#undef NNTP_ART_DEBUG   /* Debug in Article-Funktion */
#undef NNTP_LOG         /* News-Log einschalten -> Debug-Mode */
/*-------------------------------------------------------------------------*/


#undef NCURSES      /* immer */
#define NNTP_ABLE  /* immer */
#define NOTERM  
#include <dirent.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <strings.h>                        
#include <time.h>                           
#include <sys/param.h>                      
#include <sys/socket.h>                     
#include <netinet/in.h>                     
#include <netdb.h>                          
#include <stdarg.h>                         

#include <fcntl.h>
#include <sys/stat.h>
#include <dirent.h>
#include <strings.h>
#include <string.h>
#include <ctype.h>
#include <arpa/inet.h>
                     
#ifndef VU
#include "defs.h"
#include "s_global.h"
#else
#include "../defs.h"
#include "../s_global.h"
#endif


#include <sys/types.h>   


#ifdef _LINUX
#include <linux/time.h>
#endif




#undef EXTERN
#define ALLOCATE

#ifndef VU
#include "uqwk/uqwk.h"
#else
#include "../uqwk/uqwk.h"
#endif





#undef DEBUG
#undef NNTP_DEBUG



/* ANzeige der aktuellen News-Config */
void nn_stat()
{
 headline("News-Config-Status");
 ansi("md");
 printf("\nOptions:\n"); ansi("me");
 printf("nntp-server       : %s\n",ZOPT.news.nntpserver);
 printf("tcp-service (nntp): %s\n",ZOPT.news.nntp_port);
 printf("news-mode         : %d\n",ZOPT.news.news_mode);
 printf("expire-time       : %d (hour)\n",ZOPT.news.difftime/60/60);
 printf("post by           : ");
 if (ZOPT.news.post) printf("inews\n"); 
  else printf("nntp-server\n");
 printf("newsgroup-description-file\n                  : ./etc/newsgroups\n\n");
 ansi("md");
 printf("\nRuntime-Status:\n"); ansi("me"); 
 printf("nntp-login-Message      : %s\n",ZOPT.news.nntp_stat.msg);
 printf("nntp (connect to socket): %d ('0' -> connection to nntp-host lost!)\n",(ZOPT.OPT->NNTP_ON&&1));
 printf("nntp-auth (not impl.)   : %d\n",ZOPT.news.nntp_stat.auth); 
 printf("nntp status ok          : %d\n",ZOPT.news.nntp_stat.ok);
 printf("nntp posting possible   : %d\n",ZOPT.news.nntp_stat.posting);
 printf("articles in curr. group : %d\n",ZOPT.news.nntp_stat.article);

}





int NewsrcUpdateReq()
{
FILE *fd;
time_t istime;
unsigned char s[STRING];
struct stat fst;

SET_NEWS_INHALT;
sprintf(s,"%s/etc/spool/updatereq.%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.id);
 
if ((fd=fopen(s,"r"))==NULL)
{
 unlink(s);
 fd=fopen(s,"w");
 fclose(fd);
 return(1);  
} 
fclose(fd);

stat(s,&fst);
time(&istime);
istime=difftime(istime,fst.st_mtime);  /* ret-time in seconds  */

 if (istime>(3*ZOPT.news.difftime)) { /* update newsrc nach 3 x expire-Zeit... */
   sprintf(s,"%s/etc/spool/updatereq.%d",ZOPT.OPT->HOME,ZOPT.OPT->USER.id);  
   unlink(s);
   fd=fopen(s,"w");
   fclose(fd);
   return(1);  
 } else
 { 
  return(0);
 }
}








int TestTimeDiff(group)
unsigned char *group;
{
FILE *fd;
time_t istime;
unsigned char s[STRING];
struct stat fst;

SET_NEWS_INHALT;
sprintf(s,"%s/tmp/%d/I%s",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,ZOPT.OPT->NG);
 
if ((fd=fopen(s,"r"))==NULL)
{
 return(1);  
} 
fclose(fd);

stat(s,&fst);
time(&istime);
istime=difftime(istime,fst.st_mtime);  /* ret-time in seconds  */

 if (istime>ZOPT.news.difftime) { /* new-index */
   return(1);  
 } else
 { /* und link richtig setzten .... */
   unlink(ZOPT.OPT->INHALT);
   if (link(s,ZOPT.OPT->INHALT)!=0)
    nerror("s_nntp.c", 58, "TestTimeDiff",
     "Permission: Can't move to", ZOPT.OPT->INHALT);
  return(0);
 }
}



int TestActiveTimeDiff()
{
FILE *fd;
time_t istime;
unsigned char s[STRING];
struct stat fst;

sprintf(s,"%s/etc/spool/nntp.server",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))!=NULL)
{
  if (fgets(s,STRING,fd)!=NULL)
  {
   fclose(fd);
   if (strpos(ZOPT.news.nntpserver,s)==0) return(1);
  } else 
  {
   fclose(fd);
   return(1);
  }
} else return(1);


sprintf(s,"%s/etc/spool/active.nntp",ZOPT.OPT->HOME);
if ((fd=fopen(s,"r"))==NULL)
{
 return(1);  
} 
fclose(fd);

stat(s,&fst);
time(&istime);
istime=difftime(istime,fst.st_mtime);  /* ret-time in seconds  */

 if (istime>ZOPT.news.difftime) { /* new-active-index */
   return(1);  
 } else return(0);
}




/* (!nntp):	Testet, ob Index-Lib zu alt ist, und erstellt diese notfalls neu */
/* (nntp) :	Holt tmp-Index ueber nntp, falls zu alt */
void CheckIndexLib(gruppe)
unsigned char *gruppe;
{

void TestLocal()
{
unsigned char s[STRING];
int fpid;


sprintf(s,"%s/lib/%s",ZOPT.OPT->HOME,gruppe);
if (TestTimeDiff(gruppe)) { /* new-index */
   printf("\n%s ..", GetText("MI211_MSG"));
   switch( (fpid = fork()) ){
        case -1 :
		break;
	case  0 :	
		while(1){
		  printf(".");fflush(stdout);
		  sleep(1);
		}	
		break;
	}
   sprintf(s, "%s/%s %s >>/dev/null", ZOPT.OPT->HOME,MB_DAEMON, gruppe);
   ssystem(s);	
    kill( fpid, SIGKILL );
    (void) wait( &fpid );
 }
}


/* ********** main  ***************** */
if ((!ZOPT.OPT->NNTP_ON)&&(ZOPT.news.news_mode==3)) TestLocal();  /* news_direct->Automatic-Mode*/
return;
}



/* trennt NNTP-Msg-No vom String */
char *select_number(char *sp, int *intPtr)
{
int i,c;

if (sp==NULL) 
 { *intPtr=0; return(sp); }
 
  for (i=0;sp[i]!=' ';i++) if (sp[i]==0) break;
  c=sp[i];
  sp[i]=0;
  sscanf(sp,"%d",intPtr);
  sp[i++]=c;
 return sp+i;
}
       





void NntpConnect()
{
if (ZOPT.OPT->IM_SYSOP) return;
    ZOPT.GET_NNTP_CHECK_ON=1;
    time((time_t *) &ZOPT.NNTP_TIMEOUT);
   printf("nntp: connecting to %s ..... ", ZOPT.news.nntpserver);
   fflush(stdout);
   nntp_connect_port(ZOPT.news.nntpserver,NNTP_DEFAULT_DUMMY);
    ZOPT.GET_NNTP_CHECK_ON=0;
    time((time_t *) &ZOPT.NNTP_TIMEOUT);   
#ifdef DEBUG
 sleep(2);
#endif   
}       




void nntp_connect_port(char *server, int _port) 
{

    if (server_init (server, (char *) ZOPT.news.nntp_port, _port)!=-1)   /*!PORT-BUG!*/
    {
     /* server ok .. */
    } else
    {
#ifndef VU
        SetFett();
#endif        
        printf("\n%c%s\n",BELL,NNTP1);
#ifndef VU        
        SetNorm();
#endif        
        fflush(stdout);
        sleep(2);
        if (!ZOPT.NNTP_CHECK_ON)
        {
         ZOPT.OPT->NNTP_ON=0;
         close_server();
        }
        
        return;
    }

    NNTPSetStat();
}

void NNTPClean()
{
do
{
 get_server(&ZOPT.news.nntp_stat.msg,NNTP_STRLEN);
} while (ZOPT.news.nntp_stat.msg[0]!=0);
}


void NNTPSetStat()
{
int _bef; 
if (ZOPT.OPT->IM_SYSOP) return;
get_server(ZOPT.news.nntp_stat.msg,NNTP_STRLEN);

Log(190,"nntp-read",ZOPT.news.nntp_stat.msg); /* read */

if (strpos("INN",ZOPT.news.nntp_stat.msg)!=0) /* check for INN */
{
  Log(190,"nntp-put:","mode reader");
  put_server("mode reader");
  get_server(ZOPT.news.nntp_stat.msg,NNTP_STRLEN);
  Log(190,"nntp-read",ZOPT.news.nntp_stat.msg); /* read stats*/
}
ZOPT.news.nntp_stat.auth=ZOPT.news.nntp_stat.posting=ZOPT.news.nntp_stat.ok=0;

/* setting*/
_bef=atoi((char *) cut_bef(ZOPT.news.nntp_stat.msg));

if (_bef==OK_CANPOST)
{
  ZOPT.news.nntp_stat.ok=1;
  ZOPT.news.nntp_stat.posting=1;
}
else
if (_bef==OK_NOPOST)
{
  ZOPT.news.nntp_stat.ok=1;
  ZOPT.news.nntp_stat.posting=0;
}

if (strpos("auth",ZOPT.news.nntp_stat.msg)!=0)
  ZOPT.news.nntp_stat.auth=1;
  
  
/* output */  
if (ZOPT.news.nntp_stat.posting) Log(190,"set","nntp: posting ok"); /* posting */
  else Log(190,"set","nntp: no posting");
  
if (ZOPT.news.nntp_stat.ok) Log(190,"set","nntp: server ok"); /* server bereit */
  else Log(190,"set","nntp: server failure");
  
}







char *NntpGroup(gruppe)
unsigned char *gruppe;
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

if (ZOPT.OPT->IM_SYSOP) return(NULL);
        sprintf(k,"GROUP %s",gruppe);
        put_server(k);
	get_server(&s,NNTP_STRLEN);
	
	sprintf(k,"nntp: \"GROUP %s\" ->",gruppe); 
#ifdef NNTP_LOG	
	Log(190,k,s); 
#endif 	
	nstat=atoi((char *) cut_bef(cut_leer(s))); /* nntp-status */
	
	if (nstat==OK_GROUP) {	/* Group selected */
	  strcpy(k,(char *) cut_arg(cut_leer(s)));
	  ZOPT.news.nntp_stat.article=atoi((char *) cut_bef(cut_leer(k))); /* Artikel-Anzahl */
	  strcpy(k,(char *) cut_arg(cut_leer(k)));
	  ZOPT.news.nntp_stat.article_von=atoi((char *) cut_bef(cut_leer(k))); /* von Artikel-Nummer */
	  strcpy(k,(char *) cut_arg(cut_leer(k)));
	  ZOPT.news.nntp_stat.article_bis=atoi((char *) cut_bef(cut_leer(k))); /* bis Artikel-Nummer */
	  sprintf(k,"nntp: article:%d, v:%d, t:%d ->",ZOPT.news.nntp_stat.article,
 	    ZOPT.news.nntp_stat.article_von,ZOPT.news.nntp_stat.article_bis); 
#ifdef NNTP_LOG 	    
 	    Log(190,k,s); 
#endif 	    
          strcpy(ZOPT.OPT->NG,gruppe); 	    
          if (TestTimeDiff(gruppe))  NntpList(1,gruppe);
	  return(NULL);
	}
	else {
	 strcpy(k,(char *) cut_arg(cut_leer(s)));
	 switch (nstat)
	 {
	  case ERR_NOGROUP:
	   	sprintf(k,"%s (%s)",GetText("NNTP1"),gruppe);
	        break;
	  case ERR_NOAUTH:/* authorization required for command */
	   	sprintf(k,"%s (%s)",GetText("NNTP2"),gruppe);
	        break;
	 default:
	  	break;
	 }
	 return((char * ) &k);
	}

}





int NntpNext() /* next. Article */
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

if (ZOPT.OPT->IM_SYSOP) return(0);
        sprintf(k,"NEXT\n");
        put_server(k);
        get_server(s,NNTP_STRLEN);
	
	if (atoi(s)==OK_NOTEXT) {/* status ok: No text sent -- stat, next, last */	
	  strcpy(k,(char *) cut_arg(s));
#ifdef NNTP_LOG	  
	  Log(190,"nntp-next:",k);
#endif	  
	  return(atoi(k));
	}
	else {
#ifdef NNTP_LOG	
	 Log(190,"nntp-next:",s);
#endif	 
	 return(0);
	}
}


int NntpPrev() /* prev. Article */
{
int nstat;
static char s[NNTP_STRLEN],k[NNTP_STRLEN];

if (ZOPT.OPT->IM_SYSOP) return(0);
        sprintf(k,"LAST\n");
        put_server(k);
        get_server(s,NNTP_STRLEN);
	
	if (atoi(s)==OK_NOTEXT) {	/*ok:  No text sent -- stat, next, last */	
	  strcpy(k,(char *) cut_arg(s));
#ifdef NNTP_LOG	  
	  Log(190,"nntp-next:",k);
#endif	  
	  return(atoi(k));
	}
	else {
#ifdef NNTP_LOG	
	 Log(190,"nntp-next:",s);
#endif	 
	 return(0);
	}
}




/* mode:   0 -> alle Artikel einschliessen 
           1 -> nur ungelesene Artikel 
 */

void NntpList(mode,group) /* Gruppen-Index-liste*/
int mode ;
unsigned char *group;
{
int i,start;
static FILE *fd;
unsigned char k[NNTP_STRLEN];
struct nrc_ent *nc=NULL;


  if (!ZOPT.OPT->NNTP_ON)
  {
    FMsgBox("nntp-server not responding - no news aviable!");
    return;
  }
  if (ZOPT.OPT->IM_SYSOP) return;
  if ((nc=(struct nrc_ent *) FindRcEntry(ZOPT.OPT->NG))==NULL)
  {
    nerror("pd.c", 264, "NntpList()", "Can't find Handle to nntp-group",group);
    return;
  }
                      
  
sprintf(k,"%s/tmp/%d/I%s",ZOPT.OPT->HOME,ZOPT.OPT->USER.id,ZOPT.OPT->NG);
if (mode==0) unlink(k);

SET_NEWS_INHALT;

if ((fd=fopen(k,"w"))==NULL) 
    nerror("s_nntp.c", 303, "NNTP_List()", "Can't write", k);
    
fprintf(fd,"%s\n",GetText("GBL05_MSG"));
fprintf(fd,"===============================================================================\n");

    if (ZOPT.news.nntp_stat.article!=0)
    {
     start=ZOPT.news.nntp_stat.article_von;
     if (mode) start=nc->hi+1;
     if (nc->hi>ZOPT.news.nntp_stat.article_bis) 
         start=ZOPT.news.nntp_stat.article_bis;

     if (start!=ZOPT.news.nntp_stat.article_bis)
     {
      NNTPSetArticle(start);

      do
      {
         printf("."); fflush(stdout);
         NNTPHead(i,fd); 
      } while ((i=NntpNext())!=0);
     }
    }

    fclose(fd);
    unlink(ZOPT.OPT->INHALT);
    if (link(k,ZOPT.OPT->INHALT)!=0) 
     nerror("s_nntp.c", 458, "NntpList", "Permission: Can't move to", ZOPT.OPT->INHALT);
}



/* schreibt Artikel-Header in TMP */
int NNTPHead(art,lst_fd)
int art;
FILE *lst_fd;
{
int nstat,_art;
static char s[NNTP_STRLEN];
char k[NNTP_STRLEN],tt[NNTP_STRLEN];
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];

if (ZOPT.OPT->IM_SYSOP) return(0);
#ifdef NNTP_DEBUG	  
/*
sprintf(k,"%s/tmp/%d/head",ZOPT.OPT->HOME,ZOPT.OPT->USER.id);
if ((fd=fopen(k,"w"))==NULL) 
    nerror("s_nntp.c", 303, "NNTP_List()", "Can't write", k);
*/    
#endif    
        sprintf(k,"HEAD\n");
        put_server(k);
	get_server(s,NNTP_STRLEN);
#ifdef NNTP_DEBUG		
        sprintf(tt,"\nnntp: \"HEAD\" -> %s\n",s);
	StrLog(tt);  
#endif	
	nstat=atoi((char *) cut_bef(cut_leer(s))); /* nntp-status */
#ifdef NNTP_DEBUG		
	StrLog(s);
#endif	
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
#ifdef NNTP_DEBUG
        StrLog("...nach#5 ");
#endif	
	if (nstat==OK_HEAD) 	/* ok head follow */
	{
	  _art=atoi((char *) cut_bef(cut_leer(s))); /* artikel-Nummer */
	  lines[0]=subject[0]=from[0]=date[0]=0;
#ifdef NNTP_DEBUG
        StrLog("...nach#7 ");
#endif	  
	  while (get_server((char *) s,NNTP_STRLEN))
	  {
	   if (s[0]=='.') break;
	   if (strpos("From",s)==1) strcpy(from,(char *) cut_arg(s)); else
	   if (strpos("Subject",s)==1) strcpy(subject,(char *) cut_arg(s)); else
	   if (strpos("Lines",s)==1) strcpy(lines,(char *) cut_arg(s)); else
	   if (strpos("Date",s)==1) strcpy(date,(char *) cut_arg(s)); 	  
	  } 
#ifdef NNTP_DEBUG
        StrLog("...nach#8 ");
#endif	  
          strcat(from,LEER);  		from[21]=0;
          strcat(subject,LEER);		subject[27]=0;
          strcat(date,LEER);		date[17]=0;
          strcat(lines,LEER);		lines[3]=0;
          sprintf(k,"%d             ",_art); k[5]=0;
	  fprintf(lst_fd,"%s %s %s %s %s\n", k,subject,from,date,lines);
	}
return(0);
}

/*
 * server_init  Get a connection to the remote server.
 *
 *	Parameters:	"machine" is the machine to connect to.
 *			"service" is the service to connect to on the machine.
 *			"port" is the servive port to connect to.
 *
 *	Returns:	-1 on error
 *			server's initial response code on success.
 *
 *	Side effects:	Connects to server.
 *			"nntp_rd_fp" and "nntp_wr_fp" are fp's
 *			for reading and writing to server.
 */

int server_init (machine, service, _port)
	char	*machine;
	char	*service;
	unsigned short _port;
{
	int	sockt_rd, sockt_wr;

if (ZOPT.OPT->IM_SYSOP) return(0);
	sockt_rd = get_tcp_socket (machine, service, _port); 

	if (sockt_rd < 0)
		return (-1);

	/*
	 * Now we'll make file pointers (i.e., buffered I/O) out of
	 * the socket file descriptor.  Note that we can't just
	 * open a fp for reading and writing -- we have to open
	 * up two separate fp's, one for reading, one for writing.
	 */

	if ((ZOPT.OPT->nntp_rd_fp = (FILE *) fdopen (sockt_rd, "r")) == NULL) {
		printf ("\nserver_init: fdopen #1");
		StrLog ("\nserver_init: fdopen #1");
		return (-1);
	}

	sockt_wr = dup (sockt_rd);

	if ((ZOPT.OPT->nntp_wr_fp = (FILE *) fdopen (sockt_wr, "w")) == NULL) {
		printf ("\nserver_init: fdopen #2");
		StrLog ("\nserver_init: fdopen #2");
		ZOPT.OPT->nntp_rd_fp = NULL;		/* from above */
		return (-1);
	}

	/*
	 * Now get the server's signon message
	 */
	/*(void) get_server (ZOPT.OPT->nntp_line, sizeof (ZOPT.OPT->nntp_line));*/
	return (atoi (ZOPT.OPT->nntp_line));
}




/*
 * put_server -- send a line of text to the server, terminating it
 * with CR and LF, as per ARPA standard.
 *
 *	Parameters:	"string" is the string to be sent to the
 *			server.
 *
 *	Returns:	Nothing.
 *
 *	Side effects:	Talks to the server.
 *			Closes connection if things are not right.
 *
 *	Note:	This routine flushes the buffer each time
 *			it is called.  For large transmissions
 *			(i.e., posting news) don't use it.  Instead,
 *			do the fprintf's yourself, and then a final
 *			fflush.
 */

void put_server (string)
	char *string;
{

if (ZOPT.OPT->IM_SYSOP) return;
	fprintf (ZOPT.OPT->nntp_wr_fp, "%s\r\n", string);
	(void) fflush (ZOPT.OPT->nntp_wr_fp);

}


void close_server ()
{
if (ZOPT.OPT->IM_SYSOP) return;
	if (ZOPT.OPT->nntp_wr_fp == NULL || ZOPT.OPT->nntp_rd_fp == NULL)
		return;

	put_server ("QUIT");
	/*(void) get_server (ZOPT.OPT->nntp_line, sizeof (ZOPT.OPT->nntp_line));*/

	(void) fclose (ZOPT.OPT->nntp_wr_fp);
	(void) fclose (ZOPT.OPT->nntp_rd_fp);
}



char *nntp_respcode (respcode)
	int respcode;
{
	static char *text;

	/*
	 * If the last response line matches and has a description, return it
	 */
	if (atoi (ZOPT.OPT->nntp_line) == respcode && strlen (ZOPT.OPT->nntp_line) > 4) {
		return ZOPT.OPT->nntp_line;
	}

	switch (respcode) {
		case 0:
			text = "";
			break;
		case INF_HELP:
			text = "100  Help text on way";
			break;
		case INF_AUTH:
			text = "180  Authorization capabilities";
			break;
		case INF_DEBUG:
			text = "199  Debug output";
			break;
		case OK_CANPOST:
			text = "200  Hello; you can post";
			break;
		case OK_NOPOST:
			text = "201  Hello; you can't post";
			break;
		case OK_SLAVE:
			text = "202  Slave status noted";
			break;
		case OK_GOODBYE:
			text = "205  Closing connection";
			break;
		case OK_GROUP:
			text = "211  Group selected";
			break;
		case OK_GROUPS:
			text = "215  Newsgroups follow";
			break;
		case OK_XMOTD:
			text = "217  News motd file follows";
			break;
		case OK_XINDEX:
			text = "218  Group index file follows";
			break;
		case OK_ARTICLE:
			text = "220  Article (head & body) follows";
			break;
		case OK_HEAD:
			text = "221  Head follows";
			break;
		case OK_BODY:
			text = "222  Body follows";
			break;
		case OK_NOTEXT:
			text = "223  No text sent -- stat, next, last";
			break;
		case OK_NEWNEWS:
			text = "230  New articles by message-id follow";
			break;
		case OK_NEWGROUPS:
			text = "231  New newsgroups follow";
			break;
		case OK_XFERED:
			text = "235  Article transferred successfully";
			break;
		case OK_POSTED:
			text = "240  Article posted successfully";
			break;
		case OK_AUTHSYS:
			text = "280  Authorization system ok";
			break;
		case OK_AUTH:
			text = "281  Authorization (user/pass) ok";
			break;
		case OK_BIN:
			text = "282  binary data follows";
			break;
		case OK_SPLIST:
			text = "283  spooldir list follows";
			break;
		case OK_SPSWITCH:
			text = "284  Switching to a different spooldir";
			break;
		case OK_SPNOCHANGE:
			text = "285  Still using same spooldir";
			break;
		case OK_SPLDIRCUR:
			text = "286  Current spooldir";
			break;
		case OK_SPLDIRAVL:
			text = "287  Available spooldir";
			break;
		case OK_SPLDIRERR:
			text = "288  Unavailable spooldir or invalid entry";
			break;
		case CONT_XFER:
			text = "335  Continue to send article";
			break;
		case CONT_POST:
			text = "340  Continue to post article";
			break;
		case NEED_AUTHINFO:
			text = "380  authorization is required";
			break;
		case NEED_AUTHDATA:
			text = "381  <type> authorization data required";
			break;
		case ERR_GOODBYE:
			text = "400  Have to hang up for some reason";
			break;
		case ERR_NOGROUP:
			text = "411  No such newsgroup";
			break;
		case ERR_NCING:
			text = "412  Not currently in newsgroup";
			break;
		case ERR_XMOTD:
			text = "417  No news motd file";
			break;
		case ERR_XINDEX:
			text = "418  No index file for this group";
			break;
		case ERR_NOCRNT:
			text = "420  No current article selected";
			break;
		case ERR_NONEXT:
			text = "421  No next article in this group";
			break;
		case ERR_NOPREV:
			text = "422  No previous article in this group";
			break;
		case ERR_NOARTIG:
			text = "423  No such article in this group";
			break;
		case ERR_NOART:
			text = "430  No such article at all";
			break;
		case ERR_GOTIT:
			text = "435  Already got that article, don't send";
			break;
		case ERR_XFERFAIL:
			text = "436  Transfer failed";
			break;
		case ERR_XFERRJCT:
			text = "437  Article rejected, don't resend";
			break;
		case ERR_NOPOST:
			text = "440  Posting not allowed";
			break;
		case ERR_POSTFAIL:
			text = "441  Posting failed";
			break;
		case ERR_NOAUTH:
			text = "480  authorization required for command";
			break;
		case ERR_AUTHSYS:
			text = "481  Authorization system invalid";
			break;
		case ERR_AUTHREJ:
			text = "482  Authorization data rejected";
			break;
		case ERR_INVALIAS:
			text = "483  Invalid alias on spooldir cmd";
			break;
		case ERR_INVNOSPDIR:
			text = "484  No spooldir file found";
			break;
		case ERR_COMMAND:
			text = "500  Command not recognized";
			break;
		case ERR_CMDSYN:
			text = "501  Command syntax error";
			break;
		case ERR_ACCESS:
			text = "502  Access to server denied";
			break;
		case ERR_FAULT:
			text = "503  Program fault, command not performed";
			break;
		case ERR_AUTHBAD:
			text = "580  Authorization Failed";
			break;
		default:
			text = "Unknown NNTP response code";
			break;
	}
	return (text);
}




/*
 * get_tcp_socket -- get us a socket connected to the specified server.
 *
 *	Parameters:	"machine" is the machine the server is running on.
 *			"service" is the service to connect to on the server.
 *			"port" is the port to connect to on the server.
 *
 *	Returns:	Socket connected to the server if
 *			all is ok, else -1 on error.
 *
 *	Side effects:	Connects to server.
 *
 *	Errors:		Printed via perror.
 */

int get_tcp_socket (machine, service, _port)
	char	*machine;	/* remote host */
	char	*service;	/* nttp/smtp etc. */
	unsigned short _port;	/* tcp port number */
{
#ifdef NNTP_ABLE
	int	s = -1;
	struct	sockaddr_in _sin;


#ifndef EXCELAN
	struct	servent *getservbyname(), *sp;
	struct	hostent *gethostbyname(), *hp;
#ifdef h_addr
	int	x = 0;
	register char **cp;
	static char *alist[1];
#endif /* h_addr */
	unsigned long inet_addr();
	static struct hostent def;
	static struct in_addr defaddr;
	static char namebuf[256];

	if ((sp = (struct servent *) getservbyname (service, "tcp")) ==  NULL) {
		printf("%s/tcp: Unknown service.\n", service);
		StrLog("?/tcp: Unknown service.\n");
		return (-1);
	}
	/* If not a raw ip address, try nameserver */
	if (!isdigit(*machine) || 
	    (long)(defaddr.s_addr = (long) inet_addr (machine)) == -1) {
		hp = gethostbyname (machine);
	} else {
		/* Raw ip address, fake  */
		(void) strcpy (namebuf, machine);
		def.h_name = (char *) namebuf;
#ifdef h_addr
		def.h_addr_list = alist;
#endif
		def.h_addr = (char *) &defaddr;
		def.h_length = sizeof (struct in_addr);
		def.h_addrtype = AF_INET;
		def.h_aliases = 0;
		hp = &def;
	}
	if (hp == NULL) {
		printf ("\n%s: Unknown host.\n", machine);
		StrLog("\n Unknown host.\n");
		return (-1);
	}

	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = hp->h_addrtype;
	_sin.sin_port = sp->s_port;
#else /* EXCELAN */
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
#endif /* EXCELAN */

	/*
	 * The following is kinda gross.  The name server under 4.3
	 * returns a list of addresses, each of which should be tried
	 * in turn if the previous one fails.  However, 4.2 hostent
	 * structure doesn't have this list of addresses.
	 * Under 4.3, h_addr is a #define to h_addr_list[0].
	 * We use this to figure out whether to include the NS specific
	 * code...
	 */

#ifdef h_addr
	/*
	 * get a socket and initiate connection -- use multiple addresses
	 */

	for (cp = hp->h_addr_list; cp && *cp; cp++) {
		s = socket (hp->h_addrtype, SOCK_STREAM, 0);
		if (s < 0) {
			printf ("socket");
			StrLog("\nSOCK_STREAM: socket-error...");
			return (-1);
		}
		bcopy(*cp, (char *) &_sin.sin_addr, hp->h_length);
		
		if (x < 0) {
			fprintf (stderr, "Trying %s", (char *) inet_ntoa (_sin.sin_addr));
		}
		x = connect (s, (struct sockaddr *) &_sin, sizeof (_sin));
		if (x == 0) {
			break;
		}
		fprintf (stderr, "\nConnection to %s: ", (char *) inet_ntoa (_sin.sin_addr));
		StrLog("\nConnection to...... close");
		(void) close (s);
	}
	if (x < 0) {
		fprintf (stderr, "Giving up...\n");
		if (ZOPT.NNTP_CHECK_ON)
 		 longjmp(ZOPT.OPT->jmpenv, 1);
 		else
		  ZOPT.OPT->NNTP_ON=0;
		return (-1);
	}
#else	/* no name server */
#ifdef EXCELAN
	if ((s = socket (SOCK_STREAM,(struct sockproto *)NULL,&_sin,SO_KEEPALIVE)) < 0) {
		/* Get the socket */
		printf ("socket");
		return (-1);
	}
	bzero((char *) &_sin, sizeof (_sin));
	_sin.sin_family = AF_INET;
	_sin.sin_port = htons (IPPORT_NNTP);
	/* set up addr for the connect */

	if ((_sin.sin_addr.s_addr = rhost (&machine)) == -1) {
		fprintf (stderr, "\n%s: Unknown host.\n", machine);
		return (-1);
	}
	/* And then connect */

	if (connect (s, (struct sockaddr *)&_sin) < 0) {
		printf ("connect");
		StrLog(" connect-err ");
		(void) close (s);
		return (-1);
	}
#else /* not EXCELAN */
	if ((s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
		printf ("\nsocket-error ");
		StrLog("AF_INET: socket-error");
		return (-1);
	}

	/* And then connect */

	bcopy (hp->h_addr, (char *) &_sin.sin_addr, hp->h_length);
	if (connect (s, (struct sockaddr *) &_sin, sizeof (_sin)) < 0) {
		printf("connect");
		StrLog("connect");
		(void) close (s);
		return (-1);
	}

#endif /* !EXCELAN */
#endif /* !h_addr */
	return (s);
#else
	return (-1);
#endif /* NNTP_ABLE */
}




/*
 * get_server -- get a line of text from the server.  Strips
 * CR's and LF's.
 *
 *	Parameters:	"string" has the buffer space for the
 *			line received.
 *			"size" is the size of the buffer.
 *
 *	Returns:	-1 on error, 0 otherwise.
 *
 *	Side effects:	Talks to server, changes contents of "string".
 *			Reopens connection when necessary and requested.
 */


int get_server_line(string, size)
    char *string;
    int size;
{
    register char *cp, *nl;

#ifdef NNTP_DEBUG
        StrLog("\nget_server_line...");
#endif
if (ZOPT.OPT->IM_SYSOP) return(0);

    ZOPT.GET_NNTP_CHECK_ON=1;
    time((time_t *) &ZOPT.NNTP_TIMEOUT);
    
    if (fgets(string, size, ZOPT.OPT->nntp_rd_fp) == NULL) {
	io_error();
	return -1;
    }
    for (cp = string, nl = NULL; *cp != NUL; cp++) {
	if (*cp == CR) {
	    nl = cp;
	    break;
	}
	if (nl == NULL && *cp == NL)
	    nl = cp;
    }
    if (nl != NULL) *nl = NUL;

    ZOPT.GET_NNTP_CHECK_ON=0;
    time((time_t *) &ZOPT.NNTP_TIMEOUT);
    
    
#ifdef NNTP_DEBUG
        StrLog("...done\n");
#endif
        
    return 0;
}



/*
 * get_server: get a response line from the server.
 *
 * 	Returns the numerical value of the reponse, or -1 in case of errors.
 */

int  get_server(string, size)
    char *string;
    int size;
{
if (ZOPT.OPT->IM_SYSOP) return(0);
    if (get_server_line(string, size) < 0)
	return (0);
#ifdef NNTP_ART_DEBUG
   Log(190,"get_server",string);
#endif
     return((int ) strlen(string));
}



int io_error()
{
      ZOPT.OPT->NNTP_ON = 0;
      close_server();
      printf( "\nLost connection to nntp-server");
      return(0);
}






/*
 *  get a response code from the server and return it to the caller
 */

int get_nntp_code ()
{
	char line[NNTP_STRLEN];

	if (get_server (line, NNTP_STRLEN) == -1) {
	        Log(190,"nntp-error: txt_connection_to_server_broken",line);
		printf("nntp-error: txt_connection_to_server_broken\n");
		return(0);
	}
#ifdef NNTP_LOG	
	Log(190,"nntp: get_respcode",line);
#endif	
	return atoi (line);
}





/* schreibt Artikel-Header in TMP */
int NNTPGetArticle(art_no,lst_fd)
int art_no;
FILE *lst_fd;
{
int nstat,_art,richtung;
FILE *fd;
char s[NNTP_STRLEN],k[NNTP_STRLEN];
int c=0;
int ret_art=0;
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];



void NNTPReadArticle()
{
         sprintf(k,"HEAD");
         put_server(k);
         s[0]=0;
         if (get_nntp_code()==OK_HEAD)
         {

          while ((get_server(s,NNTP_STRLEN)!=-1)&& 
                     (!((s[0]=='.')&&(strlen(s)==1)))
               )
          {
           fprintf(lst_fd,"%s\n",s);
          }
         } /* if body ok ..*/
#ifdef NNTP_LOG         
         else Log(190,"nntp: invalid head",s);         
#endif         
         fprintf(lst_fd,"\n"); 
         
         sprintf(k,"BODY");
         put_server(k);
         s[0]=0;
         if (get_nntp_code()==OK_BODY)
         {

          while ((get_server(s,NNTP_STRLEN)!=-1)&& 
                     (!((s[0]=='.')&&(strlen(s)==1)))
               )
          {
           fprintf(lst_fd,"%s\n",s);
          }
          
         } /* if body ok ..*/
#ifdef NNTP_LOG         
         else Log(190,"nntp: invalid body",s);
#endif         
         fclose(lst_fd);
	 
}


#ifdef NNTP_ART_DEBUG
       sprintf(s,"NNTPGetArticle(in:%d)",art_no);
       Log(190,"nntp:",s);
#endif
        sprintf(k,"STAT");
        put_server(k);
	get_server(s,NNTP_STRLEN);
	
	
	nstat=atoi((char *) s); /* nntp-status */
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:",s);
	StrLog(s);
#endif	
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
	if (nstat==OK_NOTEXT) 	/* stat ok? */
	{
	  _art=atoi((char *) s); /* artikel-Nummer */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(%d): stat: article: %d",art_no,_art);
	Log(190,"nntp:",s);
	StrLog(s);
#endif		  


         if (_art==art_no) {
           ret_art=art_no;         
           NNTPReadArticle();
           fclose(lst_fd);  
           return(_art);
         }
                    
         if (_art<art_no) {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (_art<art_no) ->Next");
#endif		           
          do{
           c=NntpNext();
          }
          while ((c<art_no)&&(c!=0));
         } else
         {
          if (_art!=art_no )
          {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (!(_art<art_no)) ->Prev");
#endif	
           do {
            c=NntpPrev();
           }
           while ((c>art_no)&&(c!=0));
          }
         }
         ret_art=c;
         NNTPReadArticle();
                   

        } else
        {    /* stat != OK */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(): stat!=ok");
	Log(190,"nntp:",s);
	StrLog(s);
#endif		
	 printf("\nNNTPGetArticle()-> stat!=ok: %s\n",s);        
        }
fclose(lst_fd);
return(ret_art);
}





/* check, on Artikel da ist oder nicht und setzt NNTP-Server auf Start-Porition */
int NNTPSetArticle(art_no)
int art_no;
{
int nstat,_art,richtung;
FILE *fd;
char s[NNTP_STRLEN],k[NNTP_STRLEN];
int c=0;
int ret_art=0;
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];



        sprintf(k,"STAT");
        put_server(k);
	get_server(s,NNTP_STRLEN);
	
#ifdef NNTP_ART_DEBUG		
	sprintf(k,"nntp: \"STAT\" -> %s",s);  
	StrLog(k);
#endif	
	
	nstat=atoi((char *) s); /* nntp-status */
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:",s);
	StrLog(s);
#endif	
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
	if (nstat==OK_NOTEXT) 	/* stat ok? */
	{
	  _art=atoi((char *) cut_leer(s)); /* artikel-Nummer */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(%d): stat: article: %d",art_no,_art);
	Log(190,"nntp:",s);
	StrLog(s);
#endif		  

         
         if (_art==art_no) return (_art);
/*         
          else
              printf("%s%c",GetText("BLD23_MSG"),CR);
*/                             
         
         if (_art<art_no) {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (_art<art_no) ->Next");
#endif		           
          do{
           c=NntpNext();
          }
          while ((c<art_no)&&(c!=0));
         } else
         {
          if (_art!=art_no )
          {
#ifdef NNTP_ART_DEBUG		
	Log(190,"nntp:","if (!(_art<art_no)) ->Prev");
#endif	
           do {
            c=NntpPrev();
           }
           while ((c>art_no)&&(c!=0));
          }
         }
                   
         return(c);
	 
        } else
        {    /* stat != OK */
#ifdef NNTP_ART_DEBUG		
        sprintf(s,"NNTPGetArticle(): stat!=ok");
	Log(190,"nntp:",s);
	StrLog(s);
#endif		
	 return(0);
        }
    return(art_no);
}


/* Artikel ueber NNTP-senden */
int NntpPost(artikel)
char *artikel;
{
char k[NNTP_STRLEN];
char ss[NNTP_STRLEN];
int i;
FILE *fd;



  if ((fd=fopen(artikel,"r"))==NULL)
  {
   nerror("s_nntp.c", 1158, "NntpPost", "Can't open", artikel);
   return(0);
  }
  fclose(fd);
  if (CheckBadArticle(artikel)) return(-1);  
  
  sprintf(k,"POST");
  put_server(k);
          
  if ((i=get_nntp_code())!=CONT_POST)
   {
    printf("\n%s",nntp_respcode(i));
    return(0);
   }

  fd=fopen(artikel,"r");
  while (fgets(ss,NNTP_STRLEN,fd)!=NULL)
  {
    if (ss[0]=='.') ss[0]=SPACE;
    if (ss[strlen(ss)-1]=='\n') ss[strlen(ss)-1]=0;
    put_server(ss);
  }
  fclose(fd);
  sprintf(k,".");
  put_server(k);
  printf("\nwait for nntp-server responding .....");
  /*
  get_server(k,NNTP_STRLEN);
  printf("\nnntp: %s\n",k);
  */

  if ((i=get_nntp_code())!=OK_POSTED)
  {
   printf("\n%s",nntp_respcode(i));
   return(0);
  }      
  else 
  {
   printf("\n%s\n",nntp_respcode(i));
   return(1);
  }
}





/*#########################################################################
  DISKUSSION-Befehl 
  #########################################################################*/
  
/* fueugt aktuellen Artikel in Disk-Struct ein */  
void AddDis(art,subject,from,date)
 int art;
 char *subject,*from,*date;
{
 struct dis_t *dat,*dat2;
 struct art_list_t *dat3,*dat4;
 
 
 dat=ZOPT.OPT->dis;
 
 while ((dat!=NULL)&&(strpos(subject,dat->dis)!=0)) dat=dat->n;
 
 /* EIntrag existiert noch nicht */

 if (dat==NULL) 
 {
   dat2=(struct dis_t *) malloc(sizeof(struct dis_t));
   dat2->n=NULL; dat2->art=NULL;
   dat2->my=dat2->org=0; 
   strcpy(dat2->autor,from);
   strcpy(dat2->dis,subject);
   dat2->art_id=art;
   
   dat2->art=(void *) malloc(sizeof(struct art_list_t));
   dat3=(struct art_list_t *) dat2->art;
   dat3->n=NULL; dat3->art=art;
   
  dat=ZOPT.OPT->dis;
  if (dat!=NULL)
  {
   while (dat->n!=NULL) dat=dat->n;
   dat->n=dat2;
  } else
  {
    ZOPT.OPT->dis=dat2;
  }

 
 } else 
 { /* Disskussion ist schon aktiv */
 
 printf("B");
   dat4=(void *) malloc(sizeof(struct art_list_t));
   dat4->n=NULL; dat4->art=art; 
   dat3=(struct art_list_t *) dat->art;
   while (dat3->n!=NULL) dat3=dat3->n;
   dat3->n=dat4;
 
 }


  if (!((strpos("Re:",subject)==1)||(strpos("RE:",subject)==1)||
     (strpos("re:",subject)==1))) /* orginal ist da */
  {  
    dat2->org=1;
    strcpy(dat2->dis,subject);
  }
  if (strpos(leer2punkt(ZOPT.OPT->USER.name),from))
    dat2->my=1;

 

}


/* loescht komplette Dis-Struct */
void DisClean()
{
 struct dis_t *dat,*dat2;

 
 dat=ZOPT.OPT->dis;
 while (dat!=NULL)
 {
  dat2=dat;
  dat=dat->n;
  free(dat2);
 }
 ZOPT.OPT->dis=NULL;
}

  
/*
 prueft ob diskussion aktuell ist und baut bei Bedarf
 Diskussion dyn. auf 
*/
void MakeHeapDis(mode)
int mode;
{
struct nrc_ent *nc=NULL;




  if ((nc=(struct nrc_ent *) FindRcEntry(ZOPT.OPT->NG))==NULL)
  {
    nerror("pd.c", 264, "MakeHeapDis()", "Can't find Handle to nntp-group",
     ZOPT.OPT->NG);
    return;
  }
                
                
  if (ZOPT.OPT->dis!=NULL)
  {
    if (1 /*CheckDis()*/ )
    {
     NntpDisList(mode);    
    }
  } 
  else 
  {
   DisClean;
   NntpDisList(mode);
  }
}


/* mode:   0 -> alle Artikel der jeweiligen Gruppe einschliessen 
           1 -> nur Diskussionsrunden, wo man selbst teilnimmt
*/

void NntpDisList(mode) 
int mode ;
{
int i,start;
static FILE *fd;
unsigned char k[NNTP_STRLEN];
struct nrc_ent *nc=NULL;
unsigned char date[NNTP_STRLEN],from[NNTP_STRLEN],subject[NNTP_STRLEN],lines[NNTP_STRLEN];
int art;

void NNTPDisHead()
{
int nstat,_art;
static char s[NNTP_STRLEN];
char tt[NNTP_STRLEN];
struct dis_t dis;


        sprintf(k,"HEAD\n");
        put_server(k);
	get_server(s,NNTP_STRLEN);
	nstat=atoi((char *) cut_bef(cut_leer(s))); /* nntp-status */
	strcpy(s,(char *) cut_arg(cut_leer(s))); 
	if (nstat==OK_HEAD) 	/* ok head follow */
	{
	  _art=atoi((char *) cut_bef(cut_leer(s))); /* artikel-Nummer */
	  lines[0]=subject[0]=from[0]=date[0]=0;
	  while (get_server((char *) s,NNTP_STRLEN))
	  {
	   if (s[0]=='.') break;
	   if (strpos("From",s)==1) strcpy(from,(char *) cut_arg(s)); else
	   if (strpos("Subject",s)==1) strcpy(subject,(char *) cut_arg(s)); else
	   if (strpos("Lines",s)==1) strcpy(lines,(char *) cut_arg(s)); else
	   if (strpos("Date",s)==1) strcpy(date,(char *) cut_arg(s)); 	  
	  } 
          strcat(from,LEER);  		from[21]=0;
          strcat(subject,LEER);		subject[27]=0;
          strcat(date,LEER);		date[17]=0;
          strcat(lines,LEER);		lines[3]=0;
          sprintf(k,"%d             ",_art); k[5]=0;
          AddDis(_art,subject,from,date);
	}
	
	
}


 struct dis_t *dat;
 
 
  dat=ZOPT.OPT->dis;
  if ((dat!=NULL)&&
      (strpos(ZOPT.OPT->dis_gruppe,ZOPT.OPT->NG)==1)
      &&(strpos(ZOPT.OPT->dis_gruppe,ZOPT.OPT->NG)==1)
     ) return ;
     else DisClean();
  strcpy(ZOPT.OPT->dis_gruppe,(char *) ZOPT.OPT->NG);     
     
       



  if ((nc=(struct nrc_ent *) FindRcEntry(ZOPT.OPT->NG))==NULL)
  {
    nerror("pd.c", 264, "NntpDisList()", "Can't find Handle to nntp-group",ZOPT.OPT->dis_gruppe);
    return;
  }
                      
    

    if (ZOPT.news.nntp_stat.article!=0)
    {
     start=ZOPT.news.nntp_stat.article_von;
    

     if (start!=ZOPT.news.nntp_stat.article_bis)
     {
      NNTPSetArticle(start);

      do
      {
         printf("."); fflush(stdout);
         NNTPDisHead(); 
      } while ((i=NntpNext())!=0);
     }
    }

}
