/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*tbstruct.h*/

/*structure for The Board's setup info and rules*/

struct tb_dat{
   char root[80];
   char bin[80];
   char dat[80];
   char log[80];
   char util[80];
   char prompt[80];
   char errlog[80];
   char menu_list[80];
   char logon_disp[80];
   char dir_list[80];
   char sec_list[80];
   char allias_list[80];
};

/*Structure for file area groups*/

struct tb_fgrp{
   int grp_num;
   int ispub;
   int sec;
   char grp_name[40];
   char grp_file[80];
};

/*Structure for File Directories*/

struct tb_fdir{
   int dir_num;
   char dir_name[40];
   char dir_list[80];
   char dir_path[80];
};

struct tb_door{
   int door_num;
   int sec;
   char door_name[40];
   char cmd_line[80];
};

struct tb_menu{
   char command[20];
   char display[80];
   char type;
   char color;
   char menu[5];
   char sec[5];
   char action[80];
};

struct tb_box{
   int xpos;
   int ypos;
   int xlen;
   int ylen;
   int color;
};

/*Structure for Mutt's config file*/
struct mutt_conf{
   char c_default[100];
   char c_hdrdefault[100];
   char c_quoted[100];
   char c_signature[100];
   char c_header_from[100];
   char c_header_subject[100];
   char c_indicator[100];
   char c_error[100];
   char c_status[100];
   char c_tree[100];
   char c_body_url[100];
   char c_body_mail[100];
   char list1[100];
   char list2[100];
   char list3[100];
   char list4[100];
   char list5[100];
   char list6[100];
   char list7[100];
   char list8[100];
   char list9[100];
   char list10[100];
};


