/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/* ipc.c - IPC Routines for TBServer and it's clients */

#include <headers.h>

int open_queue(key_t keyval, int make)
{
   int qid;
   if(make){
      if((qid = msgget(keyval, IPC_CREAT | 0666)) == -1){
	 log_error("open_queue(): Could not create Message Queue");
	 return(-1);
      }
   }
   else{
      if((qid = msgget(keyval, 0)) == -1){
	 log_error("open_queue(): Could not open Message Queue");
	 return(-1);
      }
   }
   
   return(qid);
}

int send_msg(int qid, struct tbmsg *qbuf)
{
   int result, length;
   length = sizeof(struct tbmsg) - sizeof(long);
   if((result = msgsnd(qid,qbuf,length,0)) == -1){
      log_error("Could not send Message");
      return(-1);
   }
   return(result);
}

int read_msg(int qid, long type, struct tbmsg *qbuf, int nowait)
{
   int result,length;
   length = sizeof(struct tbmsg) - sizeof(long);
   if(nowait){
      if((result = msgrcv(qid,qbuf,length,type,IPC_NOWAIT)) == -1){
	 return(-1);
      }
   }
   else{
      if((result = msgrcv(qid,qbuf,length,type,0)) == -1){
	 return(-1);
      }
   }
   return(result);
}


