/*Copyright (C) 1998 Darren Braun
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *   Any comments or questions can be directed to darren@theboard.dyn.ml.org
 */

/*tbsystem.c - The Board's Sysop's Console*/

#include<headers.h>
#include<tbsystem.h>

extern char tb_logon[10][80];
extern char logs[10][80];
extern int displogon_max;
extern char temp_buf[4096];
extern char graphmode;
extern int to_int_return;
extern struct tm *cur_time;
extern time_t cur_rawtime;
extern time_t logon_time;
extern int orig_timeon;
extern struct user_dat user;
extern struct user_stat user2;
extern struct user_dat alt_user;
extern struct user_stat alt_user2;
extern struct user_index user3;
extern int linenum;
extern int time_limit[1002];
extern struct tb_dat dat_main;

int menu_num = 0;
int menu_hist[50];
int menu_max = 1;
int menup_max = 0;
int command_max = 0;
int box_max = 0;
int menu_prv = 0;
char menu_disp[80];
char menu_name[40];
int menu_box_ypos = 1, menu_box_xpos = 1, menu_box_xlen = 10, menu_box_ylen = 5, menu_box_color = 1;
char menus[200][80];
char menusp[200][80];
key_t k_who;
key_t k_ask;
key_t k_yn;
key_t k_chat;
key_t k_page;
key_t k_channel;
int qid_who;
int qid_ask;
int qid_yn;
int qid_chat;
int qid_page;
int qid_channel;
int l_who;
int l_ask;
int l_yn;
int l_chat;
int l_page;
int l_channel;
struct msg_yn s_yn;
struct msg_ask s_ask;
struct msg_who s_who;
struct msg_chat s_chat;
struct msg_page s_page;
struct msg_channel s_channel;
int Node;
struct tb_menu menu_choice[40];
struct tb_box boxes[20];
int chk_pl = 1;



int main(void)
{
   int end;
   signal(SIGTERM,tbc_shutdown);
   signal(SIGHUP,tbc_shutdown);
   system("setterm -term linux");
   tbc_save_term();
   tbc_setup_term();
   /*Read theboard.dat*/
   read_vars();
   /*Read .tbsetup*/
   read_usetup();
   /*Read .tbstat*/
   read_ustats();
   /*Connect to tbserver*/
   connect_tbserver();
   /*Start Loop*/
   start_menu();
   /*Disconnect tbserver*/
   tbc_cleanup();
   return 0;
}


void tbc_shutdown(int sig){
   if(sig == SIGTERM || sig == SIGHUP){
      tbc_cleanup();
      msgctl(qid_channel,IPC_RMID, NULL);
      exit(1);
   }
}


int tbc_cleanup(void){
   disconnect_tbserver();
   printf("%s", cnrm);
   clrscr();
   tbc_reset_term();
   return 0;
}



int connect_tbserver(void)
{
   int a = 0, quit = 0, end = 0;
   char node_name[30], temp[100], node_str[4];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   Node = 1000;
   s_ask.mtype = Node;
   s_ask.req = 2;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, "Logging into System");
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   s_ask.mtype = Node;
   s_ask.req = 8;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   quit = 0;
   while(!quit){
      end = msgrcv(qid_chat, (struct msgbuf *)&s_chat, l_chat, Node, IPC_NOWAIT);
      if(end == -1){
	 quit = 1;
      }
   }
   quit = 0;
   while(!quit){
      end = msgrcv(qid_page, (struct msgbuf *)&s_page, l_page, Node, IPC_NOWAIT);
      if(end == -1){
	 quit = 1;
      }
   }
   return 0;
}


int disconnect_tbserver(void)
{
   char temp[100];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 3;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   return 0;
}



int start_menu(void)
{
   int menu_ypos[20], quit = 0, quitb = 0, a = 0, b = 0, c = 0, end, display1 = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, choice = 0;
   char temp, cmd[41], bg;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   k_page = ftok(dat_main.root, 'e');
   k_channel = ftok(user.homedir, 'a');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   qid_page = msgget(k_page, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   l_page = (sizeof(s_page) - sizeof(long));
   l_channel = (sizeof(s_channel) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 6;
   strcpy(s_ask.name, user.login);
   strcpy(s_ask.activity, "At Main Console");
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   while(!quit){
      if(display1){
	 printf("%s",cnrm);
	 clrscr();
	 box_3d(1,1,50,10,1,1);
	 putcolor(0,'F');
	 ansipos(3,3);printf("(WHO) is Online");
	 ansipos(3,4);printf("(VL) View Logs");
	 ansipos(3,5);printf("(SHOUT) a Message to All Nodes");
	 ansipos(3,6);printf("(AV) Availible for Chat");
	 ansipos(3,7);printf("(UN) Unavailible for Chat");
	 ansipos(3,8);printf("(Q)uit TBSystem");
	 ansipos(1,24);
	 display2 = 1;
	 display1 = 0;
      }
      if(display2){
	 putcolor('0','7');
	 tbc_newline();
	 printf("> ");
	 display2 = 0;
      }
      end = msgrcv(qid_page, (struct msgbuf *)&s_page, l_page, Node, IPC_NOWAIT);
      if(end != -1){
	 cmd[0] = '\0';
	 putcolor('0','E');
	 tbc_newline();
	 printf("\aYou are being paged.\a  Do you want to answer it?\a ");
	 display2 = 1;
	 putcolor('0','F');
	 quitb = 0;
	 c = 0;
	 while(!quitb){
	    printf("\a");
	    c++;
	    temp = tolower(getchar());
	    if(temp != EOF){
	       if(temp == 'Y' || temp == 'y'){
		  quitb = 1;
		  choice = 1;
	       }
	       else{
		  quitb = 1;
		  choice = 0;
	       }
	    }
	    else{
	       if(c > 30){
		  choice = -1;
		  quitb = 1;
	       }
	    }
	 }
	 if(choice == 1){
	    s_page.mtype = s_page.node;
	    s_page.node = 1000;
	    s_page.channel = 1000;
	    s_page.channel_key = k_channel;
	    qid_channel = msgget(k_channel, IPC_CREAT | 0666);
	    msgsnd(qid_page, (struct msgbuf *)&s_page, l_page, 0);
	    end = tbc_chat(s_page.mtype);
	    if(end == 1){
	       s_channel.mtype = s_page.mtype;
	       s_channel.node = Node;
	       strcpy(s_channel.message, "-quit");
	       msgsnd(qid_channel, (struct msgbuf *)&s_channel, l_channel, 0);
	       quitb = 0;
	       while(!quitb){
		  msgrcv(qid_channel, (struct msgbuf *)&s_channel, l_channel, Node, 0);
		  if(!(strcmp(s_channel.message, "-quit"))){
		     quitb = 1;
		  }
	       }
	    }
	    msgctl(qid_channel,IPC_RMID, NULL);
	    display2 = 1;
	    continue;
	 }
	 else if(choice == -1){
	    s_page.mtype = s_page.node;
	    s_page.node = 1000;
	    s_page.channel = -1;
	    msgsnd(qid_page, (struct msgbuf *)&s_page, l_page, 0);
	 }
	 else{
	    s_page.mtype = s_page.node;
	    s_page.node = 1000;
	    s_page.channel = 0;
	    msgsnd(qid_page, (struct msgbuf *)&s_page, l_page, 0);
	 }
	 
      }
      temp = tolower(getchar());
      if(temp != EOF){
	 linenum = 1;
	 if(temp == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp == '\n'){
	    cmd[a] = '\0';
	    end = tbc_docmd(cmd);
	    strcpy(cmd, "");
	    switch(end){
	     case 0:
	       break;
	     case 1:
	       display1 = 1;
	       break;
	     case 2:
	       display2 = 1;
	       break;
	     case 3:
	       display1 = 1;
	       display2 = 1;
	       break;
	     case 4:
	       quit = 1;
	       break;
	     default:
	       display2 = 1;
	       break;
	    }
	    a = 0;
	 }
	 else if(a < 40){
	    cmd[a] = temp;
	    printf("%c",temp);
	    a++;
	 }
      }
      else{
	 if(check_messages()){
	    display2 = 1;
	 }
      }
   }
   
   
   return 0;
}


int tbc_chat(int node_num)
{
   int menu_ypos[20], quit = 0, quitb = 0, a = 0, b = 0, c = 0, end, display1 = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, choice = 0;
   int line1 = 1, line2 = 1;
   char temp, cmd[80], bg;
   strcpy(cmd, "");
   while(!quit){
      if(display1){
	 printf("%s",cnrm);
	 clrscr();
	 box_3d(1,1,79,23,1,1);
	 box_3d(2,2,77,9,1,1);
	 box_3d(2,11,77,9,1,1);
	 box_3d(2,20,77,3,1,1);
	 display2 = 1;
	 display1 = 0;
      }
      if(display2){
	 ansipos(3,21);
	 putcolor('1','F');
	 printf("%.75s",cmd);
	 ansipos(3 + strlen(cmd),21);
	 display2 = 0;
      }
      end = msgrcv(qid_channel, (struct msgbuf *)&s_channel, l_channel, Node, IPC_NOWAIT);
      if(end != -1){
	 if(!(strcmp(s_channel.message, "-quit"))){
	    quit = 2;
	    continue;
	 }
	 if(line2 >= 8){
	    for(b = 1;b < 8;b++){
	       ansipos(3, 11 + b);
	       printf("%75s", " ");
	    }
	    line2 = 1;
	 }
	 ansipos(3,11 + line2);
	 printf("%s", s_channel.message);
	 line2++;
	 display2 = 1;
	 continue;
      }
      temp = getchar();
      if(temp != EOF){
	 linenum = 1;
	 if(temp == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp == '\n'){
	    cmd[a] = '\0';
	    a = 0;
	    ansipos(3,21);
	    putcolor('1','F');
	    printf("%75s"," ");
	    ansipos(3,21);
	    display2 = 1;
	    if(cmd[0] == '-'){
	       if(!(strcmp(cmd, "-quit"))){
		  quit = 1;
		  continue;
	       }
	    }
	    else{
	       if(line1 >= 8){
		  for(b = 1;b < 8;b++){
		     ansipos(3, 2 + b);
		     printf("%75s", " ");
		  }
		  line1 = 1;
	       }
	       ansipos(3,2+line1);
	       printf("%s", cmd);
	       s_channel.mtype = node_num;
	       s_channel.node = Node;
	       strcpy(s_channel.message, cmd);
	       msgsnd(qid_channel, (struct msgbuf *)&s_channel, l_channel, 0);
	       cmd[a] = '\0';
	       line1++;
	    }
	    cmd[a] = '\0';
	 }
	 else if(a < 75){
	    cmd[a] = temp;
	    cmd[a+1] = '\0';
	    printf("%c",temp);
	    a++;
	 }
      }
   }
   
   if(quit == 1){
      return 1;
   }
   
   return 0;
}


int check_my_mail(void)
{
   disp_prompt(10);
   tbc_newline();
   disp_prompt(11);
   tbc_newlines(2);
   tbc_wait();
   putcolor(0,'B');
   tbc_newline();
   system("/usr/games/fortune");
   tbc_newline();
   tbc_wait();
   return 0;
}



int tbc_docmd(char cmd[])
{
   int quit = 0, quitb = 0, a = 0, match = -1, choice = 0;
   time_t cur_time;
   char cmd_line[30], temp[512], temp2[512], site[100], port[10], temp3;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   if(cmd[0] == '\0'){
      return 2;
   }
   if(!(strcmp("m",cmd))){
      toggle_graph();
      return 2;
   }
   if(!(strcmp("help",cmd)) || !(strcmp("?",cmd))){
      return 3;
   }
   if(!(strcmp("clear",cmd)) || !(strcmp("cls",cmd))){
      putcolor('0','7');
      clrscr();
      return 2;
   }
   if(!(strcmp("quit",cmd))){
      putcolor('0','E');
      tbc_newline();
      printf("Are you sure you want to Quit? ");
      putcolor('0','F');
      choice = tbc_getyn();
      if(choice){
	 return 4;
      }
      else{
	 return 2;
      }
   }
   if(!(strcmp("q",cmd))){
      putcolor('0','E');
      tbc_newline();
      printf("Are you sure you want to Quit? ");
      putcolor('0','F');
      choice = tbc_getyn();
      if(choice){
	 return 4;
      }
      else{
	 return 2;
      }
   }
   if(!(strcmp("av",cmd))){
      chat_av();
   }
   if(!(strcmp("un",cmd))){
      chat_un();
   }
   if(!(strcmp("who",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Spying on Nodes");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbs_who();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 2;
   }
   if(!(strcmp("vl",cmd)) || !(strcmp("viewlog",cmd))){
      putcolor('0','E');
      tbc_newlines(2);
      printf("(1) Log of user logons");
      tbc_newline();
      printf("(2) Log of misc actions");
      tbc_newline();
      printf("(3) Log of errors");
      tbc_newlines(2);
      putcolor('0','F');
      printf("Enter Choice: ");
      while(!quitb){
	 temp3 = tolower(getchar());
	 if(temp3 != EOF){
	    quitb = 1;
	    switch(temp3){
	     case '1':
	       printf("%s",cnrm);
	       tbc_newline();
	       tbc_dispfile(logs[2]);
	       tbc_wait();
	       break;
	     case '2':
	       printf("%s",cnrm);
	       tbc_newline();
	       tbc_dispfile(logs[4]);
	       tbc_wait();
	       break;
	     case '3':
	       printf("%s",cnrm);
	       tbc_newline();
	       tbc_dispfile(logs[1]);
	       tbc_wait();
	       break;
	     default:
	       break;
	    }
	 }
      }
	 
      return 2;
   }
   if(!(strcmp("yell",cmd)) || !(strcmp("shout",cmd))){
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "Shouting Something");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      strcpy(temp2, "");
      tbc_newline();
      disp_prompt(90);
      tbc_newline();
      get_input(temp2,450,1,1,1,0,0);
      strcpy(temp, sputcolor(0,'E'));
      strcat(temp, user.login);
      strcat(temp, " just shouted\n    ");
      strcat(temp, sputcolor(0,'B'));
      strcat(temp, temp2);
      strcat(temp, "\n");
      k_ask = ftok(dat_main.root, 'b');
      k_chat = ftok(dat_main.root, 'd');
      qid_ask = msgget(k_ask, 0);
      qid_chat = msgget(k_chat, 0);
      l_ask = (sizeof(s_ask) - sizeof(long));
      l_chat = (sizeof(s_chat) - sizeof(long));
      s_ask.mtype = Node;
      s_ask.req = 5;
      strcpy(s_ask.message, temp);
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      tbc_newline();
      s_ask.mtype = Node;
      s_ask.req = 6;
      strcpy(s_ask.name, user.login);
      strcpy(s_ask.activity, "At Menu Prompt");
      msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
      return 2;
   }
   
   return 2;
}



int tbs_who(void)
{
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 1;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   msgrcv(qid_who, (struct msgbuf *)&s_who, l_who, Node, 0);
   tbc_newlines(2);
   putcolor('0','E');
   printf("PORT       USER                        ACTION");
   tbc_newline();
   putcolor('0','F');
   if((strcmp(s_who.tty1, "Accepting Connections - Local"))){
      printf("TTY1   %.35s %35s",s_who.tty1, s_who.tty1_act);
      tbc_newline();
   }
   if((strcmp(s_who.tty2, "Accepting Connections - Local"))){
      printf("TTY2   %.35s %35s",s_who.tty2, s_who.tty2_act);
      tbc_newline();
   }
   if((strcmp(s_who.tty3, "Accepting Connections - Local"))){
      printf("TTY3   %.35s %35s",s_who.tty3, s_who.tty3_act);
      tbc_newline();
   }
   if((strcmp(s_who.tty4, "Accepting Connections - Local"))){
      printf("TTY4   %.35s %35s",s_who.tty4, s_who.tty4_act);
      tbc_newline();
   }
   if((strcmp(s_who.tty5, "Accepting Connections - Local"))){
      printf("TTY5   %.35s %35s",s_who.tty5, s_who.tty5_act);
      tbc_newline();
   }
   if((strcmp(s_who.tty6, "Accepting Connections - Local"))){
      printf("TTY6   %.35s %35s",s_who.tty6, s_who.tty6_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp0, "Accepting Connections - Telnet"))){
      printf("TTYP0  %.35s %35s",s_who.ttyp0, s_who.ttyp0_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp1, "Accepting Connections - Telnet"))){
      printf("TTYP1  %.35s %35s",s_who.ttyp1, s_who.ttyp1_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp2, "Accepting Connections - Telnet"))){
      printf("TTYP2  %.35s %35s",s_who.ttyp2, s_who.ttyp2_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp3, "Accepting Connections - Telnet"))){
      printf("TTYP3  %.35s %35s",s_who.ttyp3, s_who.ttyp3_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp4, "Accepting Connections - Telnet"))){
      printf("TTYP4  %.35s %35s",s_who.ttyp4, s_who.ttyp4_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp5, "Accepting Connections - Telnet"))){
      printf("TTYP5  %.35s %35s",s_who.ttyp5, s_who.ttyp5_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp6, "Accepting Connections - Telnet"))){
      printf("TTYP6  %.35s %35s",s_who.ttyp6, s_who.ttyp6_act);
      tbc_newline();
   }
   if((strcmp(s_who.ttyp7, "Accepting Connections - Telnet"))){
      printf("TTYP7  %.35s %35s",s_who.ttyp7, s_who.ttyp7_act);
      tbc_newline();
   }
   tbc_newline();
   return 0;
}


int chat_av(void)
{
   char temp[100];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 8;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   tbc_newlines(2);
   putcolor(0,'F');
   printf("You are now availible for chat");
   tbc_newlines(2);
   return 0;
}

int chat_un(void)
{
   char temp[100];
   time_t cur_time;
   k_yn = ftok(dat_main.root, 'a');
   k_ask = ftok(dat_main.root, 'b');
   k_who = ftok(dat_main.root, 'c');
   k_chat = ftok(dat_main.root, 'd');
   qid_yn = msgget(k_yn, 0);
   qid_ask = msgget(k_ask, 0);
   qid_who = msgget(k_who, 0);
   qid_chat = msgget(k_chat, 0);
   l_yn = (sizeof(s_yn) - sizeof(long));
   l_ask = (sizeof(s_ask) - sizeof(long));
   l_who = (sizeof(s_who) - sizeof(long));
   l_chat = (sizeof(s_chat) - sizeof(long));
   s_ask.mtype = Node;
   s_ask.req = 9;
   msgsnd(qid_ask, (struct msgbuf *)&s_ask, l_ask, 0);
   tbc_newlines(2);
   putcolor(0,'F');
   printf("You are now unavailible for chat");
   tbc_newlines(2);
   return 0;
}


int check_messages(void)
{
   int end = 0;
   k_chat = ftok(dat_main.root, 'd');
   qid_chat = msgget(k_chat, 0);
   l_chat = (sizeof(s_chat) - sizeof(long));
   end = msgrcv(qid_chat, (struct msgbuf *)&s_chat, l_chat, Node, IPC_NOWAIT);
   if(end != -1){
      tbc_newline();
      printf("%s", s_chat.message);
      return 1;
   }
   
   return 0;
}


int tbc_user_edit(void)
{
   int quit = 0, quitb = 0, display = 1, display2 = 1, timechk = 0, warned = 0, warned2 = 0, a = 0;
   FILE *fp_user, *fp_stat;
   char cmd[41], temp[80], temp2, home_dir[80], udat_file[80], udat_file2[80], user_name[21];
   write_ustats();
   tbc_newline();
   disp_prompt(70);
   get_input(user_name,20,1,1,0,0,0);
   strcpy(home_dir, "/home/");
   strcat(home_dir, user_name);
   strcat(home_dir, "/");
   strcpy(udat_file, home_dir);
   strcat(udat_file, ".tbsetup");
   fp_user = fopen(udat_file, "r+");
   if(!fp_user){
      disp_prompt(71);
      return 1;
   }
   fseek(fp_user, 0, SEEK_SET);
   fread(&alt_user, sizeof(alt_user), 1, fp_user);
   strcpy(udat_file2, alt_user.homedir);
   strcat(udat_file2, ".tbstat");
   fp_stat = fopen(udat_file2, "r+");
   if(!fp_stat){
      fclose(fp_user);
      disp_prompt(71);
      return 1;
   }
   fseek(fp_stat, 0, SEEK_SET);
   fread(&alt_user2, sizeof(alt_user2), 1, fp_stat);
   quit = 0;
   while(!quit){
      if(display){
	 clrscr();
	 box_3d(2,2,76,20,1,1);
	 ansipos(3,5);
	 putcolor(0,'F');
	 printf("1 ) ");
	 putcolor(0,'E');
	 printf("First Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.fname);
	 ansipos(3,6);
	 putcolor(0,'F');
	 printf("2 ) ");
	 putcolor(0,'E');
	 printf("Last Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.lname);
	 ansipos(3,7);
	 putcolor(0,'F');
	 printf("3 ) ");
	 putcolor(0,'E');
	 printf("User Alias: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.allias);
	 ansipos(3,8);
	 putcolor(0,'F');
	 printf("4 ) ");
	 putcolor(0,'E');
	 printf("Logon Name: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.login);
	 ansipos(3,9);
	 putcolor(0,'F');
	 printf("5 ) ");
	 putcolor(0,'E');
	 printf("Home Directory: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.homedir);
	 ansipos(3,11);
	 putcolor(0,'F');
	 printf("6 ) ");
	 putcolor(0,'E');
	 printf("Street Address: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.saddress);
	 ansipos(3,12);
	 putcolor(0,'F');
	 printf("7 ) ");
	 putcolor(0,'E');
	 printf("City: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.city);
	 ansipos(3,13);
	 putcolor(0,'F');
	 printf("8 ) ");
	 putcolor(0,'E');
	 printf("State: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.state);
	 ansipos(3,14);
	 putcolor(0,'F');
	 printf("9 ) ");
	 putcolor(0,'E');
	 printf("Zip Code: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.zip);
	 ansipos(3,15);
	 putcolor(0,'F');
	 printf("10) ");
	 putcolor(0,'E');
	 printf("H-Phone: ");
	 putcolor(0,'F');
	 printf("%s  ",alt_user.hphone);
	 ansipos(3,16);
	 putcolor(0,'F');
	 printf("11) ");
	 putcolor(0,'E');
	 printf("D-Phone: ");
	 putcolor(0,'F');
	 printf("%s",alt_user.dphone);
	 ansipos(3,17);
	 putcolor(0,'F');
	 printf("12) ");
	 putcolor(0,'E');
	 printf("Security Level: ");
	 putcolor(0,'F');
	 printf("%d",alt_user2.sec);
	 ansipos(1,22);
	 display = 0;
	 display2 = 1;
      }
      if(display2){
	 disp_prompt(50);
	 display2 = 0;
      }
      temp2 = tolower(getchar());
      if(temp2 != EOF){
	 linenum = 1;
	 if(temp2 == ''){
	    if(a >= 1){
	       printf("\b \b");
	       a--;
	    }
	 }
	 else if(temp2 == '\n'){
	    cmd[a] = '\0';
	    if(!strcmp(cmd,"q")){
	       quit = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"quit")){
	       quit = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"menu")){
	       display = 1;
	       continue;
	    }
	    else if(!strcmp(cmd,"1")){
	       tbc_newline();
	       disp_prompt(72);
	       get_input(alt_user.fname,20,0,1,0,0,0);
	       display = 1;
	    }
	    else if(!strcmp(cmd,"12")){
	       tbc_newline();
	       disp_prompt(72);
	       strcpy(temp, "");
	       get_input(temp,4,1,0,0,0,0);
	       to_int(temp);
	       alt_user2.sec = to_int_return;
	       display = 1;
	    }
	    else if(!strcmp(cmd,"")){
	       tbc_newline();
	       display2 = 1;
	       continue;
	    }
	    else{
	       tbc_newline();
	       disp_prompt(60);
	       tbc_newline();
	       display2 = 1;
	    }
	    a = 0;
	 }
	 else if(a < 40){
	    cmd[a] = temp2;
	    printf("%c",temp2);
	    a++;
	 }
      }
      
   }
   tbc_newline();
   disp_prompt(69);
   if(tbc_getyn()){
      fseek(fp_user, 0, SEEK_SET);
      printf("\nWriting .tbsetup");
      fwrite(&alt_user, sizeof(alt_user), 1, fp_user);
      fseek(fp_stat, 0, SEEK_SET);
      printf("\nWriting .tbstat");
      fwrite(&alt_user2, sizeof(alt_user2), 1, fp_stat);
      tbc_wait();
   }
   fclose(fp_user);
   fclose(fp_stat);
   read_ustats();
   read_usetup();
   return 0;
}

