/* Concord BBS software structures */

#ifndef __CONCORD_H
#define __CONCORD_H

typedef char ANameStr[61];
typedef char NameStr[36];
typedef char CityStr[26];
typedef char PhoneStr[21];
typedef char PassStr[16];
typedef char DefStr[16];
typedef char QWKStr[13];
typedef char OpenStr[12];
typedef char MenuStr[9];
typedef char GroupStr[4];
typedef char FileMaskType[11];

typedef struct
{
    unsigned short Day:5;
    unsigned short Month:4;
    unsigned short Year:7;
}
DateRec;

typedef unsigned short TimeRec;    /* Minutes after 00:00 */
typedef long DateTimeRec;          /* UNIX time stamp     */

#define MAX_FLAG 10
typedef char FlagType[MAX_FLAG];   /* Flags, bitmapped */

typedef struct
{
    unsigned short Bpsrate;        /* Current BPS rate div 100 */
    char Age;                      /* Age  . . . . . . . . . . */
    unsigned short SecLvl;         /* Security Level . . . . . */
    FlagType Flags;                /* Flags ON . . . . . . . . */
    FlagType NotFlags;             /* Flags OFF  . . . . . . . */
}
Security;

typedef struct
{
    unsigned long NameCRC;
    unsigned long AliasCRC;
}
CONCORD_NAMEIDX_REC;

typedef struct
{
    long Id;                       /* Always ID_USR_HDR            */
    long Version;                  /* Version number               */
    unsigned short UserSize;       /* Size of user record in bytes */
}
CONCORD_USER_HEADER;

typedef struct
{
    long            Id;            /* Always ID_USR_REC   */
    NameStr         Name;          /* Real name           */
    NameStr         Alias;         /* Alias               */
    CityStr         City;          /* City                */
    PhoneStr        Voice;         /* Voice number        */
    PhoneStr        Data;          /* Data number         */
    DateRec         Birthday;      /* Birthday            */
    PassStr         Password;      /* Password            */
    Security        Sec;           /* Security            */
    unsigned char   ScreenLen;     /* Screen length       */
    unsigned long   Attrib1;       /* User attributes I   */
    unsigned long   Attrib2;       /* User attributes II  */
    DateTimeRec     FirstTime;     /* First logon date    */
    DateTimeRec     LastTime;      /* Last logon date     */
    unsigned long   TimesCalled;   /* Total times called  */
    unsigned long   TotalMinutes;  /* Total minutes used  */
    unsigned long   Pages;         /* Total times paged   */
    unsigned long   PublicMsgs;    /* Messages posted I   */
    unsigned long   PrivateMsgs;   /* Messages posted II  */
    unsigned long   UpK;           /* Upload kilobytes    */
    unsigned long   UpTimes;       /* Upload times        */
    unsigned long   DownK;         /* Download kilobytes  */
    unsigned long   DownTimes;     /* Download times      */
    ANameStr        SysopCmnt;     /* Sysop comment       */
    unsigned char   Protocol;      /* Protocol number     */
    unsigned char   Editor;        /* Editor number       */
    unsigned char   Viewer;        /* Viewer number       */
    unsigned char   Packer;        /* Packer number       */
    unsigned char   CharSet;       /* Char set number     */
    DateRec         LastFileChk;   /* Last new files chk  */
    DateRec         LastBullChk;   /* Last new bullet chk */
    DateRec         Expiration;    /* Expiration date     */
    MenuStr         FirstMenu;     /* First menu to enter */
    MenuStr         Language;      /* Language file       */
    unsigned long   MessageArea;   /* Msg area number     */
    GroupStr        MAreaExt;      /* N/A                 */
    unsigned long   FileArea;      /* File area number    */
    GroupStr        FAreaExt;      /* N/A                 */
    unsigned long   Door;          /* Door number         */
    GroupStr        DoorExt;       /* N/A                 */
    unsigned long   ChatChannel;   /* Chat channel number */
    unsigned char   TodayCalls;    /* Today times called  */
    short           TodayElapsed;  /* Today minutes used  */
    unsigned long   TodayDownK;    /* Today download kB   */
    unsigned long   TodayDowns;    /* Today DL times      */
    unsigned long   TimeInBank;    /* Total time in bank  */
    unsigned long   DLLimitInBank; /* Total limit in bank */
    QWKStr          ViewFileName;  /* View file name      */
    unsigned char   OfflineFmt;    /* Offline packet fmt  */
    unsigned char   OfflineDays;   /* Automatic pack days */
    unsigned long   OfflineAttrib; /* Offline attributes  */
    unsigned char   ReadMsgNum;
    unsigned char   FileListNum;
    unsigned char   TodayLastPkt;  /* Today last pkt num  */
    unsigned char   VerifyCalls;   /* Calls since last birthday verify, 255 = verify failed */
    unsigned char   PasswordTries; /* Number of wrong passwords entered since last call */
    unsigned short  OfflineMaxNum; /* Max msgs to pack */
    unsigned long   FlexPos;       /* Flex record number */
    DateRec         LastPktDl;
    unsigned long   BBSCRC;
    unsigned char   Emulation;     /* 1=ANSI, 2=AVATAR, 4=ASCII */
    unsigned char   TextFileType;  /* 0=.ANS, 1->=others */
    unsigned char   DateFormat;    /* See later */
    unsigned long   PasswordCRC;   /* CRC password field */
    unsigned long   UserDefNum[10];/* User definable number variables */
    DateRec         LastVoteChk;
    unsigned char   TodayLastDesc; /* Last DESCRIPT.xxx downloaded */
    unsigned long   TimeUnits;     /* 0=not used, -1=none left, >0=n units left */
    unsigned long   KBUnits;       /* 0=not used, -1=none left, >0=n units left */
    char            Empty[29];
}
CONCORD_USER_REC;

#endif
