/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __FSEARCH_H
#define __FSEARCH_H

#include <time.h>
#include "files.h"

#define FBASE_FLAGS_OFFLINE     0x0001  /* File does not exist */
#define FBASE_FLAGS_PRIVATE     0x0002  /* Private file to sysop */

typedef struct
{
    unsigned short Flags;               /* See FBASE_FLAGS_xxxx */
    time_t UlDate;                      /* Upload date */
    time_t FileDate;                    /* File date */
    unsigned long Size;                 /* File size */
    unsigned short Downloads;           /* Downloads */

    unsigned long Ptr;                  /* Pointer to description */
    unsigned long PrevRec;              /* Pointer to previous FILEBASE_REC */
    unsigned long NextRec;              /* Pointer to next FILEBASE_REC */

    /*char FileName[];                     File name */
}
FILEBASE_REC;

extern char *fb_fname;
extern FILE_BUF *Fbase;
extern FILE_BUF *fs_Fdat;
extern FILEBASE_REC *baserec;
extern unsigned long fbase_pos;

int open_filebase(char *file);
void close_filebase(void);

int read_filebase_record(unsigned long record);
int increase_filebase_downs(char *fname);

void newfiles_search(char *data);
void file_search(char *data);
void keyword_search(char *data);

#endif
