/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* getdescs.c - Get descriptions to files from files.bbs or file_id.diz */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "os.h"
#include "files.h"
#include "config.h"

#define DATA_BUF 8192

static int Fcfg;

int open_config(void)
{
    Fcfg = FileOpen(fareas_bbs, O_RDONLY, SH_DENYNO);
    return Fcfg != -1;
}

void close_desc_config(void)
{
    FileClose(Fcfg);
}

char *get_path(char *path)
{
    char str[256],*strp;

    for (;;)
    {
        if (_fgets(str,sizeof(str),Fcfg) == NULL) return NULL;

        strp = str;
        while (*strp == ' ') strp++; /* Skip spaces */

        if (*strp != '\0' && *strp != ';')
        {
            strcpy(path,strp);

            /* Get only path */
            strp = strchr(path,' ');
            if (strp != NULL) *strp = '\0';
            return path;
        }
    }
}

int read_description(int handle, char *data, char *fname, unsigned *downs, time_t *uldate)
{
    char *strp;
    struct tm tim;

    *downs = 0; *uldate = 0;

    if (handle == -1) return 0;

    FileSeek(handle,0,SEEK_SET);
    while (_fgets(data,DATA_BUF,handle) != NULL)
    {
        strp = strchr(data,' ');
        if (strp == data) continue;

        if (strp != NULL) *strp++ = '\0';
        if (stricmp(data,fname) == 0)
        {
            /* Found file! */
            if (strp == NULL) return 0; /* No description, quit. */

            while (*strp == ' ') strp++;
            if (strp[0] == '\0' || (*strp == '@' && *(strp+1) == '_') || strnicmp(strp,"<No description>",16) == 0)
            {
                /* No description */
                if (strp == NULL) return 0;

                data = strp;
                strp = strstr(data,"@_DOWNS=");
                if (strp != NULL)
                {
                    /* Get # of downloads */
                    strp += 8;
                    while (*strp >= '0' && *strp <= '9')
                    {
                        *downs = *downs*10 + (*strp-'0');
                        strp++;
                    }
                }

                strp = strstr(data,"@_ULDATE=");
                if (strp != NULL)
                {
                    /* Get upload date */
                    strp += 9; memset(&tim,0,sizeof(tim));
                    tim.tm_mday = (*strp-'0') * 10 + (*(strp+1)-'0'); strp += 2;
                    tim.tm_mon = (*strp-'0') * 10 + (*(strp+1)-'0'); strp += 2;
                    tim.tm_year = (*strp-'0') * 10 + (*(strp+1)-'0');
                    *uldate = mktime(&tim);
                }
                return 0;
            }
            if (strp != NULL) *(strp-1) = ' ';
            return 1;
        }
    }

    return 0;
}

int read_files_bbs(int handle, char *data, char *fname, unsigned *downs)
{
    int hdiz,wrote;
    char *strp;

    if (handle == -1) return 0;

    FileSeek(handle,0,SEEK_SET);
    while (_fgets(data, DATA_BUF, handle) != NULL)
    {
        strp = strchr(data,' ');
        if (strp == data) continue;

        if (strp != NULL) *strp++ = '\0';
        if (stricmp(data,fname) == 0)
        {
            /* Found file! */
            hdiz = FileCreate("file_id.diz", CREATE_MODE);
            if (hdiz == -1)
            {
                printf("Can't create file_id.diz!\n");
                exit(1);
            }

            /* Write first line */
            wrote = 0;
            if (strp != NULL)
            {
                while (*strp == ' ') strp++;
                if (*strp == '[')
                {
                    /* DL counter found (?) */
                    if (*(strp+1) >= '0' && *(strp+1) <= '9' &&
                        *(strp+2) >= '0' && *(strp+2) <= '9')
                    {
                        if (*(strp+3) >= '0' && *(strp+3) <= '9' && *(strp+4) == ']')
                        {
                            /* 3 digits */
                            if (*downs == 0)
                            {
                                *downs = (*(strp+1)-'0') * 100 + (*(strp+2)-'0') * 10 + (*(strp+3)-'0');
                            }
                            strp += 5;
                        }
                        else if (*(strp+3) == ']')
                        {
                            /* 2 digits */
                            if (*downs == 0)
                            {
                                *downs = (*(strp+1)-'0') * 10 + (*(strp+2)-'0');
                            }
                            strp += 4;
                        }
                    }
                }
                if (*strp != '\0')
                {
                    strcat(strp, " ");
                    wrote += FileWrite(hdiz, strp, strlen(strp));
                }
            }

            /* Write rest description lines */
            while (_fgets(data, DATA_BUF, handle) != NULL)
            {
                /* Check if this is next description line.. */
                if (data[0] == '>')
                    strp = data+1;
                else if (data[0] == ' ' && data[1] == '>')
                    strp = data+2;
                else
                    break; /* Not a description */

                while (*strp == ' ') strp++;
                if (*strp != '\0')
                {
                    strcat(strp, " ");
                    wrote += FileWrite(hdiz, strp, strlen(strp));
                }
            }

            FileClose(hdiz);

            if (wrote != 0) return 1;

            /* Description was empty */
            remove("file_id.diz");
            return 0;
        }
    }

    return 0;
}

int write_description(int Fdes, char *data, unsigned downs, time_t uldate)
{
    unsigned char *strp;
    int F,readed,ignore_space,spos;
    char str[256];
    struct tm *tim;

    /* Open diz */
    F = FileOpenIgn("file_id.diz", O_RDONLY | O_BINARY, SH_DENYNO);
    if (F == -1)
    {
        printf("Error! Couldn't find file_id.diz, and it _should_ have be here!\n");
        exit(1);
    }

    /* Read diz */
    ignore_space = 1;
    for (;;)
    {
        readed = FileRead(F, data, sizeof(str));
        if (readed == 0) break;

        strp = (unsigned char *) data; spos = 0;
        if (*strp == 26) break;
        while (readed > 0)
        {
            if (*strp == 26) break;
            if (*strp == 13 || *strp == 10 || *strp == 9) *strp = ' '; /* cr/lf -> ' ' */
            if (*strp == 228) *strp = 132; /*  ->  */
            //if (*strp == 196) *strp = 142; /*  ->  */
            if (*strp == 246) *strp = 148; /*  ->  */
            if (*strp == 214) *strp = 153; /*  ->  */
            if (*strp == 229) *strp = 134; /*  ->  */
            //if (*strp == 197) *strp = 143; /*  ->  */
            if (*strp < 32) *strp = ' ';

            if (*strp == ' ' && !ignore_space)
            {
                str[spos++] = *strp;
                ignore_space = 1;
            }
            else if (*strp < 155 && *strp != ' ')
            {
                str[spos++] = *strp;
                ignore_space = 0;
            }
            strp++; readed--;
        }
        FileWrite(Fdes, str, spos);
    }

    FileClose(F);

    if (downs != 0)
    {
        /* Write # of downloads */
        sprintf(str,"@_DOWNS=%04u_@",downs);
        FileWrite(Fdes, str, strlen(str));
    }

    if (uldate != 0)
    {
        /* Write upload data */
        tim = localtime(&uldate);
        sprintf(str,"@_ULDATE=%02d%02d%02d_@",tim->tm_mday,tim->tm_mon,tim->tm_year);
        FileWrite(Fdes, str, strlen(str));
    }

    FileWrite(Fdes, "\n", 1);

    /* Remove file_id.diz */
#ifdef __FILES_CASE_SENSITIVE__
    while ((strp = (unsigned char *) search_ign_file("file_id.diz")) != NULL) remove((char *) strp);
#else
    remove("file_id.diz");
#endif

    return 1;
}

void get_descs(char *path)
{
    DIR *dirp;
    struct dirent *direntp;

    int Fdes, Fold, Fbbs, F;
    char str[256],fname[256],diz,*data,*strp;
    struct stat statbuf;

    unsigned downs;
    time_t uldate;

    /* Open dir */
    dirp = opendir(path);
    if (dirp == NULL)
    {
        printf("Couldn't find path '%s'\n",path);
        return;
    }

    /* Create new descript.ion */
    sprintf(str,"%s"SSLASH"descript.tmp",path);
    Fdes = FileCreate(str, CREATE_MODE);
    if (Fdes == -1)
    {
        printf("Couldn't create file '%s'\n",str);
        closedir(dirp);
        return;
    }

    /* Open old descript.ion */
    sprintf(str,"%s"SSLASH"descript.ion",path);
    Fold = FileOpen(str, O_RDONLY, SH_DENYNO);

    /* Open files.bbs */
    sprintf(str,"%s"SSLASH"files.bbs",path);
    Fbbs = FileOpen(str, O_RDONLY, SH_DENYNO);

    data = (char *) malloc(DATA_BUF);
    for (;;)
    {
        /* Read directory */
        direntp = readdir(dirp);
        if (direntp == NULL) break;

        if (stricmp(direntp->d_name,"descript.bak") == 0) continue;
        if (stricmp(direntp->d_name,"descript.ion") == 0) continue;
        if (stricmp(direntp->d_name,"descript.tmp") == 0) continue;
        if (stricmp(direntp->d_name,"files.bbs") == 0) continue;

        sprintf(fname,"%s"SSLASH"%s",path,direntp->d_name);
        if (stat(fname,&statbuf) != 0 || ISDIR(statbuf))
        {
            /* This is a directory.. */
            continue;
        }

        downs = 0; uldate = 0;

        /* Check if already descripted */
        if (Fold != -1)
        {
            if (read_description(Fold, data, direntp->d_name, &downs, &uldate))
            {
                /* Old description ok, write and continue. */
                FileWrite(Fdes, data, strlen(data));
                if (strstr(data,"@_DOWNS=") == NULL)
                {
                    /* Check if download counter is found from files.bbs */
                    read_files_bbs(Fbbs, data, direntp->d_name, &downs);
                    if (downs != 0)
                    {
                        /* Got it, write. */
                        sprintf(data,"@_DOWNS=%04d_@",downs);
                        FileWrite(Fdes, data, strlen(data));
                    }

                    /* Remove file_id.diz */
#ifdef __FILES_CASE_SENSITIVE__
                    while ((strp = search_ign_file("file_id.diz")) != NULL) remove(strp);
#else
                    remove("file_id.diz");
#endif
                }
                FileWrite(Fdes, "\n", 1);
                continue;
            }
        }

        FileWrite(Fdes, direntp->d_name, strlen(direntp->d_name));
        FileWrite(Fdes, " ", 1);

        /* Need to get description somewhere, first check if it's in files.bbs */
        if (Fbbs != -1)
        {
            if (read_files_bbs(Fbbs, data, direntp->d_name, &downs))
            {
                /* Got it, write and continue. */
                write_description(Fdes, data, downs, uldate);
                continue;
            }
        }

        /* Oh well, need to unpack it and find file_id.diz.. */

        F = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
        if (F == -1)
        {
            printf("Couldn't open open '%s'\n",fname);
            FileClose(Fbbs);
            FileClose(Fdes);
            FileClose(Fold);
            closedir(dirp);
            return;
        }

        diz = 0;
        if (FileRead(F,str,5) != 5)
        {
            /* Couldn't read 5 bytes, what a small file.. */
            FileClose(F);
        }
        else
        {
            FileClose(F);
            if ((str[0] == 'P') && (str[1] == 'K'))
            {
                /* Zip packet */
                sprintf(str,"unzip -CjL -qq %s file_id.diz",fname);
                if (system(str) == 0) diz = 1;
            }
            else if (strncmp(str,"Rar!\032",5) == 0)
            {
                /* Rar packet */
                sprintf(str,"rar e -cl -c- -inul %s file_id.diz",fname);
                if (system(str) == 0) diz = 1;
            }
            else if (strncmp(str+2,"-lh",3) == 0)
            {
                /* Lha packet */
                sprintf(str,"lha e %s file_id.diz",fname);
                if (system(str) == 0) diz = 1;
            }
            else
            {
                strp = strrchr(direntp->d_name,'.'); diz = 1;
                if (strp != NULL && stricmp(strp,"exe") == 0)
                {
                    diz = 0;

                    /* Check if it's self-extracting Zip.. */
                    sprintf(str,"unzip -CjL -qq %s file_id.diz",fname);
                    if (system(str) == 0)
                    {
                        /* It was. */
                        diz = 1;
                    }
                    else
                    {
                        /* Check if it's self-extracting Rar.. */
                        sprintf(str,"rar e -cl -c- -inul %s file_id.diz",fname);
                        if (system(str) == 0) diz = 1;
                    }
                }
            }

            /* Check if diz really unpacked. */
#ifdef __FILES_CASE_SENSITIVE__
            if (diz && search_ign_file("file_id.diz") == NULL) diz = 0;
#else
            if (diz && stat("file_id.diz",&statbuf) != 0) diz = 0;
#endif
        }

        if (!diz)
        {
            /* Create diz if not in packet */
            F = FileCreate("file_id.diz", CREATE_MODE);
            FileWrite(F, "<no description>\n",17);
            FileClose(F);
        }

        write_description(Fdes, data, downs, uldate);
    }
    free(data);

    FileClose(Fdes);
    if (Fold != -1) FileClose(Fold);
    if (Fbbs != -1) FileClose(Fbbs);

    /* All ok, rename.. */
    sprintf(str,"%s"SSLASH"descript.tmp",path);
    sprintf(fname,"%s"SSLASH"descript.ion",path);
    remove(fname);
    rename(str,fname);

    closedir(dirp);
}

int get_file_descriptions(void)
{
    char path[256];

#ifdef __FILES_CASE_SENSITIVE__
    char *strp;

    while ((strp = search_ign_file("file_id.diz")) != NULL) remove(strp);
#else
    remove("file_id.diz");
#endif

    if (!open_config())
    {
        printf("%s not found.\n", fareas_bbs);
        return 0;
    }

    while (get_path(path) != NULL)
    {
        printf("Scanning directory '%s'\n",path);
        get_descs(path);
    }

    close_desc_config();

    return 1;
}
