/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* language.c - Language file handling */

#include <stdio.h>
#include <string.h>

#include "os.h"
#include "files.h"
#include "memory.h"
#include "config.h"
#include "output.h"
#include "logfile.h"
#include "nodes.h"
#include "language.h"

char **lang = NULL;

int read_language(char *fname)
{
    int len, num, hlang = -1, errlines;
    char *data, *strp;

    if (lang != NULL) close_language();

    hlang = FileOpen(fname, O_RDONLY | O_BINARY, SH_DENYNO);
    if (hlang == -1)
    {
        write_log("Can't open language file %s", fname);
        output("FATAL: Can't open language file!\n");
        return 0;
    }

    data = (char *) _malloc(8192);
    lang = (char **) _malloc(LANGUAGE_LINES*sizeof(char *));
    if (lang == NULL || data == NULL)
    {
        write_log("read_language() : Not enough memory (%d bytes)", data == NULL ? 8192 : (LANGUAGE_LINES*sizeof(char *)));
        output("FATAL: Not enough memory, can't read language file!\r\n");
        close(hlang);
        if (lang != NULL) _free(lang);
        if (data != NULL) _free(data);
        return 0;
    }

    errlines = 0;
    for (num = 0; num < LANGUAGE_LINES; num++)
    {
        if (_fgets(data, 8192, hlang) == NULL)
        {
            if (!errlines)
            {
                errlines = 1;
                output("Warning: Not enough lines in language file\r\n");
                write_log("Not enough lines in language file");
            }
            data[0] = '\0';
        }
        len = strlen(data);
        if (len >= 2)
        {
            strp = data+len-2;
            if (*strp == '%' && *(strp+1) == '|')
            {
                *strp = '\0';
                len -= 2;
            }
        }

        lang[num] = (char *) _malloc(len+1);
        strcpy(lang[num], data);
    }

    close(hlang);
    _free(data);

    node_doing = &lang[LANG_NODEDOING_1];

    return 1;
}

void close_language(void)
{
    int num;

    if (lang == NULL) return;

    for (num = 0; num < LANGUAGE_LINES; num++)
        _free(lang[num]);
    _free(lang); lang = NULL;
}
