/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* logfile.c - Log file handling */

#include <stdio.h>
#include <stdarg.h>
#include <time.h>

#include "logfile.h"
#include "files.h"
#include "config.h"

static FILE *Flog = NULL;

/* Open/create log file */
int open_logfile(int nodenum)
{
    char str[256];

    sprintf(str, log_file, nodenum);
    Flog = fopen(str, "a+t");
    if (Flog == NULL) { printf("Can't open logfile: '%s'",str); return 0; }
    setbuf(Flog,NULL);
    chmod(str, 0660);

    return 1;
}

/* Close log file */
void close_logfile(void)
{
    if (Flog != NULL)
    {
        fclose(Flog);
        Flog = NULL;
    }
}

void write_log(char *text, ...)
{
    va_list arglist;
    time_t _tim;
    struct tm *tim;

    if (Flog == NULL) return;

    /* Get time */
    _tim = time(NULL);
    tim = localtime(&_tim);

    /* Put text to 'tmp' */
    va_start(arglist,text);
    fprintf(Flog,"%02d.%02d.%02d %02d:%02d:%02d  ",
            tim->tm_mday,tim->tm_mon+1,tim->tm_year,
            tim->tm_hour,tim->tm_min,tim->tm_sec);
    vfprintf(Flog,text,arglist);
    fprintf(Flog,"\n");
    va_end(arglist);
}

