/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* os.c - OS-dependent functions */

#include <stdio.h>
#include <ctype.h>

#ifdef __linux__

char *strupr(char *str)
{
    while (*str != '\0')
    {
        *str = toupper(*str);
        str++;
    }
    return str;
}

char *strlwr(char *str)
{
    while (*str != '\0')
    {
        *str = tolower(*str);
        str++;
    }
    return str;
}

#ifdef WANT_STRCHR
char *r_strchr(char *s, int c)
{
    while (*s)
    {
        if (*s == c) return s;
        s++;
    }
    return NULL;
}

char *r_strrchr(char *s, int c)
{
    char *start;

    start = s;
    while (*s) s++;
    while (s > start)
    {
        if (*s == c) return s;
        s--;
    }
    return NULL;
}
#endif

#ifdef WANT_STRSTR
char *r_strstr(const char *haystack, const char *needle)
{
    const char *last,*pos;

    last = haystack; pos = needle;
    while (*haystack)
    {
        if (*haystack == *pos)
        {
            if (pos == needle) last = haystack;
            pos++;
            if (*pos == '\0') return (char *) last;
        }
        else if (pos != needle)
        {
            haystack = last;
            pos = needle;
        }
        haystack++;
    }
    return NULL;
}
#endif

#endif

char *stristr(char *haystack, char *needle)
{
    char *last,*pos;

    last = haystack; pos = needle;
    while (*haystack)
    {
        if (toupper(*haystack) == toupper(*pos))
        {
            if (pos == needle) last = haystack;
            pos++;
            if (*pos == '\0') return (char *) last;
        }
        else if (pos != needle)
        {
            haystack = last;
            pos = needle;
        }
        haystack++;
    }
    return NULL;
}
