/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __OS_H
#define __OS_H

#ifdef __linux__
#  include <limits.h>
#  define MAX_NAME_LEN NAME_MAX
#  define MAX_PATH_LEN PATH_MAX
#  define stricmp strcasecmp
#  define strnicmp strncasecmp
char *strlwr(char *str);
char *strupr(char *str);
#else /* __linux__ */
#  include <stdio.h>
#  include <dos.h> /* For sleep() */
#  ifdef __WATCOMC__
#    include <i86.h> /* delay(), int86() */
#  endif

#  ifndef PATH_MAX
#    ifdef __DOS__
#      define PATH_MAX 90
#    else
#      define PATH_MAX 256
#    endif
#  endif
#  ifdef __DOS__
#    define MAX_NAME_LEN 13
#  else
#    define MAX_NAME_LEN PATH_MAX+1
#  endif
#  define MAX_PATH_LEN PATH_MAX+1

#  ifdef __EMX__
#    define INCL_DOS
#    include <os2.h>
#    define usleep(a) DosSleep(a)
#    define sleep(a) DosSleep(a*1000)
#  else
#    define usleep(a) delay((a)/1000)
#  endif
#endif

/* I want strchr() function!! */
#ifdef WANT_STRCHR
#  define strchr r_strchr
#  define strrchr r_strrchr
char *r_strchr(char *s, int c);
char *r_strrchr(char *s, int c);
#endif

/* I want strstr() function!! */
#ifdef WANT_STRSTR
#  define strstr r_strstr
char *r_strstr(const char *haystack, const char *needle);
#endif

#ifdef __DOS__
/* DOS registers */

#ifdef __WATCOMC__
/* Watcom */
#  ifdef __386__
#    define hireg w
#    define intr int386
#    define intrx int386x
#  else
#    define hireg x
#    define intr int86
#    define intrx int86x
#  endif
#  define loreg h
#  define segreg h
#else
/* Others .. */
#  define hireg x
#  define loreg h
#  define segreg h
#  define intr int86
#  define intrx int86x
#endif

#endif

char *stristr(char *haystack, char *needle);

#endif
