/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

#ifndef __THREADS_H
#define __THREADS_H

#ifdef __OS2__
#  define INCL_DOSPROCESS
#  include <os2.h>
#endif

#if defined (__linux__) || defined (__DOS__) || defined (__NT__)
typedef int TID;
#endif

#define NO_MESSAGES     0x0001

typedef struct
{
    void *next;
    char name[30];
    int Restrict;
    TID ThreadID;
}
TID_REC;

extern TID_REC *first_TID;                      /* First thread ID */
extern TID_REC *cur_TID;                        /* Current thread ID */

extern unsigned long cur_thread_num;            /* Thread number */
extern char cur_thread_name[30];                /* Thread name */
extern char cur_thread_restr[30];               /* Thread restricts usage of .. */

extern int restrict_usage;                      /* Don't allow using these functions */

void init_threads(void);                        /* Init threads */
void deinit_threads(void);                      /* Deinit threads */

int begin_thread(void *func, char *name, int restrict, int stack, int *tid);/* Begin new thread */
void end_thread(int ThreadID);                  /* Close thread */
int remove_thread(int ThreadID);                /* Kill thread */

int restrictive_thread(int restrict);           /* Check which thread restricts usage of <..> */

void show_jobs(void);                           /* Display threads */
void kill_job(char *data);                      /* Kill thread */

#endif
