/* YAK - Copyright (c) 1997 Timo Sirainen - read license.txt */

/* toplist.c - All kinds of top-nn lists */

#include <string.h>

#include "files.h"
#include "output.h"
#include "bbs_func.h"
#include "userbase.h"
#include "language.h"
#include "logfile.h"

#define UPLOAD_BYTES     *3
#define DOWNLOAD_BYTES   *-1
#define MSGS_WRITTEN     *20
#define MSGS_READ        /100
#define MINS_USED        /2

void create_user_score_list(void)
{
    char lastuser[36], highnames[10][36], lownames[10][36];
    char str[20], *strp;
    long highest[10], lowest[10], score;
    unsigned long max;
    int num, usern, last, maxpros, pros;

    strcpy(lastuser,usrsub.name);
    if (!write_user())
    {
        write_log("Can't write user to userbase!");
        return;
    }

    memset(highnames, 0, sizeof(highnames));
    memset(lownames, 0, sizeof(lownames));
    for (num=0; num<10; num++) highest[num] = 0x80000000;
    for (num=0; num<10; num++) lowest[num] = 0x7fffffff;

    strncpy(str, lang[LANG_TOPLIST_DATA], 19); str[19] = '\0';
    strp = strchr(str, ';');
    if (strp != NULL)
    {
        *strp = '\0';
        if (sscanf(str, "%d", &maxpros) != 1) maxpros = 0;
    }
    else
        maxpros = 0;
    strp = strchr(lang[LANG_TOPLIST_DATA], ';');
    if (strp != NULL) strp++;

    output(lang[LANG_TOPLIST_WAITING]);
    usern = 1; max = users(); last = 0;
    while (read_user(usern,1) != 0)
    {
        pros = usern*maxpros / max;
        if (last != pros && maxpros > 0 && strp != NULL)
        {
            last = pros;
            output(strp, pros);
        }
        score = user.UploadBytes/1024 UPLOAD_BYTES +
            user.DownloadBytes/1024 DOWNLOAD_BYTES +
            user.MsgsWritten MSGS_WRITTEN +
            user.MsgsRead/100 MSGS_READ +
            user.TotalMinutes MINS_USED;

        for (num=0; num<10; num++)
        {
            if (score > highest[num])
            {
                memmove(&highest[num+1], &highest[num], sizeof(highest[0])*(9-num));
                memmove(highnames[num+1], highnames[num], sizeof(highnames[0])*(9-num));
                strcpy(highnames[num], usrsub.name);
                highest[num] = score;
                break;
            }
        }

        for (num=0; num<10; num++)
        {
            if (score < lowest[num])
            {
                memmove(&lowest[num+1], &lowest[num], sizeof(lowest[0])*(9-num));
                memmove(lownames[num+1], lownames[num], sizeof(lownames[0])*(9-num));
                strcpy(lownames[num], usrsub.name);
                lowest[num] = score;
                break;
            }
        }
        usern++;
    }
    read_user(scan_user(lastuser),1);

    output(lang[LANG_TOPLIST_TOP_HEADER]);
    for (num=0; num<10; num++)
        if (!output(lang[LANG_TOPLIST_TOP_ENTRY], num+1, highnames[num], highest[num])) return;
    if (!output(lang[LANG_TOPLIST_TOP_BOTTOM])) return;

    if (!output(lang[LANG_TOPLIST_LOW_HEADER])) return;
    for (num=0; num<10; num++)
        if (!output(lang[LANG_TOPLIST_LOW_ENTRY], num+1, lownames[num], lowest[num])) return;
    output(lang[LANG_TOPLIST_LOW_BOTTOM]);
}
