#include <QMessageBox>
#include <QCloseEvent>
#include "portdialog.h"
#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    listening = false;
    udpsocket = new QUdpSocket(this);
    connect(udpsocket, SIGNAL(readyRead()), this, SLOT(processReadyRead()));
    pdialog = new PortDialog(this);
    setWindowIcon(QIcon(":/icons/cauldron.png"));
    sysTrayIcon = new QSystemTrayIcon();
    sysTrayIcon->setIcon(QIcon(":/icons/cauldron.png"));
    connect(sysTrayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
    sysTrayIcon->show();
    settings = new QSettings("MagickaBBS", "MagickaNotify");
    port = settings->value("port", 2027).toInt();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::addItem(QString item) {
    QListWidgetItem *witem;
    if (ui->logListWidget->count() > 100 ) {
        witem = ui->logListWidget->takeItem(0);
        delete witem;
    }
    ui->logListWidget->addItem(item);
    if (!this->isVisible()) {
        sysTrayIcon->showMessage("Magicka Notify", item);
    }
    ui->logListWidget->scrollToBottom();
}

void MainWindow::on_actionListen_toggled(bool arg1)
{
    QString item;
    if (arg1) {
        item = "Starting to listen on port " + QString::number(port);
        udpsocket->bind(port, QUdpSocket::ShareAddress);
        listening = true;
    } else {
        item = "Stopping listening on port " + QString::number(port);
        udpsocket->close();
        listening = false;
    }
    addItem(item);
}

void MainWindow::setPort(quint16 p) {
    port = p;
    QString item;
    if (listening) {
        udpsocket->close();
        udpsocket->bind(port, QUdpSocket::ShareAddress);
        item = "Restarting on port " + QString::number(port);
        addItem(item);
    }
    settings->setValue("port", port);
}

void MainWindow::processReadyRead()
{
    while (udpsocket->hasPendingDatagrams()) {
        QByteArray datagram;
        datagram.resize(udpsocket->pendingDatagramSize());
        udpsocket->readDatagram(datagram.data(), datagram.size());
        addItem(QString::fromUtf8(datagram.data()));
    }
}

void MainWindow::on_actionChoose_Port_triggered()
{
    pdialog->setPort(port);
    pdialog->show();
}

void MainWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
    switch (reason) {
    case QSystemTrayIcon::Trigger:
    case QSystemTrayIcon::DoubleClick:
        this->show();
        break;
    default:
        ;
    }
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    if (sysTrayIcon->isVisible()) {
        this->hide();
        sysTrayIcon->showMessage("Magicka Notify", "Magicka Notify is running in the tray, to quit select \"Quit\" from the application menu.");
        event->ignore();
    }
}

void MainWindow::on_actionQuit_triggered()
{
    if (listening) {
        udpsocket->close();
    }
    QApplication::quit();
}
