DECLARE FUNCTION lbyte% (word%)
DECLARE FUNCTION hbyte% (word%)

REM Ejects a CD door v1.1a PD 2005.

REM $INCLUDE: 'qb.bi'
DIM SHARED InregsX AS RegTypeX
DIM SHARED OutregsX AS RegTypeX

DIM SHARED rh(26) AS STRING * 1 ' request header
DIM SHARED cb(1) AS STRING * 1 ' command block
DIM SHARED Drive AS INTEGER ' ascii of drive letter
DIM SHARED Length AS INTEGER
Length = 1 ' length of cb()

' check command line
IF COMMAND$ = "" THEN
   COLOR 15
   PRINT "Enter drive letter(A-Z)";
   INPUT D$
   COLOR 7
   IF D$ = "" THEN END
   D$ = UCASE$(D$)
ELSE
   D$ = COMMAND$
END IF
IF D$ >= "A" AND D$ <= "Z" THEN
   Drive = ASC(D$) - 65
ELSE
   END
END IF

' get number of drives.
InregsX.AX = &H1500
InregsX.BX = &H0
InregsX.CX = &H0
CALL INTERRUPTX(&H2F, InregsX, OutregsX)
NumDrives = OutregsX.BX

' check number of drives.
IF NumDrives = 0 THEN
   COLOR 14
   PRINT "No cd-rom drives exist."
   COLOR 7
   END
END IF

' declare drive tables.
DIM Temp1(1 TO NumDrives) AS STRING * 1
DIM Temp2(1 TO NumDrives * 5) AS STRING * 1
DIM Drives(1 TO NumDrives, 1 TO 2) AS INTEGER

' get drive list.
InregsX.AX = &H150D
InregsX.ES = VARSEG(Temp1(1))
InregsX.BX = VARPTR(Temp1(1))
CALL INTERRUPTX(&H2F, InregsX, OutregsX)
InregsX.AX = &H1501
InregsX.ES = VARSEG(Temp2(1))
InregsX.BX = VARPTR(Temp2(1))
CALL INTERRUPTX(&H2F, InregsX, OutregsX)

' store drive info.
FOR X = 1 TO NumDrives
   Drives(X, 1) = ASC(Temp1(X)) ' a=0, b=1, ..
   Drives(X, 2) = ASC(Temp2(1 + (X - 1) * 5))
NEXT X

' search for drive
V = 0
FOR X = 1 TO NumDrives
   IF Drives(X, 1) = Drive THEN
      V = -1
      EXIT FOR
   END IF
NEXT
IF V = 0 THEN
   COLOR 14
   PRINT "Drive letter not in list."
   COLOR 7
   END
END IF

' prepare the request header for a given command code.
rh(1) = CHR$(26) ' length
rh(2) = CHR$(Drives(X, 2)) ' drive device
rh(3) = CHR$(12) ' command code 0Ch

' prepare the control block for a given subfunction of command code.
cb(1) = CHR$(0) ' function code 00h - eject disk.

' update address of cb() in rh()
rh(15) = CHR$(lbyte(VARPTR(cb(1)))) ' transfer address (dword) 0Eh
rh(16) = CHR$(hbyte(VARPTR(cb(1))))
rh(17) = CHR$(lbyte(VARSEG(cb(1))))
rh(18) = CHR$(hbyte(VARSEG(cb(1))))
rh(19) = CHR$(lbyte(Length)) ' number of transfer bytes (word) 12h
rh(20) = CHR$(hbyte(Length))

' call ioctl
InregsX.AX = &H1510
InregsX.CX = Drives(X, 1)
InregsX.ES = VARSEG(rh(1))
InregsX.BX = VARPTR(rh(1))
CALL INTERRUPTX(&H2F, InregsX, OutregsX)
COLOR 14
PRINT "Eject command sent to drive "; CHR$(Drives(X, 1) + 65)
COLOR 7
END

FUNCTION hbyte% (word%)
'Returns the high byte of a 2-byte number (INTEGER)
'
'input:    word%               - 2-byte number (INTEGER)
'return:   Function Value      - High byte or word%

IF word% >= 0 THEN
   hbyte% = word% \ 256
ELSE
   hbyte% = (65536 + word%) \ 256
END IF
END FUNCTION

FUNCTION lbyte% (word%)
'Returns the low byte of a 2-byte number (INTEGER)
'
'input:    word%               - 2-byte number (INTEGER)
'return:   Function Value      - Low byte or word%

IF word% >= 0 THEN
   lbyte% = word% MOD 256
ELSE
   lbyte% = (65536 + word%) MOD 256
END IF
END FUNCTION

