PROGRAM UpgradePortalConfig;
{ͻ}
{ Converts older config files to new format     Last Changed: 16.03.00  MR }
{                                                                          }
{                        (C) Copyright 1997-2000 by                        }
{                        Marcus Roeckrath                                  }
{                        Fido: 2:2449/523                                  }
{                        E-Mail: marcus.roeckrath@gmx.de                   }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}
{$I POPDEFS.INC}

USES Use32, Dos, PopTypes, OPDate, OPCrt;

TYPE
  TConfig4 = RECORD
    Version        : Byte;             { .CFG file version                   }
    TaskNumber     : Byte;             { Which task number are we            }
    SwapDir        : DosPathStr;          { Where to swap to                    }
    Filler1        : DosPathStr;
    Outbound,                          { Outbound directories                }
    Banner,                            { Name of banner to show callers      }
    DefaultMacro,                      { Name of default keyboard-macro file }
    Editor,                            { Command to envoke message editor    }
    LogfileName    : DosPathStr;          { Log file for your system            }
    LogLevel       : Byte;             { Desired log level (1-5)             }
    UseYearInLog   : Boolean;          { False= ! dd-nnn hh:mm PORTAL        }
                                       { True = ! dd-nnn-yy hh:mm PORTAL     }
    NodeList       : DosPathStr;          { Directory of your nodelist files    }
    NodelistTyp    : NodeListType;     { Type of nodelist used               }

    MainAdrNum     : Byte;
    Addresses      : ARRAY[1..16] Of TFidoAddress;
                                       { Defined addresses                   }
    PointNet       : SmallInt;          { Number of point-net (for fake)      }
    UseFakeAddress : Boolean;          { Should PORTAL Use fake or real      }
                                       { addresses                           }
    Sysop          : S20;              { Name of SysOp                       }
    System         : S60;              { Name of system                      }
    SwapOnExec     : Boolean;          { Swap on exec of any command         }
    EnterBBSText,                      { Text displayed while loading        }
                                       { BBS software                        }
    DoingMailText,                     { Text to display, while in a         }
                                       { mail-only event                     }
    PressESCText   : DosPathStr;          { Text displayed when user should     }
                                       { press ESC                           }
    MaxRinging     : Byte;             { Max RINGING on calls out            }
    ZMHStart,                          { Start of Zone Mail Hour             }
    ZMHEnd,                            { End of Zone Mail Hour               }
    CallTime,                          { Global call frequency               }
    CallWidth      : Time;             { Global max call delay               }
    ConnectFastest : Boolean;          { Check node list for max. speed      }
                                       { and abort poll, if lower            }
    OutReReadDelay : Time;             { Delay between reading outbound      }
                                       { information                         }
    FuncReqPwd     : S20;              { Password for function requests      }
    UseJanus       : Boolean;          { Allow Janus protocol                }
    UseEMSI        : Boolean;          { Allow EMSI hand shake               }
    FastCalls      : Boolean;          { Call systems faster than us         }
    KeepEmptyDirs  : Boolean;          { If Yes, don't delete Zone, 4D Point }
    Curmudgeon     : Boolean;          { If Yes, hang up on calls from       }
                                       { unknown systems           SA:930330 }
    RereadOnCall   : Boolean;          { If set to Y, PoP will reread the    }
                                       { outbound if there is nothing to send}
    Inbound        : ARRAY[TNodeStat] OF DosPathStr;
    InboundToDo    : ARRAY[TNodeStat] OF SmallWord;
    TaskType       : BYTE;             { 0=Normal, 1=Is Request server, }
                                       { 2=Running under Request server }
    HexTask        : Boolean;              { No = MakeTaskFileName makes decimal numbers  SA:940610}
    Filler         : ARRAY[1..22] of Byte;
    FKey           : ARRAY[1..2, 1..10] OF TFunctionKey;    { See above      }
    Color          : ARRAY[1..4] OF ColorSet;               { See above      }
    BBS : RECORD
      BBSType        : TBBSType;       { BBS Type used                       }
      Path           : DosPathStr;        { Path to BBS-information files       }
      UserFile       : DosPathStr;        { Name of user file, for user editor  }
      MinBaud        : SmallWord;           { Min. baud to enter BBS              }
      MinBaudFile    : DosPathStr;        { File to show slower callers         }
      UserErrorLevel : Byte;           { Error level for all callers         }
      Multi : ARRAY[1..5] OF RECORD
        Key     : Char;                { Key to select BBS                   }
        BatName : S8;                  { Name of .BAT file to create         }
      END;
      DefFile        : S8;             { Name of BBS definition file         }
      Filler         : ARRAY[1..55] of Byte;
    END;
    Modem : RECORD
      CommPort   : Byte;                    { Comm. port number              }
      BaudRate   : SmallWord;                    { Baud rate to initialize modem  }
      PreInit    : S40;                     { ??? }
      Init       : S80;                     { Init. command                  }
      NoAnswer,                             { Init cmd. in NoAnswer event    }
      Dial,                                 { Dial command                   }
      Busy,                                 { Cmd. to make line busy         }
      HangUp,                               { Hang-up command                }
      Answer     : S40;                     { Answer command                 }
      ReInit     : Time;                    { Delay between modem inits,     }
                                            { while the system is idle       }
      LockedBaud : S10;                     { Part of connect STRING, to tell}
                                            { the system that the baud rate  }
                                            { should remain locked (/ARQ)    }
      ExitStr : ARRAY[1..5] Of RECORD
        ConStr : S10;                       { Special exit STRING e.g. /FAX  }
        ErrLvl : Byte;                      { Exit error level for above str }
      END;
      ModemType : ARRAY[0..7] OF RECORD
        Bit     : Byte;
        Dial    : S40;
        DialOut : Boolean;
        Baud    : SmallWord;
      END;
      WaitTime    : Time;              { Sek. to wait for logon   250593 SBC }
      InternalFax : Boolean;           { Use internal fax receive  191093 SA }
      LinkStat    : S10;
      LogLines    : Byte;
      ConnectTime : BYTE;              { How many seconds before CONNECT }
      UseLCR      : BOOLEAN;           { Use Least Cost Routing? }
      UseRingAnaly: BOOLEAN;           { Use Ring Analyzer? }
      UseNConAnaly: BOOLEAN;           { Use No Connect Analyzer? }
      Filler      : ARRAY[1..3] OF Byte;
    END;

    Screen         : RECORD
      BlankTime      : Time;           { Time of inactivity, before blanking }
                                       { the screen                          }
      ChkSnow,                         { Check for 'snow' during screen      }
                                       { updates (CGA only)                  }
      KeepOffScrMode,                  { Allow to change screen mode         }
      ScrMode,                         { False=25, True=43/50 lines          }
      HardwareBlank,                   { Blank using hardware interrupt      }
      ExplodingWin   : Boolean;        { Use fancy display of menus and      }
                                       { windows                             }
      FourDigitsYear : BOOLEAN;        { Four digits year in status window }
      Filler         : ARRAY[1..1] OF Byte;
    END;
    Statistics : RECORD
      MdmProtocol : ARRAY[1..5] OF S5;
    END;
    ListFiles : RECORD
      FileList,                          { Name of finished file list         }
      NewsList,                          { Name of new files list             }
      Header,                            { Name of header file for file list  }
      Footer,                            { Name of footer file for file list  }
      TopFile,                           { Name of most downloaded files list }
      StatFile       : DosPathStr;          { Name of area statistics file       }
      Adopt          : Boolean;          { Adopt orphan files while running   }
      AdoptComment   : S40;              { Comment for adopted files          }
      DupeCheck      : Boolean;          { Perform dupe check of file base    }
      Stat           : Boolean;          { Include statistics file in Filelist}
      IncludeTop     : Boolean;          { Include top list in file list      }
      Top            : Byte;             { How many files (0-50) to include in}
                                         { top downloads list                 }
      DkDate         : Boolean;          { Use european date format           }
      NewsDays       : Byte;             { How old files to include in news   }
                                         { file                               }
      Threshold      : Byte;             { DupeCheck Size Threshold           }
      RemMissing,                        { Remove Missing Files               }
      OkPortal,                          { Update portal compatible ok file   }
      ZapZero,                           { Delete zero Byte files             }
      Touch          : Boolean;          { Touch files with invalid time stamp}
      CrapFiles,                            { Files to delete                 }
      ExcludeFiles,                         { Files not to include in FileList}
      NoDupeCheck    : ARRAY[1..10] of S12; { Files not to check for dupes    }
      NonAdoptFiles  : ARRAY[1..10] of S12; { Files not to adopt              }
      NonAdoptAreas  : ARRAY[1..10] of S3;  { Areas not to adopt files in     }
      PrivateAreas   : ARRAY[1..11] of S3;  { Areas to leave out from list    }
      DoBefore       : DosPathStr;             { Command to do before generation }
      DoAfter        : DosPathStr;             { Command to do after generation  }
      DoPack         : DosPathStr;             { Command to pack finished list   }
      DupeReport     : DosPathStr;             { DupeReport filename             }
      TXTFreq        : ARRAY[0..3] of S55;  { Txt to display if Freq is OK    }
      OkBimodempath  : DosPathStr;             { Bimodem compatible OK-File      }
      Filler         : ARRAY[1..32] of Byte;
    END;

                        { 1..3, 1..2 (PrCall, PrDay) }
    Request : RECORD
      Limit : ARRAY[TNodeStat,TReqLimit] OF RECORD
        MaxFiles : SmallWord;
        MaxTime  : Time;
        MaxBytes : LongInt;
      END;
      RspAsPkt       : Boolean;
      SkipAfterFirst : Boolean;        { Skip search after first matching    }
                                       { file - if no jokers in requested    }
                                       { name                                }
      MinBaud        : SmallWord;           { Minimum baudrate required for       }
                                       { requests                  SA:170593 }
      ReqOnUs        : TReqOnUs;
      ReqOnUsCost    : SmallWord;
      Filler         : ARRAY[1..58] of Byte;
    END;

    MailScanner    : RECORD
      Filler1      : ARRAY[1..50] OF Char;
      RenumThresh  : SmallInt;
      NetMailDir   : DosPathStr;
      Filler3      : DosPathStr;
      Secure       : Boolean;
      BadMsgs      : DosPathStr;
      SaveDupesDir : DosPathStr;
      MaxDupes     : SmallWord;
      EchoTossLog  : DosPathStr;
      StripCrash   : Boolean;
      SetAKASent   : Boolean;
      PvtEchoMail  : Boolean;
      SaveFwdMail  : Boolean;
      RouteFile    : DosPathStr;
      ForwardMail  : Boolean;
      KillFwdFiles : Boolean;
      Filler2      : DosPathStr;
      OldExt       : Boolean;
      DefaultPacker: Byte;
      NetMailBoard : Byte;
      ForceWIPMode : Boolean;
      Filler       : ARRAY[1..127] OF Char;
    END;
    FwdFile        : RECORD
      PreCmd       : DosPathStr;        { Cmd. to run before forwarding }
      SecureDir    : DosPathStr;        { Path to security directory    }
      MsgAttribute : SmallWord;
      KillSent     : Boolean;        { Mark msgs. as kill/sent       }
      MsgPrivate   : Boolean;        { Mark msgs. as private         }
      Subject      : S72;            { Subject of forward msgs.      }
      Filler       : ARRAY[1..64] OF Byte;
    END;
    Tick : RECORD
      DupeDir        : DosPathStr;          { Dupe check directory               }
      HoldDir        : DosPathStr;          { Where to place outgoing .TIC files }
      BeforeMoving   : DosPathStr;          { Command to execute before          }
                                         { processing any ticks               }
      RequestMissing : Boolean;          { Should Portal try to make a file
                                         { request for any files, not received}
      Filler         : ARRAY[1..64] of Byte;
    END;
    BiMail         : RECORD
      BiOverride     : ARRAY[1..5] Of S10;   { Protocol flags to override    }
                                             { full duplex max baud          }
      NoSendOverride : Boolean;              { Override no send events when  }
                                             { using a full duplex protocol  }
      MaxBaud        : SmallWord;                 { Max. baud rate for full       }
                                             { duplex.                       }
      BiModemPath    : DosPathStr;              { Path & file name of BiModem   }
                                             { program                       }
      Filler         : ARRAY[1..16] OF Byte;
    END;
    NLCompiler     : RECORD
      CostFileName   : DosPathStr;            { Name of cost file               }
      IntPrefix      : S10;                { Int. dial prefix                }
      OurPrefix      : S10;                { Prefix (direction number) of    }
                                           { your country                    }
      UseFidoUserLst : Boolean;            { Create FIDOUSER.LST file        }
      MTypeStr       : ARRAY[0..7] OF S5;  { Node list flag for modem type   }
      Filler         : ARRAY[1..64] OF Byte;
    END;
    DumbTerm : RECORD
      CRSendsLF,                               { Make a CR after receiving a }
                                               { line feed character         }
      DestructiveBS : Boolean;                 { BS deletes characters       }
      ModemInit     : S40;                     { Cmd. to initialize modem    }
      Filler        : ARRAY[1..128] OF Byte;
    END;
    ExtProt : ARRAY[1..5] OF Record
      Key       : Char;                      { Key to use on menu            }
      Name      : S8;                        { Name of protocol              }
      AskDLName : Boolean;                   { Does it need a name to be     }
                                             { supplied by the user          }
      AutoStart : S10;                       { STRING to detect auto-start   }
      SendCmd   : DosPathStr;                   { upload command                }
      RecvCmd   : DosPathStr;                   { download command              }
    END;
    AreaMan : RECORD
      DLCntStart,                            { Character to use for start of }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      DLCntStop    : Char;                   { Character to use for stop of  }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      AdoptDefault,                          { Adopt orphans when entering a }
                                             { file area                     }
      InsDLCnt,                              { Insert download counters, when}
                                             { entering a file area          }
      AddInbound   : Boolean;                { add inbound to file area list }
      FirstArea,                             { First area # (for OPUS)       }
      LastArea     : Byte;                   { Last area # (for OPUS)        }
      DlCDigits    : Byte;                   { Number of digits in DL Cnt    }
      DlCZeroFill  : Boolean;                { Fill with zero [000] or [   ] }
      ViewCMD      : S50;                    { GIF-Viewer command            }
      Filler       : ARRAY[1..11] OF Byte;
    END;
    Packer : ARRAY[1..7] OF RECORD
      AddCmd,                          { Cmd. to add files to an archive     }
      UnPackCmd,                       { Cmd. to extract files from archive  }
      EraseCmd,                        { Cmd. to delete files from archive   }
      TestCmd    : S40;                { Cmd. to test files in an archive    }
    END;
  END;

CONST MaxAddresses     = 126;

TYPE
  TConfig6 = RECORD
    Version        : Byte;             { .CFG file version                   }
    TaskNumber     : Byte;             { Which task number are we            }
    SwapDir        : DosPathStr;          { Where to swap to                    }
    ExtOutboundMan : DosPathStr;       { External Outbound Manager }
    Outbound,                          { Outbound directories                }
    Banner,                            { Name of banner to show callers      }
    DefaultMacro,                      { Name of default keyboard-macro file }
    Editor,                            { Command to envoke message editor    }
    LogfileName    : DosPathStr;          { Log file for your system            }
    LogLevel       : Byte;             { Desired log level (1-5)             }
    UseYearInLog   : Boolean;          { False= ! dd-nnn hh:mm PORTAL        }
                                       { True = ! dd-nnn-yy hh:mm PORTAL     }
    NodeList       : DosPathStr;          { Directory of your nodelist files    }
    NodelistTyp    : NodeListType;     { Type of nodelist used               }

    MainAdrNum     : Byte;
    Addresses      : ARRAY[1..MaxAddresses] Of TFidoAddress;
                                       { Defined addresses                   }
    PointNet       : SmallInt;          { Number of point-net (for fake)      }
    UseFakeAddress : Boolean;          { Should PORTAL Use fake or real      }
                                       { addresses                           }
    Sysop          : S20;              { Name of SysOp                       }
    System         : S60;              { Name of system                      }
    SwapOnExec     : Boolean;          { Swap on exec of any command         }
    EnterBBSText,                      { Text displayed while loading        }
                                       { BBS software                        }
    DoingMailText,                     { Text to display, while in a         }
                                       { mail-only event                     }
    PressESCText   : DosPathStr;          { Text displayed when user should     }
                                       { press ESC                           }
    MaxRinging     : Byte;             { Max RINGING on calls out            }
    ZMHStart,                          { Start of Zone Mail Hour             }
    ZMHEnd,                            { End of Zone Mail Hour               }
    CallTime,                          { Global call frequency               }
    CallWidth      : Time;             { Global max call delay               }
    ConnectFastest : Boolean;          { Check node list for max. speed      }
                                       { and abort poll, if lower            }
    OutReReadDelay : Time;             { Delay between reading outbound      }
                                       { information                         }
    FuncReqPwd     : S20;              { Password for function requests      }
    UseJanus       : Boolean;          { Allow Janus protocol                }
    UseEMSI        : Boolean;          { Allow EMSI hand shake               }
    FastCalls      : Boolean;          { Call systems faster than us         }
    KeepEmptyDirs  : Boolean;          { If Yes, don't delete Zone, 4D Point }
    Curmudgeon     : Boolean;          { If Yes, hang up on calls from       }
                                       { unknown systems           SA:930330 }
    RereadOnCall   : Boolean;          { If set to Y, PoP will reread the    }
                                       { outbound if there is nothing to send}
    Inbound        : ARRAY[TNodeStat] OF DosPathStr;
    InboundToDo    : ARRAY[TNodeStat] OF SmallWord;
    TaskType       : BYTE;             { 0=Normal, 1=Is Request server, }
                                       { 2=Running under Request server }
    HexTask        : Boolean;              { No = MakeTaskFileName makes decimal numbers  SA:940610}
    ZModemDummyPkt : Boolean;          { Send dummy pkt on ZModemSend if there is no outgoing mail }
    Filler         : ARRAY[1..21] of Byte;
    FKey           : ARRAY[1..2, 1..10] OF TFunctionKey;    { See above      }
    Color          : ARRAY[1..4] OF ColorSet;               { See above      }
    BBS : RECORD
      BBSType        : TBBSType;       { BBS Type used                       }
      Path           : DosPathStr;        { Path to BBS-information files       }
      UserFile       : DosPathStr;        { Name of user file, for user editor  }
      MinBaud        : SmallWord;           { Min. baud to enter BBS              }
      MinBaudFile    : DosPathStr;        { File to show slower callers         }
      UserErrorLevel : Byte;           { Error level for all callers         }
      Multi : ARRAY[1..5] OF RECORD
        Key     : Char;                { Key to select BBS                   }
        BatName : S8;                  { Name of .BAT file to create         }
      END;
      DefFile        : S8;             { Name of BBS definition file         }
      Filler         : ARRAY[1..55] of Byte;
    END;
    Modem : RECORD
      CommPort   : Byte;                    { Comm. port number              }
      BaudRate   : SmallWord;                    { Baud rate to initialize modem  }
      PreInit    : S40;                     { ??? }
      Init       : S80;                     { Init. command                  }
      NoAnswer,                             { Init cmd. in NoAnswer event    }
      Dial,                                 { Dial command                   }
      Busy,                                 { Cmd. to make line busy         }
      HangUp,                               { Hang-up command                }
      Answer     : S40;                     { Answer command                 }
      ReInit     : Time;                    { Delay between modem inits,     }
                                            { while the system is idle       }
      LockedBaud : S10;                     { Part of connect STRING, to tell}
                                            { the system that the baud rate  }
                                            { should remain locked (/ARQ)    }
      ExitStr : ARRAY[1..5] Of RECORD
        ConStr : S10;                       { Special exit STRING e.g. /FAX  }
        ErrLvl : Byte;                      { Exit error level for above str }
      END;
      ModemType : ARRAY[0..7] OF RECORD
        Bit     : Byte;
        Dial    : S40;
        DialOut : Boolean;
        Baud    : SmallWord;
      END;
      WaitTime    : Time;              { Sek. to wait for logon   250593 SBC }
      InternalFax : Boolean;           { Use internal fax receive  191093 SA }
      LinkStat    : S10;
      LogLines    : Byte;
      ConnectTime : BYTE;              { How many seconds before CONNECT }
      UseLCR      : BOOLEAN;           { Use Least Cost Routing? }
      UseRingAnaly: BOOLEAN;           { Use Ring Analyzer? }
      Filler      : ARRAY[1..4] OF Byte;
    END;

    Screen         : RECORD
      BlankTime      : Time;           { Time of inactivity, before blanking }
                                       { the screen                          }
      ChkSnow,                         { Check for 'snow' during screen      }
                                       { updates (CGA only)                  }
      KeepOffScrMode,                  { Allow to change screen mode         }
      ScrMode,                         { False=25, True=43/50 lines          }
      HardwareBlank,                   { Blank using hardware interrupt      }
      ExplodingWin   : Boolean;        { Use fancy display of menus and      }
                                       { windows                             }
      FourDigitsYear : BOOLEAN;        { Four digits year in status window }
      Filler         : ARRAY[1..1] OF Byte;
    END;
    Statistics : RECORD
      MdmProtocol : ARRAY[1..5] OF S5;
    END;
    ListFiles : RECORD
      FileList,                          { Name of finished file list         }
      NewsList,                          { Name of new files list             }
      Header,                            { Name of header file for file list  }
      Footer,                            { Name of footer file for file list  }
      TopFile,                           { Name of most downloaded files list }
      StatFile       : DosPathStr;          { Name of area statistics file       }
      Adopt          : Boolean;          { Adopt orphan files while running   }
      AdoptComment   : S40;              { Comment for adopted files          }
      DupeCheck      : Boolean;          { Perform dupe check of file base    }
      Stat           : Boolean;          { Include statistics file in Filelist}
      IncludeTop     : Boolean;          { Include top list in file list      }
      Top            : Byte;             { How many files (0-50) to include in}
                                         { top downloads list                 }
      DkDate         : Boolean;          { Use european date format           }
      NewsDays       : Byte;             { How old files to include in news   }
                                         { file                               }
      Threshold      : Byte;             { DupeCheck Size Threshold           }
      RemMissing,                        { Remove Missing Files               }
      OkPortal,                          { Update portal compatible ok file   }
      ZapZero,                           { Delete zero Byte files             }
      Touch          : Boolean;          { Touch files with invalid time stamp}
      CrapFiles,                            { Files to delete                 }
      ExcludeFiles,                         { Files not to include in FileList}
      NoDupeCheck    : ARRAY[1..10] of S12; { Files not to check for dupes    }
      NonAdoptFiles  : ARRAY[1..10] of S12; { Files not to adopt              }
      NonAdoptAreas  : ARRAY[1..10] of S3;  { Areas not to adopt files in     }
      PrivateAreas   : ARRAY[1..11] of S3;  { Areas to leave out from list    }
      DoBefore       : DosPathStr;             { Command to do before generation }
      DoAfter        : DosPathStr;             { Command to do after generation  }
      DoPack         : DosPathStr;             { Command to pack finished list   }
      DupeReport     : DosPathStr;             { DupeReport filename             }
      TXTFreq        : ARRAY[0..3] of S55;  { Txt to display if Freq is OK    }
      OkBimodempath  : DosPathStr;             { Bimodem compatible OK-File      }
      Filler         : ARRAY[1..32] of Byte;
    END;

                        { 1..3, 1..2 (PrCall, PrDay) }
    Request : RECORD
      Limit : ARRAY[TNodeStat,TReqLimit] OF RECORD
        MaxFiles : SmallWord;
        MaxTime  : Time;
        MaxBytes : LongInt;
      END;
      RspAsPkt       : Boolean;
      SkipAfterFirst : Boolean;        { Skip search after first matching    }
                                       { file - if no jokers in requested    }
                                       { name                                }
      MinBaud        : SmallWord;           { Minimum baudrate required for       }
                                       { requests                  SA:170593 }
      ReqOnUs        : TReqOnUs;
      ReqOnUsCost    : SmallWord;
      Filler         : ARRAY[1..58] of Byte;
    END;

    MailScanner    : RECORD
      Filler1      : ARRAY[1..50] OF Char;
      RenumThresh  : SmallInt;
      NetMailDir   : DosPathStr;
      Filler3      : DosPathStr;
      Secure       : Boolean;
      BadMsgs      : DosPathStr;
      SaveDupesDir : DosPathStr;
      MaxDupes     : SmallWord;
      EchoTossLog  : DosPathStr;
      StripCrash   : Boolean;
      SetAKASent   : Boolean;
      PvtEchoMail  : Boolean;
      SaveFwdMail  : Boolean;
      RouteFile    : DosPathStr;
      ForwardMail  : Boolean;
      KillFwdFiles : Boolean;
      Filler2      : DosPathStr;
      OldExt       : Boolean;
      DefaultPacker: Byte;
      NetMailBoard : Byte;
      ForceWIPMode : Boolean;
      Filler       : ARRAY[1..127] OF Char;
    END;
    FwdFile        : RECORD
      PreCmd       : DosPathStr;        { Cmd. to run before forwarding }
      SecureDir    : DosPathStr;        { Path to security directory    }
      MsgAttribute : SmallWord;
      KillSent     : Boolean;        { Mark msgs. as kill/sent       }
      MsgPrivate   : Boolean;        { Mark msgs. as private         }
      Subject      : S72;            { Subject of forward msgs.      }
      Filler       : ARRAY[1..64] OF Byte;
    END;
    Tick : RECORD
      DupeDir        : DosPathStr;          { Dupe check directory               }
      HoldDir        : DosPathStr;          { Where to place outgoing .TIC files }
      BeforeMoving   : DosPathStr;          { Command to execute before          }
                                         { processing any ticks               }
      RequestMissing : Boolean;          { Should Portal try to make a file
                                         { request for any files, not received}
      Filler         : ARRAY[1..64] of Byte;
    END;
    BiMail         : RECORD
      BiOverride     : ARRAY[1..5] Of S10;   { Protocol flags to override    }
                                             { full duplex max baud          }
      NoSendOverride : Boolean;              { Override no send events when  }
                                             { using a full duplex protocol  }
      MaxBaud        : SmallWord;                 { Max. baud rate for full       }
                                             { duplex.                       }
      BiModemPath    : DosPathStr;              { Path & file name of BiModem   }
                                             { program                       }
      Filler         : ARRAY[1..16] OF Byte;
    END;
    NLCompiler     : RECORD
      CostFileName   : DosPathStr;            { Name of cost file               }
      IntPrefix      : S10;                { Int. dial prefix                }
      OurPrefix      : S10;                { Prefix (direction number) of    }
                                           { your country                    }
      UseFidoUserLst : Boolean;            { Create FIDOUSER.LST file        }
      MTypeStr       : ARRAY[0..7] OF S5;  { Node list flag for modem type   }
      Filler         : ARRAY[1..64] OF Byte;
    END;
    DumbTerm : RECORD
      CRSendsLF,                               { Make a CR after receiving a }
                                               { line feed character         }
      DestructiveBS    : Boolean;              { BS deletes characters       }
      ModemInit        : S40;                  { Cmd. to initialize modem    }
      TimeOutNoCarrier : SMALLWORD;            { TimeOut, if No Carrier }
      TimeOutCarrier   : SMALLWORD;            { TimeOut, if Carrier }
      ExtTermErrorlevel: BYTE;                 { Errorlevel for external terminal }
      Filler           : ARRAY[1..123] OF Byte;
    END;
    ExtProt : ARRAY[1..5] OF Record
      Key       : Char;                      { Key to use on menu            }
      Name      : S8;                        { Name of protocol              }
      AskDLName : Boolean;                   { Does it need a name to be     }
                                             { supplied by the user          }
      AutoStart : S10;                       { STRING to detect auto-start   }
      SendCmd   : DosPathStr;                   { upload command                }
      RecvCmd   : DosPathStr;                   { download command              }
    END;
    AreaMan : RECORD
      DLCntStart,                            { Character to use for start of }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      DLCntStop    : Char;                   { Character to use for stop of  }
                                             { a download counter, in a      }
                                             { FILES.BBS                     }
      AdoptDefault,                          { Adopt orphans when entering a }
                                             { file area                     }
      InsDLCnt,                              { Insert download counters, when}
                                             { entering a file area          }
      AddInbound   : Boolean;                { add inbound to file area list }
      FirstArea,                             { First area # (for OPUS)       }
      LastArea     : Byte;                   { Last area # (for OPUS)        }
      DlCDigits    : Byte;                   { Number of digits in DL Cnt    }
      DlCZeroFill  : Boolean;                { Fill with zero [000] or [   ] }
      ViewCMD      : S50;                    { GIF-Viewer command            }
      Filler       : ARRAY[1..11] OF Byte;
    END;
    Packer : ARRAY[1..7] OF RECORD
      AddCmd,                          { Cmd. to add files to an archive     }
      UnPackCmd,                       { Cmd. to extract files from archive  }
      EraseCmd,                        { Cmd. to delete files from archive   }
      TestCmd    : S40;                { Cmd. to test files in an archive    }
    END;
  END;

VAR G           : FILE OF BYTE;
    F           : FILE OF TConfig4;
    E           : FILE OF TConfig6;
    sCFGVersion : BYTE;
    CFG4        : TConfig4;
    CFG6        : TConfig6;
    X           : TNodeStat;
    CFGFilename : STRING;
    test:word;

PROCEDURE HaltOnFileError(Error : STRING);
  BEGIN
    Writeln(Error);
    Writeln('Program aborted!');
    Writeln;
    Writeln('Usage: CONVPCFG <portal configuration file name>');
    Writeln('       f. e. CONVPCFG portal.cfg');
    Halt(1);
  END;

PROCEDURE ConvertFile(SourceLen, StartSkip, SkipWidth : WORD; NewVersion : BYTE);
VAR Z           : Array[0..15000] OF BYTE;
    CZ          : WORD;
  BEGIN
    FillChar(Z, SizeOf(Z), #0);
    Assign(G, CFGFilename);
    FileMode := ShareRead+ShareDenyW;
    Reset(G);
    IF IOResult <> 0 THEN HaltOnFileError('Input configuration file not found!');
    FOR cz:= 0 TO SourceLen-1 DO BEGIN
        IF cz < StartSkip THEN Read(G, z[cz]) ELSE Read(G, z[cz+SkipWidth]);
        IF IOResult <> 0 THEN HaltOnFileError('Can not read from configuration file!');
    END;
    Close(G);
    z[0] := NewVersion;
    sCFGVersion := NewVersion;
    Assign(G, CFGFilename);
    Rewrite(G);
    IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
    FOR cz:= 0 TO SourceLen+SkipWidth-1 DO BEGIN
      Write(G, z[cz]);
      IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
    END;
    Close(G);
  END;

BEGIN
  Writeln('Portal configuration file converter 6.0 - (c) Marcus Roeckrath, 1999');
  Writeln('Distributed with PoP 0.63 b 9 GPT 06 - Updates older Portal');
  Writeln('configuration files to the structure needed by PoP 0.63 b 9 GPT 06');
  IF ParamCount <> 0 THEN BEGIN
    CFGFilename := ParamStr(1);
    Assign(G, CFGFilename);
    FileMode:=ShareRead+ShareDenyW;
    Reset(G);
    IF IOResult <> 0 THEN HaltOnFileError('Input configuration file not found!');
    Read(G, sCFGVersion);
    IF IOResult <> 0 THEN HaltOnFileError('Can not read from configuration file!');
    Close(G);
    IF (sCFGVersion = 0) OR (sCFGVersion = 1) THEN BEGIN
      Writeln('No upgrade possible! Configuration file to old!');
      Halt(1);
    END;
    IF sCFGVersion = CFGVersion THEN BEGIN
      Writeln('No update needed! Configuration file is up to date.');
      Halt(1);
    END;
    IF sCFGVersion > CFGVersion THEN BEGIN
      Writeln('Not a Portal configuration file or wrong version of this conversion tool!');
      Halt(1);
    END;
    IF (sCFGVersion = 2) OR (sCFGVersion = 3) THEN BEGIN
      Assign(F, CFGFilename);
      FileMode := ShareRead+ShareDenyW;
      Reset(F);
      IF IOResult <> 0 THEN HaltOnFileError('Configuration file not found!');
      Read(F, CFG4);
      IF IOResult <> 0 THEN HaltOnFileError('Can not read from configuration file!');
      Close(f);
      IF sCFGVersion = 2 THEN BEGIN
        Writeln('Upgrading configuration file from version 2 to 3.');
        CFG4.Version := 3;
        sCFGVersion := 3;
        FOR X := nsUnknown TO nsPassword DO BEGIN
           CFG4.Inbound[x]:=CFG4.Filler1;
           CFG4.InboundToDo[nsKnown]:=itd_Tick+itd_File+itd_Mail;
           FillChar(CFG4.Filler1, SizeOf(CFG4.Filler1), 0);
           CFG4.Modem.WaitTime:=60;
        END;
      END;
      IF sCFGVersion = 3 THEN BEGIN
        Writeln('Upgrading configuration file from version 3 to 4.');
        CFG4.Version := 4;
        sCFGVersion := 4;
        Move(CFG4.Modem.Init[41], CFG4.Modem.NoAnswer, 645);
        IF CFG4.Modem.WaitTime=0 THEN CFG4.Modem.WaitTime:=60;
        CFG4.Modem.ConnectTime := 0;
        CFG4.Modem.UseLCR      := FALSE;
        CFG4.Modem.UseRingAnaly := FALSE;
        CFG4.screen.FourDigitsYear := FALSE;
        Assign(F, CFGFilename);
        Rewrite(F);
        IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
        Write(F, CFG4);
        IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
        Close(F);
      END;
    END;
    IF sCFGVersion = 4 THEN BEGIN
      Writeln('Upgrading configuration file from version 4 to 5.');
      ConvertFile(10240, $306, 880, 5);
    END;
    IF sCFGVersion = 5 THEN BEGIN
      Assign(E, CFGFilename);
      FileMode := ShareRead+ShareDenyW;
      Reset(E);
      IF IOResult <> 0 THEN HaltOnFileError('Input configuration file not found!');
      Read(E, CFG6);
      IF IOResult <> 0 THEN HaltOnFileError('Can not read from configuration file!');
      Close(E);
      Writeln('Upgrading configuration file from version 5 to 6.');
      CFG6.Version := 6;
      sCFGVersion := 6;
      CFG6.DumbTerm.TimeOutNoCarrier := 300;
      CFG6.DumbTerm.TimeOutCarrier := 300;
      Assign(E, CFGFilename);
      Rewrite(E);
      IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
      Write(E, CFG6);
      IF IOResult <> 0 THEN HaltOnFileError('Can not write to configuration file!');
      Close(E);
    END;
  END
  ELSE BEGIN
    Writeln;
    Writeln('Usage: CONVPCFG <portal configuration file name>');
    Writeln('       f. e. CONVPCFG portal.cfg');
  END;
END.