/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PackFile
implements Serializable {
    public static final int OVERRIDE_FALSE = 0;
    public static final int OVERRIDE_TRUE = 1;
    public static final int OVERRIDE_ASK_FALSE = 2;
    public static final int OVERRIDE_ASK_TRUE = 3;
    public static final int OVERRIDE_UPDATE = 4;
    public String sourcePath = null;
    private String targetPath = null;
    private List osConstraints = null;
    private long length = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private int override = 0;
    private Map additionals = null;
    public int previousPackNumber = -1;
    public long offsetInPreviousPack = -1L;

    public PackFile(File src, String target, List osList, int override) throws FileNotFoundException {
        if (!src.exists()) {
            throw new FileNotFoundException("No such file: " + src);
        }
        if ('/' != File.separatorChar) {
            target = target.replace(File.separatorChar, '/');
        }
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        this.sourcePath = src.getPath();
        this.targetPath = target;
        this.osConstraints = osList;
        this.override = override;
        this.length = src.length();
        this.mtime = src.lastModified();
        this.isDirectory = src.isDirectory();
    }

    public PackFile(File src, String target, List osList, int override, Map additionals) throws FileNotFoundException {
        this(src, target, osList, override);
        this.additionals = additionals;
    }

    public void setPreviousPackFileRef(int previousPackNumber, long offsetInPreviousPack) {
        this.previousPackNumber = previousPackNumber;
        this.offsetInPreviousPack = offsetInPreviousPack;
    }

    public final List osConstraints() {
        return this.osConstraints;
    }

    public final long length() {
        return this.length;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final int override() {
        return this.override;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.previousPackNumber >= 0;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public Map getAdditionals() {
        return this.additionals;
    }
}

