unit freedoor;

{
        FreeDoor 1.14 for VP/BP
        Release Date: 06/20/2001
        (C)opyright 2000-2001 Mike Hodgson
        EleCom is (C)opyright Maarten Bekers

        Released under the BSD License. Please see License.txt.

        Revision History

        1.14    ::  Support for Borland Delphi added.

        1.13    ::  Updated docs
                    Changed to BSD license.
                    Finally removed CEXYZ send procedure.

        1.12    ::  Removed second decimal from version number :o)
                    Added Basic Multinode Messaging support.
                        (see CSendToNode and CGetFromNode in docs)


        1.1.0   ::  Added support for Borland Pascal, the doorkit can now
                        be used to create 16bit DOS doors.
                    Added some speed improvements to CMaskInput.
                    Added CCenter procedure for centering text.

        1.0.8   ::  Fixed problem with programs crashing after being
                        started with no command-line parameters.
                    Changed timing code. SysSysMsCount did not seem to
                        work on some WinNT systems. Code now uses GetTimeMSec.
                    CGotoXY was reversed (oopsie!), works properly now.
                    Kit is now much more processor friendly, no more 100%
                        CPU usage!


        1.0.6   ::  Fixed slight problem with timer code
                    StatFore and StatBack actually change the statusbar's
                        colors now.

        1.0.4   ::  Added support for WWIV and Synchronet colour codes.

        1.0.2   ::  Changed Statusbar code to use SysSysMsCount instead of
                        old, complicated elapsed time routine.
                    Took redundant code out of CGetChar.

        1.0.0   ::  Additions/Fixes supplied by Michael Preslar denoted by mp
                    Additions/Fixes supplied by Rick Parrish denoted by rp
                    Added MASK_* constants for CMaskInput (see freedoor.inc)
                    Fixed some more ANSI problems
                    Compiled and tested with Virtual Pascal 2.1 prebeta

        0.9.8   ::  Fixed major bug in CWriteFile()
                    Added DORINFOx.DEF support
                    Added /N<node number> switch

        0.9.5   ::  New ANSI parser written from scratch, some code
                    fixed that was messing up colours.

        0.9.2   ::  Initial public release.

        COMMAND LINE PARAMETER EXAMPLES

        doorname.exe /L                               -- for local mode
        doorname.exe /Dc:\path\to\door.sys /P#        -- for normal FOSSIL mode, # = port number
        doorname.exe /Dc:\path\to\door.sys /T /P#     -- Telnet mode, # = port handle

        If your system is using DOOR32.SYS, /T and /P# are not required.

}

{NOTE : Modify COLORDEF.INC to select which sets of colour codes you
        would like to support}

interface

uses
{$IFDEF OS2}os2base,{$ENDIF}                                    {mp}
{$IFDEF WIN32}windows,{$ENDIF}                                  {mp}
{$IFDEF MSDOS} BPCompat, {$ENDIF}
{$IFDEF VirtualPascal}Use32, VPUtils, VpSysLow, sysutils, {$ENDIF}
crt, dos, newansi, extra, elenorm;

{$I FREEDOOR.INC}

function InitDoorDriver : boolean;
Procedure DeInitDoorDriver;
Procedure CClrScr;
Procedure CClrEol;
Procedure CursorSave;
Procedure CursorRestore;
Procedure CursorUp (Distance : Integer);
Procedure CursorDown (Distance : Integer);
Procedure CursorBack (Distance : Integer);
Procedure CursorForward (Distance : Integer);
Procedure CGotoXY (X,Y : Integer);
Procedure ErrorWriteLn (S : String); {Prints message w/o calling statbar }
Procedure CWriteLn (S : String);
Procedure CWrite (S : String);
Procedure CGetChar (var Ch: Char);  { From Manning's MDoor kit! }
Procedure CReadLn (var S: String);  { From Manning's MDoor kit! }
Procedure CWriteLong (I : LongInt);
Procedure CGetByte (var B: Byte);
Procedure CWriteLnLong (I : LongInt);
Procedure CReadLnLong (var L: LongInt);
Procedure CPause;
Procedure CWriteFile (FN : String);
Function CMaskInput (mask : String; StrLength : Byte) : String;
Procedure CCenter (S : String);
Procedure CWindow (X1,Y1,X2,Y2 : Integer);
Procedure CSendToNode (S : String; Node : String);
Procedure CGetFromNode;

implementation


(*************************************************************)
 Procedure LocalLogin;
(*************************************************************)
var
  tempusername : String;
begin
  clrscr;
  textcolor(7);
  textbackground(0);
  WriteLn ('Enter your name or leave blank for SYSOP');
  Write (':: ');
  TextColor(15);
  ShowCursor;                                                   {mp}
  ReadLn (tempusername);
  HideCursor;                                                   {mp}
  If (tempusername <> '') then fdInfo.RealName := tempusername;
  fdInfo.Handle := fdInfo.RealName;
  TextColor(7);
end;

(*************************************************************)
 function ReadDropFile (DropPath : String) : Boolean;
(*************************************************************)
var
  f : text;           { Dropfile file variable }
  s : string;         { Temporary String }
  {$IFDEF VirtualPascal}
  i : LongInt;        { Temporary Integer }
  {$ELSE}
  i : Integer;
  {$ENDIF}
  Procedure ReadDoorSys;
  begin
    readln (f,s);
    delete (s,1,3);
    delete (s,2,1);
    val(s,fdInfo.ComPort,i);
    if fdInfo.ComPort <> 0 then fdInfo.ConnType := 1;
    readln(f,s); { remote baud rate}
    val(s,fdInfo.Baud,i);
    readln(f,s); {dbits}
    readln(f,s); {node num}
    fdInfo.Node := s;
    readln(f,s); {actual internal bbs}
    readln(f,s); {screen on}
    readln(f,s); {printer}
    readln(f,s); {page bell}
    readln(f,s); {caller bell}
    readln(f,s); {user name}
    fdInfo.RealName := s;
    fdInfo.Handle := fdInfo.RealName;
    readln(f,s); {city,state}
    fdInfo.CityState := s;
    readln(f,s); {home phone}
    readln(f,s); {work phone}
    readln(f,s); {password}
    readln(f,s); {security}
    val(s,fdInfo.ACS,i);
    readln(f,s); {times on}
    readln(f,s); {last called}
    readln(f,s); {secs left}
    readln(f,s); {time left}
    val(s,fdInfo.TimeLeft,i);
    fdInfo.TotalTime := fdInfo.TimeLeft;
    readln(f,s); {graphics code}
    if s='GR' then fdInfo.GraphMode:=ANSI_GRAPH
    else if s='RIP' then fdInfo.GraphMode:=RIP_GRAPH
    else fdInfo.GraphMode:=ASCII_GRAPH;
    close(f);
  end;

  Procedure ReadDoor32Sys;
  begin
    readln (f,s);
    val(s,fdInfo.ConnType,i);
    readln (f,s);
    val(s,fdInfo.ComPort,i);
    readln (f,s);
    val(s,fdInfo.Baud,i);
    readln (f,s);
    fdInfo.BBSID := s;
    readln (f,s);
    val(s,fdInfo.RecPos,i);
    readln (f,s);
    fdInfo.RealName := s;
    readln (f,s);
    fdInfo.Handle := s;
    readln (f,s);
    val(s,fdInfo.ACS,i);
    readln (f,s);
    val(s,fdInfo.TimeLeft,i);
    fdInfo.TotalTime := fdInfo.TimeLeft;
    readln (f,s);
    val (s,fdInfo.GraphMode,i);
    readln (f,s);
    fdInfo.Node := s;
    close(f);
  end;

  Procedure ReadDorinfo;
  begin
    readln (f,s);
    readln (f,s);
    readln (f,s);
    readln (f,s);
    val(s,fdInfo.ComPort,i);
    readln (f,s);
    val(s,fdInfo.Baud,i);
    readln (f,s);
    readln (f,s);
    fdInfo.RealName := s;
    readln (f,s);
    fdInfo.RealName := fdInfo.RealName + ' ' + s;
    fdInfo.Handle := fdInfo.RealName;
    readln (f,s);
    fdInfo.CityState := s;
    readln (f,s);
    if (s = '0') then fdInfo.GraphMode := ASCII_GRAPH else fdInfo.GraphMode := ANSI_GRAPH;
    readln (f,s);
    val(s,fdInfo.ACS,i);
    readln (f,s);
    val(s,fdInfo.TimeLeft,i);
    fdInfo.TotalTime := fdInfo.TimeLeft;
    readln (f,s);
    close(f);
  end;

begin
  assign (f,DropPath);
  if not (FileExists(DropPath)) then
  begin
    WriteLn ('ReadDropFile :: ERROR :: DropFile not found!');
    ReadDropFile := False;
  end
  else
  begin
    reset(f);
    fdInfo.DropFile := DropPath;
    if (fdInfo.DropType = 1) then ReadDoorSys
    else if (fdInfo.DropType = 2) then ReadDoor32Sys
    else if (fdInfo.DropType = 3) then ReadDorinfo;
    ReadDropFile := True;
  end;
end;

(*************************************************************)
 function tl: word;
(*************************************************************)
begin;
  tl := (GetTimeMSec div 1000) - SavedTime;
end;

(*************************************************************)
 procedure UpdateStatusBar;
(*************************************************************)
var
  c,d: word;
  x,y: integer;
  OldTextAttr : Byte;
begin
  SysCtrlSleep(2);
  OldTextAttr := TextAttr;
  x:=wherex;
  y:=wherey;
  window(1,25,80,25);
  textcolor(StatFore);
  textbackground(StatBack);
  if (FirstTime = True) then
  begin
    clreol;
    gotoxy(1,1);
    write(fdInfo.RealName);
    GotoXY (40 - (Length(ProgName) div 2),1);
    Write (ProgName);
    LastTime := 30000;
    FirstTime := False;
  end;
  c:= (fdInfo.TimeLeft-1) - (tl div 60);
  d:=60- (tl mod 60);
  if ((c -1 = -1) and (d-1 = 0)) then
    begin
      textcolor(7);
      textbackground(0);
      window(1,1,80,25-1);
      gotoxy(x,y);
      ErrorWriteLn('`0CTime limit exceeded');
      delay(1);
      halt(0);
    end;
  if ((GetTimeMSec div 1000 div 60) - (LkTime div 1000 div 60)) >= 5 then
    begin
      textcolor(7);
      textbackground(0);
      window(1,1,80,25-1);
      gotoxy(x,y);
      ErrorWriteLn('User Inactive.');
      delay(10);
      halt(0);
    end;
    if (d <= (LastTime - 5)) or (d = 55) then
    begin
      gotoxy(72,1);
      write ('     ');
      gotoxy(72,1);
      write(c,':');
      if d<10 then write('0');
      write(d);
      LastTime:=d;
    end;
    TextAttr := OldTextAttr;
    window(1,1,80,25-1);
    gotoxy(x,y);
end;

(*************************************************************)
 function InitDoorDriver : boolean;
(*************************************************************)
var
  TempInt  : LongInt;
  TempStr  : String;
{$IFDEF VirtualPascal}
  Code     : LongInt;
{$ELSE}
  Code     : Integer;
{$ENDIF}
{$IFDEF WIN32}                                                  {mp}
  pp:array[0..40] of char;                                      {mp}
  pc:pchar;                                                     {mp}
{$ENDIF}                                                        {mp}

begin
  MouseOff;                                                     {mp}
  HideCursor;
{$IFDEF WIN32}                                                  {mp}
  pc:=pp;                                                       {mp}
  pc:=strpcopy(pc,progname);                                    {mp}
  setconsoletitle(pc);                                          {mp}
{$ENDIF}                                                        {mp}

  fdInfo.ConnType := 0;
  fdInfo.BBSID := 'Unknown';
  fdInfo.Handle := 'Sysop';
  fdInfo.RealName := 'Sysop';
  fdInfo.CityState := 'Somewheresville';
  fdInfo.ACS := 255;
  fdInfo.TimeLeft := 3000;
  fdInfo.TotalTime := 3000;
  fdInfo.ComPort := 0;
  fdInfo.Baud := 0;
  fdInfo.Node := '0';
  fdInfo.Graphmode := ANSI_GRAPH;
  fdInfo.DropFile := '';
  fdInfo.DropType := 0;
  if (ParamCount = 0) then
  begin
    writeln ('InitDoorDriver :: ERROR :: You didn''t tell me what to do!');
    writeln ('Exiting.');
{mp}    writeln (' If you''re trying to load this program locally, you should do a');
{mp}    writeln;
{mp}    writeln (' '+paramstr(0)+' /l');

    InitDoorDriver := False;
    isLocal := True;
  end
  else
  begin
    for TempInt := 1 to ParamCount do
      begin
        if (UpperCase(ParamStr(TempInt)) = '/L') then          {Local Only?}
          isLocal := True;
        if (pos('/D',UpperCase(ParamStr(TempInt))) <> 0) then  {Read Dropfile!}
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete(TempStr,1,2);
            if (pos('DOOR.SYS',UpperCase(TempStr)) <> 0) then fdInfo.DropType := 1 else
              if (pos('DOOR32.SYS',UpperCase(TempStr)) <> 0) then fdInfo.DropType := 2 else
              if (pos('DORINFO',UpperCase(TempStr)) <> 0) then fdInfo.DropType := 3 else fdInfo.DropType := 0;
            ReadDropFile (TempStr);
          end;
        if (pos('/T',UpperCase(ParamStr(TempInt))) <> 0) then fdInfo.ConnType := 02;
        if (pos('/N',UpperCase(ParamStr(TempInt))) <> 0) then
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete (TempStr,1,2);
            fdInfo.Node := TempStr;
          end;
        if (pos('/P',UpperCase(ParamStr(TempInt))) <> 0) then
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete (TempStr,1,2);
            val(TempStr,fdInfo.ComPort,Code);
          end;
      end;
    if (fdInfo.ConnType = 0) or (fdInfo.ComPort = 0) then isLocal := True;
    if (not isLocal) then
    begin
      Com_StartUp(fdInfo.ConnType);
      Com_SetDontClose(True);
      Com_OpenQuick(fdInfo.ComPort);
      Com_SendString(#27 + '[0;37m');
    end;
    if ((isLocal) and (fdInfo.DropType = 0)) then LocalLogin;
    LkTime := GetTimeMSec;
    SavedTime := GetTimeMSec div 1000;
    UpdateStatusBar;
    CWrite(#27 + '[0;37m');
    InitDoorDriver := True;
  end;
end;

(*************************************************************)
 Procedure DeInitDoorDriver;
(*************************************************************)
begin
  ShowCursor;
  if (not isLocal) then Com_Shutdown;
end;

(*************************************************************)
 Procedure CClrScr;
(*************************************************************)
begin
  if (not isLocal) then
    Com_SendString(#27 + '[2J');
  ClrScr;
end;

(*************************************************************)
 Procedure CClrEol;
(*************************************************************)
begin
  if (not isLocal) then
    Com_SendString(#27 + '[K');
  ClrEol;
end;

(*************************************************************)
 Procedure CursorSave;
(*************************************************************)
Begin
  CWrite (#27 + '[s');
End;

(*************************************************************)
 Procedure CursorRestore;
(*************************************************************)
Begin
  CWrite (#27 + '[u');
End;

(*************************************************************)
 Procedure CursorUp (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'A');
End;

(*************************************************************)
 Procedure CursorDown (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'B');
End;

(*************************************************************)
 Procedure CursorBack (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'D');
End;

(*************************************************************)
 Procedure CursorForward (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'C');
End;

(*************************************************************)
 Procedure CGotoXY (X,Y : Integer);
(*************************************************************)
var
  TempX : String;
  TempY : String;
begin
  Str(X,TempX);
  Str(Y,TempY);
  CWrite (#27 + '[' + TempX + ';' + TempY + 'H');
end;

(*************************************************************)
 Procedure ErrorWriteLn (S : String); {Prints message w/o calling statbar }
(*************************************************************)
begin
  if not (isLocal) then
    Com_SendString(S + #10#13);
  WriteLn (S);
end;

(*************************************************************)
 Procedure CWrite (S : String);
(*************************************************************)
begin
  Convert_To_ANSI(S);
  if (not isLocal) then
    Com_SendString(S);
  AWrite (S);
  UpdateStatusBar;
end;

(*************************************************************)
 Procedure CWriteLn (S : String);
(*************************************************************)
begin
  CWrite(S + #10#13);
end;

(*************************************************************)
  Procedure CWriteLnLong (I : LongInt);
(*************************************************************)
var
  S : String;
begin
  str(I,S);
  CWrite (S + #10#13);
end;

(*************************************************************)
  Procedure CWriteLong (I : LongInt);
(*************************************************************)
var
  S : String;
begin
  str(I,S);
  CWrite (S);
end;

(*************************************************************)
 Procedure CGetChar (var Ch : Char);  { From Manning's MDoor kit! }
(*************************************************************)
begin
     Ch := #0;
     if (isLocal) then
     begin
          repeat
                if (KeyPressed) then
                   Ch := ReadKey;
          SysCtrlSleep(2);
           CGetFromNode;
          UpdateStatusBar;
          until (Ch <> #0);
     end else
     begin
          repeat
                if (KeyPressed) then
                   Ch := ReadKey;
                     if (Com_CharAvail) then
                        Ch := Com_GetChar;
          SysCtrlSleep(2);
          CGetFromNode;
          UpdateStatusBar;
          until (Ch <> #0) or (Not(Com_Carrier));
     end;
     LkTime := GetTimeMSec;
end;

(*************************************************************)
  Procedure CGetByte (var B : Byte);
(*************************************************************)
var
  C : Char;
{$IFDEF VirtualPascal}
  Code : LongInt;
{$ELSE}
  Code : Integer;
{$ENDIF}
begin
  CGetChar(C);
  val (C,B,Code);
end;

(*************************************************************)
 Procedure CReadLn (var S: String);  { From Manning's MDoor kit! }
(*************************************************************)
var
   Ch: Char;
begin
     S := '';
     Ch := #0;
     if (isLocal) then
     begin
          repeat
                CGetChar(Ch);
                CWrite(Ch);
                if (Ch <> #13) and (Ch <> #10) then
                   S := S + Ch;
          until (Ch = #13);
     end else
     begin
          repeat
                CGetChar(Ch);
                CWrite(Ch);
                if (Ch <> #13) and (Ch <> #10) then
                   S := S + Ch;
          until (Ch = #13) or (Not(Com_Carrier));
     end;
     if Not(isLocal) then
        Com_SendChar(#10);
     WriteLn;
end;

(*************************************************************)
  Procedure CReadLnLong (var L : LongInt);
(*************************************************************)
var
  S : String;
{$IFDEF VirtualPascal}
  Code : LongInt;
{$ELSE}
  Code : Integer;
{$ENDIF}
begin
  CReadLn(S);
  val (S,L,Code);
end;

(*************************************************************)
 Procedure CPause;
(*************************************************************)
var
  C : Char;
begin
  CWrite (PAUSE_STRING);
  CGetChar(C);
  CwriteLn('');
end;

(*************************************************************)
 Procedure CWriteFile (FN : String);
(*************************************************************)
var
  f: file;
  s : array[1..255] of char;
  numread : integer;
  tempint : integer;
  tempint2 : integer;
  tempstr : string[255];
begin
  Fillchar (s,sizeof(s),#0);
  Assign(f,FN);
  Reset(f,1);
  if not (FileExists(FN)) then
    CWriteLn ('`0A*** FILE ' + FN + ' NOT FOUND ***')
  else
  begin
    repeat
      {$I-}BlockRead (f,s,sizeof(s),numread);{$I+}
      if (numread > 0) and (IOResult = 0) then
      begin
            Move(s,tempstr[1],numread);
            tempstr[0] := chr(numread);
            CWrite(tempstr);
            tempstr[0] := #0;
      end;
    until ((EOF(f)) or (numread <= 0));
    FlushAnsi;
    close (f);
  end;
end;

(*************************************************************)
 Function CMaskInput (mask : String; StrLength : Byte) : String;
(*************************************************************)
Var
  ch : Char;
  DummyByte : Byte;
  s : String;
begin
 s:='';
 CWrite ('`1F');
 Fillchar(s,StrLength + 2, ' ');
 CursorSave;
 CWrite (s);
 s := '';
 CursorRestore;
 CWrite (' ');
 if s<>'' then CWrite(s) else begin
  repeat
   CGetChar(ch);
   if (ch<>#8) and (ch<>^M) and (Pos(UpCase(Ch), mask) = 0) and (length(s) < StrLength) then
   begin
     s:=s+ch;
     CWrite(ch);
   end;
   if (ch=chr(8)) and (length(s)>0) then
   begin
     delete(s,length(s),1);
     CWrite(chr(8)+' '+chr(8));
   end;
  until (ch=^M);
 end;
 CWriteln('`07');
 CMaskInput := s;
end;
(*************************************************************)
 Procedure CCenter (S : String);
(*************************************************************)
begin
  CGotoXY (40 - (Length(S) div 2), WhereY);
  CWrite (S);
end;

(*************************************************************)
 Procedure CWindow (X1,Y1,X2,Y2 : Integer);
(*************************************************************)
var
  TempInt : Integer;
  StoredX : Integer;
  StoredY : Integer;
begin
  StoredX := WhereX;
  StoredY := WhereY;
  CGotoXY (X1,Y1);
  CWrite ('');
  for TempInt := (X1 + 1) to (X2 - 1) do
    CWrite ('');
  CWrite ('');
  for TempInt := (Y1 + 1) to (Y2 - 1) do
  begin
    CGotoXY(X2,TempInt);
    CWrite ('');
  end;
  CGotoXY (X1,Y2);
  CWrite ('');
  for TempInt := (X1 + 1) to (X2 - 1) do
    CWrite ('');
  CWrite ('');
  for TempInt := (Y1 + 1) to (Y2 - 1) do
  begin
    CGotoXY(X1,TempInt);
    CWrite ('');
  end;
  CGotoXY(StoredX,StoredY);
end;

(*************************************************************)
Procedure CSendToNode (S: String; Node : String);
(*************************************************************)
var
  NodeFile : Text;
begin
  Assign (NodeFile, 'MSG'+Node+'.TMP');
  Repeat
    {$I-}ReWrite (NodeFile){$I+}
  Until (IOResult = 0);
  WriteLn (NodeFile, 'From ' + fdInfo.Handle + ' on Node #' + fdInfo.Node);
  WriteLn (S);
  Close (NodeFile);
end;

(*************************************************************)
Procedure CGetFromNode;
(*************************************************************)
var
  NodeFile : Text;
  S : String;
begin
  If FileExists('MSG'+fdInfo.Node+'.TMP') then
  Begin
    Assign (NodeFile, 'MSG'+fdInfo.Node+'.TMP');
    Reset (NodeFile);
    ReadLn (NodeFile, S);
    CWriteLn ('`0A' + S);
    ReadLn (NodeFile, S);
    CWriteLn ('`02' + S);
    CWriteLn ('');
    Close (NodeFile);
    Erase (NodeFile);
  end;
end;

end.
