{$A+,B-,D+,E+,F-,G-,I+,L+,N+,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384,0,655360}
Unit ArcMisc; { by John Stephenson; Copyright 1995 }
Interface
Uses Dos,FileMisc;
Const
  Unknown = 0;
  _Zip = 1;
  _Arj = 2;
  _Lzh = 3;
  _Zoo = 4;
  _Arc = 5;
  _Pak = 6;
  _Rar = 7;
Const
  ArcNames: array[_zip.._rar] of string[3] =
   ('ZIP','ARJ','LZH','ZOO','ARC','PAK','RAR');
Type
  ZipSearchRec = record
    Time: Longint;
    CMethod: word;
    CSize,
    USize,
    CRC32: Longint;
    Name: PathStr;
    { Private variables! }
    ZipPlace,ZipSize: Longint; ZipFn: PathStr;
  End;

Function GetArcType(Fn: String): Byte;
Procedure ZipFindFirst(ZipName: PathStr; var sr: ZipSearchRec);
Procedure ZipFindNext(var sr: ZipSearchRec);

Implementation
Type
  tZipHeader = Record
    Signature: longint;
    Version,GPBFlag,Compress: word;
    arctime: longint;
    ArcCRC32,ArcCSize,ArcUSize: longint;
    FNameLen,ExtraField: word;
  end;
Const
  ZipLocalFileSig = $04034B50;
  ZipCentralFileSig = $02014B50;
  ZipEndCentralFileSig = $06064B50;

Function GetArcType(Fn: String): Byte;
Var
  ArcFile: File;
  c      : Array[1..5] of char;
  Attr   : word;
begin
  GetArcType := unknown;
  Assign(ArcFile,Fn);
  Getfattr(ArcFile,attr);
  if doserror<>0 then exit;
  { We can't open system hidden files }
  Setfattr(ArcFile,attr and (anyfile-sysfile-hidden-readonly));
  Reset(ArcFile,1);
  if (ioresult=0) then begin
    if (filesize(ArcFile)>=5) then begin
      blockread(arcfile,c,5);
      if (c[1]='P') and (c[2]='K') and (c[3]=#3) and (c[4]=#4) then GetArcType := _Zip
      else if (c[1]=#$60) and (c[2]=#$EA) then GetArcType := _Arj
      else if (c[4]='l') and (c[5]='h') then GetArcType := _Lzh
      else if (c[1]='Z') and (c[2]='O') and (c[3]='O') then GetArcType := _Zoo
      else if (c[1]=#$1A) and (c[2]=#$08) then GetArcType := _Arc
      else if (c[1]=#$1A) and ((c[2]<=#$0B)) then GetArcType := _Pak
      else if (c[1]='R') and (c[2]='a') and (c[3]='r') and (c[4]='!') then GetArcType := _Rar;
    End;
    Close(ArcFile);
  End;
  Setfattr(ArcFile,attr);
end;

Procedure ZipFindFirst(ZipName: PathStr; var sr: ZipSearchRec);
{ Finds the first file entry in a zipfile. Please note that this a}
var
  header: tZipHeader;
  f: file;
begin
  with sr,header do begin
    if not fexist(ZipName) then begin
      doserror := 2; { File not found }
      exit;
    end;
    if getarctype(ZipName)<>_ZIP then begin
      doserror := 11; { Invalid format }
      exit;
    end;
    { Then we must have an okay zip file, so start at the begining }
    ZipFn := ZipName;
    ZipSize := Fsize(ZipFn);
    ZipPlace := 0;

    { Read the header.. }
    repeat
      assign(f,ZipFn);
      reset(f,1);
      seek(f,zipplace);
      blockread(f,header,sizeof(header));
      Name[0] := char(header.FNameLen);
      blockread(f,name[1],length(name));
      { Figure out where the next one is }
      Inc(ZipPlace,Sizeof(header)+extrafield+Fnamelen+ArcCsize);
      close(f);
    Until (ZipPlace>=ZipSize) or (name<>'') or (signature<>ZipLocalFileSig);
    While pos('/',name)>0 do name[pos('/',name)] := '\';

    Time := arcTime;
    CMethod := compress;
    CSize := ArcCsize;
    USize := ArcUsize;
    CRC32 := ArcCRC32;
  end;
end;

Procedure ZipFindNext(var sr: ZipSearchRec);
Var
  header: tZipHeader;
  f: file;
Begin
  with header,sr do begin
    if zipplace>=zipsize then begin
      doserror := 18; { No more files }
      exit;
    end;

    { Read the header.. }
    repeat
      assign(f,ZipFn);
      reset(f,1);
      seek(f,zipplace);
      blockread(f,header,sizeof(header));
      Name[0] := char(header.FNameLen);
      blockread(f,name[1],length(name));
      { Figure out where the next one is }
      Inc(ZipPlace,Sizeof(header)+extrafield+Fnamelen+ArcCsize);
      close(f);
    Until (ZipPlace>=ZipSize) or (name<>'') or (signature<>ZipLocalFileSig);
    if signature<>ZipLocalFileSig then begin
      doserror := 18;
      exit;
    end;
    While pos('/',name)>0 do name[pos('/',name)] := '\';
    If Name='' then begin
      doserror := 18; { No more files }
      exit;
    end;

    Time := ArcTime;
    CMethod := compress;
    CSize := ArcCsize;
    USize := ArcUsize;
    CRC32 := ArcCRC32;
  end;
end;

End.
