/*͸
   UED - the Maximus-CBCS User Base Editor  (C) 1996 by CodeLand Australia 
   CFG.C Configuration routines                        All Rights Reserved 
  ;*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <signal.h>
#include <dos.h>
#include <ctype.h>

#define INCL_DOS
#include <os2.h>

#include "vid.h"
#include "win.h"
#include "menu.h"
#include "form.h"
#include "user.h"
#include "prm.h"
#include "ued.h"

#define KEY_OFFSET 256
#define m_c LGREY|_BLUE
#define m_h WHITE|_BLUE

/**/

UEDCFG UedCfg;                          /* UED CFG struct                   */
CHAR CfgFile[160];                      /* Configuration file path & name   */
SHORT PfPtr=0;                          /* Current profile pointer          */

static CHAR CfgId[]="[UED300]";

static PCHAR CfgVerb[]= {               /* Cfg Verbs                        */
    "MaxPath",
    "PrmFile",
    "UserFile",
    "MsgAreaFile",
    "DateFormat",
    "Sound",
    "AutoSortTyp",
    "AutoSortDir",
    "DefaultScreen",
    "Maintenance",
    "ShowPwd",
    "UpgProfile01",
    "UpgProfile02",
    "UpgProfile03",
    "UpgProfile04",
    "UpgProfile05",
    "UpgProfile06",
    "UpgProfile07",
    "UpgProfile08",
    "UpgProfile09",
    "UpgProfile10",
    "UpgProfile11",
    "UpgProfile12",
    "UpgProfile13",
    "UpgProfile14",
    "UpgProfile15",
    "UpgProfile16",
    "GlobalDel",
    "GlobalExp",
    "GlobalKey",
    "GlobalCdt",
    "RegCode",
    "RegName",
    "RegCity",
    NULL
};

static PCHAR CfgKeyVerb[32]= {          /* Cfg Key Verbs                    */
    "Key1Desc", "Key2Desc", "Key3Desc", "Key4Desc",
    "Key5Desc", "Key6Desc", "Key7Desc", "Key8Desc",
    "KeyADesc", "KeyBDesc", "KeyCDesc", "KeyDDesc",
    "KeyEDesc", "KeyFDesc", "KeyGDesc", "KeyHDesc",
    "KeyIDesc", "KeyJDesc", "KeyKDesc", "KeyLDesc",
    "KeyMDesc", "KeyNDesc", "KeyODesc", "KeyPDesc",
    "KeyQDesc", "KeyRDesc", "KeySDesc", "KeyTDesc",
    "KeyUDesc", "KeyVDesc", "KeyWDesc", "KeyXDesc"
};

SHORT CfgChanged=0;              /* Cfg changed flag                 */

/**/

static SHORT WhichVerb (PCHAR Str);
static VOID PASCAL CfgUpgClearMenu (VOID);
static VOID PASCAL CfgUpgShow (VOID);
static VOID CfgUpgFirst (VOID);
static VOID CfgUpgLast (VOID);
static VOID CfgUpgPrev (VOID);
static VOID CfgUpgNext (VOID);
static SHORT PASCAL CfgUpgExp (PUCHAR xp_flag, SCOMBO *xp_date, PUSHORT xpp_mths, PULONG xp_mins, PUSHORT xp_priv);
static VOID PASCAL KeyLabel (SHORT os);
static VOID PASCAL GetKeyKeys (CHAR keys[], SHORT os);

/**/

/* Init INI and set default INI items */
VOID PASCAL CfgInit (VOID)
{
    SHORT i;
    PCHAR def_comp[] = { /* Default compression descriptions */
    "None","ARC","PAK","ZIP","LH113","LHARC","ZOO","ARJ",
    "---","---","---","---","---","---","---","---" };

    /* Set default Ued.Ini file name */
    strcpy(CfgFile,"UED.INI");

    memset(&UedCfg,'\0',sizeof(UEDCFG));

    *UedCfg.MaxPath='\0';
    strcpy(UedCfg.UserFile,"User");
    strcpy(UedCfg.AreaFile,"Marea");
    strcpy(UedCfg.PrmFile,"Max");
    UedCfg.Maintenance=0;
    UedCfg.DateFormat=DATE_US;
    for(i=0;i<8;i++) strcpy(UedCfg.lang[i],"*Blank* ");
    for(i=0;i<16;i++) strcpy(UedCfg.comp[i],def_comp[i]);
    for(i=0;i<32;i++) strcpy(UedCfg.key[i],"User Key Number");

    UedCfg.PrivNum=_PRIVS_NUM;
    for(i=0;i<UedCfg.PrivNum;i++) {
        strcpy(UedCfg.Priv[i],_privs[i].name);
        UedCfg.PrivValue[i]=_privs[i].priv;
        strcpy(UedCfg.PrivDesc[i],"Security Level");
    }

    for(i=0;i<_PROFILES;i++) {
        sprintf(UedCfg.Profile[i].Title,"Upgrade Profile %02d",i+1);
        strcpy(UedCfg.Profile[i].Keys,"00000000000000000000000000000000");
    }

    UedCfg.NoPwEncrypt=TRUE;
}

/**/

/* Read the INI file */
SHORT PASCAL CfgRead (VOID)
{
    SHORT i, j, gotsection=0;
    FILE *fp;
    CHAR *q, *tok1, *tok2, *tok3, line[514], tmp[514];

    /* Open the INI file */
    if((fp=fopen(CfgFile,"r"))==NULL) return 0;

    for (;;) { /* Scan for CfgId entry */
        if(fgets(line,512,fp)==NULL) break;
        if((tok1=strtok(line," \t=\r\n"))!=NULL) {
            if(!stricmp(tok1,CfgId)) { ++gotsection; break; }
            /* Import last beta ini file ok */
            if(!stricmp(tok1,"[UED300.B8]")) {
                ++CfgChanged; /* Set changed flag */
                ++gotsection; break;
            }
        }
    }

    if(!gotsection) { fclose(fp); return 0; }

    for (;;) { /* Process the INI entries */
        if(fgets(line,512,fp)==NULL) break; /* Read a line */

        /* Get line's first token */
        if((tok1=strtok(line," \t=\r\n"))==NULL) continue;
        if(*tok1==';') continue; /* Skip comment line */
        if(*tok1=='[') break; /* Section end */

        /* Get line's second token */
        if((tok2=strtok(NULL," \t=\r\n"))==NULL) tok2="";

        /* Process verbs */
        i=WhichVerb(tok1);
        if(!i) continue;
        switch(i-1) {
        case  0: /* MaxPath       */
            strcpy(UedCfg.MaxPath,tok2);
            if(*UedCfg.MaxPath=='.') *UedCfg.MaxPath='\0';
            break;
        case  1: /* PrmFile       */
            strcpy(UedCfg.PrmFile,tok2);
            q=FormStrIInc(".PRM",UedCfg.PrmFile);
            if(q!=NULL) *q='\0';
            break;
        case  2: /* UserFile      */
            strcpy(UedCfg.UserFile,tok2);
            q=FormStrIInc(".BBS",UedCfg.UserFile);
            if(q!=NULL) *q='\0';
            break;
        case  3: /* MsgAreaFile   */
            strcpy(UedCfg.AreaFile,tok2);
            q=FormStrIInc(".DAT",UedCfg.AreaFile);
            if(q!=NULL) *q='\0';
            break;
        case  4: /* DateFormat    */
            if(!stricmp(tok2,"DD-MM-YY")) UedCfg.DateFormat=DATE_OZ;
            else if(!stricmp(tok2,"MM-DD-YY")) UedCfg.DateFormat=DATE_US;
            else if(!stricmp(tok2,"YY-MM-DD")) UedCfg.DateFormat=DATE_JP;
            break;
        case  5: /* Sound         */
            if(!stricmp(tok2,"ON")||!stricmp(tok2,"YES")) UedCfg.NoSound=0;
            else UedCfg.NoSound=1;
            break;
        case  6: /* AutoSortTyp   */
            for(i=0;i<_SORT_NUM;i++) {
                strcpy(tmp,tok2); RemUS(tmp);
                if(!stricmp(tmp,SortStr[i])) {
                    UedCfg.SortTyp=i;
                    break;
                }
            }
            break;
        case  7: /* AutoSortDir   */
            if(!stricmp(tok2,"REVERSE")) UedCfg.SortDir=1;
            else UedCfg.SortDir=0;
            break;
        case  8: /* DefaultScreen */
            if(!stricmp(tok2,"BROWSE")) UedCfg.DefaultScreen=1;
            else UedCfg.DefaultScreen=0;
            break;
        case  9: /* Maintenance   */
            if(!stricmp(tok2,"ON")||!stricmp(tok2,"YES")) UedCfg.Maintenance=1;
            else UedCfg.Maintenance=0;
            break;
        case 10: /* ShowPwd       */
            if(!stricmp(tok2,"ON")||!stricmp(tok2,"YES")) UedCfg.ShowPwd=1;
            else UedCfg.ShowPwd=0;
            break;
        #define UPGPROIDX (i-1-11)
        case 11: /* UpgProfile01  */
        case 12: /* UpgProfile02  */
        case 13: /* UpgProfile03  */
        case 14: /* UpgProfile04  */
        case 15: /* UpgProfile05  */
        case 16: /* UpgProfile06  */
        case 17: /* UpgProfile07  */
        case 18: /* UpgProfile08  */
        case 19: /* UpgProfile09  */
        case 20: /* UpgProfile10  */
        case 21: /* UpgProfile11  */
        case 22: /* UpgProfile12  */
        case 23: /* UpgProfile13  */
        case 24: /* UpgProfile14  */
        case 25: /* UpgProfile15  */
        case 26: /* UpgProfile16  */
            if(UPGPROIDX>=_PROFILES) break; /* Safety */
            /* Title */
            if((tok3=strtok(tok2," \t=\r\n,"))==NULL) continue;
            strcpy(UedCfg.Profile[UPGPROIDX].Title,tok3);
            RemUS(UedCfg.Profile[UPGPROIDX].Title);
            /* FlagPriv */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            if(!stricmp(tok3,"T")) UedCfg.Profile[UPGPROIDX].FlagPriv=TRUE;
            else UedCfg.Profile[UPGPROIDX].FlagPriv=FALSE;
            /* Priv */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].Priv=atoi(tok3);
            /* FlagCredit */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            if(!stricmp(tok3,"T")) UedCfg.Profile[UPGPROIDX].FlagCredit=TRUE;
            else UedCfg.Profile[UPGPROIDX].FlagCredit=FALSE;
            /* Credit */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].Credit=atoi(tok3);
            /* FlagExp */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            if(!stricmp(tok3,"T")) UedCfg.Profile[UPGPROIDX].FlagExp=TRUE;
            else UedCfg.Profile[UPGPROIDX].FlagExp=FALSE;
            /* XpPriv */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpPriv=atoi(tok3);
            /* XpDate */
            if((tok3=strtok(NULL," \t=\r\n,-"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpDate.msg_st.date.yr=atoi(tok3);
            if((tok3=strtok(NULL," \t=\r\n,-"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpDate.msg_st.date.mo=atoi(tok3);
            if((tok3=strtok(NULL," \t=\r\n,-"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpDate.msg_st.date.da=atoi(tok3);
            /* XpMins */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpMins=atol(tok3);
            /* XpFlag */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpFlag=(UCHAR)atoi(tok3);
            /* XpMths */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.Profile[UPGPROIDX].XpMths=atoi(tok3);
            /* Keys */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            tok3[32]='\0'; strcpy(UedCfg.Profile[UPGPROIDX].Keys,tok3);
            break;
        case KEY_OFFSET+ 0: /* Key 1 */
        case KEY_OFFSET+ 1: /* Key 2 */
        case KEY_OFFSET+ 2: /* Key 3 */
        case KEY_OFFSET+ 3: /* Key 4 */
        case KEY_OFFSET+ 4: /* Key 5 */
        case KEY_OFFSET+ 5: /* Key 6 */
        case KEY_OFFSET+ 6: /* Key 7 */
        case KEY_OFFSET+ 7: /* Key 8 */
        case KEY_OFFSET+ 8: /* Key A */
        case KEY_OFFSET+ 9: /* Key B */
        case KEY_OFFSET+10: /* Key C */
        case KEY_OFFSET+11: /* Key D */
        case KEY_OFFSET+12: /* Key E */
        case KEY_OFFSET+13: /* Key F */
        case KEY_OFFSET+14: /* Key G */
        case KEY_OFFSET+15: /* Key H */
        case KEY_OFFSET+16: /* Key I */
        case KEY_OFFSET+17: /* Key J */
        case KEY_OFFSET+18: /* Key K */
        case KEY_OFFSET+19: /* Key L */
        case KEY_OFFSET+20: /* Key M */
        case KEY_OFFSET+21: /* Key N */
        case KEY_OFFSET+22: /* Key O */
        case KEY_OFFSET+23: /* Key P */
        case KEY_OFFSET+24: /* Key Q */
        case KEY_OFFSET+25: /* Key R */
        case KEY_OFFSET+26: /* Key S */
        case KEY_OFFSET+27: /* Key T */
        case KEY_OFFSET+28: /* Key U */
        case KEY_OFFSET+29: /* Key V */
        case KEY_OFFSET+30: /* Key W */
        case KEY_OFFSET+31: /* Key X */
            strcpy(tmp,tok2);
            strcpy(UedCfg.key[i-KEY_OFFSET-1],FormStrSetSz(RemUS(tmp),15));
            break;
        case 27: /* GlobalDel */
            /* Privs */
            if((tok3=strtok(tok2," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) UedCfg.GlobDel.PrivFlag[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* Days */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) {
                strncpy(tmp,tok3+i*4,4);
                tmp[4]='\0';
                sscanf(tmp,"%04x",&UedCfg.GlobDel.PrivDays[i]);
            }
            /* Calls */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) {
                strncpy(tmp,tok3+i*4,4);
                tmp[4]='\0';
                sscanf(tmp,"%04x",&UedCfg.GlobDel.PrivCalls[i]);
            }
            /* FlagXpSetDel */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobDel.FlagXpSetDel=(CHAR)(*tok3=='T'?'\1':'\0');
            /* FlagCrdtSetDel */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobDel.FlagCrdtSetDel=(CHAR)(*tok3=='T'?'\1':'\0');
            /* Keys */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<32;i++) UedCfg.GlobDel.Keys[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            break;
        case 28: /* GlobalExp */
            /* Privs */
            if((tok3=strtok(tok2," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) UedCfg.GlobExp.gExpPriv[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* ExpFlagVal */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            sscanf(tok3,"%02x",&UedCfg.GlobExp.xp_flag);
            /* ExpDateVal */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            sscanf(tok3,"%04x",&UedCfg.GlobExp.xp_date);
            /* ExpMinVal */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            sscanf(tok3,"%04x",&UedCfg.GlobExp.xp_mins);
            /* ExpPrivVal */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            sscanf(tok3,"%03x",&UedCfg.GlobExp.xp_priv);
            /* KeyFlgs */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<32;i++) UedCfg.GlobExp.gExpKeys[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* ExpSetFlg */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobExp.gCdtExpSet=(CHAR)(*tok3=='T'?'\1':'\0');
            /* OvrSetFlg */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobExp.gOvrExpSet=(CHAR)(*tok3=='T'?'\1':'\0');
            break;
        case 29: /* GlobalKey */
            /* Privs */
            if((tok3=strtok(tok2," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) UedCfg.GlobKey.gKeyPriv[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* gKeyExpSet */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobKey.gKeyExpSet=(CHAR)(*tok3=='T'?'\1':'\0');
            /* gKeyCdtSet */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobKey.gKeyCdtSet=(CHAR)(*tok3=='T'?'\1':'\0');
            /* Keys */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0,j=0;i<32&&j==0;i++) {
                switch(tok3[i]) {
                    case 0: /* End of string, abort */
                        ++j;
                        break;
                    case '0':
                        UedCfg.GlobKey.gKeyKeys[i]='\0';
                        break;
                    case '1':
                        UedCfg.GlobKey.gKeyKeys[i]='\1';
                        break;
                    case '2':
                        UedCfg.GlobKey.gKeyKeys[i]='\2';
                        break;
                    default:
                        UedCfg.GlobKey.gKeyKeys[i]='\0';
                        break;
                }
            }
            break;
        case 30: /* GlobalCdt */
            /* CdtPrivFlgs */
            if((tok3=strtok(tok2," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) UedCfg.GlobCdt.gCdtPriv[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* CdtVals */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) {
                strncpy(tmp,tok3+i*4,4);
                tmp[4]='\0';
                sscanf(tmp,"%04x",&UedCfg.GlobCdt.gCdtVal[i]);
            }
            /* DbtPrivFlgs */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) UedCfg.GlobCdt.gDbtPriv[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* DbtVals */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<16;i++) {
                strncpy(tmp,tok3+i*4,4);
                tmp[4]='\0';
                sscanf(tmp,"%04x",&UedCfg.GlobCdt.gDbtVal[i]);
            }
            /* KeyFlgs */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            for(i=0;i<32;i++) UedCfg.GlobCdt.gcdtkeys[i]=(CHAR)(tok3[i]=='T'?'\1':'\0');
            /* ExpSetFlg */
            if((tok3=strtok(NULL," \t=\r\n,"))==NULL) continue;
            UedCfg.GlobCdt.gCdtExpiry=(CHAR)(*tok3=='T'?'\1':'\0');
            break;
        case 31: /* RegCode */
            strcpy(UedCfg.RegCode,tok2);
            break;
        case 32: /* RegName */
            strcpy(UedCfg.RegName,RemUS(tok2));
            break;
        case 33: /* RegCity */
            strcpy(UedCfg.RegCity,RemUS(tok2));
            break;
        }
    }

    fclose(fp);
    return 1;
}

/**/

/* Read the PRM file */
SHORT PASCAL GetPrmInfo (VOID)
{
    SHORT i;
    CHAR *p, buf[160];

    /* Open PRM */
    strcpy(buf,UedCfg.MaxPath);
    if(*buf&&buf[strlen(buf)-1]!='\\') strcat(buf,"\\");
    strcat(buf,UedCfg.PrmFile); strcat(buf,".PRM");
    /* printf("DEBUG: prm=%s\n",buf); */
    if(PrmRead(buf)) { /* If failed access */
        /* Try Maximus environment var */
        p=getenv("MAXIMUS"); if(p==NULL) return 0;
        strcpy(buf,p); if(PrmRead(buf)) return 0;
    }

    /* Save Prm PW no encryption flag */
    UedCfg.NoPwEncrypt=PrmInfo.noencrypt;

    /* Load Prm lang strings */
    for(i=0;i<(SHORT)PrmInfo.max_lang;i++) {
        strcpy(UedCfg.lang[i],PrmInfo.lang_file[i]);
    }

    if(PrmInfo.PrmPrivNum) {
        UedCfg.PrivNum=PrmInfo.PrmPrivNum;
        for(i=0;i<UedCfg.PrivNum;i++) {
            strcpy(UedCfg.Priv[i],PrmInfo.PrmPriv[i].zAbbrev);
            UedCfg.PrivValue[i]=PrmInfo.PrmPriv[i].usLevel;
            strcpy(UedCfg.PrivDesc[i],PrmInfo.PrmPriv[i].zDesc);
        }
    }

    if(PrmInfo.CompNum) {
        for(i=0;i<PrmInfo.CompNum;i++) {
            /* Load in reverse order */
            strcpy(UedCfg.comp[i+1],PrmInfo.Comp[(PrmInfo.CompNum-1)-i]);
        }
        for(;i<15;i++) strcpy(UedCfg.comp[i+1],"---");
    }

    return 1;
}

/**/

VOID PASCAL CfgCheck (VOID)
{
    if(CfgChanged) {
        if(YesNo("Save Configuration Changes?",11,22,13,56))
            CfgWrite();
    }
}

/**/

/* Write the INI file */
VOID CfgWrite (VOID)
{
    FILE *fp;
    SHORT i, var;
    CHAR cbuf[64], cbuf2[256];

    /* Open the INI file */
    if((fp=fopen(CfgFile,"w+"))==NULL) return;

    fprintf(fp,";UED V" VERSION " - the Maximus V3.XX Specific User Base Editor\n"
        ";    (C) Copyright 1990-97 by CodeLand, All Rights Reserved\n");
    fprintf(fp,"%s\n",CfgId);

    fprintf(fp,"RegName=%s\n",AddUS(UedCfg.RegName));
    fprintf(fp,"RegCity=%s\n",AddUS(UedCfg.RegCity));
    fprintf(fp,"RegCode=%s\n",UedCfg.RegCode);

    fprintf(fp,"MaxPath=%s\n",UedCfg.MaxPath);
    fprintf(fp,"PrmFile=%s\n",UedCfg.PrmFile);
    fprintf(fp,"UserFile=%s\n",UedCfg.UserFile);
    fprintf(fp,"MsgAreaFile=%s\n",UedCfg.AreaFile);
    switch(UedCfg.DateFormat) {
        case DATE_OZ: strcpy(cbuf,"DD-MM-YY"); break;
        case DATE_JP: strcpy(cbuf,"YY-MM-DD"); break;
        case DATE_US: strcpy(cbuf,"MM-DD-YY");
        default:      break;
    }
    fprintf(fp,"DateFormat=%s\n",cbuf);
    fprintf(fp,"Sound=%s\n",UedCfg.NoSound?"OFF":"ON");
    var=UedCfg.SortTyp; if(var<0||var>=_SORT_NUM-1) var=0;
    strcpy(cbuf,SortStr[var]); fprintf(fp,"AutoSortTyp=%s\n",AddUS(cbuf));
    fprintf(fp,"AutoSortDir=%s\n",UedCfg.SortDir?"Reverse":"Forward");
    fprintf(fp,"DefaultScreen=%s\n",UedCfg.DefaultScreen?"BROWSE":"EDIT");
    fprintf(fp,"Maintenance=%s\n",UedCfg.Maintenance?"ON":"OFF");
    fprintf(fp,"ShowPwd=%s\n",UedCfg.ShowPwd?"ON":"OFF");
    for(i=0;i<32;i++) {
        strcpy(cbuf,UedCfg.key[i]);
        fprintf(fp,"%s=%s\n",CfgKeyVerb[i],AddUS(cbuf));
    }

    /* Profiles */
    fprintf(fp,";UpgProfileXX:Title,PrivFlg(T/F),PrivVal,CdtFlg(T/F),CdtVal,ExpFlg(T/F),ExpPrivVal,ExpDateVal,ExpMinVal,ExpFlgVal,ExpMthVal,KeyFlgs(0/1/2)\n");
    for(i=0;i<_PROFILES;i++) {
        strcpy(cbuf,UedCfg.Profile[i].Title); AddUS(cbuf);
        sprintf(cbuf2,"%s,%s,%u,%s,%u,%s,%u,%2.2u-%2.2u-%2.2u,%lu,%u,%u,%s",
            cbuf,
            UedCfg.Profile[i].FlagPriv?"T":"F",
            UedCfg.Profile[i].Priv,
            UedCfg.Profile[i].FlagCredit?"T":"F",
            UedCfg.Profile[i].Credit,
            UedCfg.Profile[i].FlagExp?"T":"F",
            UedCfg.Profile[i].XpPriv,
            UedCfg.Profile[i].XpDate.msg_st.date.yr,
            UedCfg.Profile[i].XpDate.msg_st.date.mo,
            UedCfg.Profile[i].XpDate.msg_st.date.da,
            UedCfg.Profile[i].XpMins,
            (USHORT)UedCfg.Profile[i].XpFlag,
            UedCfg.Profile[i].XpMths,
            UedCfg.Profile[i].Keys
        );
        fprintf(fp,"UpgProfile%02d=%s\n",i+1,cbuf2);
    }

    /* GlobalDel */
    fprintf(fp,";GlobalDel:PrivFlgs(T/F),DayVals(Hex),CallVals(Hex),ExpSetFlg(T/F),CdtSetFlg(T/F),KeyFlgs(T/F)\n");
    fprintf(fp,"GlobalDel=");
    /* Privs */
    for(i=0;i<16;i++) fprintf(fp,"%s",UedCfg.GlobDel.PrivFlag[i]?"T":"F");
    fprintf(fp,",");
    /* Days */
    for(i=0;i<16;i++) fprintf(fp,"%04x",UedCfg.GlobDel.PrivDays[i]);
    fprintf(fp,",");
    /* Calls */
    for(i=0;i<16;i++) fprintf(fp,"%04x",UedCfg.GlobDel.PrivCalls[i]);
    fprintf(fp,",");
    /* FlagXpSetDel */
    fprintf(fp,"%s,",UedCfg.GlobDel.FlagXpSetDel?"T":"F");
    /* FlagCrdtSetDel */
    fprintf(fp,"%s,",UedCfg.GlobDel.FlagCrdtSetDel?"T":"F");
    /* Keys */
    for(i=0;i<32;i++) fprintf(fp,"%s",UedCfg.GlobDel.Keys[i]?"T":"F");
    fprintf(fp,"\n");

    /* GlobalExp */
    fprintf(fp,";GlobalExp:PrivFlgs(T/F),ExpFlgVal(Hex),ExpDateVal(Hex),ExpMinVal(Hex),ExpPrivVal(Hex),KeyFlgs(T/F),ExpSetFlg(T/F),OvrSetFlg(T/F)\n");
    fprintf(fp,"GlobalExp=");
    /* Privs */
    for(i=0;i<16;i++) fprintf(fp,"%s",UedCfg.GlobExp.gExpPriv[i]?"T":"F");
    fprintf(fp,",");
    /* ExpFlagVal */
    fprintf(fp,"%02x,",UedCfg.GlobExp.xp_flag);
    /* ExpDateVal */ 
    fprintf(fp,"%04x,",UedCfg.GlobExp.xp_date);
    /* ExpMinVal */
    fprintf(fp,"%04x,",UedCfg.GlobExp.xp_mins);
    /* ExpPrivVal */
    fprintf(fp,"%03x,",UedCfg.GlobExp.xp_priv);
    /* KeyFlgs */
    for(i=0;i<32;i++) fprintf(fp,"%s",UedCfg.GlobExp.gExpKeys[i]?"T":"F");
    fprintf(fp,",");
    /* ExpSetFlg */
    fprintf(fp,"%s,",UedCfg.GlobExp.gCdtExpSet?"T":"F");
    /* OvrSetFlg */
    fprintf(fp,"%s",UedCfg.GlobExp.gOvrExpSet?"T":"F");
    fprintf(fp,"\n");

    /* GlobalKey */
    fprintf(fp,";GlobalKey:PrivFlgs(T/F),ExpSetFlg(T/F),CdtSetFlg(T/F),KeyFlgs(0/1/2)\n");
    fprintf(fp,"GlobalKey=");
    /* Privs */
    for(i=0;i<16;i++) fprintf(fp,"%s",UedCfg.GlobKey.gKeyPriv[i]?"T":"F");
    fprintf(fp,",");
    /* gKeyExpSet */
    fprintf(fp,"%s,",UedCfg.GlobKey.gKeyExpSet?"T":"F");
    /* gKeyCdtSet */
    fprintf(fp,"%s,",UedCfg.GlobKey.gKeyCdtSet?"T":"F");
    /* Keys */
    for(i=0;i<32;i++) {
        switch(UedCfg.GlobKey.gKeyKeys[i]) {
            case 0:
                fprintf(fp,"0");
                break;
            case 1:
                fprintf(fp,"1");
                break;
            case 2:
                fprintf(fp,"2");
                break;
            default:
                fprintf(fp,"0");
                break;
        }
    }
    fprintf(fp,"\n");

    /* GlobalCdt */
    fprintf(fp,";GlobalCdt:CdtPrivFlgs(T/F),CdtVals(Hex),DbtPrivFlgs(T/F),DbtVals(Hex),KeyFlgs(T/F),ExpSetFlg(T/F)\n");
    fprintf(fp,"GlobalCdt=");
    /* CdtPrivFlgs */
    for(i=0;i<16;i++) fprintf(fp,"%s",UedCfg.GlobCdt.gCdtPriv[i]?"T":"F");
    fprintf(fp,",");
    /* CdtVals */
    for(i=0;i<16;i++) fprintf(fp,"%04x",UedCfg.GlobCdt.gCdtVal[i]);
    fprintf(fp,",");
    /* DbtPrivFlgs */
    for(i=0;i<16;i++) fprintf(fp,"%s",UedCfg.GlobCdt.gDbtPriv[i]?"T":"F");
    fprintf(fp,",");
    /* DbtVals */
    for(i=0;i<16;i++) fprintf(fp,"%04x",UedCfg.GlobCdt.gDbtVal[i]);
    fprintf(fp,",");
    /* KeyFlgs */
    for(i=0;i<32;i++) fprintf(fp,"%s",UedCfg.GlobCdt.gcdtkeys[i]?"T":"F");
    fprintf(fp,",");
    /* ExpSetFlg */
    fprintf(fp,"%s",UedCfg.GlobCdt.gCdtExpiry?"T":"F");
    fprintf(fp,"\n");

    fprintf(fp,"[END]\n");
    fclose(fp);
    CfgChanged=0; /* Zero changed flag */
}

/**/

/* Edit Registration */
VOID CfgReg (VOID)
{
    SHORT Status;

    if(!WinOpen(8,7,12,67,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinPrintS(0,1,BLUE|_LGREY,"Registration Name:");
    WinPrintS(1,1,BLUE|_LGREY,"Registration City:");
    WinPrintS(2,1,BLUE|_LGREY,"Registration Code:");

    FormBeg(fattr,hattr); /* Do the edit form */
    FormDef(0,20,UedCfg.RegName,"??????????????????????????????",0,1,NULL,0);
    FormDef(1,20,UedCfg.RegCity,"??????????????????????????????",0,1,NULL,0);
    FormDef(2,20,UedCfg.RegCode,"??????????????????????????????",0,1,NULL,0);
    Status=FormRead(); /* Process the input fields */
    VidHideCur();

    WinClose(); /* Close window */
    FormStrTrim(UedCfg.RegName);
    FormStrTrim(UedCfg.RegCity);
    FormStrTrim(UedCfg.RegCode);

    /* Process changes */
    if(Status!=W_ESCPRESS) CfgChanged=1;
}

/**/

/* Edit Maximus Path */
VOID CfgPath (VOID)
{
    SHORT Status;

    if(!WinOpen(11,7,13,70,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinPrintS(0,1,BLUE|_LGREY,"Maximus Directory:");

    FormBeg(fattr,hattr); /* Do the edit form */
    FormDef(0,19,UedCfg.MaxPath,"??????????????????????????????????????????",0,1,NULL,0);
    Status=FormRead(); /* Process the input fields */
    VidHideCur();

    WinClose(); /* Close window */
    FormStrTrim(UedCfg.MaxPath);

    /* Process changes */
    if(Status!=W_ESCPRESS) CfgChanged=1;
}

/**/

/* Edit Maximus file names */
VOID CfgName (VOID)
{
    SHORT Status;

    if(!WinOpen(5,7,9,37,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    WinPrintS(0,1,BLUE|_LGREY,"Maximus PRM Name :");
    WinPrintS(1,1,BLUE|_LGREY,"User File Name   :");
    WinPrintS(2,1,BLUE|_LGREY,"Msg Area DAT Name:");

    FormBeg(fattr,hattr); /* Do the edit form */
    FormDef(0,20,UedCfg.PrmFile, "????????",0,1,NULL,0);
    FormDef(1,20,UedCfg.UserFile,"????????",0,1,NULL,0);
    FormDef(2,20,UedCfg.AreaFile,"????????",0,1,NULL,0);
    Status=FormRead(); /* Process the input fields */
    VidHideCur();

    WinClose(); /* Close window */
    FormStrTrim(UedCfg.PrmFile);
    FormStrTrim(UedCfg.UserFile);
    FormStrTrim(UedCfg.AreaFile);

    /* Process changes */
    if(Status!=W_ESCPRESS) CfgChanged=1;
}

/**/

/* Edit date type */
VOID CfgDate (VOID)
{
    SHORT val;

    if(!WinOpen(6,26,10,37,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    if(UedCfg.DateFormat>2||UedCfg.DateFormat<0) UedCfg.DateFormat=0;
    switch(UedCfg.DateFormat) { /* Get current date format */
        case DATE_OZ:
            val=1;
            break;
        case DATE_JP:
            val=2;
            break;
        case DATE_US:
        default:
            val=0;
            break;
    }

    MenuBegC();
    MenuItem(0,0,"MM-DD-YY",0,0,0,NULL,0,0); /* U.S. */
    MenuItem(1,0,"DD-MM-YY",0,1,0,NULL,0,0); /* Australian */
    MenuItem(2,0,"YY-MM-DD",0,2,0,NULL,0,0); /* Japan */
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        switch(val) {
            case 1:
                UedCfg.DateFormat=DATE_OZ;
                break;
            case 2:
                UedCfg.DateFormat=DATE_JP;
                break;
            case 0:
            default:
                UedCfg.DateFormat=DATE_US;
                break;
        }
        CfgChanged=1;
        MenuStat=MENU_CFGS;
    }
}

/**/

VOID CfgSound (VOID)
{
    struct _item_t *citem;
    PCHAR str;

    citem=MenuICurr(); str=citem->str;
    UedCfg.NoSound^=1;
    strcpy(str,UedCfg.NoSound?"Use Sound    OFF":"Use Sound     ON");
    citem->redisp=1;

    CfgChanged=1;
}

/**/

VOID CfgSort (VOID)
{
    SHORT done=0, selection=3, i, val;
    SHORT sorttyp, sortdir;
    CHAR cbuf[16];

    /* Get cfg values */
    sorttyp=UedCfg.SortTyp;
    sortdir=UedCfg.SortDir;

    /* Open the window */
    if(!WinOpen(2,19,22,59,bdr,battr2,wattr2)) return;
    WINSHADOW();
    WinHLine(1,0,40,bdr,battr2); WinHLine(17,0,40,bdr,battr2);
    WinVLine(1,12,17,bdr,battr2);
    WinPrintS(0,0,battr," SET AUTO SORT                         ");
    WinPrintS(0,27,qattr,"ESC - ABORT");
    WinPrintS(18,0,LGREY|_BLUE," Sort Type  Sort Direction        QUIT ");
    WinPrintS(4,16,BLUE|_LGREY,"Type     :");
    WinPrintS(6,16,BLUE|_LGREY,"Direction:");

    /* Menu */
    while(!done) {
        for(i=0;i<_SORT_NUM-1;i++) { /* Type menu text */
            sprintf(cbuf," %-10s ",SortStr[i]);
            WinPrintS(i+2,0,BLUE|_LGREY,cbuf);
        }
        sprintf(cbuf,"%-10s",SortStr[sorttyp]); WinPrintS(4,26,LGREY|_BLACK,cbuf);
        WinPrintS(6,26,LGREY|_BLACK,sortdir?"Reverse   ":"Forward   ");

        if(selection<1||selection>3) selection=3;
        MenuBegC();
        MenuItem(18, 1, "Sort Type",     'T',  1,0, NULL, 0, 0);
        MenuItem(18,12, "Sort Direction",'D',  2,0, NULL, 0, 0);
        MenuItem(18,34, "QUIT",          'Q',  3,0, NULL, 0, 0);
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        selection=MenuGet();
        WinPrintS(18,0,LGREY|_BLUE," Sort Type  Sort Direction        QUIT ");
        switch(selection) {
            case 1 : /* Type */
                val=sorttyp; /* Get current sort type */
                if(val<0||val>=_SORT_NUM-1) val=0;
                MenuBegC();
                for(i=0;i<_SORT_NUM-1;i++) MenuItem(i+2,0,SortStr[i],SortChr[i],i,0,NULL,0,0);
                MenuEnd(val,M_VERT,12,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
                val=MenuGet();
                if(val!=-1) sorttyp=val;
                break;
            case 2 : /* Direction */
                sortdir^=1;
                break;
            case 3 : /* Quit */
                /* Save changes */
                CfgChanged=1;
                UedCfg.SortTyp=sorttyp;
                UedCfg.SortDir=sortdir;
                /* Flow through */
            case -1 : /* ESC */
                ++done;
                break;
        }
    }

    WinClose(); /* Close window */
}

/**/

VOID CfgView (VOID)
{
    SHORT val, sval;

    if(!WinOpen(9,26,12,37,bdr,BLUE|_LGREY,BLUE|_LGREY)) return;
    WINSHADOW();
    if(UedCfg.DefaultScreen>1||UedCfg.DefaultScreen<0) UedCfg.DefaultScreen=0;
    val=sval=UedCfg.DefaultScreen; /* Get current value */

    MenuBegC();
    MenuItem(0,0,"EDIT",  0,0,0,NULL,0,0);
    MenuItem(1,0,"BROWSE",0,1,0,NULL,0,0);
    MenuEnd(val,M_VERT,20,1,BLUE|_LGREY,LBLUE|_LGREY,BLACK|_LGREY,WHITE|_RED);
    val=MenuGet();

    WinClose(); /* Close window */

    if(val!=-1) {
        if(val!=sval) {
            UedCfg.DefaultScreen=val;
            CfgChanged=1;
        }
    }
}

/**/

VOID CfgDebug (VOID)
{
    struct _item_t *citem;
    PCHAR str;

    citem=MenuICurr(); str=citem->str;
    UedCfg.Maintenance^=1;
    strcpy(str,UedCfg.Maintenance?"Maintenance   ON":"Maintenance  OFF");
    citem->redisp=1;

    CfgChanged=1;
    MenuStat=MENU_CFGS;
}

/**/

/* Edit key labels */
VOID CfgLabel (VOID)
{
/*
Ŀ
 SET KEY LABELS            ESC - ABORT 
Ĵ
 User Key Number 1  User Key Number I 
 User Key Number 2  User Key Number J 
 User Key Number 3  User Key Number K 
 User Key Number 4  User Key Number L 
 User Key Number 5  User Key Number M 
 User Key Number 6  User Key Number N 
 User Key Number 7  User Key Number O 
 User Key Number 8  User Key Number P 
Ĵ
 User Key Number A  User Key Number Q 
 User Key Number B  User Key Number R 
 User Key Number C  User Key Number S 
 User Key Number D  User Key Number T 
 User Key Number E  User Key Number U 
 User Key Number F  User Key Number V 
 User Key Number G  User Key Number W 
 User Key Number H  User Key Number X 

*/
    SHORT i;

    if(!WinOpen(2,19,22,59,bdr,battr2,wattr2)) return;
    WINSHADOW();
    WinHLine(1,0,40,bdr,battr2); WinHLine(10,0,40,bdr,battr2);
    WinVLine(1,19,19,bdr,battr2);
    WinPrintS(0,0,battr," SET KEY LABELS                        ");
    WinPrintS(0,27,qattr,"ESC - ABORT");

    for(i= 0;i< 8;i++) {
        WinPrintC(i+2,17,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
        WinPrintC(i+2,37,LBLUE|_LGREY,KeyNum[i+16]);  /* Show key */
    }
    for(i= 8;i<16;i++) {
        WinPrintC(i+3,17,LBLUE|_LGREY,KeyNum[i]);  /* Show key */
        WinPrintC(i+3,37,LBLUE|_LGREY,KeyNum[i+16]);  /* Show key */
    }

    FormBeg(BLUE|_CYAN,hattr2);
    for(i=0;i< 8;i++) {
        FormDef(i+2, 1,UedCfg.key[i],"***************",0,1,NULL,0);
        FormDef(i+2,21,UedCfg.key[i+16],"***************",0,1,NULL,0);
    }
    for(i=8;i<16;i++) {
        FormDef(i+3, 1,UedCfg.key[i],"***************",0,1,NULL,0);
        FormDef(i+3,21,UedCfg.key[i+16],"***************",0,1,NULL,0);
    }
    if(FormRead()==W_NOERROR) CfgChanged=1;
    VidHideCur(); WinClose(); /* Close window */
}

/**/

/* Return verb index, one based */
static SHORT WhichVerb (PCHAR Str)
{
    SHORT i=0, result=0;

    while(CfgVerb[i]!=NULL) {
        if(!stricmp(Str,CfgVerb[i])) { /* If a match found */
            result=i+1;
            break;
        }
        ++i;
    }

    if(!result) { /* If not found, check for key verb */
        for(i=0;i<32;i++) {
            if(!stricmp(Str,CfgKeyVerb[i])) { /* If a match found */
                result=KEY_OFFSET+i+1;
                break;
            }
        }
    }

    return result;
}

/**/
/*
Ŀ
 UPGRADE PROFILE CONFIGURATION                   Profile     1 of    16 
Ĵ
 Ŀ   Profile:    123456789012345678901234567890123456789012 
  SysOp                                                               
  AsstSysOp    Set Access:          Ŀ 
  Clerk                              Key Set Mask                   
  Extra        Access:               Key 1  NO Key C  NO Key N  NO  
  Favored                            Key 2  NO Key D  NO Key O  NO  
  Privil       Set Credit:     NO    Key 3  NO Key E  NO Key P  NO  
  Worthy                             Key 4  NO Key F  NO Key Q  NO  
  Normal       Credit:      10000    Key 5  NO Key G  NO Key R  NO  
  Limited                            Key 6  NO Key H  NO Key S  NO  
  Disgrace     Set Expiry:     NO    Key 7  NO Key I  NO Key T  NO  
  Twit                               Key 8  NO Key J  NO Key U  NO  
  Hidden       Expiry:  Date         Key A  NO Key K  NO Key V  NO  
                                     Key B  NO Key L  NO Key W  NO  
               Value :  05/05/92               Key M  NO Key X  NO  
               Action:  Demote       Exit                           
    Demote:  Normal       
Ĵ
 First - + Last  Title AccSet Access CdtSet Cdt EXpSet Expiry Keys QUIT 

*/
VOID CfgUpg (VOID)
{
    SHORT i, selection=13, done=0, val;
    USHORT spriv;
    CHAR sbuf[50], credit[10];

    if(!WinOpen(1,2,23,75,bdr,battr2,wattr2)) return;
    WINSHADOW();

    if(PfPtr<0||PfPtr>=_PROFILES) PfPtr=0;

    /* Header */
    WinPrintS(0,0,WHITE|_BLUE," UPGRADE PROFILE CONFIGURATION                   Profile       of       ");
    WinPrintS(0,49,YELLOW|_BLUE,"Profile       of");
    FormCvtIC(sbuf,_PROFILES,5); WinPrintS(0,66,LGREY|_BLACK,sbuf);
    WinHLine(1,0,72,bdr,battr2);

    /* Priv settings */
    WinFill(2,2,18,12,' ',WHITE|_BLUE);
    WinVLine(1,1,19,bdr,battr2); WinVLine(1,13,19,bdr,battr2);
    for(i=0;i<UedCfg.PrivNum;i++) WinPrintS(i+2,3,LGREY|_BLUE,UedCfg.Priv[i]);

    /* Labels */
    WinPrintS( 2,17,BLUE|_LGREY,"Profile:");
    WinPrintS( 4,17,BLUE|_LGREY,"Set Access:");
    WinPrintS( 6,17,BLUE|_LGREY,"Access:");
    WinPrintS( 8,17,BLUE|_LGREY,"Set Credit:");
    WinPrintS(10,17,BLUE|_LGREY,"Credit:");
    WinPrintS(12,17,BLUE|_LGREY,"Set Expiry:");
    WinPrintS(14,17,BLUE|_LGREY,"Expiry:");
    WinPrintS(16,17,BLUE|_LGREY,"Value :");
    WinPrintS(17,17,BLUE|_LGREY,"Action:");
    WinPrintS(18,17,BLUE|_LGREY,"Demote:");

    /* Key flags */
    WinPrintS( 5,39,LCYAN|_CYAN," Key Set Mask                  ");
    KeyLabel(39);

    WinHLine(19,0,72,bdr,battr2);
    WinFill(20,0,20,71,' ',WHITE|_BLUE); /* Under menu */

    while(!done) {
        CfgUpgShow();
        if(selection<1||selection>13) selection=13;
        MenuSetOnKey(0x4700,CfgUpgFirst,0); /* Turn on HOME key          */
        MenuSetOnKey(0x4F00,CfgUpgLast,0);  /* Turn on END key           */
        MenuSetOnKey(0x4800,CfgUpgPrev,0);  /* <Up Arrow>                */
        MenuSetOnKey(0x5000,CfgUpgNext,0);  /* <Down Arrow>              */
        MenuBegC(); /* The menu */
        MenuItem(20,  1, "First",        'F',  1,0, NULL, 0, 0);
        MenuItem(20,  7, "-",            '-',  2,0, NULL, 0, 0);
        MenuItem(20,  9, "+",            '+',  3,0, NULL, 0, 0);
        MenuItem(20, 11, "Last",         'L',  4,0, NULL, 0, 0);
        MenuItem(20, 17, "Title",        'T',  5,0, NULL, 0, 0);
        MenuItem(20, 23, "AccSet",       'S',  6,0, NULL, 0, 0);
        MenuItem(20, 30, "Access",       'A',  7,0, NULL, 0, 0);
        MenuItem(20, 37, "CdtSet",       'C',  8,0, NULL, 0, 0);
        MenuItem(20, 44, "CDt",          'D',  9,0, NULL, 0, 0);
        MenuItem(20, 48, "EXpSet",       'X', 10,0, NULL, 0, 0);
        MenuItem(20, 55, "Expiry",       'E', 11,0, NULL, 0, 0);
        MenuItem(20, 62, "Keys",         'K', 12,0, NULL, 0, 0);
        MenuItem(20, 67, "QUIT",         'Q', 13,0, NULL, 0, 0);
        MenuEnd(selection,M_HORZ|M_SAVE,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        selection=MenuGet();
        MenuFreOnKey(); /* Disable the hotkey functions */
        CfgUpgClearMenu();

        switch(selection) {
            case  1 : /* First profile */
                        CfgUpgFirst();
                        break;
            case  2 : /* Previous profile */
                        CfgUpgPrev();
                        break;
            case  3 : /* Next profile */
                        CfgUpgNext();
                        break;
            case  4 : /* Last profile */
                        CfgUpgLast();
                        break;
            case  5 : /* Title */
                        FormBeg(fattr,hattr);
                        FormDef(2,29,UedCfg.Profile[PfPtr].Title,
                        "??????????????????????????????????????????",0,2,NULL,0);
                        if(FormRead()!=W_ESCPRESS) {
                            TONEUPDATE(); CfgChanged=1;
                        }
                        VidHideCur();
                        break;
            case  6 : /* AccSet */
                        UedCfg.Profile[PfPtr].FlagPriv^=1;
                        TONEUPDATE(); CfgChanged=1;
                        break;
            case  7 : /* Access */
                        spriv=UedCfg.Profile[PfPtr].Priv;
                        val=GetPriv(UedCfg.Profile[PfPtr].Priv);
                        MenuBegC();
                        for(i=0;i<UedCfg.PrivNum;i++)
                            MenuItem(i+2,2,UedCfg.Priv[i],*UedCfg.Priv[i],i,0,NULL,0,0);
                        MenuEnd(val,M_VERT,11,1,LGREY|_BLUE,LGREY|_BLUE,LGREY|_BLUE,WHITE|_RED);
                        if((val=MenuGet())!=-1) {
                            strcpy(sbuf," "); strcat(sbuf,UedCfg.Priv[val]);
                            WinPrintS(val+2,2,LGREY|_BLUE,FormStrSetSz(sbuf,11));
                            UedCfg.Profile[PfPtr].Priv=UedCfg.PrivValue[val];
                            if(spriv!=UedCfg.Profile[PfPtr].Priv) {
                                TONEUPDATE(); CfgChanged=1;
                            }
                        }
                        break;
            case  8 : /* CdtSet */
                        UedCfg.Profile[PfPtr].FlagCredit^=1;
                        TONEUPDATE(); CfgChanged=1;
                        break;
            case  9 : /* Credit */
                        sprintf(credit,"%6u",UedCfg.Profile[PfPtr].Credit);
                        FormBeg(fattr,hattr);
                        FormDef(10,28,credit,"%%%%%%",0,1,NULL,0);
                        if(FormRead()!=W_ESCPRESS) {
                            ULONG tmpval;
                            TONEUPDATE(); CfgChanged=1;
                            tmpval=atol(credit);
                            UedCfg.Profile[PfPtr].Credit=(USHORT)(tmpval>65535L?65535L:tmpval);
                        }
                        VidHideCur();
                        break;
            case 10 : /* EXpSet */
                        UedCfg.Profile[PfPtr].FlagExp^=1;
                        TONEUPDATE(); CfgChanged=1;
                        break;
            case 11 : /* Expiry */
                        if(CfgUpgExp(&UedCfg.Profile[PfPtr].XpFlag,
                                   &UedCfg.Profile[PfPtr].XpDate,
                                   &UedCfg.Profile[PfPtr].XpMths,
                                   &UedCfg.Profile[PfPtr].XpMins,
                                   &UedCfg.Profile[PfPtr].XpPriv
                        )) {
                            TONEUPDATE(); CfgChanged=1;
                        }
                        break;
            case 12 : /* Keys */
                        GetKeyKeys(UedCfg.Profile[PfPtr].Keys,46);
                        break;
            case -1 :
            case 13 : done++; break;
        }
    }
    WinClose(); /* Close down this window */
}

/**/

static VOID PASCAL CfgUpgClearMenu (VOID)
{
    WinPrintS(20,0,m_c," First - + Last  Title AccSet Access CdtSet Cdt EXpSet Expiry Keys QUIT ");
    WinPrintS(20, 1,m_h,"F");
    WinPrintS(20, 7,m_h,"-");
    WinPrintS(20, 9,m_h,"+");
    WinPrintS(20,11,m_h,"L");
    WinPrintS(20,17,m_h,"T");
    WinPrintS(20,26,m_h,"S");
    WinPrintS(20,30,m_h,"A");
    WinPrintS(20,37,m_h,"C");
    WinPrintS(20,45,m_h,"D");
    WinPrintS(20,49,m_h,"X");
    WinPrintS(20,55,m_h,"E");
    WinPrintS(20,62,m_h,"K");
    WinPrintS(20,67,m_h,"Q");
}

/**/

static VOID PASCAL CfgUpgShow (VOID)
{
    SHORT i;
    CHAR *p, ign[4]=" - ";
    CHAR sbuf[50];

    FormCvtIC(sbuf,PfPtr+1,5); WinPrintS(0,57,LGREY|_BLACK,sbuf);

    /* Title */
    strcpy(sbuf,UedCfg.Profile[PfPtr].Title);
    WinPrintS(2,29,LGREY|_BLACK,FormStrSetSz(sbuf,42));

    /* Access */
    WinPrintS(4,31,LGREY|_BLACK,UedCfg.Profile[PfPtr].FlagPriv?
        Yes:No);
    WinPrintS(6,25,LGREY|_BLACK,ShowPriv(UedCfg.Profile[PfPtr].Priv));

    /* Credit */
    WinPrintS(8,31,LGREY|_BLACK,UedCfg.Profile[PfPtr].FlagCredit?
        Yes:No);
    sprintf(sbuf,"%6u",UedCfg.Profile[PfPtr].Credit);
    WinPrintS(10,28,fattr,sbuf);

    /* Expire data */
    WinPrintS(12,31,LGREY|_BLACK,UedCfg.Profile[PfPtr].FlagExp?
        Yes:No);
    if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_EXPDATE) {
        WinPrintS(14,25,fattr,"Date Abs ");
        ShowDate(&(UedCfg.Profile[PfPtr].XpDate),sbuf);
        WinPrintS(16,25,fattr,FormStrSetSz(sbuf,9));
    }
    else if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_EXPDATREL) {
        WinPrintS(14,25,fattr,"Date Rel ");
        sprintf(sbuf,"%9d",UedCfg.Profile[PfPtr].XpMths);
        WinPrintS(16,25,fattr,sbuf);
    }
    else if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_EXPMINS) {
        WinPrintS(14,25,fattr,"Time     ");
        sprintf(sbuf,"%9ld",UedCfg.Profile[PfPtr].XpMins);
        WinPrintS(16,25,fattr,sbuf);
    }
    else {
        WinPrintS(14,25,fattr,"None     ");
        WinPrintS(16,25,fattr,"         ");
    }

    if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_AXE) {
        WinPrintS(17,25,fattr,"HangUp   ");
        WinPrintS(18,25,fattr,"         ");
    }
    else if(UedCfg.Profile[PfPtr].XpFlag&XFLAG_DEMOTE) {
        WinPrintS(17,25,fattr,"Demote   ");
        WinPrintS(18,25,fattr,ShowPriv(UedCfg.Profile[PfPtr].XpPriv));
    }
    else {
        WinPrintS(17,25,fattr,"None     ");
        WinPrintS(18,25,fattr,"         ");
    }

    /* Keys */
    for(i=0;i<10;i++) {
        switch(UedCfg.Profile[PfPtr].Keys[i]-'0') {
        case 1: p=Off; break;
        case 2: p=On; break;
        case 0: 
        default: p=ign; break;
        }
        WinPrintS(i+6,46,LGREY|_BLACK,p);
    }
    for(i=10;i<21;i++) {
        switch(UedCfg.Profile[PfPtr].Keys[i]-'0') {
        case 1: p=Off; break;
        case 2: p=On; break;
        case 0:
        default: p=ign; break;
        }
        WinPrintS(i-4,56,LGREY|_BLACK,p);
    }
    for(i=21;i<32;i++) {
        switch(UedCfg.Profile[PfPtr].Keys[i]-'0') {
        case 1: p=Off; break;
        case 2: p=On; break;
        case 0:
        default: p=ign; break;
        }
        WinPrintS(i-15,66,LGREY|_BLACK,p);
    }
}

/**/

static VOID CfgUpgFirst (VOID)
{
    PfPtr=0;
    CfgUpgShow();
}

/**/

static VOID CfgUpgLast (VOID)
{
    PfPtr=_PROFILES-1;
    CfgUpgShow();
}

/**/

static VOID CfgUpgPrev (VOID)
{
    if(--PfPtr<0) PfPtr=0;
    CfgUpgShow();
}

/**/

static VOID CfgUpgNext (VOID)
{
    if(++PfPtr>=_PROFILES) PfPtr=_PROFILES-1;
    CfgUpgShow();
}

/**/

static SHORT PASCAL CfgUpgExp (PUCHAR xp_flag, SCOMBO *xp_date, PUSHORT xpp_mths, PULONG xp_mins, PUSHORT xp_priv)
{
/*
Ŀ
 PROFILE ACCOUNT EXPIRY           ESC - Abort 
Ĵ
    Expiry        Ŀ  
  Ŀ     Expiry by    :Date Abs   
   None                                   
   Date Abs      Absolute Date:01-01-93   
   Date Rel                               
   Time          Rel Date Mths:           
                                
    Action         Expiry Time  :       0   
  Ŀ                              
   None          Action      :Demote      
   Demote                                 
   Hangup        Demote to   :Normal      
        
Ĵ
 EXpiry Action AbsDate RelDate Time Priv Quit 

*/
    SHORT done=0, val=7, exp, exp2, exp3, exp4, status;
    USHORT savemths, privsave;
    ULONG savetime;
    UCHAR xpflagsave;
    CHAR time[10], mths[10], date[10], savedate[10];
    CHAR date1[4], date2[4], date3[4], sbuf[16];

    privsave=*xp_priv; /* Save current setting */
    xpflagsave=*xp_flag;
    savetime=*xp_mins;
    savemths=*xpp_mths;

    if(!WinOpen(2,16,20,63,bdr,battr2,wattr2)) return 0;
    WINSHADOW();
    WinHLine(1,0,46,bdr,battr2); WinHLine(15,0,46,bdr,battr2);
    WinPrintS( 0,0,battr," PROFILE ACCOUNT EXPIRY           ESC - Abort ");
    WinPrintS( 0,34,qattr,"ESC - Abort");
    WinPrintS( 2, 4,BLUE|_LGREY,"Expiry"); WinPrintS( 9, 4,BLUE|_LGREY,"Action");
    WinBox(3,2,8,13,bdr,nosel); WinBox(10,2,14,13,bdr,nosel);
    WinBox(2,18,14,43,bdr,battr2);
    WinPrintS( 3,20,wattr2,"Expiry by    :");
    WinPrintS( 5,20,wattr2,"Absolute Date:");
    WinPrintS( 7,20,wattr2,"Rel Date Mths:");
    WinPrintS( 9,20,wattr2,"Expiry Time  :");
    WinPrintS(11,20,wattr2,"Action      :");
    WinPrintS(13,20,wattr2,"Demote to   :");
    WinPrintS(16,0,battr,"                                              ");

    while(!done) {
        if(val<1||val>7) val=7;
        WinPrintS( 4,3,nosel," None     ");
        WinPrintS( 5,3,nosel," Date Abs ");
        WinPrintS( 6,3,nosel," Date Rel ");
        WinPrintS( 7,3,nosel," Time     ");
        WinPrintS(11,3,nosel," None     ");
        WinPrintS(12,3,nosel," Demote   ");
        WinPrintS(13,3,nosel," Hangup   ");

        if(*xp_flag&XFLAG_EXPDATE) {
            WinPrintS( 3,34,fattr2,"Date Abs");
            exp=2;
        }
        else if(*xp_flag&XFLAG_EXPDATREL) {
            WinPrintS( 3,34,fattr2,"Date Rel");
            exp=3;
        }
        else if(*xp_flag&XFLAG_EXPMINS) {
            WinPrintS( 3,34,fattr2,"Time    ");
            exp=4;
        }
        else {
            WinPrintS( 3,34,fattr2,"None    ");
            exp=1;
        }

        if(*xp_flag&XFLAG_AXE) {
            WinPrintS(11,33,fattr2,"HangUp   ");
            exp3=3;
        }
        else if(*xp_flag&XFLAG_DEMOTE) {
            WinPrintS(11,33,fattr2,"Demote   ");
            exp3=2;
        }
        else {
            WinPrintS(11,33,fattr2,"None     ");
            exp3=1;
        }

        ShowDate(xp_date,savedate); WinPrintS( 5,34,fattr2,savedate);
        sprintf(mths,"%8d",*xpp_mths); WinPrintS( 7,34,fattr2,mths);
        sprintf(time,"%8ld",*xp_mins); WinPrintS( 9,34,fattr2,time);
        WinPrintS(13,33,fattr2,ShowPriv(*xp_priv));

        MenuBegC();
        MenuItem(16, 1,"EXpiry", 'X',1,0,NULL,0,0);
        MenuItem(16, 8,"Action", 'A',2,0,NULL,0,0);
        MenuItem(16,15,"AbsDate",'D',3,0,NULL,0,0);
        MenuItem(16,23,"RelDate",'R',4,0,NULL,0,0);
        MenuItem(16,31,"Time",   'T',5,0,NULL,0,0);
        MenuItem(16,36,"Priv",   'P',6,0,NULL,0,0);
        MenuItem(16,41,"Quit",   'Q',7,0,NULL,0,0);
        MenuEnd(val,M_HORZ,0,0,LGREY|_BLUE,WHITE|_BLUE,BLACK|_BLUE,WHITE|_RED);
        val=MenuGet();
        switch(val) {
        case 1 : /* EXpiry */
                 WinPrintS(16, 1,LGREY|_BLUE,"Expiry"); WinPrintS(16, 2,WHITE|_BLUE,"X");
                 MenuBegC();
                 MenuItem(4,3," None     ", 'N',1,0,NULL,0,0);
                 MenuItem(5,3," Date Abs ", 'D',2,0,NULL,0,0);
                 MenuItem(6,3," Date Rel ", 'R',3,0,NULL,0,0);
                 MenuItem(7,3," Time     ", 'T',4,0,NULL,0,0);
                 MenuEnd(exp,M_VERT,0,0,nosel,nosel,nosel,WHITE|_RED);
                 if((exp2=MenuGet())!=-1) {
                     *xp_flag&=~XFLAG_EXPDATE;
                     *xp_flag&=~XFLAG_EXPDATREL;
                     *xp_flag&=~XFLAG_EXPMINS;
                     switch(exp2) {
                     case 1: /* None */
                             break;
                     case 2: /* Date absolute */
                             *xp_flag|=XFLAG_EXPDATE;
                             break;
                     case 3: /* Date */
                             *xp_flag|=XFLAG_EXPDATREL;
                             break;
                     case 4: /* Time */
                             *xp_flag|=XFLAG_EXPMINS;
                             break;
                     }
                 }
                 break;
        case 2 : /* Action */
                 WinPrintS(16, 8,WHITE|_BLUE,"A"); WinPrintS(16, 9,LGREY|_BLUE,"ction");
                 MenuBegC();
                 MenuItem(11,3," None     ",'N',1,0,NULL,0,0);
                 MenuItem(12,3," Demote   ",'D',2,0,NULL,0,0);
                 MenuItem(13,3," Hangup   ",'H',3,0,NULL,0,0);
                 MenuEnd(exp3,M_VERT,0,0,nosel,nosel,nosel,WHITE|_RED);
                 if((exp4=MenuGet())!=-1) {
                     *xp_flag&=~XFLAG_DEMOTE;
                     *xp_flag&=~XFLAG_AXE;
                     switch(exp4) {
                     case 1: /* None */
                             break;
                     case 2: /* Demote */
                             *xp_flag|=XFLAG_DEMOTE;
                             break;
                     case 3: /* Hangup */
                             *xp_flag|=XFLAG_AXE;
                             break;
                     }
                 }
                 break;
        case 3 : /* Absolute Date */
                 WinPrintS(16,15,LGREY|_BLUE,"AbsDate"); WinPrintS(16,18,WHITE|_BLUE,"D");
                 ShowDate(xp_date,date);
                 strncpy(date1,date,2); date1[2]='\0';
                 strncpy(date2,date+3,2); date2[2]='\0';
                 strncpy(date3,date+6,2); date3[2]='\0';
                 FormBeg (fattr,hattr); /* Do menu */
                 /* FormDef( 5,25,date,"%#<->%#<->##",0,1,NULL,0); */
                 FormDef( 5,34,date1,"%%",0,1,NULL,0);
                 FormDef( 5,37,date2,"%%",0,1,NULL,0);
                 FormDef( 5,40,date3,"%%",0,1,NULL,0);
                 status=FormRead(); /* Process the input fields */
                 VidHideCur(); /* Fix cursor */
                 if(status!=W_ESCPRESS) { /* Process changes */
                     strcpy(date,date1); strcat(date,"-");
                     strcat(date,date2); strcat(date,"-");
                     strcat(date,date3);
                     GetDate(xp_date,date);
                 }
                 break;
        case 4 : /* Relative Date */
                 WinPrintS(16,23,WHITE|_BLUE,"R"); WinPrintS(16,24,LGREY|_BLUE,"elDate");
                 sprintf(mths,"%8d",*xpp_mths);
                 FormBeg(fattr,hattr); /* Do menu */
                 FormDef( 7,34,mths,"%%%%%%%%",0,1,NULL,0);
                 status=FormRead(); /* Process the input fields */
                 VidHideCur(); /* Fix cursor */
                 if(status!=W_ESCPRESS) { /* Process changes */
                     *xpp_mths=atoi(mths);
                 }
                 break;
        case 5 : /* Time */
                 WinPrintS(16,31,WHITE|_BLUE,"T"); WinPrintS(16,32,LGREY|_BLUE,"ime");
                 sprintf(time,"%8ld",*xp_mins);
                 FormBeg (fattr,hattr); /* Do menu */
                 FormDef( 9,34,time,"%%%%%%%%",0,1,NULL,0);
                 status=FormRead(); /* Process the input fields */
                 VidHideCur(); /* Fix cursor */
                 if(status!=W_ESCPRESS) { /* Process changes */
                     *xp_mins=atol(time);
                 }
                 break;
        case 6 : /* Priv */
                 WinPrintS(16,36,WHITE|_BLUE,"P"); WinPrintS(16,37,LGREY|_BLUE,"riv");
                 *xp_priv=GetXPriv(*xp_priv);
                 WinPrintS(13,33,fattr2,ShowPriv(*xp_priv));
                 break;
        case -1: /* Abort */
                 *xp_priv=privsave;
                 *xp_flag=xpflagsave;
                 *xp_mins=savetime;
                 *xpp_mths=savemths;
        case 7 : done++;
                 break;
        }
    }
    WinClose(); /* Close window */
    /* If there were changes */
    if( privsave!=*xp_priv   ||
        *xp_flag!=xpflagsave ||
        savetime!=*xp_mins   ||
        savemths!=*xpp_mths  ||
        strcmp(savedate,ShowDate(xp_date,sbuf))
    ) return 1;

    return 0;
}

/**/

/* Key flag labels */
static VOID PASCAL KeyLabel (SHORT os)
{
    WinBox(4,os-1,18,os+31,0,LCYAN|_CYAN);
    WinPrintS( 6,os,WHITE|_CYAN," Key 1     Key C     Key N     ");
    WinPrintS( 7,os,WHITE|_CYAN," Key 2     Key D     Key O     ");
    WinPrintS( 8,os,WHITE|_CYAN," Key 3     Key E     Key P     ");
    WinPrintS( 9,os,WHITE|_CYAN," Key 4     Key F     Key Q     ");
    WinPrintS(10,os,WHITE|_CYAN," Key 5     Key G     Key R     ");
    WinPrintS(11,os,WHITE|_CYAN," Key 6     Key H     Key S     ");
    WinPrintS(12,os,WHITE|_CYAN," Key 7     Key I     Key T     ");
    WinPrintS(13,os,WHITE|_CYAN," Key 8     Key J     Key U     ");
    WinPrintS(14,os,WHITE|_CYAN," Key A     Key K     Key V     ");
    WinPrintS(15,os,WHITE|_CYAN," Key B     Key L     Key W     ");
    WinPrintS(16,os,WHITE|_CYAN,"           Key M     Key X     ");
    WinPrintS(17,os,WHITE|_CYAN,"                               ");
    WinPrintS(17,os+1,LGREY|_BLACK,"Exit");
}

/**/

static VOID PASCAL GetKeyKeys (CHAR keys[], SHORT os)
{
    SHORT i, sel2=0, changed=0;
    CHAR flag_text[3][4] = { " - ","OFF"," ON" };
    CHAR save[32];

    for(i=0;i<32;i++) save[i]=keys[i]; /* Copy keys */
    for(;;) {
        MenuBegC(); /* Key menu */
        MenuItem( 6,os,   flag_text[keys[ 0]-'0'],0, 0,0,NULL,0,0);
        MenuItem( 7,os,   flag_text[keys[ 1]-'0'],0, 1,0,NULL,0,0);
        MenuItem( 8,os,   flag_text[keys[ 2]-'0'],0, 2,0,NULL,0,0);
        MenuItem( 9,os,   flag_text[keys[ 3]-'0'],0, 3,0,NULL,0,0);
        MenuItem(10,os,   flag_text[keys[ 4]-'0'],0, 4,0,NULL,0,0);
        MenuItem(11,os,   flag_text[keys[ 5]-'0'],0, 5,0,NULL,0,0);
        MenuItem(12,os,   flag_text[keys[ 6]-'0'],0, 6,0,NULL,0,0);
        MenuItem(13,os,   flag_text[keys[ 7]-'0'],0, 7,0,NULL,0,0);
        MenuItem(14,os,   flag_text[keys[ 8]-'0'],0, 8,0,NULL,0,0);
        MenuItem(15,os,   flag_text[keys[ 9]-'0'],0, 9,0,NULL,0,0);
        MenuItem( 6,os+10,flag_text[keys[10]-'0'],0,10,0,NULL,0,0);
        MenuItem( 7,os+10,flag_text[keys[11]-'0'],0,11,0,NULL,0,0);
        MenuItem( 8,os+10,flag_text[keys[12]-'0'],0,12,0,NULL,0,0);
        MenuItem( 9,os+10,flag_text[keys[13]-'0'],0,13,0,NULL,0,0);
        MenuItem(10,os+10,flag_text[keys[14]-'0'],0,14,0,NULL,0,0);
        MenuItem(11,os+10,flag_text[keys[15]-'0'],0,15,0,NULL,0,0);
        MenuItem(12,os+10,flag_text[keys[16]-'0'],0,16,0,NULL,0,0);
        MenuItem(13,os+10,flag_text[keys[17]-'0'],0,17,0,NULL,0,0);
        MenuItem(14,os+10,flag_text[keys[18]-'0'],0,18,0,NULL,0,0);
        MenuItem(15,os+10,flag_text[keys[19]-'0'],0,19,0,NULL,0,0);
        MenuItem(16,os+10,flag_text[keys[20]-'0'],0,20,0,NULL,0,0);
        MenuItem( 6,os+20,flag_text[keys[21]-'0'],0,21,0,NULL,0,0);
        MenuItem( 7,os+20,flag_text[keys[22]-'0'],0,22,0,NULL,0,0);
        MenuItem( 8,os+20,flag_text[keys[23]-'0'],0,23,0,NULL,0,0);
        MenuItem( 9,os+20,flag_text[keys[24]-'0'],0,24,0,NULL,0,0);
        MenuItem(10,os+20,flag_text[keys[25]-'0'],0,25,0,NULL,0,0);
        MenuItem(11,os+20,flag_text[keys[26]-'0'],0,26,0,NULL,0,0);
        MenuItem(12,os+20,flag_text[keys[27]-'0'],0,27,0,NULL,0,0);
        MenuItem(13,os+20,flag_text[keys[28]-'0'],0,28,0,NULL,0,0);
        MenuItem(14,os+20,flag_text[keys[29]-'0'],0,29,0,NULL,0,0);
        MenuItem(15,os+20,flag_text[keys[30]-'0'],0,30,0,NULL,0,0);
        MenuItem(16,os+20,flag_text[keys[31]-'0'],0,31,0,NULL,0,0);
        MenuItem(17,os-6,"Exit",            0x1C0A,32,0,NULL,0,0);
        MenuEnd(sel2,M_OMNI,0,0,LGREY|_BLACK,LGREY|_BLACK,LGREY|_BLACK,WHITE|_RED);
        sel2=MenuGet();
        if(sel2 != -1 && sel2 != 32) {
            if(sel2>=0&&sel2<32) {
                if(++keys[sel2]>2+'0') keys[sel2]=0+'0';
                TONEUPDATE(); changed=1;
            }
        }
        else {
            if(sel2==-1) {
                    for(i=0;i<32;i++) keys[i]=save[i]; /* Throw away changes */
                    changed=0;
            }
            WinPrintS(17,os-6,LGREY|_BLACK,"Exit");
            break; /* Exit */
        }
    }

    if(changed) CfgChanged=1;
}

/**/

